/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond.RightCondTypeParser;
import com.digiwin.athena.datamap.service.IMechanismService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MechanismVariableParser
implements RightCondTypeParser {
    private static final Logger log = LoggerFactory.getLogger(MechanismVariableParser.class);
    @Autowired
    IMechanismService mechanismService;
    @Autowired
    DataMapKgService dataMapKgService;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.RightCondType.MECHANISM_VARIABLE.getCode().equalsIgnoreCase(type);
    }

    @Override
    public CustomFuncResult preParse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty((Collection)metaDataList)) {
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
        }
        try {
            MechanismVariable right = conditionConfig.getRight();
            String dataNameFrom = right.getFrom().getData_name();
            String dataNameTo = right.getTo().getData_name();
            ArrayList variableIds = Lists.newArrayList((Object[])new String[]{dataNameFrom, dataNameTo});
            Object variableObj = this.dataMapKgService.getVariableListSimple(variableIds, Boolean.TRUE);
            JSONObject variableJsonObj = JSONObject.parseObject((String)JSON.toJSONString((Object)variableObj));
            right.getFrom().setFunctionValue(variableJsonObj.get((Object)dataNameFrom));
            right.getFrom().setValue(variableJsonObj.get((Object)dataNameFrom));
            right.getTo().setFunctionValue(variableJsonObj.get((Object)dataNameTo));
            right.getTo().setValue(variableJsonObj.get((Object)dataNameTo));
        }
        catch (Exception e) {
            log.error("MechanismVariableParser.preParse \u5931\u8d25\uff0ce={}", (Throwable)e);
        }
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
    }

    @Override
    public CustomFuncResult parse(MechanismConditionConfig config, JSONObject metaDataObj, JSONArray metaDataList) {
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
    }
}

