/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.JsExpressionConverter;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitHandler;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.LimitFormValidate;
import com.digiwin.athena.preset.PresetDomainEnum;
import com.digiwin.athena.preset.Rule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormValidateLimitHandler
implements LimitHandler {
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    PresetLibraryService presetLibraryService;
    @Autowired
    JsExpressionConverter jsExpressionConverter;

    @Override
    public boolean accept(SingleStrategyWidget singleStrategyWidget) {
        return singleStrategyWidget.getPositiveTarget() != null && MechanismPlanType.limitFormValidate.name().equalsIgnoreCase(singleStrategyWidget.getPositiveTarget().getType());
    }

    @Override
    public void handler(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) {
        Rule rule = this.buildRule(singleStrategyWidget, parseContext);
        this.presetLibraryService.saveRule(rule);
    }

    private Rule buildRule(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) {
        LimitFormValidate validate = this.mechanismHelpService.convert(singleStrategyWidget.getPositiveTarget(), LimitFormValidate.class);
        Rule rule = new Rule();
        HashMap<String, Object> content = new HashMap<String, Object>();
        rule.setContent(content);
        rule.setApplication(parseContext.getBindingContext().getApplication());
        rule.setTenantId(parseContext.getBindingContext().getTenantId());
        rule.setPluginId(parseContext.getBindingContext().getPluginId());
        rule.setDomain(PresetDomainEnum.ACTIVITY);
        rule.setDescription(validate.getMsg());
        rule.setDomainId(parseContext.getProjectPageTarget() == null ? parseContext.getSourceTarget() : parseContext.getProjectPageTarget());
        rule.setKey(this.mechanismHelpService.uid());
        content.put("condition", this.mechanismHelpService.toExpression(singleStrategyWidget.getCondition(), parseContext));
        content.put("description", validate.getMsg());
        content.put("errorMessage", validate.getMsg());
        if (null != validate.getRuleContent()) {
            content.putAll((Map<String, Object>)JSON.parseObject((String)JSON.toJSONString((Object)validate.getRuleContent())));
        }
        String path = null;
        String schema = null;
        String relationPath = validate.getRelationPath();
        if (null != validate.getPath()) {
            String fullpath = validate.getPath();
            int len = fullpath.lastIndexOf(".");
            path = fullpath.substring(0, len);
            schema = fullpath.substring(len + 1, fullpath.length());
            content.put("path", path);
            content.put("schema", schema);
        }
        switch (validate.getValidateType()) {
            case "unEditAble": {
                content.put("key", "disabled");
                content.put("scope", "EDIT");
                break;
            }
            case "dateLimit": {
                content.put("key", "connection");
                ArrayList relations = new ArrayList();
                content.put("relations", relations);
                HashMap<String, Object> relation1 = new HashMap<String, Object>();
                relations.add(relation1);
                relation1.put("path", relationPath == null ? schema : relationPath);
                ArrayList operations = new ArrayList();
                relation1.put("operations", operations);
                HashMap<String, String> operation1 = new HashMap<String, String>();
                operations.add(operation1);
                operation1.put("name", "disabledDate");
                operation1.put("type", "attribute");
                operation1.put("script", "");
                if (validate.getDateLimitType() == 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("(current)=>{var today=new Date();today=new Date(today.getFullYear(),today.getMonth(),today.getDate()");
                    sb.append("+").append(validate.getDateLimit());
                    sb.append(");return(current<today);}");
                    operation1.put("script", sb.toString());
                    break;
                }
                if (validate.getDateLimitType() != 1) break;
                operation1.put("script", this.mechanismHelpService.replaceMechanismVariable(validate.getScript(), parseContext, true));
                break;
            }
            case "required": {
                content.put("key", "required");
                break;
            }
            case "hidden": {
                content.put("key", "hidden");
                break;
            }
        }
        return rule;
    }

    public static void main(String[] args) {
        String path = "aa.bb.cc.dd";
        int len = path.lastIndexOf(".");
        String path0 = path.substring(0, len);
        String path1 = path.substring(len + 1, path.length());
        System.out.println(path0);
        System.out.println(path1);
    }
}

