/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitAction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitAction.LimitActionParser;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.widgets.action.LimitAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActionParser
implements LimitActionParser {
    private static final Logger log = LoggerFactory.getLogger(ActionParser.class);
    @Autowired
    MechanismHelpService mechanismHelpService;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.LimitActionType.LIMIT_ACTION.getCode().equalsIgnoreCase(type);
    }

    @Override
    public Object parse(MechanismApiInfoDTO apiInfoDTO) throws Exception {
        LimitAbilityBo bo = this.mechanismHelpService.convert(apiInfoDTO.getAbility(), LimitAbilityBo.class);
        LimitAction limitAction = bo.getLimitAction();
        List conditions = limitAction.getConditions();
        if (CollectionUtils.isEmpty((Collection)conditions)) {
            return null;
        }
        HashMap accordSceneDataMap = new HashMap();
        LinkedList keyFieldNameList = new LinkedList();
        if (apiInfoDTO != null) {
            keyFieldNameList.addAll(apiInfoDTO.getKeyFieldNameList());
        }
        JSONArray metaDataList = JSON.parseArray((String)JSON.toJSONString((Object)apiInfoDTO.getTableData()));
        metaDataList.stream().forEach(v -> {
            JSONObject rowData = JSON.parseObject((String)JSON.toJSONString((Object)v));
            JSONObject accordRowData = new JSONObject();
            JSONObject keyObj = new JSONObject();
            accordRowData.put("key", (Object)keyObj);
            accordRowData.put("row_data", v);
            StringBuilder priKeyValue = new StringBuilder();
            for (int n = 0; n < keyFieldNameList.size(); ++n) {
                keyObj.put((String)keyFieldNameList.get(n), rowData.get(keyFieldNameList.get(n)));
                priKeyValue.append(rowData.get(keyFieldNameList.get(n)));
            }
            accordSceneDataMap.put(priKeyValue.toString(), accordRowData);
        });
        return accordSceneDataMap.values();
    }
}

