/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitAction;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.controlSourcehandlers.ControlSourceHandler;
import com.digiwin.athena.datamap.mechanism.limithandler.ReminderLimitHandler;
import com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitAction.LimitActionParser;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataMapReminderParser
implements LimitActionParser {
    private static final Logger log = LoggerFactory.getLogger(DataMapReminderParser.class);
    @Autowired
    ReminderLimitHandler reminderLimitHandler;
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    List<ControlSourceHandler> sourceHandlers;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.LimitActionType.REMINDER.getCode().equalsIgnoreCase(type);
    }

    @Override
    public Object parse(MechanismApiInfoDTO apiInfoDTO) throws Exception {
        LimitAbilityBo bo = this.mechanismHelpService.convert(apiInfoDTO.getAbility(), LimitAbilityBo.class);
        BindingContext bindingContext = this.mechanismHelpService.convert(apiInfoDTO.getContext(), BindingContext.class);
        List strategies = bo.getStrategies();
        MechanismParseContext parseContext = this.buildParseContext(bo, bindingContext);
        if (null != strategies) {
            for (SingleStrategyWidget widget : strategies) {
                if (null == widget.getCondition() || null == widget.getCondition().getVariables()) continue;
                this.reminderLimitHandler.handler(widget, parseContext);
            }
        }
        return null;
    }

    private MechanismParseContext buildParseContext(LimitAbilityBo runnableAbility, BindingContext bindingContext) throws DWBusinessException {
        MechanismParseContext parseContext = new MechanismParseContext();
        parseContext.setSourceWidget(runnableAbility.getCheckSource());
        parseContext.setBo((MechanismAbility)runnableAbility);
        parseContext.setBindingContext(bindingContext);
        parseContext.setSourceTarget(runnableAbility.getCheckSource().getTarget());
        this.parseSource(runnableAbility.getCheckSource(), parseContext);
        return parseContext;
    }

    public void parseSource(SourceWidget checkSource, MechanismParseContext context) throws DWBusinessException {
        if (null == checkSource || null == checkSource.getType()) {
            return;
        }
        for (ControlSourceHandler sourceHandler : this.sourceHandlers) {
            if (!sourceHandler.accept(checkSource)) continue;
            sourceHandler.parse(checkSource, context);
            break;
        }
    }
}

