/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitCondition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.ConditionParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond.CustomFunctionParser;
import com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitCondition.LimitConditionParser;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DataMapBusinessConditionParser
implements LimitConditionParser {
    private static final Logger log = LoggerFactory.getLogger(DataMapBusinessConditionParser.class);
    @Autowired
    MechanismParserFactory mechanismParserFactory;
    @Autowired
    DataMapKgService dataMapKgService;
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    CustomFunctionParser customFunctionParser;
    @Autowired
    ConditionParser conditionParser;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.LimitConditionType.BUSINESS.getCode().equalsIgnoreCase(type);
    }

    @Override
    public Boolean parse(MechanismApiInfoDTO apiInfoDTO) {
        LimitAbilityBo bo = this.mechanismHelpService.convert(apiInfoDTO.getAbility(), LimitAbilityBo.class);
        if (ObjectUtils.isEmpty((Object)bo.getBusinessCondition())) {
            log.error("\u65e0\u573a\u666f\u6570\u636e\uff0c\u5165\u53c2\uff1a{}", (Object)apiInfoDTO);
            return null;
        }
        if (ObjectUtils.isEmpty((Object)apiInfoDTO.getTableData())) {
            log.error("\u65e0\u8868\u683c\u6570\u636e\uff0c\u5165\u53c2\uff1a{}", (Object)apiInfoDTO);
            return null;
        }
        JSONArray metaDataList = JSON.parseArray((String)JSON.toJSONString((Object)apiInfoDTO.getTableData()));
        HashMap<String, Object> accordTableDataMap = new HashMap<String, Object>();
        List groups = bo.getBusinessCondition().getGroups();
        accordTableDataMap.putAll(this.conditionParser.parseSingleScene(groups, metaDataList, apiInfoDTO, null));
        if (CollectionUtils.isEmpty(accordTableDataMap)) {
            return Boolean.FALSE;
        }
        List rowDataList = accordTableDataMap.values().stream().map(v -> {
            JSONObject rowDataJson = this.mechanismHelpService.convert(v, JSONObject.class);
            Object rowDataObj = rowDataJson.get((Object)"row_data");
            return rowDataObj;
        }).collect(Collectors.toList());
        apiInfoDTO.setTableData(rowDataList);
        return Boolean.TRUE;
    }
}

