/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitCondition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType.NumericParser;
import com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitCondition.LimitConditionParser;
import com.digiwin.athena.datamap.spi.AudcService;
import com.digiwin.athena.datamap.spi.DatamapEocService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.widgets.condition.PersonnelCondition;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DataMapPersonnelConditionParser
implements LimitConditionParser {
    private static final Logger log = LoggerFactory.getLogger(DataMapPersonnelConditionParser.class);
    @Autowired
    DatamapEocService datamapEocService;
    @Autowired
    AudcService acduService;
    @Autowired
    NumericParser numericParser;
    private static final String EOC_DUTY_LIST_URL = "/api/eoc/v2/duty/list?pageSize=99999";
    private static final String EOC_PROFICIENCY_URL = "/api/v1/user/track/search";

    @Override
    public boolean accept(String type) {
        return MechanismEnum.LimitConditionType.PERSONNEL.getCode().equalsIgnoreCase(type);
    }

    @Override
    public Boolean parse(MechanismApiInfoDTO apiInfoDTO) {
        LimitAbilityBo bo = (LimitAbilityBo)JSONObject.parseObject((String)JSON.toJSONString((Object)apiInfoDTO.getAbility()), LimitAbilityBo.class);
        PersonnelCondition personnelCondition = bo.getPersonnelCondition();
        if (personnelCondition == null) {
            return Boolean.FALSE;
        }
        String performerType = personnelCondition.getPerformerType();
        if (MechanismEnum.PersonnelConditionType.PROFICIENCY.getCode().equalsIgnoreCase(performerType)) {
            return this.parserProficiency(bo);
        }
        if (MechanismEnum.PersonnelConditionType.DUTY.getCode().equalsIgnoreCase(performerType)) {
            return this.parserDuty(bo);
        }
        if (MechanismEnum.PersonnelConditionType.STAFF.getCode().equalsIgnoreCase(performerType)) {
            return this.parserStaff(bo);
        }
        return Boolean.FALSE;
    }

    private Boolean parserProficiency(LimitAbilityBo bo) {
        Map profile = DWServiceContext.getContext().getProfile();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("workType", bo.getPersonnelCondition().getWorkType());
        params.put("workCode", bo.getPersonnelCondition().getWorkCode());
        params.put("operations", bo.getPersonnelCondition().getOperations());
        params.put("userId", profile.get("userId"));
        params.put("tenantId", profile.get("tenantId"));
        log.info("\u67e5\u8be2\u719f\u7ec3\u5ea6\u5f00\u59cb\uff0c\u5165\u53c2\u4e3a{},{}", (Object)EOC_PROFICIENCY_URL, params);
        Map proficiencyMap = this.acduService.requestAudc(EOC_PROFICIENCY_URL, "post", params);
        log.info("\u67e5\u8be2\u719f\u7ec3\u5ea6\uff0c\u7ed3\u679c\u4e3a{}", (Object)proficiencyMap);
        if (!CollectionUtils.isEmpty((Map)proficiencyMap) && Objects.equals(proficiencyMap.get("status").toString(), HttpStatus.OK.toString())) {
            JSONObject response = (JSONObject)proficiencyMap.get("response");
            BigDecimal count = response.getBigDecimal("count");
            PersonnelCondition condition = bo.getPersonnelCondition();
            return this.numericParser.isSatisfyCond(condition.getProficiencyType().name(), count, ObjectUtils.isEmpty((Object)condition.getFromValue()) ? null : new BigDecimal(condition.getFromValue().toString()), new BigDecimal(condition.getToValue().toString()));
        }
        return Boolean.FALSE;
    }

    private Boolean parserDuty(LimitAbilityBo bo) {
        Map dataMap;
        log.info("\u67e5\u8be2\u804c\u80fd\u5f00\u59cb\uff0c\u5165\u53c2\u4e3a{}", (Object)EOC_DUTY_LIST_URL);
        Map dutyMap = this.datamapEocService.requestEoc(EOC_DUTY_LIST_URL, "get", new HashMap<String, Object>());
        log.info("\u67e5\u8be2\u804c\u80fd\u7ed3\u675f\uff0c\u7ed3\u679c\u4e3a{}", (Object)dutyMap);
        if (!CollectionUtils.isEmpty((Map)dutyMap) && Objects.equals(dutyMap.get("code").toString(), HttpStatus.OK.toString()) && !CollectionUtils.isEmpty((Map)(dataMap = (Map)dutyMap.get("data")))) {
            List dataList = (List)dataMap.get("list");
            List dutyIdList = dataList.stream().map(data -> data.get("id").toString()).collect(Collectors.toList());
            if (null == bo.getPersonnelCondition().getToValue() || bo.getPersonnelCondition().getToValue().toString().isEmpty()) {
                return false;
            }
            List<String> targetDutyIds = DataMapPersonnelConditionParser.handleList(bo.getPersonnelCondition().getToValue().toString());
            for (String each : targetDutyIds) {
                if (!dutyIdList.contains(each)) continue;
                return true;
            }
        }
        return Boolean.FALSE;
    }

    private Boolean parserStaff(LimitAbilityBo bo) {
        log.info("\u83b7\u53d6\u7528\u6237\u8bbe\u7f6e\u7684\u4eba\u5458:{}", bo.getPersonnelCondition().getToValue());
        if (null == bo.getPersonnelCondition().getToValue() || bo.getPersonnelCondition().getToValue().toString().isEmpty()) {
            return false;
        }
        List<String> staff = DataMapPersonnelConditionParser.handleList(bo.getPersonnelCondition().getToValue().toString());
        Boolean result = staff.contains(DWServiceContext.getContext().getProfile().get("userId").toString());
        log.info("\u4eba\u5458\u6761\u4ef6\u5224\u65ad\u7ed3\u679c:{}", (Object)result);
        return result;
    }

    private static List<String> handleList(String performerValueStaff) {
        String[] emails = performerValueStaff.replace("[", "").replace("]", "").replace("\"", "").split(",");
        return Arrays.asList(emails);
    }
}

