/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.dao.DataMapActivityDAO;
import com.digiwin.athena.datamap.povo.TenantABIReportDAO;
import com.digiwin.athena.datamap.service.impl.DatamapAppService;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.datamap.spi.DatamapCacService;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.TenantAppRelation;
import com.digiwin.athena.kg.authority.AuthorizedUser;
import com.digiwin.athena.kg.authority.AuthorizedUserResult;
import com.digiwin.athena.kg.report.dao.ABIReportUserStatistics;
import com.digiwin.athena.repository.neo4j.ActivityRepository;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class DataMapReportManager {
    private static final Logger log = LoggerFactory.getLogger(DataMapReportManager.class);
    private final String USER_PERMISSION_TARGET_PREFIX = "drn:iam:app:";
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private DataMapIamService dataMapIamService;
    @Autowired
    private DatamapCacService datamapCacService;
    @Autowired
    Executor executor;
    @Autowired
    DataMapKgDataPickService dataPickService;
    @Autowired
    private DatamapAppService datamapAppService;
    @Autowired
    KmService kmService;
    @Autowired
    private DataMapActivityDAO dataMapActivityDAO;

    private List<TenantABIReportDAO> allABiReport() throws DWBusinessException {
        List<String> codes = this.dataMapActivityDAO.getAllABiReportCodes();
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations("activity", codes);
        List<String> appCodes = relations.stream().map(ApplicationRelation::getAppCode).distinct().collect(Collectors.toList());
        List<TenantAppRelation> tenantAppRelationByAppCode = this.kmService.getTenantAppRelationByAppCode(appCodes);
        Map<String, List> appTenants = tenantAppRelationByAppCode.stream().collect(Collectors.toMap(TenantAppRelation::getAppCode, obj -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add(obj.getTenantId());
            return list;
        }, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }));
        ArrayList<TenantABIReportDAO> list = new ArrayList<TenantABIReportDAO>();
        for (ApplicationRelation applicationRelation : relations) {
            List tenants = appTenants.get(applicationRelation.getAppCode());
            if (CollectionUtils.isEmpty((Collection)tenants)) continue;
            for (String tenantId : tenants) {
                TenantABIReportDAO dao = new TenantABIReportDAO();
                dao.setCode(applicationRelation.getCode());
                dao.setNamespace(applicationRelation.getAppCode());
                dao.setAthenaNamespace(applicationRelation.getAthena_namespace());
                dao.setTenantId(tenantId);
                dao.setTenantName(tenantId);
                list.add(dao);
            }
        }
        return list;
    }

    public Object getABIReportUserStatistics(String startDate, String endDate) throws DWBusinessException {
        ArrayList result = new ArrayList();
        List<TenantABIReportDAO> allABiReport = this.allABiReport();
        if (CollectionUtils.isEmpty(allABiReport)) {
            return result;
        }
        Map<String, List> collectByTenant = allABiReport.stream().collect(Collectors.toMap(TenantABIReportDAO::getTenantId, p -> {
            ArrayList<TenantABIReportDAO> list = new ArrayList<TenantABIReportDAO>();
            list.add((TenantABIReportDAO)p);
            return list;
        }, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }));
        CountDownLatch countDownLatch = new CountDownLatch(collectByTenant.size());
        List<Application> applications = this.datamapAppService.postAllApplications();
        Map nameSpaceAppMap = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> a));
        Set<Map.Entry<String, List>> entries = collectByTenant.entrySet();
        for (Map.Entry<String, List> entry : entries) {
            this.executor.execute(() -> {
                try {
                    String expiredTime;
                    String tenantId = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    Map<String, List> collectByApp = value.stream().collect(Collectors.toMap(e -> this.getAppGroupKey((TenantABIReportDAO)e, nameSpaceAppMap), p -> {
                        ArrayList<TenantABIReportDAO> list = new ArrayList<TenantABIReportDAO>();
                        list.add((TenantABIReportDAO)p);
                        return list;
                    }, (list1, list2) -> {
                        list1.addAll(list2);
                        return list1;
                    }));
                    log.info("==========ABIReportUserStatistics start tenant:{}", (Object)tenantId);
                    Map<String, Map> allAppAuthorizationsMap = this.userAllAppAuthorizations(tenantId);
                    Map athenaInfoMap = allAppAuthorizationsMap.get("Athena");
                    if (athenaInfoMap == null) {
                        return;
                    }
                    String effectiveTime = String.valueOf(athenaInfoMap.get("effectiveTime"));
                    if (!this.checkIsEffective(startDate, endDate, effectiveTime, expiredTime = String.valueOf(athenaInfoMap.get("expiredTime")))) {
                        return;
                    }
                    String tenantToken = this.dataMapIamService.getTenantToken(tenantId);
                    String tenantName = null;
                    HashMap<String, ArrayList<Map<String, String>>> userTimeRangeTmp = new HashMap<String, ArrayList<Map<String, String>>>();
                    HashMap<String, AuthorizedUserResult> userInfoMap = new HashMap<String, AuthorizedUserResult>();
                    HashSet<String> hasSetUserList = new HashSet<String>();
                    Set<Map.Entry<String, List>> groupByAppEntries = collectByApp.entrySet();
                    for (Map.Entry<String, List> entry1 : groupByAppEntries) {
                        List<AuthorizedUserResult> appAuthorizedUserList;
                        String otherAppExpiredTime;
                        String otherAppEffectiveTime;
                        String appCode = entry1.getKey();
                        Map otherAppInfoMap = allAppAuthorizationsMap.get(appCode);
                        if (otherAppInfoMap == null || !this.checkIsEffective(startDate, endDate, otherAppEffectiveTime = String.valueOf(otherAppInfoMap.get("effectiveTime")), otherAppExpiredTime = String.valueOf(otherAppInfoMap.get("expiredTime"))) || CollectionUtils.isEmpty(appAuthorizedUserList = this.dataMapIamService.getAuthorizedUser(tenantToken, appCode))) continue;
                        List abiReportList = entry1.getValue();
                        for (AuthorizedUserResult authorizedUserResult : appAuthorizedUserList) {
                            Map<String, String> checkTimeRangeSuitableThenGet;
                            AuthorizedUser user = authorizedUserResult.getUser();
                            if (user.getId().endsWith("digiwin.com")) continue;
                            userInfoMap.put(user.getId(), authorizedUserResult);
                            if (hasSetUserList.contains(user.getId()) || !this.hasPermission("Athena", user.getId(), tenantToken, "report:module-enable", null) || !this.checkUserHasReportPermission(abiReportList, appCode, user.getId(), tenantToken)) continue;
                            ArrayList<Map<String, String>> tmpTimeRangList = (ArrayList<Map<String, String>>)userTimeRangeTmp.get(user.getId());
                            if (CollectionUtils.isEmpty((Collection)tmpTimeRangList)) {
                                tmpTimeRangList = new ArrayList<Map<String, String>>();
                                userTimeRangeTmp.put(user.getId(), tmpTimeRangList);
                            }
                            if ((checkTimeRangeSuitableThenGet = this.checkTimeRangeSuitableThenGet(tmpTimeRangList, startDate, endDate, otherAppEffectiveTime, otherAppExpiredTime)) == null) continue;
                            hasSetUserList.add(user.getId());
                            userTimeRangeTmp.remove(user.getId());
                            tenantName = ((TenantABIReportDAO)abiReportList.get(0)).getTenantName();
                            ABIReportUserStatistics abiReportUserStatistics = new ABIReportUserStatistics();
                            abiReportUserStatistics.setTenantId(tenantId);
                            abiReportUserStatistics.setTenantName(StringUtils.isNotEmpty((CharSequence)tenantName) ? tenantName : tenantId);
                            abiReportUserStatistics.setUserId(user.getId());
                            abiReportUserStatistics.setUserName(user.getName());
                            abiReportUserStatistics.setOpeningStartDate(checkTimeRangeSuitableThenGet.get("effectiveTime").substring(0, 10));
                            abiReportUserStatistics.setOpeningCloseDate(checkTimeRangeSuitableThenGet.get("expiredTime").substring(0, 10));
                            abiReportUserStatistics.setProportion(this.calculateProportion(startDate, endDate, abiReportUserStatistics.getOpeningStartDate(), abiReportUserStatistics.getOpeningCloseDate()));
                            result.add(abiReportUserStatistics);
                        }
                    }
                    if (!ObjectUtils.isEmpty(userTimeRangeTmp)) {
                        Set userTimeRangeEntrys = userTimeRangeTmp.entrySet();
                        for (Map.Entry userTimeRangeEntry : userTimeRangeEntrys) {
                            String key = (String)userTimeRangeEntry.getKey();
                            List value1 = (List)userTimeRangeEntry.getValue();
                            if (!CollectionUtils.isNotEmpty((Collection)value1)) continue;
                            for (Map map : value1) {
                                ABIReportUserStatistics abiReportUserStatistics = new ABIReportUserStatistics();
                                abiReportUserStatistics.setTenantId(tenantId);
                                abiReportUserStatistics.setTenantName(StringUtils.isNotEmpty(tenantName) ? tenantName : tenantId);
                                abiReportUserStatistics.setUserId(key);
                                abiReportUserStatistics.setUserName(((AuthorizedUserResult)userInfoMap.get(key)).getUser().getName());
                                abiReportUserStatistics.setOpeningStartDate(((String)map.get("effectiveTime")).substring(0, 10));
                                abiReportUserStatistics.setOpeningCloseDate(((String)map.get("expiredTime")).substring(0, 10));
                                abiReportUserStatistics.setProportion(this.calculateProportion(startDate, endDate, abiReportUserStatistics.getOpeningStartDate(), abiReportUserStatistics.getOpeningCloseDate()));
                                result.add(abiReportUserStatistics);
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("getABIReportUserStatistics error:{}", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return result;
    }

    private Map<String, String> checkTimeRangeSuitableThenGet(List<Map<String, String>> tmpTimeRangList, String startDate, String endDate, String newEffectiveTime, String newExpiredTime) {
        String expiredTime;
        Map<String, String> stringStringMap;
        String effectiveTime;
        if (this.isTimeSuitable(startDate, endDate, newEffectiveTime, newExpiredTime)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("effectiveTime", newEffectiveTime);
            map.put("expiredTime", newExpiredTime);
            return map;
        }
        this.mergedTimeRange(tmpTimeRangList, newEffectiveTime, newExpiredTime);
        if (tmpTimeRangList != null && tmpTimeRangList.size() == 1 && this.isTimeSuitable(startDate, endDate, effectiveTime = (stringStringMap = tmpTimeRangList.get(0)).get("effectiveTime"), expiredTime = stringStringMap.get("expiredTime"))) {
            return stringStringMap;
        }
        return null;
    }

    private void mergedTimeRange(List<Map<String, String>> tmpTimeRangList, String newEffectiveTime, String newExpiredTime) {
        if (CollectionUtils.isEmpty(tmpTimeRangList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("effectiveTime", newEffectiveTime);
            map.put("expiredTime", newExpiredTime);
            tmpTimeRangList.add(map);
        } else {
            boolean mergeFlag = false;
            Iterator<Map<String, String>> iterator = tmpTimeRangList.iterator();
            while (iterator.hasNext()) {
                Map<String, String> next = iterator.next();
                if (!this.checkTimeCanMerge(next.get("effectiveTime"), next.get("expiredTime"), newEffectiveTime, newExpiredTime)) continue;
                newEffectiveTime = this.getEarlyEffectiveTime(next.get("effectiveTime"), newEffectiveTime);
                newExpiredTime = this.getLateExpireTime(next.get("expiredTime"), newExpiredTime);
                iterator.remove();
                mergeFlag = true;
                break;
            }
            if (mergeFlag) {
                this.mergedTimeRange(tmpTimeRangList, newEffectiveTime, newExpiredTime);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("effectiveTime", newEffectiveTime);
                map.put("expiredTime", newExpiredTime);
                tmpTimeRangList.add(map);
            }
        }
    }

    private boolean checkTimeCanMerge(String startDate, String endDate, String effectiveTime, String expiredTime) {
        LocalDate startLocalDate = LocalDate.parse(startDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(endDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate effectiveLocalDate = LocalDate.parse(effectiveTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate expiredLocalDate = LocalDate.parse(expiredTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return startLocalDate.compareTo(expiredLocalDate) < 0 && endLocalDate.compareTo(effectiveLocalDate) > 0 || startLocalDate.isEqual(expiredLocalDate) || startLocalDate.minusDays(1L).equals(effectiveLocalDate) || endLocalDate.isEqual(effectiveLocalDate) || endLocalDate.plusDays(1L).equals(effectiveLocalDate);
    }

    private String getEarlyEffectiveTime(String effectiveTime1, String effectiveTime2) {
        LocalDate endLocalDate;
        LocalDate startLocalDate = LocalDate.parse(effectiveTime1.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        if (startLocalDate.isBefore(endLocalDate = LocalDate.parse(effectiveTime2.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd")))) {
            return effectiveTime1.substring(0, 10);
        }
        return effectiveTime2.substring(0, 10);
    }

    private String getLateExpireTime(String effectiveTime1, String effectiveTime2) {
        LocalDate endLocalDate;
        LocalDate startLocalDate = LocalDate.parse(effectiveTime1.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        if (startLocalDate.isBefore(endLocalDate = LocalDate.parse(effectiveTime2.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd")))) {
            return effectiveTime2.substring(0, 10);
        }
        return effectiveTime1.substring(0, 10);
    }

    private long localDateCompare(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate, ChronoUnit.DAYS);
    }

    private String calculateProportion(String startDate, String endDate, String appStart, String appEnd) {
        LocalDate startLocalDate = LocalDate.parse(startDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(endDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate effectiveLocalDate = LocalDate.parse(appStart.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate expiredLocalDate = LocalDate.parse(appEnd.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        if (effectiveLocalDate.compareTo(startLocalDate) <= 0 && expiredLocalDate.compareTo(endLocalDate) >= 0) {
            return "1";
        }
        if (effectiveLocalDate.compareTo(startLocalDate) < 0) {
            long totalDay = this.localDateCompare(startLocalDate, endLocalDate);
            long useDay = this.localDateCompare(startLocalDate, expiredLocalDate);
            return this.calculateProportion(totalDay, useDay);
        }
        long totalDay = this.localDateCompare(startLocalDate, endLocalDate);
        long useDay = this.localDateCompare(effectiveLocalDate, endLocalDate);
        return this.calculateProportion(totalDay, useDay);
    }

    private String calculateProportion(long totalDay, long useDay) {
        BigDecimal totalbigDecimal = new BigDecimal(String.valueOf(totalDay));
        BigDecimal usebigDecimal = new BigDecimal(String.valueOf(useDay));
        return usebigDecimal.divide(totalbigDecimal, 2, 4).toString();
    }

    private boolean isTimeSuitable(String startDate, String endDate, String effectiveTime, String expiredTime) {
        LocalDate startLocalDate = LocalDate.parse(startDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(endDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate effectiveLocalDate = LocalDate.parse(effectiveTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate expiredLocalDate = LocalDate.parse(expiredTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return startLocalDate.compareTo(effectiveLocalDate) >= 0 && endLocalDate.compareTo(expiredLocalDate) <= 0;
    }

    public static void main(String[] args) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("effectiveTime", "2022-01-02");
        map.put("expiredTime", "2022-02-01");
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("effectiveTime", "2022-05-03");
        map1.put("expiredTime", "2022-06-03");
        list.add(map);
        list.add(map1);
        new DataMapReportManager().mergedTimeRange(list, "2022-03-04", "2022-05-03");
        System.out.println(list);
    }

    private boolean checkUserHasReportPermission(List<TenantABIReportDAO> abiReportList, String appCode, String userId, String token) {
        Object allUserPermission = this.dataMapIamService.getUserPermission(appCode, userId, token);
        for (TenantABIReportDAO tenantABIReportDAO : abiReportList) {
            if (!this.hasPermission(appCode, userId, token, "report:" + tenantABIReportDAO.getCode(), "enable", allUserPermission)) continue;
            return true;
        }
        return false;
    }

    private String getAppGroupKey(TenantABIReportDAO tenantABIReportDAO, Map<String, Application> nameSpaceAppMap) {
        if (StringUtils.isNotEmpty((CharSequence)tenantABIReportDAO.getAthenaNamespace())) {
            return tenantABIReportDAO.getAthenaNamespace();
        }
        Application appEntity = nameSpaceAppMap.get(tenantABIReportDAO.getNamespace());
        if (appEntity != null) {
            return appEntity.getCode();
        }
        return tenantABIReportDAO.getNamespace();
    }

    private Map<String, Map> userAllAppAuthorizations(String tenantId) {
        HashMap<String, Map> result = new HashMap<String, Map>();
        Object obj = this.datamapCacService.authorizationsTenants(tenantId);
        if (obj == null) {
            return result;
        }
        JSONArray jsonArray = JSON.parseArray((String)JSONObject.toJSONString((Object)obj));
        for (int i = 0; i < jsonArray.size(); ++i) {
            String code = jsonArray.getJSONObject(i).getString("code");
            if (result.containsKey(code)) continue;
            result.put(code, (Map)jsonArray.getJSONObject(i));
        }
        return result;
    }

    private boolean checkIsEffective(String startDate, String endDate, String effectiveTime, String expiredTime) {
        LocalDate startLocalDate = LocalDate.parse(startDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(endDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate effectiveLocalDate = LocalDate.parse(effectiveTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate expiredLocalDate = LocalDate.parse(expiredTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return startLocalDate.compareTo(expiredLocalDate) < 0 && endLocalDate.compareTo(effectiveLocalDate) > 0;
    }

    private boolean hasPermission(String appCode, String userId, String token, String target, String conditionKey) {
        Object allUserPermission = this.dataMapIamService.getUserPermission(appCode, userId, token);
        return this.hasPermission(appCode, userId, token, target, conditionKey, allUserPermission);
    }

    private boolean hasPermission(String appCode, String userId, String token, String target, String conditionKey, Object allUserPermission) {
        JSONObject responseJson = JSONObject.parseObject((String)JSON.toJSONString((Object)allUserPermission));
        String code = responseJson.getString("code");
        if (!"200".equals(code)) {
            return false;
        }
        JSONArray permissions = responseJson.getJSONArray("data");
        if (permissions == null) {
            return true;
        }
        for (int i = 0; i < permissions.size(); ++i) {
            JSONObject moduleJsonObject;
            JSONObject permissionJson = permissions.getJSONObject(i);
            JSONObject conditions = permissionJson.getJSONObject("conditions");
            String dbTarget = permissionJson.getString("target");
            if (!StringUtils.equals((CharSequence)dbTarget, (CharSequence)("drn:iam:app:" + appCode + ":" + target))) continue;
            String effect = permissionJson.getString("effect");
            if (!StringUtils.equals((CharSequence)"allow", (CharSequence)effect)) {
                return false;
            }
            if (!StringUtils.isNotEmpty((CharSequence)conditionKey) || (moduleJsonObject = conditions.getJSONObject("drn:iam:app:" + appCode + ":" + target)) == null) continue;
            String psermissionResult = moduleJsonObject.getString(conditionKey);
            return StringUtils.equals((CharSequence)"allow", (CharSequence)psermissionResult);
        }
        return true;
    }
}

