/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.povo.ActivityInputData;
import com.digiwin.athena.datamap.povo.ViewRequest;
import com.digiwin.athena.datamap.service.IActivityService;
import com.digiwin.athena.datamap.service.IViewService;
import com.digiwin.athena.datamap.service.impl.DataMapTaskService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.definition.actions.DataEntity;
import com.digiwin.athena.domain.definition.actions.DataEntityMetadataDTO;
import com.digiwin.athena.domain.definition.actions.DataField;
import com.digiwin.athena.dto.ActivityBaseInfoVO;
import com.digiwin.athena.dto.ActivityVisibleConfig;
import com.digiwin.athena.kg.monitorRule.ConditionOperatorTypeEnum;
import com.digiwin.athena.kg.monitorRule.DynamicCondition;
import com.digiwin.athena.kg.monitorRule.DynamicConditionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.repository.neo4j.ActivityRepository;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@MyExceptionHandler
@Service
public class DataMapActivityService
implements IActivityService {
    private static final Logger log = LoggerFactory.getLogger(DataMapActivityService.class);
    private static final String ACTIVITY = "activity";
    private static final String PRODUCT_CODE = "productCode";
    @Autowired
    @Lazy
    DataMapTaskService dataMapTaskService;
    @Autowired
    private DataMapPickService dataPickService;
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private ProductNameResolver productNameResolver;
    @Autowired
    private IKnowledgeGraphService knowledgeGraphService;
    @Autowired
    private DataMapKgService dataMapKgService;
    @Autowired
    private IViewService viewService;

    @Override
    public Object postSaveActivity(Activity activity) {
        this.dataPickService.save((TenantObject)activity, Activity.class);
        return activity;
    }

    @Override
    public Map<String, Object> getInputData(String activityId) throws DWBusinessException {
        Task task = (Task)this.dataPickService.findByCode(activityId, Task.class);
        if (null != task && null != task.getInputData()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(ACTIVITY, activityId);
            result.put("inputData", task.getInputData());
            return result;
        }
        return null;
    }

    @Override
    @Deprecated
    public Map<String, Object> getInputData(String taskId, String activityId) throws DWBusinessException {
        String tenantVersion;
        String tenantId = ServiceUtils.getTenantId();
        Optional<ActivityInputData> inputData = this.activityRepository.getActivityInputData(tenantId, taskId, activityId, tenantVersion = this.dataPickService.tenantVersion());
        if (inputData.isPresent()) {
            ActivityInputData data = inputData.get();
            data.getInputData().setField(new ArrayList<DataField>(data.getFields()));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(ACTIVITY, activityId);
            result.put("inputData", DataEntityMetadataDTO.convertFromDataEntity((DataEntity)data.getInputData()));
            return result;
        }
        return null;
    }

    @Override
    public List<ActivityBaseInfoVO> postActivityByTask(String taskCode, String appCode, String locale, Map<String, Object> paramCodeAndValue) throws Exception {
        ViewRequest request = new ViewRequest();
        request.setProjectCode(taskCode);
        request.setLocale(locale);
        List<ActivityBaseInfoVO> tasks = this.viewService.postTasksByProject(request);
        if (null == tasks || tasks.isEmpty()) {
            return Collections.emptyList();
        }
        String tenantId = ServiceUtils.getTenantId();
        List<ActivityBaseInfoVO> filterResult = this.filterActivityInfo(appCode, tasks, paramCodeAndValue, tenantId);
        this.setConfig(taskCode, tenantId, filterResult);
        return filterResult;
    }

    @Override
    public List<ActivityBaseInfoVO> getAllApproveActivityByApp(String applicationCode, String locale) throws DWException {
        ServiceUtils.setLocale((String)locale);
        List<String> codes = this.dataPickService.getCodeByTypeAndAppCode(ACTIVITY, applicationCode);
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> q = new HashMap<String, Object>();
        q.put("code", codes);
        q.put("type", "approve");
        ViewRequest viewRequest = new ViewRequest();
        viewRequest.getQuery().putAll(q);
        return this.viewService.postTaskListApprove(viewRequest);
    }

    private List<ActivityBaseInfoVO> filterActivityInfo(String applicationCode, List<ActivityBaseInfoVO> approveActivityList, Map<String, Object> paramCodeAndValue, String tenantId) throws Exception {
        ArrayList<ActivityBaseInfoVO> result = new ArrayList<ActivityBaseInfoVO>();
        List productList = this.productNameResolver.getCloudProductNamesWithRetryAfterEocSet(tenantId, 3);
        for (ActivityBaseInfoVO activityBaseInfo : approveActivityList) {
            Object activityCode = JSONPath.eval((Object)activityBaseInfo, (String)"activityId");
            Bson bsonHasProduct = Filters.and((Bson[])new Bson[]{Filters.eq((String)"activityCode", (Object)activityCode), Filters.eq((String)"appCode", (Object)applicationCode), Filters.in((String)PRODUCT_CODE, (Iterable)productList)});
            ActivityVisibleConfig activityVisibleConfig = this.knowledgeGraphService.findOne(bsonHasProduct, ActivityVisibleConfig.class, "activityVisibleConfig", KnowledgeGraphDb.SYSTEM);
            if (activityVisibleConfig == null) {
                Bson bsonHasNoProduct = Filters.and((Bson[])new Bson[]{Filters.eq((String)"activityCode", (Object)activityCode), Filters.eq((String)"appCode", (Object)applicationCode), Filters.or((Bson[])new Bson[]{Filters.eq((String)PRODUCT_CODE, (Object)""), Filters.eq((String)PRODUCT_CODE, null)})});
                activityVisibleConfig = this.knowledgeGraphService.findOne(bsonHasNoProduct, ActivityVisibleConfig.class, "activityVisibleConfig", KnowledgeGraphDb.SYSTEM);
            }
            if (!this.conditionResult(activityVisibleConfig, paramCodeAndValue).booleanValue()) continue;
            result.add(activityBaseInfo);
        }
        return result;
    }

    private Boolean conditionResult(ActivityVisibleConfig activityVisibleConfig, Map<String, Object> paramCodeAndValue) throws DWBusinessException {
        if (activityVisibleConfig == null) {
            return true;
        }
        DynamicCondition dynamicCondition = activityVisibleConfig.getAcitvityVisibleCondition();
        if (DynamicConditionTypeEnum.SINGLE.toString().equals(dynamicCondition.getType())) {
            return this.judgeExpression(dynamicCondition, paramCodeAndValue);
        }
        if (DynamicConditionTypeEnum.AND_GROUP.toString().equals(dynamicCondition.getType())) {
            return this.judgeAndGroup(paramCodeAndValue, dynamicCondition);
        }
        if (DynamicConditionTypeEnum.OR_GROUP.toString().equals(dynamicCondition.getType())) {
            return this.judgeOrGroup(paramCodeAndValue, dynamicCondition);
        }
        return true;
    }

    private Boolean judgeAndGroup(Map<String, Object> paramCodeAndValue, DynamicCondition dynamicCondition) throws DWBusinessException {
        List conditions = dynamicCondition.getItems();
        for (DynamicCondition cd : conditions) {
            if (this.judgeExpression(cd, paramCodeAndValue).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private Boolean judgeOrGroup(Map<String, Object> paramCodeAndValue, DynamicCondition dynamicCondition) throws DWBusinessException {
        List conditions = dynamicCondition.getItems();
        for (DynamicCondition cd : conditions) {
            if (!this.judgeExpression(cd, paramCodeAndValue).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Boolean judgeExpression(DynamicCondition dc, Map<String, Object> paramCodeAndValue) throws DWBusinessException {
        boolean result = false;
        if (paramCodeAndValue == null || paramCodeAndValue.isEmpty()) {
            paramCodeAndValue = (Map)this.dataMapKgService.getVariable(dc.getLeft(), ServiceUtils.getTenantId());
        }
        if (paramCodeAndValue == null || paramCodeAndValue.isEmpty()) {
            return true;
        }
        Object variable = paramCodeAndValue.get(dc.getLeft());
        String op = dc.getOp();
        String[] value = dc.getRight().split(",");
        if (ConditionOperatorTypeEnum.IN.toString().equals(op) && Arrays.asList(value).contains(String.valueOf(variable))) {
            result = true;
        }
        try {
            double douValue;
            if (ConditionOperatorTypeEnum.GREATER_THAN.toString().equals(op)) {
                double d = douValue = variable != null ? Double.parseDouble(String.valueOf(variable)) : 0.0;
                if (douValue > Double.parseDouble(value[0])) {
                    result = true;
                }
            }
            if (ConditionOperatorTypeEnum.LESS_THAN.toString().equals(op)) {
                double d = douValue = variable != null ? Double.parseDouble(String.valueOf(variable)) : 0.0;
                if (douValue < Double.parseDouble(value[0])) {
                    result = true;
                }
            }
        }
        catch (Exception e) {
            log.error("\u6761\u4ef6\u6570\u503c\u6bd4\u8f83\u51fa\u73b0\u5f02\u5e38, \u8bf7\u68c0\u67e5\u914d\u7f6e\u6761\u4ef6\u503c\u7c7b\u578b\uff01");
            throw e;
        }
        return result;
    }

    private void setConfig(String taskCode, String tenantId, List<ActivityBaseInfoVO> filterResult) throws DWException {
        if (CollectionUtils.isEmpty(filterResult)) {
            return;
        }
        for (ActivityBaseInfoVO item : filterResult) {
            Map<String, Object> dm = this.getTaskInfoFromDataMap(taskCode, item.getActivityId(), tenantId);
            item.setConfig((Map)dm.get("config"));
        }
    }

    private Map<String, Object> getTaskInfoFromDataMap(String taskId, String activityId, String tenantId) throws DWException {
        ViewRequest request = new ViewRequest();
        request.setProjectCode(taskId);
        request.setTaskCode(activityId);
        return this.viewService.postTask(request);
    }
}

