/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.component.ComponentHandler;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.ConditionParser;
import com.digiwin.athena.datamap.povo.Product;
import com.digiwin.athena.datamap.service.IMechanismService;
import com.digiwin.athena.datamap.service.impl.ProjectService;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kg.domain.VariableDefinition;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.cache.Cache;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.dto.MechanismConfigReq;
import com.digiwin.athena.mechanism.dto.MechanismFilterDTO;
import com.digiwin.athena.preset.Rule;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@MyExceptionHandler
@Service
public class DataMapMechanismService
implements IMechanismService {
    private static final Logger log = LoggerFactory.getLogger(DataMapMechanismService.class);
    private static final String MECHANISM_VARIABLE_COLLECTION_NAME = "mechanismVariable";
    private static final String MECHANISM_VARIABLE_ID_KEY_NAME = "variableId";
    private static final String MECHANISM_VARIABLE_VALUE_FIELD_NAME = "value";
    private static final String TENANT_ID_KEY_NAME = "tenantId";
    private static final String MECHANISM_VARIABLE_INDEX_NAME = "mechanismVariable";
    private static final String MECHANISM_TENANT_PARADIGM = "mechanismTenantParadigm";
    private static final String SYSTEM = "SYSTEM";
    @Autowired
    DataPickService dataPickService;
    @Autowired
    DataMapKgDataPickService kdDataPickService;
    @Autowired
    PluginService pluginService;
    @Autowired
    ProjectService projectService;
    @Autowired
    List<ComponentHandler> componentHandlers;
    @Autowired
    PresetLibraryService presetLibraryService;
    @Autowired
    ConditionParser conditionParser;
    @Autowired
    MechanismParserFactory mechanismParserFactory;
    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    @Qualifier(value="kgSystem")
    MongoTemplate kgSystem;
    @Autowired
    @Qualifier(value="kgTenant")
    MongoTemplate kgTenant;
    @Autowired
    @Lazy
    DataMapMechanismService self;

    @Override
    public Object postComponentApply(MechanismComponentDTO component) throws Exception {
        log.info("postComponentApply....{}", (Object)component);
        System.out.println("\u5f00\u59cb\u5e94\u7528\u7ec4\u4ef6\uff0ccomponent=" + JSON.toJSONString((Object)component));
        Object obj = null;
        for (ComponentHandler handler : this.componentHandlers) {
            if (!handler.accept(component)) continue;
            obj = handler.handlerApply(component);
            break;
        }
        return obj;
    }

    @Override
    public Object postComponentUnApply(MechanismComponentDTO component) throws Exception {
        Object obj = null;
        log.info("postComponentUnApply....{}", (Object)component);
        for (ComponentHandler handler : this.componentHandlers) {
            if (!handler.accept(component)) continue;
            obj = handler.handlerUnApply(component);
            break;
        }
        return obj;
    }

    @Override
    public List<Task> attachTasks(String masterCode) throws DWBusinessException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("masterCode", masterCode);
        param.put("assistantType", "MECHANISM");
        List tasks = this.dataPickService.find(BasicQuery.of(param, null), Task.class);
        return tasks;
    }

    @Override
    public Object postMechanismConfig(MechanismConfigReq req) throws DWException {
        HashMap<String, List<Rule>> result = new HashMap<String, List<Rule>>();
        if (null == req.getAction()) {
            return result;
        }
        switch (req.getAction()) {
            case "rules": {
                result.put("rules", this.mechanismRules(req.getCode()));
                break;
            }
        }
        return result;
    }

    public List<Rule> mechanismRules(String taskCode) {
        ArrayList<Rule> rulesMech = new ArrayList<Rule>();
        try {
            List<Rule> rulesAll = this.presetLibraryService.rules(taskCode);
            for (Rule r : rulesAll) {
                if (null == r.getPluginId()) continue;
                rulesMech.add(r);
            }
        }
        catch (Exception e) {
            log.error("mechanismRules error", (Throwable)e);
        }
        return rulesMech;
    }

    @Override
    public Object postQueryApiResult(MechanismApiInfoDTO apiInfoDTO) {
        log.info("MechanismService.postQueryApiResult beginning...apiInfoDTO={}", (Object)apiInfoDTO);
        JSONObject result = new JSONObject();
        Object handleResult = this.mechanismParserFactory.getAbilityHandlerByType(apiInfoDTO.getAbilityType()).parseScene(apiInfoDTO);
        result.put("meta_data_list", handleResult);
        return result;
    }

    @Override
    public Boolean judgeBusinessCondition(MechanismApiInfoDTO apiInfoDTO) {
        log.info("MechanismService.judgeBusinessCondition beginning...apiInfoDTO={}", (Object)apiInfoDTO);
        Object handleResult = this.mechanismParserFactory.getAbilityHandlerByType(apiInfoDTO.getAbilityType()).parseScene(apiInfoDTO);
        JSONArray handleResultJson = JSONObject.parseArray((String)JSON.toJSONString((Object)handleResult));
        return !CollectionUtils.isEmpty((Collection)handleResultJson);
    }

    @Override
    public Object postFilterListByBusinessCondition(MechanismFilterDTO mechanismFilterDTO) {
        log.info("MechanismService.postFilterListByBusinessCondition beginning...mechanismFilterDTO={}", (Object)mechanismFilterDTO);
        Map<String, Object> resultMap = this.conditionParser.parseSingleScene(mechanismFilterDTO.getGroups(), mechanismFilterDTO.getDataList(), null, null);
        log.info("MechanismService.postFilterListByBusinessCondition ending...resultMap={}", resultMap);
        if (!CollectionUtils.isEmpty(resultMap)) {
            return resultMap.get("list");
        }
        return null;
    }

    private Map<String, Object> getStringObjectMap(String variableName, String tenantId, boolean isGetDefault) throws DWBusinessException {
        if (variableName == null || variableName.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue((String)"knowledgegraph.variableEmpty", (Object[])new Object[0]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.equals((CharSequence)variableName, (CharSequence)"hasGroundEnd")) {
            Object hasGroundEnd = this.self.getHasGroundEnd();
            result.put(variableName, hasGroundEnd);
            result.put(TENANT_ID_KEY_NAME, tenantId);
            return result;
        }
        MongoCollection col = this.kgTenant.getCollection("mechanismVariable");
        Document doc = (Document)col.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)MECHANISM_VARIABLE_ID_KEY_NAME, (Object)variableName), Filters.eq((String)TENANT_ID_KEY_NAME, (Object)tenantId)})).first();
        if (doc != null) {
            Object val = doc.get((Object)MECHANISM_VARIABLE_VALUE_FIELD_NAME);
            if (isGetDefault) {
                val = this.getDefValue(val, variableName);
            }
            result.put(variableName, val);
            result.put(TENANT_ID_KEY_NAME, doc.get((Object)TENANT_ID_KEY_NAME));
        } else {
            if (!isGetDefault) {
                return result;
            }
            VariableDefinition def = this.getDefinition(variableName);
            if (def != null) {
                result.put(variableName, def.getDefaultValue());
                result.put(TENANT_ID_KEY_NAME, tenantId);
            }
        }
        return result;
    }

    public VariableDefinition getDefinition(String variableName) throws DWBusinessException {
        return this.kdDataPickService.findByCode(variableName, VariableDefinition.class, "variableDefinition");
    }

    @Cache(key="'knowledgegraph:SYSTEM:'+ctx.tenantId+':'+'getHasGroundEnd'")
    public Object getHasGroundEnd() throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        List allSteadyProductList = (List)this.getAllSteadyProduct();
        try {
            Object o = this.productNameResolver.tenantProductOperationList(tenantId);
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)o));
            JSONArray gateways = jsonObject.getJSONArray("prod_eoc_mapping");
            if (gateways == null) {
                return "N";
            }
            for (int i = 0; i < gateways.size(); ++i) {
                String prod_name = gateways.getJSONObject(i).getString("prod_name");
                if (!allSteadyProductList.contains(prod_name)) continue;
                return !ObjectUtils.isEmpty((Object)gateways.getJSONObject(i).get((Object)"org_type_company")) || !ObjectUtils.isEmpty((Object)gateways.getJSONObject(i).get((Object)"org_type_region")) ? "Y" : "N";
            }
        }
        catch (Exception e) {
            log.error("hasGroundEnd\u83b7\u53d6\u4ea7\u54c1\u4fe1\u606f\u5931\u8d25:{}", (Throwable)e);
            return "N";
        }
        return "N";
    }

    public Object getAllSteadyProduct() throws DWBusinessException {
        Query query = new Query();
        query.fields().include("product");
        List products = this.kgSystem.find(query, Product.class);
        return products.stream().map(Product::getProduct).distinct().collect(Collectors.toList());
    }

    private Object getDefValue(Object val, String variableName) throws DWBusinessException {
        if (val instanceof List) {
            String key = null;
            String valKey = null;
            VariableDefinition def = this.getDefinition(variableName);
            if (def != null) {
                List cols;
                Map typeDef;
                if (StringUtils.equals((CharSequence)def.getDisplayType(), (CharSequence)"TABLE") && def.getDisplayTypeDefinition() != null && def.getDisplayTypeDefinition() instanceof Map && (typeDef = (Map)def.getDisplayTypeDefinition()).get("category").equals("radioboxgroup") && typeDef.get("columns") instanceof List && !CollectionUtils.isEmpty((Collection)(cols = (List)typeDef.get("columns"))) && cols.get(0) instanceof Map) {
                    Map col = (Map)cols.get(0);
                    key = (String)col.get("key");
                    List exts = (List)col.get("extends");
                    if (!CollectionUtils.isEmpty((Collection)exts) && exts.get(0) instanceof Map) {
                        Map ext = (Map)exts.get(0);
                        valKey = (String)ext.get("key");
                    }
                }
                if (StringUtils.isEmpty(key) || StringUtils.isEmpty(valKey)) {
                    return val;
                }
                if (def.getDefaultValue() != null && def.getDefaultValue() instanceof List) {
                    List defValList = (List)def.getDefaultValue();
                    List valList = (List)val;
                    for (Map defVal : defValList) {
                        boolean exist = false;
                        for (Map v : valList) {
                            if (!defVal.get(key).equals(v.get(key))) continue;
                            exist = true;
                            break;
                        }
                        if (exist) continue;
                        HashMap d = new HashMap();
                        d.put(key, defVal.get(key));
                        d.put(valKey, defVal.get(valKey));
                        valList.add(d);
                    }
                }
            }
        }
        return val;
    }

    public Object getVariable(String variableName, String tenantId) throws DWBusinessException {
        log.info("enter getVariable " + variableName + " " + tenantId);
        Map<String, Object> result = this.getStringObjectMap(variableName, tenantId, true);
        return result;
    }
}

