/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.dao.DataMapActivityDAO;
import com.digiwin.athena.datamap.report.DataMapReportManager;
import com.digiwin.athena.datamap.service.IStatementService;
import com.digiwin.athena.datamap.service.impl.DataMapActionService;
import com.digiwin.athena.datamap.service.impl.DataMapDictService;
import com.digiwin.athena.datamap.service.impl.DataMapTenantService;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.utils.AthenaUtils;
import com.digiwin.athena.datamap.utils.DataMapHttpUtil;
import com.digiwin.athena.datamap.utils.JsonUtil;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.action.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.dto.StatementQueryConditionDTO;
import com.digiwin.athena.kg.statement.StatementDynamicCondition;
import com.digiwin.athena.kg.statement.StatementFormAdapter;
import com.digiwin.athena.kg.statement.StatementFormAdapterSystem;
import com.digiwin.athena.kg.statement.StatementFormMatcher;
import com.digiwin.athena.kg.statement.exception.StatementMatchException;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.repository.neo4j.ActivityRepository;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Lang
@Service
@MyExceptionHandler
public class DataMapStatementService
implements IStatementService {
    private static final Logger log = LoggerFactory.getLogger(DataMapStatementService.class);
    @Autowired
    @Qualifier(value="kgSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="kgTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    DataMapReportManager dataMapReportManager;
    @Autowired
    KmService kmService;
    @Autowired
    DataMapActionService dataMapActionService;
    @Autowired
    DataMapTenantService dataMapTenantService;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    DataMapKgDataPickService dataPickService;
    @Autowired
    private DataMapActivityDAO dataMapActivityDAO;
    public static final String COPY_CUSTOMIZE = "/abi/copy.rpt.customize";
    public static final String DELETE_CUSTOMIZE = "/abi/delete.customize";
    public static final String EDIT_WORKNAME_CUSTOMIZE = "/abi/update.rptname.customize";
    public static final String REPORT_KEY = "reportKey";
    @Value(value="${abiUrl}")
    private String dapUri;
    @Autowired
    private DataMapDictService dataMapDictService;

    @Override
    public Object postResId(StatementQueryConditionDTO queryObject) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"statementCode").is((Object)queryObject.getStatementCode()).and("tenantId").is((Object)queryObject.getTenantId()));
        StatementFormAdapter statementFormAdapter = (StatementFormAdapter)this.mongoTemplateUser.findOne(query, StatementFormAdapter.class, "statementFormAdapter");
        Map<Object, Object> resIdMap = new HashMap();
        if (null != statementFormAdapter) {
            List conditions = statementFormAdapter.getDynamicConditions();
            Map<String, String> resIdMapNew = this.matchConditionNew(queryObject.getCondition(), conditions);
            if (!CollectionUtils.isEmpty(resIdMapNew)) {
                return resIdMapNew;
            }
            resIdMap = this.matchCondition(queryObject.getCondition(), conditions);
        }
        if (CollectionUtils.isEmpty(resIdMap)) {
            resIdMap = this.postSystemResId(queryObject.getStatementCode(), queryObject.getCondition(), queryObject.getTenantId());
        }
        return resIdMap;
    }

    private Map<String, String> postSystemResId(String statementCode, Map<String, Object> condition, String tenantId) {
        String tenantVersion = this.kmService.tenantVersion(tenantId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"statementCode").is((Object)statementCode).and("version").is((Object)tenantVersion));
        StatementFormAdapterSystem statementFormAdapter = (StatementFormAdapterSystem)this.mongoTemplate.findOne(query, StatementFormAdapterSystem.class, "statementFormAdapter");
        if (null == statementFormAdapter) {
            return Collections.EMPTY_MAP;
        }
        List conditions = statementFormAdapter.getDynamicConditions();
        Map<String, String> resIdMapNew = this.matchConditionSystem(condition, conditions);
        if (!CollectionUtils.isEmpty(resIdMapNew)) {
            return resIdMapNew;
        }
        Map<String, String> resIdMap = this.matchCondition(condition, conditions);
        return resIdMap;
    }

    @Override
    public Object getDataCharacteristic(String tenantId, String statementCode) throws Exception {
        JSONArray jsonArray = this.getDataCharacteristicArray(statementCode);
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.dataNotFound", (Object[])new Object[0]), null);
        }
        return this.returnObj(200, I18nUtils.getValue((String)"knowledgegraph.success", (Object[])new Object[0]), jsonArray);
    }

    @Override
    public Object postEditStyle(String tenantId, String date, String resId, String statementCode) throws DWBusinessException {
        String appCode = this.getAppCodeByStatementCode(statementCode);
        if (StringUtils.isEmpty((CharSequence)appCode)) {
            return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.appCodeNotFound", (Object[])new Object[0]), null);
        }
        Query queryCustom = Query.query((CriteriaDefinition)Criteria.where((String)"statementCode").is((Object)statementCode).and("tenantId").is((Object)tenantId));
        StatementFormAdapter statementFormAdapter = (StatementFormAdapter)this.mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        List customList = statementFormAdapter.getDynamicConditions();
        for (StatementDynamicCondition statementDynamicCondition : customList) {
            String existResId = statementDynamicCondition.getResId();
            if (!resId.equals(existResId)) continue;
            statementDynamicCondition.setLastUpdateUserName(tenantId);
            statementDynamicCondition.setLastUpdateTime(date);
        }
        Update update = new Update();
        update.set("dynamicConditions", (Object)customList);
        this.mongoTemplateUser.upsert(queryCustom, (UpdateDefinition)update, "statementFormAdapter");
        return this.returnObj(200, I18nUtils.getValue((String)"knowledgegraph.success", (Object[])new Object[0]), null);
    }

    @Override
    public Object postCopyStyle(String tenantId, String workName, String resId, String statementCode, String lang) throws DWBusinessException {
        ArrayList<StatementDynamicCondition> customList;
        String appCode = this.getAppCodeByStatementCode(statementCode);
        log.info("dapUri:{}", (Object)this.dapUri);
        if (StringUtils.isEmpty((CharSequence)appCode)) {
            return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.appCodeNotFound", (Object[])new Object[0]), null);
        }
        JSONObject paramBody = new JSONObject();
        paramBody.put("resid", (Object)resId);
        paramBody.put("rptname", (Object)workName);
        paramBody.put("program_id", (Object)statementCode);
        paramBody.put("app_id", (Object)appCode);
        String url = this.dapUri + COPY_CUSTOMIZE + "?@routerKey=" + this.getTenant();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        url = this.addUrlParamFromHeader(request, url, "@ReportKey", REPORT_KEY);
        String token = request.getHeader("token");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-user", token);
        String response = DataMapHttpUtil.post(url, paramBody.toJSONString(), headers);
        log.info("response---" + response);
        JSONObject responseJson = JSONObject.parseObject((String)response);
        if (responseJson == null) {
            return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.copyStatementError", (Object[])new Object[0]), null);
        }
        if (200 != responseJson.getInteger("status")) {
            return this.returnObj(responseJson.getInteger("status"), responseJson.getString("message"), null);
        }
        String newResId = responseJson.getString("data");
        Query queryCustom = Query.query((CriteriaDefinition)Criteria.where((String)"statementCode").is((Object)statementCode).and("tenantId").is((Object)tenantId));
        StatementFormAdapter statementFormAdapter = (StatementFormAdapter)this.mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        if (statementFormAdapter == null) {
            statementFormAdapter = new StatementFormAdapter();
            statementFormAdapter.setTenantId(tenantId);
            statementFormAdapter.setStatementCode(statementCode);
        }
        if (CollectionUtils.isEmpty((Collection)(customList = statementFormAdapter.getDynamicConditions()))) {
            customList = new ArrayList<StatementDynamicCondition>();
        }
        StatementDynamicCondition statementDynamicCondition = new StatementDynamicCondition();
        statementDynamicCondition.setType(Integer.valueOf(1));
        statementDynamicCondition.setStatus(Integer.valueOf(0));
        statementDynamicCondition.setResId(newResId);
        statementDynamicCondition.setLang(lang);
        statementDynamicCondition.setWorkName(workName);
        statementDynamicCondition.setLastUpdateTime(DateUtils.formatDate((Date)new Date(), (String)"EEE, dd MMM yyyy HH:mm:ss zzz"));
        statementDynamicCondition.setLastUpdateUserName(this.getUserName());
        statementDynamicCondition.setAppCode(appCode);
        customList.add(statementDynamicCondition);
        Update update = new Update();
        update.set("tenantId", (Object)tenantId);
        update.set("statementCode", (Object)statementCode);
        update.set("dynamicConditions", customList);
        this.mongoTemplateUser.upsert(queryCustom, (UpdateDefinition)update, "statementFormAdapter");
        return this.returnObj(200, I18nUtils.getValue((String)"knowledgegraph.success", (Object[])new Object[0]), null);
    }

    @Override
    public Object postDeleteStyle(String tenantId, String resId, String statementCode) throws DWBusinessException {
        String appCode = this.getAppCodeByStatementCode(statementCode);
        if (StringUtils.isEmpty((CharSequence)appCode)) {
            return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.appCodeNotFound", (Object[])new Object[0]), null);
        }
        JSONObject paramBody = new JSONObject();
        paramBody.put("resid", (Object)resId);
        paramBody.put("program_id", (Object)statementCode);
        paramBody.put("app_id", (Object)appCode);
        String url = this.dapUri + DELETE_CUSTOMIZE + "?@routerKey=" + this.getTenant();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        url = this.addUrlParamFromHeader(request, url, "@ReportKey", REPORT_KEY);
        String token = request.getHeader("token");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-user", token);
        String response = DataMapHttpUtil.post(url, paramBody.toJSONString(), headers);
        log.info("response---" + response);
        JSONObject responseJson = JSONObject.parseObject((String)response);
        if (responseJson == null) {
            return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.deleteStatementError", (Object[])new Object[0]), null);
        }
        if (200 != responseJson.getInteger("status")) {
            return this.returnObj(responseJson.getInteger("status"), responseJson.getString("message"), null);
        }
        Query queryCustom = Query.query((CriteriaDefinition)Criteria.where((String)"statementCode").is((Object)statementCode).and("tenantId").is((Object)tenantId));
        StatementFormAdapter statementFormAdapter = (StatementFormAdapter)this.mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        List customList = statementFormAdapter.getDynamicConditions();
        for (StatementDynamicCondition statementDynamicCondition : customList) {
            String existResId = statementDynamicCondition.getResId();
            if (!resId.equals(existResId)) continue;
            customList.remove(statementDynamicCondition);
            break;
        }
        Update update = new Update();
        update.set("dynamicConditions", (Object)customList);
        this.mongoTemplateUser.upsert(queryCustom, (UpdateDefinition)update, "statementFormAdapter");
        return this.returnObj(200, I18nUtils.getValue((String)"knowledgegraph.success", (Object[])new Object[0]), null);
    }

    @Override
    public Object getStyleList(String tenantId, String statementCode) throws Exception {
        List conditionalPreinstallList;
        String tenantVersion;
        Activity activityNeo4j;
        String locale = AthenaUtils.getCurrentLocale();
        String version = this.kmService.tenantVersion();
        Query queryPreinstall = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)statementCode).and("version").is((Object)version));
        Query queryCustom = Query.query((CriteriaDefinition)Criteria.where((String)"statementCode").is((Object)statementCode).and("tenantId").is((Object)tenantId));
        Activity tenantActivity = (Activity)this.mongoTemplate.findOne(queryPreinstall, Activity.class, "activityConfigs");
        List<StatementDynamicCondition> preinstallList = this.getPreinstallList(tenantActivity, activityNeo4j = this.dataPickService.chooseOneWithSameCode(this.dataMapActivityDAO.getActivityByCodeAndVersion(statementCode, tenantVersion = this.dataMapTenantService.getTenantVersion(tenantId), tenantId)), locale);
        if (CollectionUtils.isEmpty(preinstallList)) {
            return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.statementStyleNotFound", (Object[])new Object[0]), null);
        }
        Query queryConditionalPreinstall = Query.query((CriteriaDefinition)Criteria.where((String)"statementCode").is((Object)statementCode).and("version").is((Object)tenantVersion));
        StatementFormAdapter conditionalPreinstallStatementFormAdapter = (StatementFormAdapter)this.mongoTemplate.findOne(queryConditionalPreinstall, StatementFormAdapter.class, "statementFormAdapter");
        if (null != conditionalPreinstallStatementFormAdapter && !CollectionUtils.isEmpty((Collection)(conditionalPreinstallList = conditionalPreinstallStatementFormAdapter.getDynamicConditions()))) {
            conditionalPreinstallList.forEach(item -> item.setType(Integer.valueOf(0)));
            preinstallList.addAll(conditionalPreinstallList);
        }
        String appCode = this.getAppCodeByStatementCode(statementCode);
        StatementFormAdapter statementFormAdapter = (StatementFormAdapter)this.mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        List<StatementDynamicCondition> customList = this.getCustomList(statementFormAdapter);
        if (!CollectionUtils.isEmpty(customList)) {
            preinstallList.addAll(customList);
        }
        JSONArray jsonArray = this.getDataCharacteristicArray(statementCode);
        this.renderDescription(preinstallList, jsonArray);
        return this.returnObj(200, I18nUtils.getValue((String)"knowledgegraph.success", (Object[])new Object[0]), preinstallList);
    }

    private void renderDescription(List<StatementDynamicCondition> preinstallList, JSONArray jsonArray) {
        if (!CollectionUtils.isEmpty(preinstallList)) {
            List jsonObjectList = jsonArray.toJavaList(JSONObject.class);
            Map<Object, Object> map = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)jsonObjectList)) {
                map = jsonObjectList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getString("paramPath"), item -> item.getString("description")));
            }
            HashMap finalMap = map;
            preinstallList.forEach(dynamicCondition -> {
                List items = dynamicCondition.getItems();
                if (!CollectionUtils.isEmpty((Collection)items) && !CollectionUtils.isEmpty((Map)finalMap)) {
                    items.forEach(item -> item.setDescription((String)finalMap.get(item.getParamPath())));
                }
            });
        }
    }

    @Override
    public Object postStylePublish(String tenantId, String workName, String resId, String statementCode, String lang, List<StatementFormMatcher> items) throws Exception {
        boolean isEditWorkName = false;
        Query queryCustom = Query.query((CriteriaDefinition)Criteria.where((String)"statementCode").is((Object)statementCode).and("tenantId").is((Object)tenantId));
        StatementFormAdapter statementFormAdapter = (StatementFormAdapter)this.mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        List statementDynamicConditions = statementFormAdapter.getDynamicConditions();
        for (StatementDynamicCondition statementDynamicCondition : statementDynamicConditions) {
            if (resId.equals(statementDynamicCondition.getResId())) {
                if (statementDynamicCondition.getStatus() == 1) {
                    return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.styleIspublished", (Object[])new Object[0]), null);
                }
                if (!workName.equals(statementDynamicCondition.getWorkName())) {
                    isEditWorkName = true;
                }
                statementDynamicCondition.setStatus(Integer.valueOf(1));
                statementDynamicCondition.setWorkName(workName);
                statementDynamicCondition.setLastUpdateTime(DateUtils.formatDate((Date)new Date(), (String)"EEE, dd MMM yyyy HH:mm:ss zzz"));
                statementDynamicCondition.setLastUpdateUserName(this.getUserName());
                if (!CollectionUtils.isEmpty(items)) {
                    JSONArray dataCharacteristicArray = this.getDataCharacteristicArray(statementCode);
                    Map<String, String> dataCharacteristicMap = this.dataCharacteristicArray2Map(dataCharacteristicArray);
                    for (StatementFormMatcher item : items) {
                        item.setDescription(dataCharacteristicMap.get(item.getParamPath()));
                    }
                }
                statementDynamicCondition.setItems(items);
                continue;
            }
            if (statementDynamicCondition.getStatus() == null || statementDynamicCondition.getLang() == null || statementDynamicCondition.getItems() == null || statementDynamicCondition.getStatus() != 1 || !lang.equals(statementDynamicCondition.getLang()) || !this.compareItems(statementDynamicCondition.getItems(), items)) continue;
            return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.styleRepet", (Object[])new Object[0]), null);
        }
        if (isEditWorkName) {
            String appCode = this.getAppCodeByStatementCode(statementCode);
            if (StringUtils.isEmpty((CharSequence)appCode)) {
                return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.appCodeNotFound", (Object[])new Object[0]), null);
            }
            JSONObject paramBody = new JSONObject();
            paramBody.put("resid", (Object)resId);
            paramBody.put("program_id", (Object)statementCode);
            paramBody.put("app_id", (Object)appCode);
            paramBody.put("rptname", (Object)workName);
            String url = this.dapUri + EDIT_WORKNAME_CUSTOMIZE + "?@routerKey=" + this.getTenant();
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            url = this.addUrlParamFromHeader(request, url, "@ReportKey", REPORT_KEY);
            String token = request.getHeader("token");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("digi-middleware-auth-user", token);
            String response = DataMapHttpUtil.post(url, paramBody.toJSONString(), headers);
            log.info("response---" + response);
            JSONObject responseJson = JSONObject.parseObject((String)response);
            if (responseJson == null) {
                return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.publishStatementError", (Object[])new Object[0]), null);
            }
            if (200 != responseJson.getInteger("status")) {
                return this.returnObj(responseJson.getInteger("status"), responseJson.getString("message"), null);
            }
        }
        Update update = new Update();
        update.set("dynamicConditions", (Object)statementDynamicConditions);
        this.mongoTemplateUser.upsert(queryCustom, (UpdateDefinition)update, "statementFormAdapter");
        return this.returnObj(200, I18nUtils.getValue((String)"knowledgegraph.success", (Object[])new Object[0]), null);
    }

    private String addUrlParamFromHeader(HttpServletRequest request, String url, String urlParamKey, String headerKey) {
        String value = request.getHeader(headerKey);
        log.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u53c2\u6570headerKey\uff1a{}\uff0cvalue\uff1a{}", (Object)headerKey, (Object)value);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            url = url + "&" + urlParamKey + "=" + value;
        }
        log.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u53c2\u6570url\uff1a{}", (Object)url);
        return url;
    }

    @Override
    public Object postStyleUnPublish(String tenantId, String resId, String statementCode) {
        Query queryCustom = Query.query((CriteriaDefinition)Criteria.where((String)"statementCode").is((Object)statementCode).and("tenantId").is((Object)tenantId));
        StatementFormAdapter statementFormAdapter = (StatementFormAdapter)this.mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        List statementDynamicConditions = statementFormAdapter.getDynamicConditions();
        for (StatementDynamicCondition statementDynamicCondition : statementDynamicConditions) {
            if (!resId.equals(statementDynamicCondition.getResId())) continue;
            if (statementDynamicCondition.getStatus() != 1) {
                return this.returnObj(-1, I18nUtils.getValue((String)"knowledgegraph.styleIsUnPublish", (Object[])new Object[0]), null);
            }
            statementDynamicCondition.setStatus(Integer.valueOf(2));
            statementDynamicCondition.setLastUpdateTime(DateUtils.formatDate((Date)new Date(), (String)"EEE, dd MMM yyyy HH:mm:ss zzz"));
            statementDynamicCondition.setLastUpdateUserName(this.getUserName());
        }
        Update update = new Update();
        update.set("dynamicConditions", (Object)statementDynamicConditions);
        this.mongoTemplateUser.upsert(queryCustom, (UpdateDefinition)update, "statementFormAdapter");
        return this.returnObj(200, I18nUtils.getValue((String)"knowledgegraph.success", (Object[])new Object[0]), null);
    }

    private Map<String, String> matchConditionNew(Map<String, Object> condition, List<StatementDynamicCondition> conditions) {
        HashMap<String, String> resIdMap = new HashMap<String, String>();
        for (int i = 0; i < conditions.size(); ++i) {
            StatementDynamicCondition statementDynamicCondition = conditions.get(i);
            if (statementDynamicCondition.getStatus() == null || statementDynamicCondition.getStatus() != 1) continue;
            List matchers = statementDynamicCondition.getItems();
            if (CollectionUtils.isEmpty((Collection)matchers)) {
                resIdMap.put("resId_" + statementDynamicCondition.getLang(), statementDynamicCondition.getResId());
                continue;
            }
            int count = 0;
            for (int j = 0; j < matchers.size() && this.matchNew((StatementFormMatcher)matchers.get(j), condition); ++j) {
                ++count;
            }
            if (count != matchers.size() && matchers.size() != 0) continue;
            resIdMap.put("resId_" + statementDynamicCondition.getLang(), statementDynamicCondition.getResId());
        }
        return resIdMap;
    }

    private Map<String, String> matchConditionSystem(Map<String, Object> condition, List<StatementDynamicCondition> conditions) {
        HashMap<String, String> resIdMap = new HashMap<String, String>();
        for (int i = 0; i < conditions.size(); ++i) {
            StatementDynamicCondition statementDynamicCondition = conditions.get(i);
            List matchers = statementDynamicCondition.getItems();
            if (CollectionUtils.isEmpty((Collection)matchers)) {
                resIdMap.put("resId_" + statementDynamicCondition.getLang(), statementDynamicCondition.getResId());
                continue;
            }
            int count = 0;
            for (int j = 0; j < matchers.size() && this.matchNew((StatementFormMatcher)matchers.get(j), condition); ++j) {
                ++count;
            }
            if (count != matchers.size() && matchers.size() != 0) continue;
            resIdMap.put("resId_" + statementDynamicCondition.getLang(), statementDynamicCondition.getResId());
        }
        return resIdMap;
    }

    private Map<String, String> matchCondition(Map<String, Object> condition, List<StatementDynamicCondition> conditions) {
        for (int i = 0; i < conditions.size(); ++i) {
            List matchers = conditions.get(i).getItems();
            if (CollectionUtils.isEmpty((Collection)matchers)) {
                return conditions.get(i).getResIdMap();
            }
            int count = 0;
            for (int j = 0; j < matchers.size() && this.match((StatementFormMatcher)matchers.get(j), condition); ++j) {
                ++count;
            }
            if (count != matchers.size() && matchers.size() != 0) continue;
            return conditions.get(i).getResIdMap();
        }
        return Collections.EMPTY_MAP;
    }

    private boolean matchNew(StatementFormMatcher statementFormMatcher, Map<String, Object> condition) {
        String param;
        String operator = statementFormMatcher.getOperator();
        String valueType = statementFormMatcher.getValueType().toUpperCase();
        String value = statementFormMatcher.getValue();
        try {
            param = (String)JsonPath.read(condition, (String)statementFormMatcher.getParamPath(), (Predicate[])new Predicate[0]);
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u9519\u8bef:{}", (Object)statementFormMatcher.getParamPath());
            return false;
        }
        switch (operator) {
            case "EQUAL": {
                switch (valueType) {
                    case "STRING": {
                        return value.equals(param);
                    }
                    case "INTEGER": {
                        return Integer.parseInt(value) == Integer.parseInt(param);
                    }
                    case "LONG": {
                        return Long.parseLong(value) == Long.parseLong(param);
                    }
                    case "DOUBLE": {
                        return Double.parseDouble(value) == Double.parseDouble(param);
                    }
                }
                throw new StatementMatchException(I18nUtils.getValue((String)"knowledgegraph.dataTypeNotSupport", (Object[])new Object[0]) + valueType);
            }
            case "START_WITH": {
                switch (valueType) {
                    case "STRING": {
                        return param.startsWith(value);
                    }
                }
                throw new StatementMatchException(I18nUtils.getValue((String)"knowledgegraph.dataTypeNotSupport", (Object[])new Object[0]) + valueType);
            }
        }
        throw new StatementMatchException(I18nUtils.getValue((String)"knowledgegraph.dataTypeNotSupport", (Object[])new Object[0]) + operator);
    }

    private boolean compareItems(List<StatementFormMatcher> list1, List<StatementFormMatcher> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        int count = 0;
        for (StatementFormMatcher statementFormMatcher1 : list1) {
            String paramPath1 = statementFormMatcher1.getParamPath();
            String value1 = statementFormMatcher1.getValue();
            for (StatementFormMatcher statementFormMatcher2 : list2) {
                String paramPath2 = statementFormMatcher2.getParamPath();
                String value2 = statementFormMatcher2.getValue();
                if (!paramPath2.equals(paramPath1) || !value2.equals(value1)) continue;
                ++count;
            }
        }
        return list1.size() == count;
    }

    private boolean match(StatementFormMatcher statementFormMatcher, Map<String, Object> condition) {
        String param;
        String operator = statementFormMatcher.getOperator();
        String valueType = statementFormMatcher.getValueType().toUpperCase();
        String value = statementFormMatcher.getValue();
        try {
            param = (String)JsonPath.read(condition, (String)statementFormMatcher.getParamPath(), (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.warn("pathNotFoundException for paramPath:{}", (Object)statementFormMatcher.getParamPath());
            return false;
        }
        catch (ClassCastException classCastException) {
            log.error("classCastException for paramPath:{}, condition:{}", (Object)statementFormMatcher.getParamPath(), (Object)JsonUtil.toJsonString(condition));
            return false;
        }
        catch (Exception exception) {
            log.error("exception for paramPath:{}, condition:{}", (Object)statementFormMatcher.getParamPath(), (Object)JsonUtil.toJsonString(condition));
            return false;
        }
        switch (operator) {
            case "EQUAL": {
                switch (valueType) {
                    case "STRING": {
                        return value.equals(param);
                    }
                    case "INTEGER": {
                        return Integer.parseInt(value) == Integer.parseInt(param);
                    }
                    case "LONG": {
                        return Long.parseLong(value) == Long.parseLong(param);
                    }
                    case "DOUBLE": {
                        return Double.parseDouble(value) == Double.parseDouble(param);
                    }
                }
                throw new StatementMatchException(I18nUtils.getValue((String)"knowledgegraph.dataTypeNotSupport", (Object[])new Object[0]) + valueType);
            }
            case "START_WITH": {
                switch (valueType) {
                    case "STRING": {
                        return param.startsWith(value);
                    }
                }
                throw new StatementMatchException(I18nUtils.getValue((String)"knowledgegraph.dataTypeNotSupport", (Object[])new Object[0]) + valueType);
            }
        }
        throw new StatementMatchException(I18nUtils.getValue((String)"knowledgegraph.dataTypeNotSupport", (Object[])new Object[0]) + operator);
    }

    private List<StatementDynamicCondition> getPreinstallList(Activity activity, Activity activityNeo4j, String locale) {
        if (activity == null || null == activityNeo4j) {
            return Collections.emptyList();
        }
        Map pages = activity.getPages();
        if (pages == null) {
            return Collections.emptyList();
        }
        JSONObject pagesJson = new JSONObject(pages);
        JSONObject detailJson = pagesJson.getJSONObject("condition-detail");
        if (detailJson == null) {
            return Collections.emptyList();
        }
        JSONObject extendedFields = detailJson.getJSONObject("extendedFields");
        if (extendedFields == null) {
            return Collections.emptyList();
        }
        ArrayList<StatementDynamicCondition> statementDynamicConditions = new ArrayList<StatementDynamicCondition>();
        for (String key : extendedFields.keySet()) {
            Map nameLang;
            StatementDynamicCondition statementDynamicCondition = new StatementDynamicCondition();
            Map map = nameLang = CollectionUtils.isEmpty((Map)activity.getLang()) ? Collections.EMPTY_MAP : (Map)activity.getLang().get("name");
            if (key.contains("zh_CN")) {
                statementDynamicCondition.setLang("zh_CN");
            } else if (key.contains("zh_TW")) {
                statementDynamicCondition.setLang("zh_TW");
            } else {
                if (!key.contains("en_US")) continue;
                statementDynamicCondition.setLang("en_US");
            }
            statementDynamicCondition.setResId(extendedFields.getString(key));
            statementDynamicCondition.setStatus(Integer.valueOf(1));
            statementDynamicCondition.setType(Integer.valueOf(0));
            statementDynamicCondition.setWorkName(StringUtils.isEmpty((CharSequence)((CharSequence)nameLang.get(locale))) ? activity.getName() : (String)nameLang.get(locale));
            statementDynamicConditions.add(statementDynamicCondition);
        }
        return statementDynamicConditions;
    }

    private List<StatementDynamicCondition> getCustomList(StatementFormAdapter statementFormAdapter) {
        Date now = new Date();
        if (statementFormAdapter == null) {
            return null;
        }
        List statementDynamicConditions = statementFormAdapter.getDynamicConditions();
        List<StatementDynamicCondition> returnStatementDynamicConditions = statementDynamicConditions.stream().filter(s -> !StringUtils.isEmpty((CharSequence)s.getResId())).collect(Collectors.toList());
        returnStatementDynamicConditions.stream().forEach(s -> {
            if (now.getTime() - DateUtils.parseDate((String)s.getLastUpdateTime()).getTime() < 3000L) {
                s.setHighLight(true);
            }
            s.setLastUpdateTime(DateUtils.formatDate((Date)DateUtils.parseDate((String)s.getLastUpdateTime()), (String)"yyyy/MM/dd"));
        });
        return this.sortCustomList(returnStatementDynamicConditions);
    }

    private List<StatementDynamicCondition> sortCustomList(List<StatementDynamicCondition> statementDynamicConditions) {
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        for (StatementDynamicCondition statementDynamicCondition : statementDynamicConditions) {
            String workName = statementDynamicCondition.getWorkName();
            if (map.containsKey(workName)) {
                List statementDynamicConditionsExist = (List)map.get(workName);
                statementDynamicConditionsExist.add(statementDynamicCondition);
                map.put(workName, statementDynamicConditionsExist);
                continue;
            }
            ArrayList<StatementDynamicCondition> statementDynamicConditionsNotExist = new ArrayList<StatementDynamicCondition>();
            statementDynamicConditionsNotExist.add(statementDynamicCondition);
            map.put(workName, statementDynamicConditionsNotExist);
        }
        ArrayList<StatementDynamicCondition> newStatementDynamicConditions = new ArrayList<StatementDynamicCondition>();
        for (String workName : map.keySet()) {
            newStatementDynamicConditions.addAll((Collection)map.get(workName));
        }
        return newStatementDynamicConditions;
    }

    private String getAppCodeByStatementCode(String statementCode) throws DWBusinessException {
        ApplicationRelation applicationRelation = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)statementCode), ApplicationRelation.class, "applicationRelation");
        if (applicationRelation != null) {
            return applicationRelation.getAppCode();
        }
        return null;
    }

    private List<String> getActionIdsByActivity(Activity activity) {
        if (activity == null) {
            return null;
        }
        Map pages = activity.getPages();
        if (pages == null) {
            return null;
        }
        JSONObject pagesJson = new JSONObject(pages);
        JSONObject detailJson = pagesJson.getJSONObject("condition-detail");
        if (detailJson == null) {
            return null;
        }
        JSONArray submitActions = detailJson.getJSONArray("submitActions");
        if (submitActions == null) {
            return null;
        }
        ArrayList<String> actionIds = new ArrayList<String>();
        for (int i = 0; i < submitActions.size(); ++i) {
            JSONObject action = submitActions.getJSONObject(i);
            String actionId = action.getString("actionId");
            actionIds.add(actionId);
        }
        return actionIds;
    }

    private Map<String, String> dataCharacteristicArray2Map(JSONArray jsonArray) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            map.put(jsonObject.getString("paramPath"), jsonObject.getString("description"));
        }
        return map;
    }

    private String getUserName() {
        Map profile = DWServiceContext.getContext().getProfile();
        return profile.getOrDefault("userName", "");
    }

    private String getTenant() {
        Map profile = DWServiceContext.getContext().getProfile();
        return profile.getOrDefault("tenantId", "");
    }

    private JSONArray getDataCharacteristicArray(String statementCode) throws Exception {
        String version = this.kmService.tenantVersion();
        Query queryPreinstall = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)statementCode).and("version").is((Object)version));
        Activity tenantActivity = (Activity)this.mongoTemplate.findOne(queryPreinstall, Activity.class, "activityConfigs");
        List<String> actionIds = this.getActionIdsByActivity(tenantActivity);
        JSONArray jsonArray = new JSONArray();
        if (CollectionUtils.isEmpty(actionIds)) {
            return jsonArray;
        }
        for (String actionId : actionIds) {
            GetActionLocaleResponseDTO actionLocaleResponseDTO = (GetActionLocaleResponseDTO)this.dataMapActionService.getMetadata(actionId);
            List apiDataFieldLocaleMetadataDTOS = actionLocaleResponseDTO.getRequest().getParameters();
            for (ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO : apiDataFieldLocaleMetadataDTOS) {
                List apiDataFieldLocaleMetadataDTOS1 = apiDataFieldLocaleMetadataDTO.getField();
                if (CollectionUtils.isEmpty((Collection)apiDataFieldLocaleMetadataDTOS1)) continue;
                List<String> enumKeys = apiDataFieldLocaleMetadataDTOS1.stream().map(ApiDataFieldLocaleMetadataDTO::getEnum_key).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toList());
                Map<String, List<Map<String, String>>> dictMaps = this.getDictsByEnumkeys(enumKeys);
                for (ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO1 : apiDataFieldLocaleMetadataDTOS1) {
                    JSONObject jsonObject = new JSONObject();
                    String paramPath = apiDataFieldLocaleMetadataDTO1.getData_name();
                    String description = apiDataFieldLocaleMetadataDTO1.getDescription();
                    String enumKey = apiDataFieldLocaleMetadataDTO1.getEnum_key();
                    jsonObject.put("paramPath", (Object)paramPath);
                    jsonObject.put("description", (Object)description);
                    jsonArray.add((Object)jsonObject);
                    Optional.ofNullable(enumKey).map(dictMaps::get).ifPresent(options -> jsonObject.put("options", options));
                }
            }
        }
        return jsonArray;
    }

    private Object returnObj(Integer code, String message, Object object) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", code);
        result.put("message", message);
        result.put("list", object);
        return result;
    }

    public static void main(String[] args) {
    }

    @Override
    public Object getABIReportUser(String startDate, String endDate) throws DWBusinessException {
        return this.dataMapReportManager.getABIReportUserStatistics(startDate, endDate);
    }

    private Map<String, List<Map<String, String>>> getDictsByEnumkeys(List<String> enumKeys) throws DWBusinessException {
        if (CollectionUtils.isEmpty(enumKeys)) {
            return Maps.newHashMap();
        }
        Object dict = this.dataMapDictService.postFindDictByKeyList(enumKeys);
        if (null == dict) {
            return Maps.newHashMap();
        }
        return ((Map)dict).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(t -> ImmutableMap.of((Object)"value", (Object)t.getCode(), (Object)"title", (Object)t.getValue(), (Object)"desc", (Object)t.getDesc(), (Object)"key", (Object)t.getKey())).collect(Collectors.toList())));
    }
}

