/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.enums.SourceType;
import com.digiwin.athena.datamap.enums.WSConfigType;
import com.digiwin.athena.datamap.enums.WSPageCode;
import com.digiwin.athena.datamap.povo.CardGroup;
import com.digiwin.athena.datamap.povo.CardGroupApplication;
import com.digiwin.athena.datamap.povo.CardGroupGroup;
import com.digiwin.athena.datamap.povo.CardGroupTask;
import com.digiwin.athena.datamap.povo.ConditionScopeVO;
import com.digiwin.athena.datamap.povo.SystemGroup;
import com.digiwin.athena.datamap.povo.SystemWSConditionVO;
import com.digiwin.athena.datamap.povo.WSConditionVO;
import com.digiwin.athena.datamap.povo.WorkbenchSettingVO;
import com.digiwin.athena.datamap.spi.AtmcService;
import com.digiwin.athena.kmservice.service.KmGeneralService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataMapTaskFieldService {
    private static final Logger log = LoggerFactory.getLogger(DataMapTaskFieldService.class);
    @Autowired
    private AtmcService atmcService;
    @Autowired
    private KmGeneralService kmGeneralService;

    public List<CardGroupGroup> sysCardGroups(String tenantId) {
        List<CardGroupGroup> sysCardGroups = null;
        try {
            sysCardGroups = this.atmcService.getGroupDimension(tenantId);
        }
        catch (Exception e) {
            log.error("getGroupDimension error", (Throwable)e);
        }
        if (null == sysCardGroups) {
            sysCardGroups = new ArrayList<CardGroupGroup>();
        }
        sysCardGroups.forEach(s -> {
            s.setEnabled(true);
            s.setCommonEnable(true);
        });
        return sysCardGroups;
    }

    public static List<WSConditionVO> systemCardGroupGroupToCondition(List<CardGroupGroup> cardGroupGroups) {
        List<WSConditionVO> wsConditionVOS = cardGroupGroups.stream().map(v -> {
            WSConditionVO wsConditionVO = (WSConditionVO)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)v), WSConditionVO.class)));
            wsConditionVO.setAliasName(v.getName());
            wsConditionVO.setAliasCode(v.getCode());
            wsConditionVO.setSourceType(SourceType.system);
            wsConditionVO.setDefaultEffective(v.isDefaultEffective());
            Boolean defaultGroup = v.getDefaultGroup();
            if (defaultGroup == null) {
                defaultGroup = v.isDefaultEffective();
            }
            wsConditionVO.setDefaultGroup(defaultGroup);
            wsConditionVO.setEnable(v.isEnabled());
            wsConditionVO.setCommonEnable(v.getCommonEnable() != null ? v.getCommonEnable() : true);
            return wsConditionVO;
        }).collect(Collectors.toList());
        List<WSConditionVO> taskGroupWSConditionVO = SystemWSConditionVO.taskGroupWSConditionVO;
        WSConditionVO groupByMember = taskGroupWSConditionVO.get(0);
        WSConditionVO groupByDepartment = taskGroupWSConditionVO.get(1);
        if (wsConditionVOS.stream().filter(v -> v.getAliasCode().equals(groupByMember.getAliasCode())).count() <= 0L) {
            wsConditionVOS.add(groupByMember);
        }
        if (wsConditionVOS.stream().filter(v -> v.getAliasCode().equals(groupByDepartment.getAliasCode())).count() <= 0L) {
            wsConditionVOS.add(groupByDepartment);
        }
        return wsConditionVOS;
    }

    public WorkbenchSettingVO cardGroupToWSConditionVO(CardGroup cardGroup) {
        List<WSConditionVO> defaultCondition;
        String tenantId;
        try {
            tenantId = ServiceUtils.getTenantId();
        }
        catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        WorkbenchSettingVO workbenchSettingVO = new WorkbenchSettingVO();
        workbenchSettingVO.setTenantId(tenantId);
        workbenchSettingVO.setPageCode(WSPageCode.task);
        workbenchSettingVO.setConfigType(WSConfigType.groups);
        ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<WSConditionVO>();
        if (!Boolean.FALSE.equals(cardGroup.getEnabled())) {
            List<CardGroupApplication> applications;
            List<CardGroupGroup> groups;
            SystemGroup system = cardGroup.getSystem();
            if (system != null && CollectionUtil.isNotEmpty(groups = system.getGroups())) {
                List<WSConditionVO> sysConditions = DataMapTaskFieldService.systemCardGroupGroupToCondition(groups);
                wsConditionVOS.addAll(sysConditions);
            }
            if (CollectionUtils.isNotEmpty(applications = cardGroup.getApplications())) {
                ArrayList<WSConditionVO> appConditionVOS = new ArrayList<WSConditionVO>();
                for (CardGroupApplication application : applications) {
                    List<CardGroupTask> tasks = application.getTasks();
                    if (!CollectionUtils.isNotEmpty(tasks)) continue;
                    for (CardGroupTask task : tasks) {
                        this.kmGeneralService.handleLang((Object)task);
                        List<CardGroupGroup> groups1 = task.getGroups();
                        if (!CollectionUtils.isNotEmpty(groups1)) continue;
                        for (CardGroupGroup group : groups1) {
                            WSConditionVO wsConditionVO = (WSConditionVO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)group)), WSConditionVO.class));
                            wsConditionVO.setAppCode(application.getAppCode());
                            wsConditionVO.setTaskCode(task.getCode());
                            wsConditionVO.setBusinessMessageSourceMethod(task.getBusinessMessageSourceMethod());
                            wsConditionVO.setTaskName(task.getName());
                            wsConditionVO.setTaskLang(task.getLang());
                            wsConditionVO.setAliasCode(group.getCode());
                            wsConditionVO.setAliasName(group.getName());
                            wsConditionVO.setSourceType(SourceType.customer);
                            wsConditionVO.setDefaultEffective(group.isDefaultEffective());
                            Boolean defaultGroup = group.getDefaultGroup();
                            if (defaultGroup == null) {
                                defaultGroup = group.isDefaultEffective();
                            }
                            wsConditionVO.setDefaultGroup(defaultGroup);
                            wsConditionVO.setEnable(group.isEnabled());
                            wsConditionVO.setCommonEnable(group.getCommonEnable() != null ? group.getCommonEnable() : true);
                            ConditionScopeVO conditionScopeVO = new ConditionScopeVO();
                            conditionScopeVO.setAppCode(application.getAppCode());
                            conditionScopeVO.setName(task.getName());
                            conditionScopeVO.setAppName(application.getAppName());
                            conditionScopeVO.setCode(task.getCode());
                            conditionScopeVO.setCardGroupTask((ConditionScopeVO.CardGroupTask)JSON.parseObject((String)JSON.toJSONString((Object)((Object)task)), ConditionScopeVO.CardGroupTask.class));
                            conditionScopeVO.setId(task.getTaskId());
                            conditionScopeVO.setBusinessMessageSourceMethod(task.getBusinessMessageSourceMethod());
                            wsConditionVO.setConditionScope(Collections.singletonList(conditionScopeVO));
                            appConditionVOS.add(wsConditionVO);
                        }
                    }
                }
                Map conditionMap = appConditionVOS.stream().collect(Collectors.groupingBy(WSConditionVO::getAliasCode, LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
                for (Map.Entry entry : conditionMap.entrySet()) {
                    List conditionVOS = (List)entry.getValue();
                    WSConditionVO wsConditionDTO = (WSConditionVO)((Object)conditionVOS.get(0));
                    wsConditionDTO.setConditionScope(conditionVOS.stream().flatMap(v -> v.getConditionScope().stream()).distinct().sorted(Comparator.comparing(ConditionScopeVO::getAppName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeVO::getId, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList()));
                    wsConditionVOS.add(wsConditionDTO);
                }
            }
        } else {
            List<CardGroupGroup> cardGroupGroups = this.sysCardGroups(tenantId);
            if (CollectionUtil.isNotEmpty(cardGroupGroups)) {
                List<WSConditionVO> sysConditions = DataMapTaskFieldService.systemCardGroupGroupToCondition(cardGroupGroups);
                wsConditionVOS.addAll(sysConditions);
            }
        }
        if ((defaultCondition = wsConditionVOS.stream().filter(v -> Boolean.TRUE.equals(v.getEnable())).map(v -> {
            WSConditionVO wsConditionVO = (WSConditionVO)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)v), WSConditionVO.class)));
            wsConditionVO.setEnable(v.getCommonEnable());
            return wsConditionVO;
        }).collect(Collectors.toList())).stream().anyMatch(v -> v.getSort() != null)) {
            defaultCondition = defaultCondition.stream().sorted(Comparator.comparing(v -> v.getSort(), Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        }
        workbenchSettingVO.setCondition(wsConditionVOS);
        workbenchSettingVO.setDefaultCondition(defaultCondition);
        return workbenchSettingVO;
    }
}

