/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.config.GroupCondition;
import com.digiwin.athena.datamap.mechanism.paradigm.DataMapParadigmService;
import com.digiwin.athena.datamap.povo.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.datamap.povo.ApplicationGroup;
import com.digiwin.athena.datamap.povo.DataRequest;
import com.digiwin.athena.datamap.povo.FindTaskFromUserRequest;
import com.digiwin.athena.datamap.povo.FindTaskFromUserResp;
import com.digiwin.athena.datamap.povo.GetActionLocaleResponseDTO;
import com.digiwin.athena.datamap.povo.MergeRule;
import com.digiwin.athena.datamap.povo.OperationUnit;
import com.digiwin.athena.datamap.povo.ProjectVo;
import com.digiwin.athena.datamap.povo.TaskDTO;
import com.digiwin.athena.datamap.povo.TaskMonitorRule;
import com.digiwin.athena.datamap.povo.ViewRequest;
import com.digiwin.athena.datamap.povo.rebuild.UserComponentDto;
import com.digiwin.athena.datamap.service.ITaskService;
import com.digiwin.athena.datamap.service.impl.DataMapViewService;
import com.digiwin.athena.datamap.service.impl.ProjectService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.spi.DbKnowledgeGraphService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.datamap.utils.CommonUtils;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Phase;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.StateMap;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.FunctionCtrl;
import com.digiwin.athena.domain.core.dtdflow.Asserts;
import com.digiwin.athena.domain.core.dtdflow.CustBizTask;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.flow.FlowNode;
import com.digiwin.athena.domain.core.view.PageUIElement;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.customBizTask.CustBizTaskConfigDTO;
import com.digiwin.athena.domain.definition.ReminderRule;
import com.digiwin.athena.domain.definition.features.DataFeatureSet;
import com.digiwin.athena.domain.definition.features.DataTagging;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.dto.DataStateVO;
import com.digiwin.athena.dto.TaskAndActivity;
import com.digiwin.athena.dto.TaskPathResp;
import com.digiwin.athena.dto.TaskPathVo;
import com.digiwin.athena.dto.TaskSchedule;
import com.digiwin.athena.dto.TenantCardTitleDefinition;
import com.digiwin.athena.kg.domain.TenantSummaryField;
import com.digiwin.athena.kg.domain.TenantSummaryFields;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.kmservice.dtd.DtdService;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.support.DapContext;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.repository.neo4j.TaskRepository;
import com.google.common.collect.Maps;
import com.mongodb.client.model.Filters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Lang
@MyExceptionHandler
@Service
public class DataMapTaskService
implements ITaskService {
    private static final Logger log = LoggerFactory.getLogger(DataMapTaskService.class);
    public static final String SUMMARY = "summary";
    public static final String BUSINESS_INFO = "businessInfo";
    public static final String SEARCH_KEY = "searchKey";
    public static final String PROJECT_INFO = "projectInfo";
    @Autowired
    ProjectService projectService;
    @Autowired
    DataMapPickService dataPickService;
    @Autowired
    DataMapParadigmService dataMapParadigmService;
    @Autowired
    private DataMapViewService dataMapViewService;
    @Autowired
    private IKnowledgeGraphService knowledgeGraphService;
    @Autowired
    private DataMapKgService dataMapKgService;
    @Autowired
    private ProductNameResolver productNameResolver;
    @Autowired
    KmService kmService;
    @Autowired
    DataMapIamService dataMapIamService;
    @Autowired
    private Executor taskExecutor;
    @Autowired
    private DbKnowledgeGraphService dbKnowledgeGraphService;
    @Autowired
    DtdService dtdService;
    @Autowired
    TaskRepository taskRepository;

    @Override
    public TaskPathResp postExecutePath(com.digiwin.athena.kmservice.povo.DataRequest request) throws DWException {
        return this.dtdService.postExecutePath(request);
    }

    private boolean reachProjectEnd(String current, String to, Project project) {
        if (to.equals(current)) {
            return true;
        }
        if (null != project.getEnds()) {
            for (DataState state : project.getEnds()) {
                if (!state.getCode().equals(current)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Task> postTasks(BasicQuery query) throws DWException {
        return this.dataPickService.findBetters(query, Task.class);
    }

    @Override
    public Task postTask(BasicQuery request) throws DWException {
        return (Task)this.dataPickService.findBetter(request, Task.class);
    }

    public TaskPathResp postExecutePathBak(DataRequest request) throws DWException {
        ServiceUtils.getContext().setEocInfo(request.getEocInfo());
        TaskPathResp resp = new TaskPathResp();
        String tenantId = ServiceUtils.getTenantId();
        request.setTenantId(tenantId);
        Project pro = this.projectService.getProjectByCode(request.getProjectCode());
        if (null == pro) {
            throw new DWException("P.DM.500.0001", I18nUtils.getValue((String)"P.DM.500.0001", (Object[])new Object[0]) + request);
        }
        String topProjectCode = pro.getCode();
        if (null != pro.getPrimaryProjectCode()) {
            topProjectCode = pro.getPrimaryProjectCode();
        }
        Application application = this.dbKnowledgeGraphService.tenantApp(pro.getApplication());
        boolean individualAll = Optional.ofNullable(application).map(Application::getIndividualAll).orElse(false);
        Project up = this.projectService.getUserProject(topProjectCode, request.getFromStateCode());
        resp.setStartProject(up);
        DataState begin = this.getDataState(request.getFromStateCode());
        resp.setFromState(begin);
        if (this.reachProjectEnd(request.getFromStateCode(), request.getToStateCode(), pro)) {
            return resp;
        }
        List<Task> tasks = this.bestTaskByFrom(request.getFromStateCode(), request, pro);
        if (!tasks.isEmpty()) {
            HashMap groups = new HashMap();
            tasks.removeIf(t -> individualAll && "SYSTEM".equals(t.getTenantId()));
            tasks.forEach(t -> {
                if (null == t.getGroup()) {
                    t.setGroup("default");
                }
                groups.computeIfAbsent(t.getGroup(), k -> new ArrayList()).add(t);
            });
            for (Map.Entry entry : groups.entrySet()) {
                List v = (List)entry.getValue();
                this.sortTasks(v, request);
                TaskPathVo vo = new TaskPathVo();
                vo.setTasks(v);
                Task first = (Task)v.get(0);
                first = this.fillTaskDetail(first);
                this.dealFeatures(first);
                vo.setTask(first);
                v.set(0, first);
                resp.getPaths().add(vo);
            }
        }
        return resp;
    }

    private void sortTasks(List<Task> tasks, DataRequest request) {
        for (Task t : tasks) {
            if (null == t.getPriority()) {
                t.setPriority(Integer.valueOf(0));
            }
            if (null == t.getScore()) {
                t.setScore(Integer.valueOf(0));
            }
            t.setScore(Integer.valueOf(t.getPriority() * 100 + t.getScore()));
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)t.getDataFeatures()) || request.getDateFeatures().isEmpty()) continue;
            for (DataTagging dt : t.getDataFeatures()) {
                if (!request.getDateFeatures().contains(dt.getCode())) continue;
                t.setScore(Integer.valueOf(t.getScore() + dt.getWeight()));
            }
        }
        tasks.sort((o1, o2) -> o2.getScore() - o1.getScore());
    }

    @Override
    public Task getTaskByCode(String code) throws DWException {
        Task detail = (Task)this.dataPickService.findBetter(code, Task.class);
        if ((detail = this.fillTaskDetail(detail)) == null) {
            return null;
        }
        this.dealFeatures(detail);
        return detail;
    }

    @Override
    @Deprecated
    public List<TaskSchedule> getTaskSchedule(String code) throws DWException {
        HashMap<String, String> q = new HashMap<String, String>();
        q.put("taskCode", code);
        return this.dataPickService.findBetters(BasicQuery.of(q, null), TaskSchedule.class);
    }

    @Override
    public Task postTaskByCode(DataRequest request) throws DWException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("code", request.getCode());
        Task detail = (Task)this.dataPickService.findBetter(BasicQuery.of(param, request.getEocInfo()), Task.class);
        detail = this.fillTaskDetail(detail);
        this.dealFeatures(detail);
        return detail;
    }

    private void dealFeatures(Task detail) {
        if (null == detail) {
            return;
        }
        detail.setFeatures(detail.getFeeInfo());
    }

    @Override
    public TaskAndActivity getTaskAndMilestoneActivity(String code) throws DWException {
        TaskAndActivity resp = new TaskAndActivity();
        Task t = this.getTaskByCode(code);
        resp.setTask(t);
        if (null != t.getFlow()) {
            Activity activity = this.milestoneActivity(t.getFlow());
            resp.setActivity(activity);
        }
        return resp;
    }

    @Override
    public FlowGraph getFlowByCode(String code) throws DWException {
        return (FlowGraph)this.dataPickService.findByCode(code, FlowGraph.class);
    }

    @Override
    public Activity getActivityByCode(String code) throws DWException {
        Activity activity = (Activity)this.dataPickService.findBetter(code, Activity.class);
        return this.processActivityConditions(activity);
    }

    private Activity processActivityConditions(Activity activity) {
        if (null != activity && "PARADIGM".equals(activity.getPattern())) {
            try {
                String expression = this.dataMapParadigmService.getExpression((String)activity.getConfig().get("_mechanismCode"), (String)activity.getConfig().get("_dataCode"));
                if (null != expression) {
                    List conditions = JSON.parseArray((String)JSON.toJSONString(activity.getConfig().get("conditions")), GroupCondition.class);
                    conditions.forEach(cond -> {
                        if (null != cond.getCondition()) {
                            cond.setCondition(expression);
                        }
                    });
                    activity.getConfig().put("conditions", conditions);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return activity;
    }

    @Override
    public Activity postActivityByCode(DataRequest request) throws DWException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("code", request.getCode());
        Activity activity = (Activity)this.dataPickService.findBetter(BasicQuery.of(param, request.getEocInfo()), Activity.class);
        return this.processActivityConditions(activity);
    }

    @Override
    public DataDescription getDataDescription(String code) throws DWException {
        return (DataDescription)this.dataPickService.findByCode(code, DataDescription.class);
    }

    @Override
    public DataDescription getDataDescriptionByStateCode(String stateCode) throws DWException {
        DataState desc = (DataState)this.dataPickService.findByCode(stateCode, DataState.class);
        if (null != desc) {
            return this.getDataDescription(desc.getDataCode());
        }
        return null;
    }

    public DataState getDataStateBasic(String code) throws DWException {
        return (DataState)this.dataPickService.findByCode(code, DataState.class);
    }

    @Override
    public DataState getDataState(String code) throws DWException {
        return this.getDataStateBasic(code);
    }

    @Override
    public DataStateVO getDataStateWithDesc(String code) throws DWException {
        DataState state = this.getDataStateBasic(code);
        DataDescription desc = this.getDataDescriptionByStateCode(code);
        DataStateVO vo = new DataStateVO();
        vo.setDataState(state);
        vo.setDataDesc(desc);
        return this.processDataFeatures(vo);
    }

    private DataStateVO processDataFeatures(DataStateVO vo) throws DWBusinessException {
        if (null != vo.getDataState() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)vo.getDataState().getDataFeatureSets())) {
            HashMap<String, List> query = new HashMap<String, List>();
            query.put("code", vo.getDataState().getDataFeatureSets());
            List tags = this.dataPickService.find(BasicQuery.of(query, null), DataFeatureSet.class);
            vo.setDataFeatures(tags);
        }
        return vo;
    }

    @Override
    @Deprecated
    public DataStateVO getDataStateTagged(String code) throws DWException {
        DataStateVO vo = this.getDataStateWithDesc(code);
        return this.processDataFeatures(vo);
    }

    @Override
    public List<DataStateVO> postDataStateNear(DataRequest request) throws DWException {
        ArrayList<DataStateVO> result = new ArrayList<DataStateVO>();
        if (null == request.getFromStateCode()) {
            return result;
        }
        List<String> states = this.taskRepository.nearStates(request.getFromStateCode());
        states.removeAll(request.getExcludeStateCodes());
        if (states.size() > 0) {
            HashMap<String, List<String>> query = new HashMap<String, List<String>>();
            query.put("code", states);
            List dataStates = this.dataPickService.findBetters(BasicQuery.of(query, null), DataState.class);
            if (dataStates.size() == 0) {
                return result;
            }
            HashSet tagCodes = new HashSet();
            dataStates.forEach(dataState -> {
                if (null != dataState.getDataFeatureSets()) {
                    tagCodes.addAll(dataState.getDataFeatureSets());
                }
            });
            HashMap mapTag = new HashMap();
            if (tagCodes.size() > 0) {
                HashMap query2 = new HashMap();
                query2.put("code", tagCodes);
                List tags = this.dataPickService.findBetters(BasicQuery.of(query2, null), DataFeatureSet.class);
                tags.forEach(tag -> mapTag.put(tag.getCode(), tag));
            }
            for (DataState dataState2 : dataStates) {
                DataStateVO vo = new DataStateVO();
                vo.setDataState(dataState2);
                if (null != dataState2.getDataFeatureSets()) {
                    dataState2.getDataFeatureSets().forEach(dt -> vo.getDataFeatures().add(mapTag.get(dt)));
                }
                result.add(vo);
            }
        }
        return result;
    }

    @Override
    public DataFeatureSet getDataFeatureSet(String code) throws DWException {
        return (DataFeatureSet)this.dataPickService.findByCode(code, DataFeatureSet.class);
    }

    @Override
    public Object clearTenantTaskField(String tenantId, String taskCode, String version, List<String> fields) {
        if (tenantId == null || taskCode == null || org.apache.commons.collections.CollectionUtils.isEmpty(fields)) {
            return ResponseEntity.ok();
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)taskCode));
        Task tenantTask = (Task)this.dataPickService.tenantTemplate().findOne(query, Task.class, this.dataPickService.tenantCol(Task.class));
        if (tenantTask != null) {
            Update update = new Update();
            for (String field : fields) {
                update.unset(field);
            }
            this.dataPickService.tenantTemplate().updateMulti(query, (UpdateDefinition)update, this.dataPickService.tenantCol(Task.class));
        }
        return null;
    }

    private List<Task> bestTaskByFrom(String from, DataRequest request, Project pro) throws DWBusinessException {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(from);
        HashMap<String, ArrayList<String>> param = new HashMap<String, ArrayList<String>>();
        param.put("from", codes);
        List tasks = this.dataPickService.find(BasicQuery.of(param, request.getEocInfo()), Task.class);
        Iterator iterator = tasks.iterator();
        List assetTaskCodes = Optional.ofNullable(pro.getAsserts()).map(Asserts::getTaskCodes).orElse(Collections.emptyList());
        block0: while (iterator.hasNext()) {
            Task next = (Task)iterator.next();
            if (next.getApplication() == null || next.getApplication().equals(pro.getApplication()) || assetTaskCodes.contains(next.getCode())) {
                for (StateMap sm : next.getStateMaps()) {
                    if (!from.equals(sm.getInput())) continue;
                    if (null == sm.getGroup()) continue block0;
                    next.setGroup(sm.getGroup());
                    continue block0;
                }
                continue;
            }
            iterator.remove();
        }
        return tasks;
    }

    public Activity milestoneActivity(FlowGraph flow) throws DWException {
        ArrayList<String> codes = new ArrayList<String>();
        for (FlowNode node : flow.getNodes()) {
            if (!"activity".equalsIgnoreCase(node.getType())) continue;
            codes.add(node.getActivityCode());
        }
        if (!codes.isEmpty()) {
            HashMap<String, Serializable> q = new HashMap<String, Serializable>();
            q.put("code", codes);
            q.put("milestone", Boolean.valueOf(true));
            List activities = this.dataPickService.findBetters(BasicQuery.of(q, null), Activity.class);
            if (!activities.isEmpty()) {
                return (Activity)activities.get(0);
            }
        }
        return null;
    }

    private Task fillTaskDetail(Task task) throws DWException {
        if (task == null) {
            return null;
        }
        if (null != (task = (Task)this.dataPickService.findBetter(task.getCode(), Task.class)).getFlowCode()) {
            FlowGraph graph = (FlowGraph)this.dataPickService.findByCode(task.getFlowCode(), FlowGraph.class);
            task.setFlow(graph);
        }
        return task;
    }

    @Override
    public Map<String, Object> getDefinition(String taskId) throws Exception {
        return this.getDefinitionByTaskId(taskId);
    }

    @Override
    public Map<String, Object> getDefinitionByTaskId(String taskId) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        ViewRequest viewRequest = new ViewRequest();
        viewRequest.setProjectCode(taskId);
        Map<String, Object> dm = this.dataMapViewService.postProject(viewRequest);
        try {
            this.filterTaskByTenantAppComponentList(dm, tenantId, taskId);
        }
        catch (Exception e) {
            log.error("Filter task error!", (Throwable)e);
        }
        return dm;
    }

    @Override
    public Map<String, Object> getDefinitionWithMultiLanguage(String taskId, String pageCode) throws Exception {
        Map<String, Object> task = this.getDefinitionByTaskId(taskId);
        if (null == task) {
            return null;
        }
        try {
            Map pages = (Map)task.get("pages");
            if (null != pages) {
                task.put("pages", pages.get(pageCode));
            }
            this.processSummaryFields(pageCode, task);
        }
        catch (Exception e) {
            log.warn("processSummaryFields error:", (Throwable)e);
        }
        return task;
    }

    @Override
    public Object postDefinitionByTaskIdAndOperationUnit(String taskId, OperationUnit operationUnit) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        ViewRequest viewRequest = new ViewRequest();
        viewRequest.setProjectCode(taskId);
        viewRequest.setEocInfo(KmService.ecoInfo(operationUnit));
        Map<String, Object> dm = this.dataMapViewService.postProject(viewRequest);
        try {
            this.filterTaskByTenantAppComponentList(dm, tenantId, taskId);
        }
        catch (Exception e) {
            log.error("Filter task error!", (Throwable)e);
        }
        return dm;
    }

    @Override
    @Deprecated
    public Map<String, Object> getActivities(String taskId) throws Exception {
        return this.getActivitiesWithMultiLanguage(taskId);
    }

    @Override
    public Map<String, Object> getActivitiesWithMultiLanguage(String taskId) throws Exception {
        ViewRequest viewRequest = new ViewRequest();
        viewRequest.setProjectCode(taskId);
        return this.dataMapViewService.postTasks(viewRequest);
    }

    @Override
    public Map<String, Object> getActivityDefinition(String activityId, String pageCode) throws Exception {
        Map<String, Object> dm = this.getTaskInfoFromDataMap(null, activityId, pageCode, ServiceUtils.getTenantId(), null);
        if (null == dm) {
            return null;
        }
        try {
            Application application = this.kmService.getAppByCodeAndType(activityId, "activity");
            this.processApplication(activityId, dm, application);
            this.processSummaryFields(pageCode, dm);
        }
        catch (Exception e) {
            log.warn("parse activity error:", (Throwable)e);
        }
        return dm;
    }

    @Override
    public Map<String, Object> getActivityDefinitionWithMergeRule(String taskId, String activityId, String pageCode) throws Exception {
        Map<String, Object> dm;
        ApplicationRelation applicationRelation = this.knowledgeGraphService.relation(activityId, null);
        Application application = null;
        if (null != applicationRelation) {
            application = this.knowledgeGraphService.application(applicationRelation.getAppCode());
        }
        if (application != null && application.getLang() != null) {
            Map nameLangMap = (Map)application.getLang().get("name");
            String language = null == nameLangMap.get(ServiceUtils.getCurrentLocale()) ? application.getName() : (String)nameLangMap.get(ServiceUtils.getCurrentLocale());
            applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
        }
        if (null == (dm = this.getTaskInfoFromDataMap(taskId, activityId, pageCode, ServiceUtils.getTenantId(), null))) {
            return dm;
        }
        try {
            this.processApplication(activityId, dm, application);
            this.processSummaryFields(pageCode, dm);
            if (null != application) {
                this.processMergeRule(dm, taskId, activityId, application.getFunctionCtrl());
            }
            this.handleReminderRule(dm);
        }
        catch (Exception e) {
            log.warn("getActivityDefinitionWithMergeRule:{}", (Object)e.getMessage());
        }
        return dm;
    }

    private void processMergeRule(Map<String, Object> task, String taskId, String activityId, FunctionCtrl functionCtrl) throws Exception {
        boolean enableCustomize;
        boolean bl = enableCustomize = null == functionCtrl ? false : functionCtrl.isTaskCardMergeCustomizeFlag();
        if (!enableCustomize) {
            return;
        }
        Map<String, Object> activityConfig = this.getActivityConfig(taskId, activityId);
        MergeRule mergeRule = this.getTenantMergeConfig("task", activityId);
        if (null == mergeRule || mergeRule.getDelete().booleanValue()) {
            return;
        }
        task.put("merge", mergeRule.getMerge());
        Map<String, Object> mergeConfig = MergeRule.convertToMergeConfig(mergeRule.getMergeRules(), activityConfig);
        ((Map)task.get("config")).put("mergeConfig", mergeConfig);
    }

    private MergeRule getTenantMergeConfig(String type, String code) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataPickService.tenantVersion(tenantId);
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"type", (Object)type), Filters.eq((String)"code", (Object)code), Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"version", (Object)tenantVersion)});
        return this.knowledgeGraphService.findOne(bson, MergeRule.class, "mergeRule", KnowledgeGraphDb.TENANT);
    }

    private void handleReminderRule(Map<String, Object> task) {
        Object reminderRuleObject = task.get("reminderRule");
        if (reminderRuleObject == null) {
            return;
        }
        ReminderRule reminderRule = (ReminderRule)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reminderRuleObject), ReminderRule.class);
        if (CollectionUtils.isEmpty((Collection)reminderRule.getRules())) {
            String currentLocale = ServiceUtils.getCurrentLocale();
            String titlePrefix = "\u89c4\u5219";
            if ("zh_TW".equals(currentLocale)) {
                titlePrefix = "\u898f\u5247";
            } else if ("en_US".equals(currentLocale)) {
                titlePrefix = "rule";
            }
            HashMap<String, Object> rule = new HashMap<String, Object>();
            rule.put("aheadTime", reminderRule.getAheadTime());
            rule.put("notices", reminderRule.getNotices());
            rule.put("rule", reminderRule.getRule());
            rule.put("title", titlePrefix + "1");
            rule.put("identities", Collections.emptyList());
            reminderRule.setRules(Collections.singletonList(rule));
            reminderRule.setRule(null);
            reminderRule.setNotices(null);
            reminderRule.setAheadTime(null);
        }
        if (!CollectionUtils.isEmpty((Collection)reminderRule.getRules())) {
            for (Map ruleItem : reminderRule.getRules()) {
                Map map = MapUtils.getMap((Map)ruleItem, (Object)"rule", Collections.emptyMap());
                String ruleType = MapUtils.getString((Map)map, (Object)"rule");
                if ("count".equals(ruleType)) {
                    map.put("interval", null);
                    continue;
                }
                map.put("count", null);
            }
        }
        task.put("reminderRule", reminderRule);
    }

    @Override
    public Map<String, Object> getActivityConfig(String taskId, String activityId) throws Exception {
        Task task = (Task)this.dataPickService.findByCode(activityId, Task.class);
        HashMap<String, Object> config = task.getConfig();
        if (null == config) {
            config = new HashMap<String, Object>();
        }
        config.put("merge", task.getMerge());
        return config;
    }

    @Override
    public Map<String, Object> postActivityDefinition(String taskId, String activityId, String pageCode, OperationUnit operationUnit) throws Exception {
        return this.getTaskInfoFromDataMap(taskId, activityId, pageCode, ServiceUtils.getTenantId(), operationUnit);
    }

    @Override
    public Map<String, Object> getActivityStartTargetCode(String taskId, String activityId, String pageCode) throws Exception {
        ViewRequest viewRequest = new ViewRequest();
        viewRequest.setProjectCode(taskId);
        viewRequest.setTaskCode(activityId);
        viewRequest.setPageCode(pageCode);
        return this.dataMapViewService.postActivityStartTargetCode(viewRequest);
    }

    @Override
    public Map<String, Object> getTaskInfoFromDataMap(String activityId) throws DWException {
        return this.getTaskInfoFromDataMap(null, activityId, null, null, null);
    }

    @Override
    public Map<String, Object> getDetail(String taskId) throws DWException {
        ViewRequest viewRequest = new ViewRequest();
        viewRequest.setProjectCode(taskId);
        return this.dataMapViewService.postProject(viewRequest);
    }

    @Override
    public Map<String, Object> getInputData(String taskId) throws DWException {
        ViewRequest viewRequest = new ViewRequest();
        viewRequest.setProjectCode(taskId);
        return this.dataMapViewService.postProjectInputData(viewRequest);
    }

    @Override
    public String postUpdateTaskConfig(Project data) throws DWException {
        this.dataMapViewService.postUpdateProject(data);
        return "success";
    }

    @Override
    public List<TaskDTO> postTaskByApp(String applicationCode, OperationUnit operationUnit) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataPickService.tenantVersion(tenantId);
        List<String> taskIdList = this.kmService.getCodeByTypeAndAppCodeWithComponentList(applicationCode, "task", tenantId);
        DWServiceContext context = DWServiceContext.getContext();
        if (CollectionUtils.isEmpty(taskIdList)) {
            return Collections.emptyList();
        }
        CopyOnWriteArrayList<TaskDTO> result = new CopyOnWriteArrayList<TaskDTO>();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        DapContext dapContext = ServiceUtils.getContext();
        CompletableFuture.allOf((CompletableFuture[])taskIdList.stream().map(taskId -> CompletableFuture.runAsync(() -> {
            DWServiceContext.setContext((DWServiceContext)context);
            RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
            ServiceUtils.setContext((DapContext)dapContext);
            try {
                TaskDTO taskDTO = new TaskDTO();
                Map definitionWithMultiLanguage = (Map)this.postDefinitionByTaskIdAndOperationUnit((String)taskId, operationUnit);
                if (null == definitionWithMultiLanguage) {
                    return;
                }
                if (Boolean.TRUE.equals(JSONPath.eval((Object)definitionWithMultiLanguage, (String)"$.config.hideDeliverySetting"))) {
                    return;
                }
                taskDTO.setTask(definitionWithMultiLanguage);
                Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"taskCode", (Object)taskId), Filters.eq((String)"version", (Object)tenantVersion)});
                List<TaskMonitorRule> taskMechanism = this.knowledgeGraphService.find(filter, TaskMonitorRule.class, "taskMonitorRule", KnowledgeGraphDb.SYSTEM);
                if (!CollectionUtils.isEmpty(taskMechanism)) {
                    List<String> collect = taskMechanism.stream().map(TaskMonitorRule::getMonitorRuleCode).collect(Collectors.toList());
                    taskDTO.setRelatedMonitorRules(collect);
                }
                result.add(taskDTO);
            }
            catch (Exception e) {
                log.error("postTaskByApp error", (Throwable)e);
            }
        }, this.taskExecutor)).toArray(CompletableFuture[]::new)).join();
        return result;
    }

    @Override
    public Object postFixTask(String taskId, OperationUnit operationUnit) {
        return null;
    }

    @Override
    public List<Map<String, Object>> getPageUIElement(String code, String activityId, String pageCode) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        return this.getPageUIElementFromDataMap(code, activityId, pageCode, tenantId);
    }

    @Override
    public List<ProjectVo> getManualList() throws Exception {
        UserComponentDto dto = this.kmService.userComponents("task", null, ServiceUtils.getLocale());
        if (null == dto) {
            return new ArrayList<ProjectVo>();
        }
        Set<String> codesFiltered = dto.getCodesFiltered();
        List<String> commonAppCodes = dto.getCommonAppCodes();
        Map<String, ApplicationRelation> codeAppCode = dto.getCodeRelations();
        HashMap<String, Object> query2 = new HashMap<String, Object>();
        query2.put("code", codesFiltered);
        query2.put("manualAble", true);
        List projects = this.dataPickService.find(BasicQuery.of(query2, null), ProjectVo.class);
        HashSet<String> appCodesHasAuthPrefix = new HashSet<String>();
        for (ProjectVo project : projects) {
            project.setCommonApp(false);
            String appCode = codeAppCode.get(project.getCode()).getAppCode();
            if (commonAppCodes.contains(appCode)) {
                project.setCommonApp(true);
            }
            if (!StringUtils.isNotEmpty((CharSequence)project.getAuthorityPrefix())) continue;
            appCodesHasAuthPrefix.add(appCode);
        }
        Map<String, String> userPemissions = this.kmService.userPermission(appCodesHasAuthPrefix, "allow");
        Iterator iterator2 = projects.iterator();
        while (iterator2.hasNext()) {
            ProjectVo project = (ProjectVo)((Object)iterator2.next());
            project.setEffect("allow");
            if (!this.shouldRemoveByPermission(project, userPemissions)) continue;
            iterator2.remove();
        }
        this.addGroupInfo(projects);
        return projects;
    }

    private boolean shouldRemoveByPermission(ProjectVo project, Map<String, String> userPemissions) {
        String eff = userPemissions.get(project.getCode());
        if (StringUtils.isNotEmpty((CharSequence)project.getAuthorityPrefix()) && !userPemissions.containsKey(project.getCode())) {
            return true;
        }
        if (Boolean.TRUE.equals(project.getCommonApp()) && StringUtils.isEmpty((CharSequence)project.getAuthorityPrefix())) {
            return true;
        }
        return null != eff && !eff.equals(project.getEffect());
    }

    @Override
    public List<ProjectVo> getManualListMobile() throws Exception {
        System.out.println(Thread.currentThread().getName() + " datamap getManualListMobile...");
        UserComponentDto dto = this.kmService.userComponents("task", null, ServiceUtils.getLocale());
        if (null == dto) {
            return new ArrayList<ProjectVo>();
        }
        Set<String> codesFiltered = dto.getCodesFiltered();
        List<String> commonAppCodes = dto.getCommonAppCodes();
        Map<String, ApplicationRelation> codeAppCode = dto.getCodeRelations();
        HashMap<String, Object> query2 = new HashMap<String, Object>();
        query2.put("code", codesFiltered);
        query2.put("manualAble", true);
        List projects = this.dataPickService.find(BasicQuery.of(query2, null), ProjectVo.class);
        HashSet<String> appCodesHasAuthPrefix = new HashSet<String>();
        for (ProjectVo project : projects) {
            project.setCommonApp(false);
            String appCode = codeAppCode.get(project.getCode()).getAppCode();
            if (commonAppCodes.contains(appCode)) {
                project.setCommonApp(true);
            }
            if (!StringUtils.isNotEmpty((CharSequence)project.getAuthorityPrefix())) continue;
            appCodesHasAuthPrefix.add(appCode);
        }
        Map<String, String> userPemissions = this.kmService.userPermission(appCodesHasAuthPrefix, "allow");
        Iterator iterator2 = projects.iterator();
        while (iterator2.hasNext()) {
            String eff;
            ProjectVo project = (ProjectVo)((Object)iterator2.next());
            project.setEffect("allow");
            if (StringUtils.isNotEmpty((CharSequence)project.getAuthorityPrefix()) && !userPemissions.containsKey(project.getCode())) {
                iterator2.remove();
            }
            if (!StringUtils.isNotEmpty((CharSequence)(eff = userPemissions.get(project.getCode())))) continue;
            project.setEffect(eff);
        }
        List codes = projects.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("project", codes);
        param.put("pageType", 1);
        List pageViewList = this.dataPickService.find(BasicQuery.of(param, null), PageView.class);
        HashMap pageViewMap = new HashMap();
        pageViewList.forEach(pv -> pageViewMap.put(pv.getProject(), pv));
        for (ProjectVo vo : projects) {
            PageView view = (PageView)pageViewMap.get(vo.getCode());
            if (null == view) continue;
            vo.setPresetActivities(Collections.singletonList(view));
        }
        this.addGroupInfo(projects);
        return projects;
    }

    @Override
    public Map<String, Object> getManualPage(String code, String pageCode) throws Exception {
        HashMap<String, Object> pageViewMap = new HashMap<String, Object>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("project", code);
        param.put("pageType", 1);
        BasicQuery query = BasicQuery.of(param, null);
        query.setReturnFields(Arrays.asList("code"));
        PageView pageView = (PageView)this.dataPickService.findOne(query, PageView.class);
        if (null != pageView) {
            return this.getActivityDefinition(pageView.getCode(), pageCode);
        }
        return pageViewMap;
    }

    @Override
    public PageView getManualPageCode(String code) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("project", code);
        param.put("pageType", 1);
        BasicQuery query = BasicQuery.of(param, null);
        query.setReturnFields(Arrays.asList("code"));
        PageView pageView = (PageView)this.dataPickService.findOne(query, PageView.class);
        return pageView;
    }

    private void addGroupInfo(List<ProjectVo> projects) throws DWBusinessException {
        String lang = DWResourceBundleUtils.getCurrentLocale().toString();
        String tenantVersion = this.dataPickService.tenantVersion();
        this.setGroupInfoWithGroupCode(projects.stream().filter(project -> null != project.getGroupCode()).collect(Collectors.toList()), lang, tenantVersion);
        this.setGroupInfoWithoutGroupCode(projects.stream().filter(project -> null == project.getGroupCode()).collect(Collectors.toList()), lang, tenantVersion);
    }

    private void setGroupInfoWithGroupCode(List<ProjectVo> projectsWithGroupCode, String lang, String tenantVersion) {
        if (projectsWithGroupCode.isEmpty()) {
            return;
        }
        Set groupCodes = projectsWithGroupCode.stream().map(ProjectVo::getGroupCode).collect(Collectors.toSet());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.exists((String)"appCode", (boolean)false), Filters.in((String)"groupCode", groupCodes), Filters.eq((String)"version", (Object)tenantVersion)});
        List<ApplicationGroup> applicationGroups = this.knowledgeGraphService.find(filter, ApplicationGroup.class, "applicationGroup", KnowledgeGraphDb.SYSTEM);
        Map applicationGroupMap = applicationGroups.stream().collect(Collectors.toMap(ApplicationGroup::getGroupCode, Function.identity(), (a, b) -> a));
        for (ProjectVo project : projectsWithGroupCode) {
            ApplicationGroup applicationGroup = (ApplicationGroup)((Object)applicationGroupMap.get(project.getGroupCode()));
            if (null == applicationGroup) continue;
            DataMapTaskService.setGroupInfo(project, applicationGroup, lang);
        }
    }

    private void setGroupInfoWithoutGroupCode(List<ProjectVo> projectsWithoutGroupCode, String lang, String tenantVersion) {
        if (projectsWithoutGroupCode.isEmpty()) {
            return;
        }
        Set appCodes = projectsWithoutGroupCode.stream().map(this::getAppCode).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        Set projectCodes = projectsWithoutGroupCode.stream().map(BaseEntity::getCode).collect(Collectors.toSet());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.in((String)"appCode", appCodes), Filters.in((String)"activityCode", projectCodes), Filters.eq((String)"version", (Object)tenantVersion)});
        List<ApplicationGroup> applicationGroups = this.knowledgeGraphService.find(filter, ApplicationGroup.class, "applicationGroup", KnowledgeGraphDb.SYSTEM);
        Map applicationGroupMap = applicationGroups.stream().collect(Collectors.toMap(each -> each.getAppCode() + ":" + each.getActivityCode(), Function.identity(), (a, b) -> a));
        for (ProjectVo project : projectsWithoutGroupCode) {
            Optional<String> appCode = this.getAppCode(project);
            if (!appCode.isPresent()) continue;
            String projectCode = project.getCode();
            ApplicationGroup applicationGroup = (ApplicationGroup)((Object)applicationGroupMap.get(appCode.get() + ":" + projectCode));
            if (null == applicationGroup) continue;
            DataMapTaskService.setGroupInfo(project, applicationGroup, lang);
        }
    }

    private static void setGroupInfo(ProjectVo project, ApplicationGroup applicationGroup, String lang) {
        project.setGroupCode(applicationGroup.getGroupCode());
        project.setGroupSort(StringUtils.isEmpty((CharSequence)applicationGroup.getGroupSort()) ? null : applicationGroup.getGroupSort());
        String groupName = applicationGroup.getGroupName();
        if (null != applicationGroup.getLang()) {
            Map nameLangMap = (Map)applicationGroup.getLang().get("groupName");
            if (null == nameLangMap) {
                Map map = nameLangMap = applicationGroup.getLang().get("name") == null ? Collections.emptyMap() : (Map)applicationGroup.getLang().get("name");
            }
            if (null != nameLangMap.get(lang)) {
                groupName = (String)nameLangMap.get(lang);
            }
        }
        project.setGroupName(groupName);
        project.setClassifyCode(applicationGroup.getClassifyCode());
        project.setClassifyName(applicationGroup.getClassifyName());
    }

    private Optional<String> getAppCode(ProjectVo project) {
        if (null != project.getApplication()) {
            return Optional.of(project.getApplication());
        }
        if (null != project.getSourceId()) {
            return Optional.of(project.getSourceId());
        }
        return Optional.empty();
    }

    private List<Map<String, Object>> getPageUIElementFromDataMap(String taskId, String activityId, String pageCode, String tenantId) throws DWException {
        ViewRequest viewRequest = new ViewRequest();
        viewRequest.setCode(taskId);
        viewRequest.setTaskCode(activityId);
        viewRequest.setPageCode(pageCode);
        List uiElements = (List)this.dataMapViewService.getPageUIElement(viewRequest);
        ArrayList<Map<String, Object>> dm = new ArrayList<Map<String, Object>>();
        for (PageUIElement each : uiElements) {
            dm.add(MergeUtil.mergeObjectToMap(new HashMap(), (Object)each, null));
        }
        if (!dm.isEmpty()) {
            try {
                this.productNameResolver.batchSetProductInfoForList(dm, tenantId);
            }
            catch (Exception ee) {
                log.error("batchSetProductInfoForList error:{}", (Object)ee.toString());
            }
        }
        return dm;
    }

    private void processSummaryFields(String pageCode, Map<String, Object> result) throws DWBusinessException {
        this.processSysSummaryFields(result);
        this.processTenantSummaryFields(result, pageCode);
    }

    private Map<String, Object> getTaskInfoFromDataMap(String taskId, String activityId, String pageCode, String tenantId, OperationUnit operationUnit) throws DWException {
        Map<String, Object> dm;
        ViewRequest viewRequest = new ViewRequest();
        viewRequest.setProjectCode(taskId);
        viewRequest.setTaskCode(activityId);
        viewRequest.setPageCode(pageCode);
        if (null != operationUnit) {
            viewRequest.getEocInfo().put("eoc_company_id", operationUnit.getEoc_company_id());
            viewRequest.getEocInfo().put("eoc_site_id", operationUnit.getEoc_site_id());
            viewRequest.getEocInfo().put("eoc_region_id", operationUnit.getEoc_region_id());
            viewRequest.getEocInfo().put("operation_unit_v2", operationUnit.getOperation_unit_v2());
        }
        if (null != (dm = this.dataMapViewService.postTask(viewRequest))) {
            this.productNameResolver.batchSetProductInfoForTaskView(tenantId, dm);
        }
        return dm;
    }

    private void processApplication(String activityId, Map<String, Object> task, Application application) {
        String locale = ServiceUtils.getLocale();
        if (null != task) {
            if (null != application) {
                task.put("application", application.getCode());
                task.put("appName", ServiceUtils.localeName((Object)application, (String)"name", (String)locale));
            }
            task.put("activityId", activityId);
            task.put("activityName", ServiceUtils.localeName(task, (String)"name", (String)locale));
        }
    }

    private void filterTaskByTenantAppComponentList(Map<String, Object> dmObject, String tenantId, String projectCode) throws Exception {
        if (null == dmObject) {
            return;
        }
        List phases = (List)dmObject.get("phases");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)phases)) {
            return;
        }
        CustBizTaskConfigDTO taskConfigDTO = (CustBizTaskConfigDTO)this.dataPickService.tenantTemplate().findOne(Query.query((CriteriaDefinition)Criteria.where((String)"projectCode").is((Object)projectCode).and("tenantId").is((Object)ServiceUtils.getTenantId())), CustBizTaskConfigDTO.class);
        if (null != taskConfigDTO && null != taskConfigDTO.getBizTasks()) {
            List skipTaskCodeList = taskConfigDTO.getBizTasks().stream().map(v -> {
                if (v.getCustomSkip().booleanValue()) {
                    return v.getCode();
                }
                return null;
            }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            phases = phases.stream().filter(v -> !skipTaskCodeList.contains(v.getCode())).collect(Collectors.toList());
        }
        dmObject.put("phases", phases);
        String applicationCode = this.getAppCodeByApplication(projectCode);
        ArrayList<String> codes = new ArrayList<String>();
        for (Phase phase : phases) {
            if (null == phase.getTaskCodes()) continue;
            codes.addAll(phase.getTaskCodes());
        }
        List<String> disabledCodes = this.kmService.tenantDisableComponentCodes(applicationCode, tenantId, "Activity", codes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(disabledCodes)) {
            return;
        }
        for (Phase phase : phases) {
            if (null == phase.getTaskCodes()) continue;
            phase.getTaskCodes().removeAll(disabledCodes);
        }
    }

    private String getAppCodeByApplication(String projectCode) throws Exception {
        ApplicationRelation applicationRelation = this.knowledgeGraphService.relation(projectCode, null);
        return applicationRelation == null ? null : applicationRelation.getAppCode();
    }

    private boolean isCardCustom(FunctionCtrl functionCtrl) {
        return functionCtrl != null && (functionCtrl.isProjectCardCustomizeFlag() || functionCtrl.isTaskCardCustomizeFlag());
    }

    private void processSysSummaryFields(Map<String, Object> task) {
        Map pages;
        if (null != task && !CollectionUtils.isEmpty((Map)(pages = (Map)task.get("pages")))) {
            List dataStates = (List)pages.get("dataStates");
            List summaryFieldsCandidate = (List)pages.get("summaryFields");
            if (!CollectionUtils.isEmpty((Collection)dataStates)) {
                dataStates.forEach(dataState -> {
                    if (SUMMARY.equals(dataState.get("type"))) {
                        task.put(SUMMARY, dataState);
                        task.put("summaryFields", (List)dataState.get("fieldMappings"));
                    }
                    if (BUSINESS_INFO.equals(dataState.get("type"))) {
                        task.put(BUSINESS_INFO, dataState);
                    }
                    if (SEARCH_KEY.equals(dataState.get("type"))) {
                        task.put(SEARCH_KEY, dataState);
                    }
                    if (PROJECT_INFO.equals(dataState.get("type"))) {
                        task.put(PROJECT_INFO, dataState);
                    }
                });
                if (!this.checkNewSummary(task)) {
                    List summaryFields = (List)((Map)dataStates.get(0)).get("summaryFields");
                    task.put("summaryFields", summaryFields);
                }
            } else if (!CollectionUtils.isEmpty((Collection)summaryFieldsCandidate)) {
                task.put("summaryFields", summaryFieldsCandidate);
            }
        }
    }

    private boolean checkNewSummary(Map<String, Object> task) {
        return task.get(SUMMARY) != null && !((Map)task.get(SUMMARY)).isEmpty() || task.get(BUSINESS_INFO) != null && !((Map)task.get(BUSINESS_INFO)).isEmpty() || task.get(SEARCH_KEY) != null && !((Map)task.get(SEARCH_KEY)).isEmpty() || task.get(PROJECT_INFO) != null && !((Map)task.get(PROJECT_INFO)).isEmpty();
    }

    private void processTenantSummaryFields(Map<String, Object> task, String pageCode) throws DWBusinessException {
        if (null != task) {
            String type;
            String application = (String)task.get("application");
            String code = (String)task.get("code");
            switch (pageCode) {
                case "project-card": {
                    type = "project";
                    break;
                }
                case "task-card": {
                    type = "task";
                    break;
                }
                default: {
                    type = null;
                }
            }
            if (this.checkNewSummary(task)) {
                this.newProcessTenantSummaryFields(task, pageCode);
            } else {
                List summaryFields = (List)task.get("summaryFields");
                task.put("canSelectedSummaryFields", ObjectUtil.cloneByStream((Object)summaryFields));
                if (type != null && null != application) {
                    TenantSummaryFields tenantSummaryFields = this.queryTenantSummaryFields(application, type, code);
                    if (null != tenantSummaryFields) {
                        boolean usedTenantSummaryFields;
                        boolean ifUseTenantSummaryFields = this.judgeIfUseTenantSummaryFields(tenantSummaryFields, summaryFields);
                        boolean ifUseTenantTitle = this.judgeIfUseTenantTitle(tenantSummaryFields);
                        if (ifUseTenantSummaryFields) {
                            if (!CollectionUtils.isEmpty((Collection)tenantSummaryFields.getSummaryFields())) {
                                List<Map<String, Object>> transformedTenantSummaryFields = this.transformTenantFieldsToSys(tenantSummaryFields, summaryFields);
                                List<Map<String, Object>> mergedSummaryFields = this.mergeSummaryFields(summaryFields, transformedTenantSummaryFields);
                                Map pages = (Map)task.get("pages");
                                if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                                    List dataStates = (List)pages.get("dataStates");
                                    Map dataState = (Map)dataStates.get(0);
                                    dataState.put("summaryFields", mergedSummaryFields);
                                } else {
                                    pages.put("summaryFields", mergedSummaryFields);
                                }
                                task.put("summaryFields", mergedSummaryFields);
                            }
                            usedTenantSummaryFields = true;
                            task.put("usedTenantSummaryFields", true);
                        } else {
                            usedTenantSummaryFields = false;
                            task.put("usedTenantSummaryFields", false);
                        }
                        if (ifUseTenantTitle && usedTenantSummaryFields) {
                            TenantCardTitleDefinition tenantCardTitleDefinition = new TenantCardTitleDefinition();
                            tenantCardTitleDefinition.setFields(tenantSummaryFields.getTitle());
                            tenantCardTitleDefinition.setTitlePrefix(tenantSummaryFields.getTitlePrefix());
                            task.put("tenantCardTitleDefinition", tenantCardTitleDefinition);
                        }
                        task.put("tenantSummaryFields", tenantSummaryFields);
                    } else {
                        task.put("usedTenantSummaryFields", false);
                    }
                } else {
                    task.put("usedTenantSummaryFields", false);
                }
                this.filterSummaryFields(task);
            }
        }
    }

    private void newProcessTenantSummaryFields(Map<String, Object> task, String pageCode) throws DWBusinessException {
        if (null != task) {
            String type;
            String application = (String)task.get("application");
            String code = (String)task.get("code");
            switch (pageCode) {
                case "project-card": {
                    type = "project";
                    break;
                }
                case "task-card": {
                    type = "task";
                    break;
                }
                default: {
                    type = null;
                }
            }
            List<Map<String, Object>> newSummaryFieldes = task.getOrDefault(SUMMARY, Collections.emptyMap()).getOrDefault("fieldMappings", Collections.emptyList());
            task.put("canSelectedSummaryFields", ObjectUtil.cloneByStream(newSummaryFieldes));
            if (type != null && null != application) {
                TenantSummaryFields tenantSummaryFields = this.queryTenantSummaryFields(application, type, code);
                if (null != tenantSummaryFields) {
                    boolean ifUseTenantSummaryFields = this.judgeIfUseTenantSummaryFields(tenantSummaryFields, newSummaryFieldes);
                    boolean ifUseTenantTitle = this.judgeIfUseTenantTitle(tenantSummaryFields);
                    if (ifUseTenantSummaryFields) {
                        if (!CollectionUtils.isEmpty((Collection)tenantSummaryFields.getSummaryFields())) {
                            List<Map<String, Object>> mergedSummaryFields = this.transformTenantFieldsToSys(tenantSummaryFields, newSummaryFieldes);
                            Map pages = (Map)task.get("pages");
                            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                                for (Map dataState : (List)pages.get("dataStates")) {
                                    if (!SUMMARY.equals(dataState.get("type"))) continue;
                                    dataState.put("fieldMappings", mergedSummaryFields);
                                }
                            }
                            task.put("summaryFields", mergedSummaryFields);
                        }
                        task.put("usedTenantSummaryFields", true);
                    } else {
                        task.put("usedTenantSummaryFields", false);
                    }
                    if (ifUseTenantTitle && Boolean.TRUE.equals(task.get("usedTenantSummaryFields"))) {
                        TenantCardTitleDefinition tenantCardTitleDefinition = new TenantCardTitleDefinition();
                        tenantCardTitleDefinition.setFields(tenantSummaryFields.getTitle());
                        tenantCardTitleDefinition.setTitlePrefix(tenantSummaryFields.getTitlePrefix());
                        task.put("tenantCardTitleDefinition", tenantCardTitleDefinition);
                    }
                    task.put("tenantSummaryFields", tenantSummaryFields);
                } else {
                    task.put("usedTenantSummaryFields", false);
                }
            } else {
                task.put("usedTenantSummaryFields", false);
            }
            this.newFilterSummaryFields(task);
        }
    }

    private void newFilterSummaryFields(Map<String, Object> task) throws DWBusinessException {
        if (task.get("summaryFields") != null && !((List)task.get("summaryFields")).isEmpty() && Boolean.FALSE.equals(task.get("usedTenantSummaryFields"))) {
            ((List)task.get("summaryFields")).removeIf(map -> MapUtils.getBoolean((Map)map, (Object)"defaultEffective", (Boolean)true) == false);
            Map pages = (Map)task.get("pages");
            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                for (Map dataState : (List)pages.get("dataStates")) {
                    if (!SUMMARY.equals(dataState.get("type"))) continue;
                    dataState.put("fieldMappings", task.get("summaryFields"));
                }
            }
        }
        if (task.get("canSelectedSummaryFields") != null && !((List)task.get("canSelectedSummaryFields")).isEmpty()) {
            ((List)task.get("canSelectedSummaryFields")).removeIf(map -> MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) == false);
            List canSelectedSummaryFields = (List)task.get("canSelectedSummaryFields");
            List tenantSummaryFieldList = (List)task.get("summaryFields");
            String locale = Optional.ofNullable(ServiceUtils.getCurrentLocale()).orElse("zh_CN");
            String actionId = MapUtils.getString((Map)((Map)canSelectedSummaryFields.get(0)), (Object)"actionId");
            List<ApiDataFieldLocaleMetadataDTO> fields = null;
            if (StringUtils.isNotEmpty((CharSequence)actionId)) {
                try {
                    GetActionLocaleResponseDTO actionLocaleResponseDTO = this.dataMapKgService.getActionMetaData(actionId);
                    ApiDataFieldLocaleMetadataDTO data = actionLocaleResponseDTO.getResponse().getData();
                    fields = data.getField();
                }
                catch (Exception e) {
                    throw new DWBusinessException("\u67e5\u8be2\u5143\u6570\u636e\u5b9a\u4e49\u51fa\u9519\uff0cactionId\uff1a{}", actionId);
                }
            }
            canSelectedSummaryFields.forEach(field -> {
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"description"))) {
                    Object title = JSONPath.eval((Object)field, (String)"$.tags[0].title");
                    Object localeTitle = JSONPath.eval((Object)field, (String)("$.tags[0].lang.title." + locale));
                    field.put("description", localeTitle != null ? localeTitle : title);
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_name"))) {
                    String value = MapUtils.getString((Map)field, (Object)"value", (String)"");
                    field.put("data_name", value.contains(".") ? value.split("\\.")[1] : "");
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_type"))) {
                    field.put("data_type", "string");
                }
            });
            for (Map tenantSummaryField : tenantSummaryFieldList) {
                boolean b = canSelectedSummaryFields.stream().noneMatch(map -> MapUtils.getString((Map)map, (Object)"value", (String)"").equals(MapUtils.getString((Map)tenantSummaryField, (Object)"value", (String)"")));
                if (!b || !MapUtils.getBoolean((Map)tenantSummaryField, (Object)SUMMARY, (Boolean)true).booleanValue()) continue;
                if (fields != null && !fields.isEmpty()) {
                    Optional<ApiDataFieldLocaleMetadataDTO> dataName = fields.stream().filter(f -> f.getData_name().equals(MapUtils.getString((Map)tenantSummaryField, (Object)"data_name", (String)""))).findFirst();
                    dataName.ifPresent(apiDataFieldLocaleMetadataDTO -> tenantSummaryField.put("description", apiDataFieldLocaleMetadataDTO.getDescription()));
                }
                canSelectedSummaryFields.add(tenantSummaryField);
            }
        }
    }

    private TenantSummaryFields queryTenantSummaryFields(String application, String type, String code) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"type", (Object)type), Filters.eq((String)"code", (Object)code), Filters.eq((String)"application", (Object)application)});
        return this.knowledgeGraphService.findOne(query, TenantSummaryFields.class, "summaryFields", KnowledgeGraphDb.TENANT);
    }

    private boolean judgeIfUseTenantSummaryFields(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        }
        if (CollectionUtils.isEmpty(summaryFields)) {
            return false;
        }
        return summaryFields.get(0).get("actionId").equals(tenantSummaryFields.getActionId());
    }

    private boolean judgeIfUseTenantTitle(TenantSummaryFields tenantSummaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        }
        String titlePrefix = tenantSummaryFields.getTitlePrefix();
        List title = tenantSummaryFields.getTitle();
        return !CollectionUtils.isEmpty((Collection)title) || !StringUtils.isEmpty((CharSequence)titlePrefix);
    }

    private List<Map<String, Object>> transformTenantFieldsToSys(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        List tenantSummaryFieldList = tenantSummaryFields.getSummaryFields();
        if (!CollectionUtils.isEmpty((Collection)tenantSummaryFieldList)) {
            ArrayList<Map<String, Object>> sysSummaryFields = new ArrayList<Map<String, Object>>(6);
            for (int i = 0; i < tenantSummaryFieldList.size(); ++i) {
                List values = ((TenantSummaryField)tenantSummaryFieldList.get(i)).getValue();
                for (String fieldPath : values) {
                    Optional<Map> first = summaryFields.stream().filter(map -> fieldPath.equals(MapUtil.getStr((Map)map, (Object)"value"))).findFirst();
                    Map sysSummaryField = Maps.newHashMap();
                    if (first.isPresent()) {
                        sysSummaryField = first.get();
                    }
                    Map sysSummaryFieldCopy = (Map)ObjectUtil.cloneByStream((Object)sysSummaryField);
                    sysSummaryFieldCopy.put(SUMMARY, true);
                    sysSummaryFieldCopy.put("actionId", tenantSummaryFields.getActionId());
                    sysSummaryFieldCopy.put("value", fieldPath);
                    ArrayList tagList = new ArrayList(1);
                    HashMap<String, Object> tag = new HashMap<String, Object>();
                    tag.put("code", "group_" + i);
                    tag.put("title", ((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                    tag.put("customTitle", true);
                    if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)sysSummaryFieldCopy, (Object)"description"))) {
                        sysSummaryFieldCopy.put("description", ((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                        sysSummaryFieldCopy.put("data_type", "string");
                        sysSummaryFieldCopy.put("data_name", fieldPath.contains(".") ? fieldPath.split("\\.")[1] : fieldPath);
                    }
                    if (!tag.containsKey("lang")) {
                        JSONObject lang = new JSONObject();
                        JSONObject titleLang = new JSONObject();
                        titleLang.fluentPut("zh_CN", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle()).fluentPut("zh_TW", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle()).fluentPut("en_US", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                        lang.put("title", (Object)titleLang);
                        tag.put("lang", lang);
                    }
                    tagList.add(tag);
                    sysSummaryFieldCopy.put("tags", tagList);
                    sysSummaryFields.add(sysSummaryFieldCopy);
                }
            }
            return sysSummaryFields;
        }
        return summaryFields;
    }

    private List<Map<String, Object>> mergeSummaryFields(List<Map<String, Object>> summaryFields, List<Map<String, Object>> transformedTenantSummaryFields) {
        if (CollectionUtils.isEmpty(summaryFields)) {
            return transformedTenantSummaryFields;
        }
        ArrayList<Map<String, Object>> mergedSummaryFields = new ArrayList<Map<String, Object>>();
        mergedSummaryFields.addAll(transformedTenantSummaryFields);
        mergedSummaryFields.addAll(summaryFields.stream().filter(map -> MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) == false).collect(Collectors.toList()));
        return mergedSummaryFields;
    }

    private void filterSummaryFields(Map<String, Object> task) throws DWBusinessException {
        List summaryFields = (List)task.get("summaryFields");
        Boolean usedTenantSummaryFields = (Boolean)task.get("usedTenantSummaryFields");
        List canSelectedSummaryFields = (List)task.get("canSelectedSummaryFields");
        if (!CollectionUtils.isEmpty((Collection)summaryFields) && !Boolean.TRUE.equals(usedTenantSummaryFields)) {
            summaryFields.removeIf(map -> MapUtils.getBoolean((Map)map, (Object)"defaultEffective", (Boolean)true) == false && MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) != false);
            Map pages = (Map)task.get("pages");
            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                List dataStates = (List)pages.get("dataStates");
                Map dataState = (Map)dataStates.get(0);
                dataState.put("summaryFields", summaryFields);
            } else {
                pages.put("summaryFields", summaryFields);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)canSelectedSummaryFields)) {
            canSelectedSummaryFields.removeIf(map -> MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) == false);
        }
        if (!CollectionUtils.isEmpty((Collection)canSelectedSummaryFields)) {
            String locale = Optional.ofNullable(ServiceUtils.getCurrentLocale()).orElse("zh_CN");
            String actionId = MapUtils.getString((Map)((Map)canSelectedSummaryFields.get(0)), (Object)"actionId");
            List<ApiDataFieldLocaleMetadataDTO> fields = null;
            if (StringUtils.isNotEmpty((CharSequence)actionId)) {
                try {
                    GetActionLocaleResponseDTO actionLocaleResponseDTO = this.dataMapKgService.getActionMetaData(actionId);
                    ApiDataFieldLocaleMetadataDTO data = actionLocaleResponseDTO.getResponse().getData();
                    fields = data.getField();
                }
                catch (Exception e) {
                    throw new DWBusinessException("\u67e5\u8be2\u5143\u6570\u636e\u5b9a\u4e49\u51fa\u9519\uff0cactionId\uff1a{}", actionId);
                }
            }
            canSelectedSummaryFields.forEach(field -> {
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"description"))) {
                    Object title = JSONPath.eval((Object)field, (String)"$.tags[0].title");
                    Object localeTitle = JSONPath.eval((Object)field, (String)("$.tags[0].lang.title." + locale));
                    field.put("description", localeTitle != null ? localeTitle : title);
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_name"))) {
                    String value = MapUtils.getString((Map)field, (Object)"value", (String)"");
                    field.put("data_name", value.contains(".") ? value.split("\\.")[1] : "");
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_type"))) {
                    field.put("data_type", "string");
                }
            });
            for (Map tenantSummaryField : summaryFields) {
                boolean b = canSelectedSummaryFields.stream().noneMatch(map -> MapUtils.getString((Map)map, (Object)"value", (String)"").equals(MapUtils.getString((Map)tenantSummaryField, (Object)"value", (String)"")));
                if (!b || !MapUtils.getBoolean((Map)tenantSummaryField, (Object)SUMMARY, (Boolean)true).booleanValue()) continue;
                if (null != fields && !fields.isEmpty()) {
                    Optional<ApiDataFieldLocaleMetadataDTO> dataName = fields.stream().filter(f -> f.getData_name().equals(MapUtils.getString((Map)tenantSummaryField, (Object)"data_name", (String)""))).findFirst();
                    dataName.ifPresent(apiDataFieldLocaleMetadataDTO -> tenantSummaryField.put("description", apiDataFieldLocaleMetadataDTO.getDescription()));
                }
                canSelectedSummaryFields.add(tenantSummaryField);
            }
        }
    }

    @Override
    public Object postFindTaskFromUser(FindTaskFromUserRequest request) throws DWException {
        if (Objects.isNull(request) || StringUtils.isEmpty((CharSequence)request.getTenantId()) || Objects.isNull(request.getPageNum()) || Objects.isNull(request.getPageSize())) {
            throw new DWBusinessException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        String version = this.dataPickService.tenantVersion();
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "1.0";
        }
        Criteria criteria = Criteria.where((String)"version").is((Object)version);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(request.getApplicationList())) {
            List<Application> applications = this.dbKnowledgeGraphService.tenantAppRelations(request.getApplicationList());
            Map<Object, Object> applicationIndividualMap = new HashMap();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(applications)) {
                applicationIndividualMap = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, app -> Optional.ofNullable(app.getIndividual()).orElse(false)));
            }
            ArrayList<Criteria> orCriteriaList = new ArrayList<Criteria>();
            for (String appCode : request.getApplicationList()) {
                if (Boolean.TRUE.equals(applicationIndividualMap.get(appCode))) {
                    orCriteriaList.add(Criteria.where((String)"application").is((Object)appCode).and("tenantId").is((Object)request.getTenantId()));
                    continue;
                }
                orCriteriaList.add(Criteria.where((String)"application").is((Object)appCode).and("tenantId").in(new Object[]{"SYSTEM", null}));
            }
            if (!orCriteriaList.isEmpty()) {
                criteria.andOperator(new Criteria[]{new Criteria().orOperator(orCriteriaList.toArray(new Criteria[0]))});
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getExecuteType())) {
            criteria.and("executeType").is((Object)request.getExecuteType());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTaskDefName())) {
            Pattern compile = Pattern.compile("^.*" + request.getTaskDefName() + ".*$", 2);
            String currentLocale = CommonUtils.getCurrentLocale();
            if (StringUtils.isEmpty((CharSequence)currentLocale)) {
                currentLocale = "zh_CN";
            }
            criteria.and("lang.name." + currentLocale).regex(compile);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(request.getIncludeCategoryList())) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(request.getDrivenCategory())) {
                criteria.orOperator(new Criteria[]{Criteria.where((String)"category").in(request.getIncludeCategoryList()), Criteria.where((String)"drivenCategory").in(request.getDrivenCategory())});
            } else {
                criteria.and("category").in(request.getIncludeCategoryList());
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(request.getExcludeCategoryList())) {
            criteria.and("category").nin(request.getExcludeCategoryList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(request.getDrivenCategory())) {
                criteria.and("drivenCategory").nin(request.getDrivenCategory());
            }
        }
        Query query = new Query((CriteriaDefinition)criteria);
        long total = this.dataPickService.systemTemplate().count(query, Task.class);
        if (total <= 0L) {
            return new FindTaskFromUserResp(null, total);
        }
        PageRequest pageable = PageRequest.of((int)(request.getPageNum() - 1), (int)request.getPageSize());
        List tasks = this.dataPickService.systemTemplate().find(query.with((Pageable)pageable), Task.class);
        return new FindTaskFromUserResp(tasks, total);
    }

    @Override
    public CustBizTaskConfigDTO getCustBizTaskByProject(String appCode, String projectCode) throws DWException {
        CustBizTaskConfigDTO custBizTaskConfig = new CustBizTaskConfigDTO();
        String version = this.dataPickService.tenantVersion();
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "2.0";
        }
        List taskList = this.dataPickService.systemTemplate().find(Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode).and("executeType").is((Object)"manual").and("version").is((Object)version)), Task.class);
        Project project = (Project)this.dataPickService.systemTemplate().findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)projectCode).and("version").is((Object)version).and("tenantId").is((Object)"SYSTEM")), Project.class);
        if (ObjectUtils.isEmpty((Object)taskList)) {
            return null;
        }
        if (project == null || ObjectUtils.isEmpty((Object)project.getMainLineTasks())) {
            return null;
        }
        CustBizTaskConfigDTO taskConfigDTO = (CustBizTaskConfigDTO)this.dataPickService.tenantTemplate().findOne(Query.query((CriteriaDefinition)Criteria.where((String)"projectCode").is((Object)projectCode).and("tenantId").is((Object)ServiceUtils.getTenantId())), CustBizTaskConfigDTO.class);
        HashMap<String, Boolean> bizTaskSkipMap = new HashMap<String, Boolean>();
        if (null != taskConfigDTO && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)taskConfigDTO.getBizTasks())) {
            bizTaskSkipMap.putAll(taskConfigDTO.getBizTasks().stream().collect(Collectors.toMap(CustBizTask::getCode, CustBizTask::getCustomSkip)));
        }
        List taskResults = taskList.stream().filter(task -> project.getMainLineTasks().contains(task.getCode())).collect(Collectors.toList());
        Map<String, Integer> taskSequenceMap = this.getTaskSequenceByProject(project, version);
        if (!ObjectUtils.isEmpty(taskResults)) {
            List custBizTasks = taskResults.stream().map(task -> {
                CustBizTask custBizTask = new CustBizTask();
                custBizTask.setCode(task.getCode());
                custBizTask.setName(task.getName());
                custBizTask.setSequence((Integer)taskSequenceMap.get(task.getCode()));
                custBizTask.setCustomSkip((Boolean)bizTaskSkipMap.get(task.getCode()));
                custBizTask.setCustomCanSkip(task.getCustomCanSkip());
                return custBizTask;
            }).sorted(Comparator.comparing(CustBizTask::getSequence, Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
            custBizTaskConfig.setBizTasks(custBizTasks);
        }
        custBizTaskConfig.setCode(taskConfigDTO == null ? null : taskConfigDTO.getCode());
        custBizTaskConfig.setCustomGroupSkip(taskConfigDTO == null ? null : taskConfigDTO.getCustomGroupSkip());
        custBizTaskConfig.setProjectCode(projectCode);
        custBizTaskConfig.setGroupSkipConfig(taskConfigDTO == null ? null : taskConfigDTO.getGroupSkipConfig());
        custBizTaskConfig.setTenantId(ServiceUtils.getTenantId());
        return custBizTaskConfig;
    }

    private Map<String, Integer> getTaskSequenceByProject(Project project, String version) {
        HashMap<String, Integer> taskSequenceMap = new HashMap<String, Integer>();
        Integer sequence = 1;
        DataState initDataState = project.getInit();
        DataState endDataState = project.getEnd();
        String taskStateCode = initDataState.getCode();
        while (!endDataState.getCode().equals(taskStateCode) && sequence < 100) {
            List taskList = this.dataPickService.systemTemplate().find(Query.query((CriteriaDefinition)Criteria.where((String)"from").in(new Object[]{taskStateCode}).and("version").is((Object)version)), Task.class);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)taskList) || taskList.size() > 1) {
                return taskSequenceMap;
            }
            Task task = (Task)taskList.get(0);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)task.getTo()) || task.getTo().size() > 1) {
                taskSequenceMap.put(task.getCode(), sequence);
                return taskSequenceMap;
            }
            taskStateCode = (String)task.getTo().get(0);
            taskSequenceMap.put(task.getCode(), sequence);
            Integer n = sequence;
            Integer n2 = sequence = Integer.valueOf(sequence + 1);
        }
        return taskSequenceMap;
    }
}

