/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.kg.DataMapLicenseKeyManager;
import com.digiwin.athena.datamap.povo.ViewRequest;
import com.digiwin.athena.datamap.service.ITenantService;
import com.digiwin.athena.datamap.service.impl.DataMapDutyService;
import com.digiwin.athena.datamap.service.impl.DataMapLevelService;
import com.digiwin.athena.datamap.service.impl.DatamapAppService;
import com.digiwin.athena.datamap.service.inner.DatamapRedisLock;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.datamap.utils.AthenaUtils;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.TenantAppRelation;
import com.digiwin.athena.domain.core.tenant.TenantEntity;
import com.digiwin.athena.kg.domain.ProductTemplateTenant;
import com.digiwin.athena.kg.dto.TenantInitParam;
import com.digiwin.athena.kg.dto.TenantInitResp;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.service.KmGeneralService;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@MyExceptionHandler
@Service
public class DataMapTenantService
implements ITenantService {
    private static final Logger log = LoggerFactory.getLogger(DataMapTenantService.class);
    @Autowired
    @Qualifier(value="kgSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="kgTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactoryDomain1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryFordomain2")
    SessionFactory sessionFactoryDomain2;
    @Resource(name="kgDataPickService")
    DataPickService dataPickService;
    @Autowired
    KmService kmService;
    @Autowired
    @Lazy
    DatamapAppService datamapAppService;
    @Autowired
    DatamapRedisLock datamapRedisLock;
    @Autowired
    DataMapIamService dataMapIamService;
    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    DataMapLicenseKeyManager dataMapLicenseKeyManager;
    @Autowired
    DataMapDutyService dataMapDutyService;
    @Autowired
    DataMapLevelService dataMapLevelService;
    @Autowired
    KmGeneralService kmGeneralService;

    @Override
    public Object postInitTenantInfo(ViewRequest request) throws DWException {
        return null;
    }

    @Override
    public Object postInitAllTenantInfo() throws DWException {
        return null;
    }

    @Override
    public List<TenantEntity> getAllTenant() {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"ifCommon").in(new Object[]{null, false})), TenantEntity.class);
    }

    @Override
    public TenantEntity getTenant(String tenantId) {
        return (TenantEntity)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), TenantEntity.class);
    }

    @Override
    public String getTenantVersion(String tenantId) {
        String version = "2.0";
        TenantEntity entity = this.getTenant(tenantId);
        if (null != entity) {
            version = entity.getVersion();
        }
        return version;
    }

    private Application getApplication(String appCode) throws DWBusinessException {
        Application application;
        if ("espCommon".equals(appCode)) {
            application = new Application();
            application.setCode("espCommon");
            application.setCommonApp(Boolean.valueOf(true));
        } else {
            application = this.datamapAppService.getApplicationByCode(appCode);
        }
        if (application == null || null == application.getCommonApp() || !application.getCommonApp().booleanValue()) {
            log.error("appEntity\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u8005appEntity\u8282\u70b9\u4e2dnameSpace\u4e3a\u7a7a\uff0c\u6216\u975e\u516c\u5171\u5e94\u7528\uff0c\u8bf7\u5148\u521b\u5efa\u540e\u518d\u521d\u59cb\u5316!");
            throw new DWArgumentException("appEntity", I18nUtils.getValue((String)"knowledgegraph.appEntity.notExist", (Object[])new Object[0]));
        }
        return application;
    }

    private List<String> findTemplateTenant(String product, String appCode) {
        log.info("findTemplateTenant appCode:{}, product:{}", (Object)appCode, (Object)product);
        if (StringUtils.isEmpty((CharSequence)product)) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"app").is((Object)appCode).and("product").is((Object)product));
        List templateTenants = this.mongoTemplate.find(query, ProductTemplateTenant.class);
        if (CollectionUtils.isEmpty((Collection)templateTenants)) {
            return null;
        }
        resultList.add(((ProductTemplateTenant)templateTenants.get(0)).getTenantId());
        return resultList;
    }

    private List<String> findTemplateTenant(List<String> products, String appCode) {
        log.info("findTemplateTenant appCode:{}, products:{}", (Object)appCode, products);
        if (CollectionUtils.isEmpty(products)) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        HashSet<String> existTenant = new HashSet<String>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"app").is((Object)appCode));
        List templateTenants = this.mongoTemplate.find(query, ProductTemplateTenant.class);
        if (CollectionUtils.isEmpty((Collection)templateTenants)) {
            return null;
        }
        Map<String, String> collect = templateTenants.stream().collect(Collectors.toMap(ProductTemplateTenant::getProduct, ProductTemplateTenant::getTenantId));
        for (String str : products) {
            String s = collect.get(str);
            if (!StringUtils.isNotEmpty((CharSequence)s) || existTenant.contains(s)) continue;
            resultList.add(s);
            existTenant.add(s);
        }
        return resultList;
    }

    @Override
    public Object postCleanTenantInfo(TenantInitParam param) throws DWBusinessException {
        System.out.println(param);
        TenantInitResp resp = new TenantInitResp();
        String tenantId = ServiceUtils.getTenantId();
        Session session = this.sessionFactory.openSession();
        String cleanCypher = "MATCH (n:TenantEntity)  where n.tenantId='" + tenantId + "' detach delete n";
        session.query(cleanCypher, new HashMap());
        session.clear();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId));
        this.mongoTemplate.remove(query, TenantEntity.class);
        this.mongoTemplate.remove(query, TenantAppRelation.class);
        return resp;
    }

    @Override
    public List<String> getAppCodes() throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        return this.kmService.tenantApps(tenantId);
    }

    private void deleteTenantAppCodeCache(String tenantId) {
        log.info("deleteTenantAppCodeCache tenantId:{}", (Object)tenantId);
        String key = "knowledgegraph:SYSTEM:SYSTEM:zh_CN:getAppCodes$" + tenantId;
        try {
            Long o = this.kmGeneralService.deleteKeys(Collections.singletonList(key));
            log.info("deleteTenantAppCodeCache tenantId:{}, result:{}", (Object)tenantId, (Object)o);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    @Override
    public Object getApps() throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        Object res = this.kmService.authorizationsTenants(tenantId);
        if (ObjectUtils.isEmpty((Object)res)) {
            return res;
        }
        ArrayList<JSONObject> objectList = new ArrayList<JSONObject>();
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)res));
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String code = jsonObject.getString("code");
            Application applicationInfo = this.datamapAppService.getApplicationInfo(code);
            if (applicationInfo == null) continue;
            jsonObject.put("displayName", (Object)applicationInfo.getName());
            objectList.add(jsonObject);
        }
        return objectList;
    }

    @Override
    public Object getAppsInfo() throws DWBusinessException {
        HashMap<String, Object> appInfo = new HashMap<String, Object>();
        String tenantId = ServiceUtils.getTenantId();
        List<TenantAppRelation> tenantAppRelations = this.kmService.tenantInitializedApps(tenantId);
        appInfo.put("tenantAppInfos", tenantAppRelations);
        appInfo.put("tenantVersion", this.kmService.tenantVersion());
        return appInfo;
    }

    @Override
    public Object getUserAppAuthByUserId() throws DWBusinessException {
        String userId = ServiceUtils.getUserId();
        String tenantId = ServiceUtils.getTenantId();
        if (StringUtils.isEmpty((CharSequence)userId)) {
            throw new DWBusinessException("userId is empty");
        }
        HashMap<String, Object> tenantAppInfos = new HashMap<String, Object>();
        tenantAppInfos.put("appCodes", this.kmService.userApps(userId));
        tenantAppInfos.put("tenantVersion", this.kmService.tenantVersion());
        tenantAppInfos.put("tenantId", tenantId);
        tenantAppInfos.put("userId", userId);
        return tenantAppInfos;
    }

    @Override
    public Object getUserAppAuthByUserId(String userId) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = AthenaUtils.getUserId();
        }
        String tenantId = ServiceUtils.getTenantId();
        HashMap<String, Object> tenantAppInfos = new HashMap<String, Object>();
        tenantAppInfos.put("appCodes", this.kmService.userApps(userId));
        tenantAppInfos.put("tenantVersion", this.kmService.tenantVersion());
        tenantAppInfos.put("tenantId", tenantId);
        tenantAppInfos.put("userId", userId);
        return tenantAppInfos;
    }

    @Override
    public List<Application> getUserMetricApplication() throws DWBusinessException {
        return this.getUserMetricApplicationByType("1");
    }

    @Override
    public List<Application> getUserMetricApplicationByType(String type) throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        return this.getUserMetricApplicationByTypeAndUserId(type, userId);
    }

    @Override
    public List<Application> getUserMetricApplicationByTypeAndUserId(String type, String userId) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = AthenaUtils.getUserId();
        }
        String tenantVersion = this.kmService.tenantVersion();
        List<String> appCodes = this.kmService.userApps(userId);
        if (StringUtils.equals((CharSequence)type, (CharSequence)"1")) {
            return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(appCodes).and("appType").is((Object)6)), Application.class);
        }
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(appCodes)), Application.class);
    }

    @Override
    public Object postQueryProductLineByApp(List<String> appCodes) throws DWBusinessException {
        if (CollectionUtils.isEmpty(appCodes)) {
            return Collections.emptyMap();
        }
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").in(appCodes).and("version").is((Object)tenantVersion));
        List applications = this.mongoTemplate.find(query, Application.class);
        return appCodes.stream().collect(Collectors.toMap(appCode -> appCode, appCode -> applications.stream().filter(application -> application.getCode().equals(appCode)).findFirst().map(Application::getProductLines).orElse(Collections.emptyList()), (existing, replacement) -> existing));
    }
}

