/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.domain.FatPageView;
import com.digiwin.athena.datamap.domain.TaskCardFields;
import com.digiwin.athena.datamap.enums.BusinessMessageSourceMethod;
import com.digiwin.athena.datamap.enums.SourceType;
import com.digiwin.athena.datamap.enums.WSConfigType;
import com.digiwin.athena.datamap.enums.WSPageCode;
import com.digiwin.athena.datamap.povo.AppCardFieldsVO;
import com.digiwin.athena.datamap.povo.BkField;
import com.digiwin.athena.datamap.povo.BkInfo;
import com.digiwin.athena.datamap.povo.BkRequest;
import com.digiwin.athena.datamap.povo.BkResponse;
import com.digiwin.athena.datamap.povo.ConditionScopeDTO;
import com.digiwin.athena.datamap.povo.DataEntityMetadataDTO2;
import com.digiwin.athena.datamap.povo.SmartDataExecutePo;
import com.digiwin.athena.datamap.povo.TaskCardFieldRequest;
import com.digiwin.athena.datamap.povo.TaskCardFieldVO;
import com.digiwin.athena.datamap.povo.TasksWithCustomizeRequest;
import com.digiwin.athena.datamap.povo.ViewRequest;
import com.digiwin.athena.datamap.povo.WSConditionDTO;
import com.digiwin.athena.datamap.povo.WordTaskReq;
import com.digiwin.athena.datamap.povo.WorkbenchSettingByConfigTypeRequest;
import com.digiwin.athena.datamap.povo.WorkbenchSettingRequest;
import com.digiwin.athena.datamap.povo.monitorrule.ActionParamDTO;
import com.digiwin.athena.datamap.povo.monitorrule.MonitorRuleDTO;
import com.digiwin.athena.datamap.povo.monitorrule.ReturnColumnDTO;
import com.digiwin.athena.datamap.service.IViewService;
import com.digiwin.athena.datamap.service.impl.DataMapActivityService;
import com.digiwin.athena.datamap.service.impl.DataMapTaskService;
import com.digiwin.athena.datamap.service.impl.GenericService;
import com.digiwin.athena.datamap.service.impl.ProjectService;
import com.digiwin.athena.datamap.service.impl.RecordService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.spi.DataMapTagSystemService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.datamap.spi.SmartDataService;
import com.digiwin.athena.datamap.utils.CommonUtils;
import com.digiwin.athena.domain.common.BaseObject;
import com.digiwin.athena.domain.common.HierarchicalEntity;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.Phase;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.EmailView;
import com.digiwin.athena.domain.core.view.PageUIElement;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.TaskRef;
import com.digiwin.athena.domain.definition.actions.ActionParam;
import com.digiwin.athena.domain.definition.actions.DataEntityMetadataDTO;
import com.digiwin.athena.domain.definition.times.ExpectedDuration;
import com.digiwin.athena.domain.definition.times.TimeDefinition;
import com.digiwin.athena.dto.ActivityBaseInfoVO;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.dto.TaskSchedule;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.entity.OpenWindowDecision;
import com.digiwin.athena.preset.Rule;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@MyExceptionHandler
@Service
@Lang
public class DataMapViewService
implements IViewService {
    private static Logger log = LoggerFactory.getLogger(DataMapViewService.class);
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    ProjectService projectService;
    @Autowired
    @Lazy
    DataMapTaskService dataMapTaskService;
    @Autowired
    DataMapPickService dataPickService;
    @Autowired
    SmartDataService smartDataService;
    @Autowired
    PresetLibraryService presetLibraryService;
    @Autowired
    DataMapKgService dataMapKgService;
    @Autowired
    GenericService genericService;
    @Autowired
    DataMapTagSystemService dataMapTagSystemService;
    @Autowired
    private IKnowledgeGraphService knowledgeGraphService;
    @Autowired
    private DataMapActivityService dataMapActivityService;
    @Autowired
    @Lazy
    RecordService recordService;

    @Override
    public Map<String, Object> postProject(ViewRequest request) throws DWException {
        if (null == request.getProjectCode()) {
            return null;
        }
        BasicQuery query = BasicQuery.of(new HashMap(), request.getEocInfo());
        query.getQuery().put("code", request.getProjectCode());
        Project project = (Project)this.dataPickService.findOne(query, Project.class);
        Map<String, Object> view = this.projectToView(project, request.getEocInfo());
        return view;
    }

    public Object postAppCardFields(AppCardFieldsVO request) throws DWException {
        String application = request.getApplication();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application));
        List pageViews = this.mongoTemplate.find(query, PageView.class);
        if (CollectionUtils.isEmpty((Collection)pageViews)) {
            return Collections.EMPTY_LIST;
        }
        LinkedList taskCardFieldsList = new LinkedList();
        pageViews.forEach(item -> {
            List cardFieldsDataStates;
            List dataStates;
            Map taskCard;
            Map pages = item.getPages();
            if (!(CollectionUtils.isEmpty((Map)pages) || CollectionUtils.isEmpty((Map)(taskCard = (Map)pages.get("task-card"))) || CollectionUtils.isEmpty((Collection)(dataStates = (List)taskCard.get("dataStates"))) || CollectionUtils.isEmpty(cardFieldsDataStates = dataStates.stream().filter(map -> "all".equals(map.get("type"))).collect(Collectors.toList())))) {
                Map cardField = (Map)cardFieldsDataStates.get(0);
                TaskCardFields taskCardFields = (TaskCardFields)JSON.parseObject((String)JSON.toJSONString((Object)cardField), TaskCardFields.class);
                taskCardFields.setCode(item.getCode());
                taskCardFieldsList.add(taskCardFields);
            }
        });
        return taskCardFieldsList;
    }

    @Override
    public Map<String, Object> postProject2(ViewRequest request) throws DWException {
        if (null == request.getProjectCode()) {
            return null;
        }
        ServiceUtils.getContext().setEocInfo(request.getEocInfo());
        Project project = this.projectService.getProjectByCode(request.getProjectCode());
        Map<String, Object> view = this.projectToView(project, request.getEocInfo());
        return view;
    }

    @Override
    public List<Object> postProjectList(ViewRequest request) throws DWException {
        List projects = this.dataPickService.findBetters(BasicQuery.of(request.getQuery(), request.getEocInfo()), Project.class);
        ArrayList<Object> views = new ArrayList<Object>();
        projects.forEach(p -> {
            try {
                views.add(this.projectToView((Project)p, request.getEocInfo()));
            }
            catch (DWException e) {
                log.error(e.toString());
            }
        });
        return views;
    }

    @Override
    public List<Object> postProjectList2(ViewRequest request) throws DWException {
        boolean cn = ServiceUtils.getCurrentLocale().equals("zh_CN");
        List projects = this.dataPickService.findBetters(BasicQuery.of(request.getQuery(), request.getEocInfo()), Project.class);
        ArrayList<Object> views = new ArrayList<Object>();
        ArrayList operations = new ArrayList();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("value", "open");
        map1.put("label", cn ? "\u6253\u5f00\u65f6" : "\u6253\u958b\u6642");
        map1.put("lang", (String)ImmutableMap.of((Object)"label", (Object)ImmutableMap.of((Object)"zh_CN", (Object)"\u6253\u5f00\u65f6", (Object)"zh_TW", (Object)"\u6253\u958b\u6642")));
        operations.add(map1);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("value", "update");
        map2.put("label", cn ? "\u4fee\u6539\u65f6" : "\u4fee\u6539\u6642");
        map2.put("lang", (String)ImmutableMap.of((Object)"label", (Object)ImmutableMap.of((Object)"zh_CN", (Object)"\u4fee\u6539\u65f6", (Object)"zh_TW", (Object)"\u4fee\u6539\u6642")));
        operations.add(map2);
        projects.forEach(p -> {
            try {
                Map<String, Object> map = this.projectToView2((Project)p, request.getEocInfo());
                map.put("operations", operations);
                views.add(map);
            }
            catch (DWException e) {
                log.error(e.toString());
            }
        });
        return views;
    }

    @Override
    public List<Project> postProjectListBasic(ViewRequest request) throws DWException {
        List projects = this.dataPickService.find(BasicQuery.of(request.getQuery(), request.getEocInfo()), Project.class);
        return projects;
    }

    @Override
    public List<Task> postTaskList(ViewRequest request) throws DWException {
        List tasks = this.dataPickService.find(BasicQuery.of(request.getQuery(), request.getEocInfo()), Task.class);
        return tasks;
    }

    @Override
    public List<ActivityBaseInfoVO> postTaskListApprove(ViewRequest request) throws DWException {
        List<Task> tasks = this.postTaskList(request);
        ArrayList<ActivityBaseInfoVO> result = new ArrayList<ActivityBaseInfoVO>();
        String locale = ServiceUtils.getCurrentLocale();
        ArrayList<String> codes = new ArrayList<String>();
        for (Task t : tasks) {
            Object dynamicApproves;
            codes.add(t.getCode());
            ActivityBaseInfoVO vo = new ActivityBaseInfoVO();
            vo.setTaskId(t.getCode());
            request.setTaskCode(t.getCode());
            Map<String, Object> map = this.postTask(request);
            if (map.get("dynamicApproves") != null && (dynamicApproves = map.get("dynamicApproves")) instanceof List) {
                ArrayList<Map> subApproveMap = new ArrayList<Map>();
                List dynamicApprovesList = (List)dynamicApproves;
                for (Object o : dynamicApprovesList) {
                    if (!(o instanceof Map)) continue;
                    Map o1 = (Map)o;
                    subApproveMap.add(o1);
                }
                vo.setSubApprove(subApproveMap);
            }
            vo.setAllowSubLevel(t.getAllowSubLevel());
            vo.setNeedEnableApprove(t.getNeedEnableApprove());
            vo.setActivityId(t.getCode());
            vo.setActivityName(t.getName());
            if (null != locale && null != t.getLang() && null != t.getLang().get("name") && null != ((Map)t.getLang().get("name")).get(locale)) {
                vo.setActivityName((String)((Map)t.getLang().get("name")).get(locale));
            }
            result.add(vo);
        }
        HashMap<String, ArrayList<String>> q2 = new HashMap<String, ArrayList<String>>();
        q2.put("mainLineTasks", codes);
        List projects = this.dataPickService.find(BasicQuery.of(q2, request.getEocInfo()), Project.class);
        for (ActivityBaseInfoVO vo : result) {
            for (Project p : projects) {
                if (!p.getMainLineTasks().contains(vo.getActivityId())) continue;
                if ("mainline".equals(p.getExecuteType())) {
                    vo.setMainLineTaskId(p.getCode());
                    vo.setManualAble(p.getManualAble());
                    vo.setAuthorityPrefix(p.getAuthorityPrefix());
                }
                vo.setTaskId(p.getCode());
                vo.setTaskName(p.getName());
                if (null == locale || null == p.getLang() || null == p.getLang().get("name") || null == ((Map)p.getLang().get("name")).get(locale)) continue;
                vo.setTaskName((String)((Map)p.getLang().get("name")).get(locale));
            }
        }
        return result;
    }

    private Map<String, Object> projectToView(Project project, Map<String, Object> eocInfo) throws DWException {
        List phases;
        PageView page;
        if (null == project) {
            return null;
        }
        boolean comeFromDesigner = null != ServiceUtils.getHeader((String)"designer");
        String locale = ServiceUtils.getLocale();
        String tenantId = ServiceUtils.getTenantId();
        Map viewMap = MergeUtil.mergeObjectToMap(new HashMap(), (Object)project, null);
        viewMap.put("taskId", project.getCode());
        viewMap.put("sequence", project.getSequence());
        viewMap.put("chargePerson", project.getPersonInCharge());
        viewMap.put("notifyParty", project.getNotifyParty());
        viewMap.put("presetVariables", project.getPresetVariables());
        if ("BUSINESS".equalsIgnoreCase(project.getType())) {
            viewMap.put("completedReport", true);
        }
        if (null != project.getPageCode() && null != (page = (PageView)this.dataPickService.findBetter(project.getPageCode(), PageView.class))) {
            page.setName(null);
            MergeUtil.mergeObjectToMap((Map)viewMap, (Object)page, Arrays.asList("id", "code", "name"));
        }
        if (Boolean.TRUE.equals(project.getManualAble())) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("project", project.getCode());
            param.put("pageType", 1);
            List pageViewList = this.dataPickService.findBetters(BasicQuery.of(param, eocInfo), PageView.class);
            viewMap.put("presetActivities", pageViewList);
        }
        if (null != project.getLang()) {
            if (null != locale && null != project.getLang().get("name") && null != ((Map)project.getLang().get("name")).get(locale)) {
                viewMap.put("name", ((Map)project.getLang().get("name")).get(locale));
            }
            viewMap.put("taskName", project.getLang().get("name"));
            viewMap.put("sourceName", project.getLang().get("sourceName"));
            viewMap.put("dueDateName", project.getLang().get("dueDateName"));
            project.getLang().remove("name");
            project.getLang().remove("sourceName");
            project.getLang().remove("dueDateName");
        }
        if (null != project.getTarget()) {
            viewMap.put("taskTargetId", project.getTarget().getCode());
            viewMap.put("taskTargetName", project.getTarget().getName());
            if (null != project.getTarget().getLang()) {
                viewMap.put("taskTargetName", project.getTarget().getLang().get("name"));
                project.getTarget().getLang().remove("name");
            }
        }
        ArrayList activities = new ArrayList();
        if (null == project.getPhases()) {
            if (null != project.getMainLineTasks() && project.getMainLineTasks().size() > 0) {
                HashMap<String, List> q = new HashMap<String, List>();
                q.put("code", project.getMainLineTasks());
                List tasks = this.dataPickService.find(BasicQuery.of(q, eocInfo), Task.class);
                if (null != tasks && tasks.size() > 0) {
                    HashMap codeTasks = new HashMap();
                    HashMap taskNames = new HashMap();
                    tasks.forEach(tv -> {
                        activities.add(tv);
                        codeTasks.put(tv.getCode(), tv);
                        taskNames.put(tv.getCode(), tv.getName());
                        if (null != tv.getLang() && null != tv.getLang().get("name") && null != ((Map)tv.getLang().get("name")).get(locale)) {
                            taskNames.put(tv.getCode(), ((Map)tv.getLang().get("name")).get(locale));
                        }
                    });
                    viewMap.put("taskNames", taskNames);
                    if (null == project.getPhases() || project.getPhases().size() == 0) {
                        ArrayList phases2 = new ArrayList();
                        project.getMainLineTasks().forEach(tcode -> {
                            Task tv = (Task)codeTasks.get(tcode);
                            if (null != tv) {
                                Phase phase = new Phase();
                                phase.setCode(tv.getCode());
                                phase.setName(tv.getName());
                                if (null != tv.getLang() && null != tv.getLang().get("name") && null != ((Map)tv.getLang().get("name")).get(locale)) {
                                    phase.setName((String)((Map)tv.getLang().get("name")).get(locale));
                                }
                                phase.setTaskCodes(new ArrayList());
                                phase.setTasks(new ArrayList());
                                phase.getTaskCodes().add(tv.getCode());
                                TaskRef ref = new TaskRef();
                                ref.setCode(tv.getCode());
                                ref.setName(tv.getName());
                                ref.setLang(tv.getLang());
                                phase.getTasks().add(ref);
                                phases2.add(phase);
                            }
                        });
                        viewMap.put("phases", phases2);
                    }
                }
            }
        } else {
            if (!comeFromDesigner) {
                Iterator refs2 = project.getPhases().iterator();
                while (refs2.hasNext()) {
                    Map resp;
                    Object inv_scrap;
                    Phase p2 = (Phase)refs2.next();
                    if (p2.getConfig() == null || null == p2.getConfig().get("skipActionId")) continue;
                    String skipActionId = (String)p2.getConfig().get("skipActionId");
                    String skipMechanismKey = (String)p2.getConfig().get("skipMechanismKey");
                    if (null == skipMechanismKey) {
                        skipMechanismKey = "inv_rework";
                    }
                    SmartDataExecutePo po = new SmartDataExecutePo();
                    po.setTenantId(tenantId);
                    po.setActionId(skipActionId);
                    Object obj = this.smartDataService.engineExecute(po);
                    if (null == obj || !Boolean.FALSE.equals(inv_scrap = (resp = (Map)obj).get(skipMechanismKey))) continue;
                    refs2.remove();
                }
            }
            ArrayList codes = new ArrayList();
            HashMap reftemp = new HashMap();
            project.getPhases().forEach(phase -> {
                if (null != phase.getTaskCodes()) {
                    codes.addAll(phase.getTaskCodes());
                    if (null == phase.getTasks()) {
                        phase.setTasks(new ArrayList());
                        phase.getTaskCodes().forEach(t -> {
                            TaskRef ref = new TaskRef();
                            ref.setCode(t);
                            phase.getTasks().add(ref);
                            reftemp.put(t, ref);
                        });
                    }
                }
            });
            if (codes.size() > 0) {
                HashMap q = new HashMap();
                q.put("code", codes);
                List tasks = this.dataPickService.find(BasicQuery.of(q, null), Task.class);
                HashMap taskNames = new HashMap();
                tasks.forEach(tv -> {
                    TaskRef ref;
                    activities.add(tv);
                    taskNames.put(tv.getCode(), tv.getName());
                    if (null != tv.getLang() && null != tv.getLang().get("name") && null != ((Map)tv.getLang().get("name")).get(locale)) {
                        taskNames.put(tv.getCode(), ((Map)tv.getLang().get("name")).get(locale));
                    }
                    if (null != (ref = (TaskRef)reftemp.get(tv.getCode()))) {
                        ref.setLang(tv.getLang());
                        ref.setName(tv.getName());
                    }
                });
                viewMap.put("taskNames", taskNames);
            }
        }
        activities.forEach(tv -> {
            tv.setActivityId(tv.getCode());
            tv.setActivityName((Object)tv.getName());
            if (null != tv.getLang()) {
                tv.setActivityName(tv.getLang().get("name"));
            }
        });
        viewMap.put("activities", activities);
        if (!comeFromDesigner && null != (phases = (List)viewMap.get("phases"))) {
            phases.forEach(p -> {
                if (null != p.getTasks()) {
                    Iterator refs = p.getTasks().iterator();
                    while (refs.hasNext()) {
                        TaskRef ref = (TaskRef)refs.next();
                        if (!Boolean.TRUE.equals(ref.getHidden())) continue;
                        refs.remove();
                    }
                }
            });
            Iterator refs2 = phases.iterator();
            while (refs2.hasNext()) {
                Phase p3 = (Phase)refs2.next();
                if (p3.getTasks() != null && p3.getTasks().size() != 0) continue;
                refs2.remove();
            }
        }
        return viewMap;
    }

    private Map<String, Object> projectToView2(Project project, Map<String, Object> eocInfo) throws DWException {
        PageView page;
        if (null == project) {
            return null;
        }
        String locale = ServiceUtils.getCurrentLocale();
        String tenantId = ServiceUtils.getTenantId();
        Map viewMap = MergeUtil.mergeObjectToMap(new HashMap(), (Object)project, null);
        viewMap.put("taskId", project.getCode());
        viewMap.put("sequence", project.getSequence());
        viewMap.put("chargePerson", project.getPersonInCharge());
        viewMap.put("presetVariables", project.getPresetVariables());
        if ("BUSINESS".equalsIgnoreCase(project.getType())) {
            viewMap.put("completedReport", true);
        }
        if (null != project.getPageCode() && null != (page = (PageView)this.dataPickService.findBetter(project.getPageCode(), PageView.class))) {
            page.setName(null);
            MergeUtil.mergeObjectToMap((Map)viewMap, (Object)page, null);
        }
        if (Boolean.TRUE.equals(project.getManualAble())) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("project", project.getCode());
            param.put("pageType", 1);
            List pageViewList = this.dataPickService.findBetters(BasicQuery.of(param, eocInfo), PageView.class);
            viewMap.put("presetActivities", pageViewList);
        }
        if (null != project.getLang()) {
            if (null != locale && null != project.getLang().get("name") && null != ((Map)project.getLang().get("name")).get(locale)) {
                viewMap.put("name", ((Map)project.getLang().get("name")).get(locale));
            }
            viewMap.put("taskName", project.getLang().get("name"));
            viewMap.put("sourceName", project.getLang().get("sourceName"));
            viewMap.put("dueDateName", project.getLang().get("dueDateName"));
            project.getLang().remove("name");
            project.getLang().remove("sourceName");
            project.getLang().remove("dueDateName");
        }
        if (null != project.getTarget()) {
            viewMap.put("taskTargetId", project.getTarget().getCode());
            viewMap.put("taskTargetName", project.getTarget().getName());
            if (null != locale && null != project.getTarget().getLang() && null != project.getTarget().getLang().get("name") && null != ((Map)project.getTarget().getLang().get("name")).get(locale)) {
                viewMap.put("taskTargetName", project.getTarget().getLang().get("name"));
                project.getTarget().getLang().remove("name");
            }
        }
        List activities = new ArrayList();
        HashSet taskCodes = new HashSet();
        if (null != project.getPhases()) {
            project.getPhases().forEach(phase -> {
                if (null != phase.getTaskCodes()) {
                    taskCodes.addAll(phase.getTaskCodes());
                }
            });
        }
        if (null != project.getMainLineTasks()) {
            taskCodes.addAll(project.getMainLineTasks());
        }
        if (taskCodes.size() > 0) {
            HashMap q = new HashMap();
            q.put("code", taskCodes);
            activities = this.dataPickService.findBetters(BasicQuery.of(q, eocInfo), Task.class);
        }
        activities.forEach(tv -> {
            tv.setActivityId(tv.getCode());
            tv.setActivityName((Object)tv.getName());
            if (null != tv.getLang() && null != locale && null != tv.getLang().get("name") && null != ((Map)tv.getLang().get("name")).get(locale)) {
                tv.setActivityName(((Map)tv.getLang().get("name")).get(locale));
                tv.setName((String)((Map)tv.getLang().get("name")).get(locale));
            }
        });
        viewMap.put("activities", activities);
        return viewMap;
    }

    @Override
    public Map<String, Object> postTasks(ViewRequest request) throws DWException {
        ServiceUtils.getContext().setEocInfo(request.getEocInfo());
        Assert.notNull((Object)request.getProjectCode(), (String)"projectCode is null!");
        Project project = this.projectService.getProjectByCode(request.getProjectCode());
        if (null == project) {
            return null;
        }
        Map viewMap = MergeUtil.mergeObjectToMap(new HashMap(), (Object)project, null);
        if (null != project.getTarget()) {
            viewMap.put("taskTargetId", project.getTarget().getCode());
            viewMap.put("taskTargetName", project.getTarget().getName());
            if (null != project.getTarget().getLang()) {
                viewMap.put("taskTargetName", project.getTarget().getLang().get("name"));
                project.getTarget().getLang().remove("name");
            }
        }
        List<Task> tasks = this.fillMainlineTaskInfo(project);
        viewMap.put("activities", tasks);
        return viewMap;
    }

    private List<Task> fillMainlineTaskInfo(Project project) throws DWBusinessException {
        ArrayList<Task> activities = new ArrayList<Task>();
        if (null != project.getMainLineTasks() && project.getMainLineTasks().size() > 0) {
            HashMap<String, List> q = new HashMap<String, List>();
            q.put("code", project.getMainLineTasks());
            List tasks = this.dataPickService.find(BasicQuery.of(q, null), Task.class);
            if (null != tasks && tasks.size() > 0) {
                tasks.forEach(tv -> {
                    tv.setActivityId(tv.getCode());
                    tv.setActivityName((Object)tv.getName());
                    if (null != tv.getLang()) {
                        tv.setActivityName(tv.getLang().get("name"));
                    }
                    activities.add((Task)tv);
                });
            }
        }
        return activities;
    }

    public static Map<String, Object> taskToMap(Task task) {
        if (null == task) {
            return null;
        }
        Map viewMap = MergeUtil.mergeObjectToMap(new HashMap(), (Object)task, null);
        viewMap.put("activityId", task.getCode());
        viewMap.put("activityName", task.getName());
        viewMap.put("resCode", task.getResCode());
        viewMap.put("feeInfo", task.getFeeInfo());
        if (null != task.getLang() && null != task.getLang().get("name")) {
            viewMap.put("activityName", task.getLang().get("name"));
        }
        return viewMap;
    }

    @Override
    public Map<String, Object> postTask(ViewRequest request) throws DWException {
        PageView page;
        Activity activity;
        FlowGraph graph;
        if (null == request.getTaskCode()) {
            return null;
        }
        ServiceUtils.getContext().setEocInfo(request.getEocInfo());
        Task task = (Task)this.dataPickService.findBetter(request.getTaskCode(), Task.class);
        if (null == task) {
            return null;
        }
        Map<String, Object> viewMap = DataMapViewService.taskToMap(task);
        if (null != task.getFlowCode() && null != (graph = (FlowGraph)this.dataPickService.findByCode(task.getFlowCode(), FlowGraph.class)) && graph.getTenantId().equals(task.getTenantId()) && null != (activity = this.dataMapTaskService.milestoneActivity(graph))) {
            if (null != activity.getConfig()) {
                viewMap.put("approve", activity.getConfig().get("approve"));
                viewMap.put("dynamicApproves", activity.getConfig().get("dynamicApproves"));
                viewMap.put("approveLevel", activity.getConfig().get("approveLevel"));
            }
            if (null != activity.getExecutor()) {
                viewMap.put("personOnDuty", activity.getExecutor());
            }
            if (null != activity.getPresetVariables()) {
                viewMap.put("presetVariables", activity.getPresetVariables());
            }
            viewMap.put("executorMeta", activity.getExecutorMeta());
        }
        if (null != task.getPageCode() && null != (page = (PageView)this.dataPickService.findBetter(task.getPageCode(), PageView.class)) && page.getTenantId().equals(task.getTenantId())) {
            page.setId(null);
            page.setName(null);
            page.setCode(null);
            if (null != page.getLang() && null != task.getLang()) {
                page.getLang().putAll(task.getLang());
            }
            MergeUtil.mergeObjectToMap(viewMap, (Object)page, null);
            if (null != request.getPageCode() && null != page.getPages()) {
                viewMap.put("pages", page.getPages().get(request.getPageCode()));
            }
        }
        if (null != task.getDueDate() && null == task.getExpectedDuration() && task.getDueDate().getValue() instanceof Number) {
            Number seconds = (Number)task.getDueDate().getValue();
            ExpectedDuration expectedDuration = new ExpectedDuration();
            int value = seconds.intValue() / 86400;
            int mod = seconds.intValue() % 86400;
            if (value > 0 && mod == 0) {
                expectedDuration.setType("DAY");
            } else {
                value = seconds.intValue() / 3600;
                mod = seconds.intValue() % 3600;
                if (value > 0 && mod == 0) {
                    expectedDuration.setType("HOUR");
                } else {
                    value = seconds.intValue() / 60;
                    expectedDuration.setType("MINUTE");
                }
            }
            expectedDuration.setValue(value);
            task.setExpectedDuration(expectedDuration);
            viewMap.put("expectedDuration", expectedDuration);
        }
        HashMap<String, String> qq = new HashMap<String, String>();
        qq.put("startApproveActivity", task.getCode());
        Task activityApprove = (Task)this.dataPickService.findOne(BasicQuery.of(qq, request.getEocInfo()), Task.class);
        if (null != activityApprove && activityApprove.getTenantId().equals(task.getTenantId())) {
            viewMap.put("targetApproveActivity", activityApprove.getCode());
        }
        return viewMap;
    }

    private List<Rule> rules(String taskCode) {
        ArrayList<Rule> rulesMech = new ArrayList<Rule>();
        try {
            List<Rule> rulesAll = this.presetLibraryService.rules(taskCode);
            if (null == rulesAll) {
                return null;
            }
            for (Rule r : rulesAll) {
                if (null == r.getPluginId()) continue;
                rulesMech.add(r);
            }
        }
        catch (Exception e) {
            log.error("get rules error", (Throwable)e);
        }
        return rulesMech;
    }

    @Override
    public List<ActivityBaseInfoVO> postTasksByProject(ViewRequest request) throws DWException {
        Project project;
        if (null != request.getProjectCode() && null != (project = (Project)this.dataPickService.findBetter(request.getProjectCode(), Project.class)) && null != project.getMainLineTasks() && project.getMainLineTasks().size() > 0) {
            HashMap<String, List> q = new HashMap<String, List>();
            q.put("code", project.getMainLineTasks());
            List tasks = this.dataPickService.find(BasicQuery.of(q, request.getEocInfo()), Task.class);
            if (null != tasks && tasks.size() > 0) {
                ArrayList<ActivityBaseInfoVO> vos = new ArrayList<ActivityBaseInfoVO>();
                String locale = request.getLocale();
                if (null == locale) {
                    locale = ServiceUtils.getCurrentLocale();
                }
                String finalLocale = locale;
                tasks.forEach(t -> {
                    ActivityBaseInfoVO vo = new ActivityBaseInfoVO();
                    vo.setTaskId(project.getCode());
                    vo.setTaskName(DataMapViewService.dealLang("name", (BaseObject)project, project.getName(), finalLocale));
                    vo.setActivityId(t.getCode());
                    vo.setActivityName(DataMapViewService.dealLang("name", (BaseObject)t, t.getName(), finalLocale));
                    vo.setSequence(t.getSequence());
                    vos.add(vo);
                });
                return vos;
            }
        }
        return null;
    }

    @Override
    public Object postEmails(ViewRequest request) throws DWException {
        if (null == request.getEmailTemplateCode()) {
            return null;
        }
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("templateCode", request.getEmailTemplateCode());
        List views = this.dataPickService.find(BasicQuery.of(query, request.getEocInfo()), EmailView.class);
        views.forEach(v -> v.setLocaleViews(null));
        return views;
    }

    @Override
    @Deprecated
    public Object postEmail(ViewRequest request) throws DWException {
        EmailView view;
        if (null != request.getEmailCode() && null != (view = (EmailView)this.dataPickService.findBetter(request.getEmailCode(), EmailView.class))) {
            HashMap map = new HashMap();
            map.put("eventId", view.getLocaleViews().get(request.getLocale()));
            return map;
        }
        return null;
    }

    @Override
    public Object postUpdateProject(Project project) throws DWException {
        this.dataPickService.setRootOperationUnitId((TenantObject)project);
        Project tp = (Project)this.dataPickService.tenantObjectToSave((TenantObject)project, Project.class);
        if (null != project.getChargePerson()) {
            tp.setPersonInCharge(project.getChargePerson());
        }
        this.dataPickService.saveTenantObject((TenantObject)tp, Project.class);
        return null;
    }

    @Override
    public Object postUpdateTask(Task task) throws DWException {
        this.dataPickService.setRootOperationUnitId((TenantObject)task);
        ServiceUtils.getContext().setEocInfo(task.getEocInfo());
        try {
            Activity activityInDb;
            FlowGraph graph;
            Task taskAll;
            Task tp = (Task)this.dataPickService.tenantObjectToSave((TenantObject)task, Task.class);
            if (null != task.getExpectedDuration() && null != task.getExpectedDuration().getType()) {
                TimeDefinition dueDate = new TimeDefinition();
                dueDate.setDatatype("second");
                switch (task.getExpectedDuration().getType()) {
                    case "DAY": {
                        dueDate.setValue((Object)(task.getExpectedDuration().getValue() * 24 * 3600));
                        break;
                    }
                    case "HOUR": {
                        dueDate.setValue((Object)(task.getExpectedDuration().getValue() * 3600));
                        break;
                    }
                    case "MINUTE": {
                        dueDate.setValue((Object)(task.getExpectedDuration().getValue() * 60));
                        break;
                    }
                }
                tp.setDueDate(dueDate);
            }
            if (null == (taskAll = (Task)this.dataPickService.findBetter(tp.getCode(), Task.class))) {
                this.dataPickService.saveTenantObject((TenantObject)tp, Task.class);
                return null;
            }
            String flowCode = taskAll.getFlowCode();
            if (null != flowCode && null != (graph = (FlowGraph)this.dataPickService.findBetter(flowCode, FlowGraph.class)) && null != (activityInDb = this.dataMapTaskService.milestoneActivity(graph))) {
                Activity activity = new Activity();
                activity.setCode(activityInDb.getCode());
                activity.setMilestone(activityInDb.getMilestone());
                activity.setType(activityInDb.getType());
                activity.setPattern(activityInDb.getPattern());
                activity.setEocInfo(task.getEocInfo());
                activity.setConfig(new HashMap());
                boolean activityChanged = false;
                if (null != task.getApprove() && "approve".equalsIgnoreCase(taskAll.getType())) {
                    activity.getConfig().put("approve", task.getApprove());
                    activity.getConfig().put("dynamicApproves", task.getDynamicApproves());
                    activity.getConfig().put("approveLevel", task.getApproveLevel());
                    activityChanged = true;
                }
                if (null != task.getPersonOnDuty()) {
                    activity.setExecutor(task.getPersonOnDuty());
                    activityChanged = true;
                }
                if (activityChanged) {
                    this.dataPickService.save((TenantObject)activity, Activity.class);
                }
            }
            this.dataPickService.saveTenantObject((TenantObject)tp, Task.class);
        }
        catch (DWException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DWBusinessException(e.getMessage());
        }
        return null;
    }

    @Override
    public void postUpdateTaskScheduleFlag(Task task) throws DWException {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)task.getCode()).and("version").is((Object)task.getVersion()));
        Task targetTask = (Task)this.dataPickService.systemTemplate().findOne(query, Task.class);
        if (null == targetTask) {
            throw new DWBusinessException(String.format("task not found, code: %s", task.getCode()));
        }
        targetTask.setNeedLightDetection(task.getNeedLightDetection());
        targetTask.setNeedScheduledTaskDetail(task.getNeedScheduledTaskDetail());
        this.dataPickService.systemTemplate().save((Object)targetTask, this.dataPickService.systemTemplate().getCollectionName(Task.class));
    }

    @Override
    public Object postTaskSchedule(TaskSchedule taskSchedule) throws DWException {
        this.dataPickService.tenantTemplate().remove(new Query((CriteriaDefinition)Criteria.where((String)"taskCode").is((Object)taskSchedule.getTaskCode()).and("mechanismLogicCode").is((Object)taskSchedule.getMechanismLogicCode()).and("tenantId").is((Object)taskSchedule.getTenantId())), "taskSchedule");
        this.dataPickService.tenantTemplate().save((Object)taskSchedule, "taskSchedule");
        return null;
    }

    @Override
    public Object postDeleteTaskSchedule(TaskSchedule taskSchedule) throws DWException {
        this.dataPickService.tenantTemplate().remove(new Query((CriteriaDefinition)Criteria.where((String)"taskCode").is((Object)taskSchedule.getTaskCode()).and("mechanismLogicCode").is((Object)taskSchedule.getMechanismLogicCode()).and("tenantId").is((Object)taskSchedule.getTenantId())), "taskSchedule");
        return null;
    }

    @Override
    public Object postProjectTasks(ViewRequest request) throws DWException {
        ArrayList results = new ArrayList();
        String projectCode = request.getProjectCode();
        if (null == projectCode) {
            return null;
        }
        Project project = this.projectService.getProjectByCode(request.getProjectCode());
        String locale = ServiceUtils.getCurrentLocale();
        if (null != project && null != project.getMainLineTasks() && !project.getMainLineTasks().isEmpty()) {
            HashMap<String, List> q = new HashMap<String, List>();
            q.put("code", project.getMainLineTasks());
            List tasks = this.dataPickService.find(BasicQuery.of(q, request.getEocInfo()), Task.class);
            tasks.forEach(t -> {
                ActivityBaseInfoVO vo = new ActivityBaseInfoVO();
                vo.setActivityId(t.getCode());
                vo.setActivityName(t.getName());
                if (null != locale && null != t.getLang() && null != t.getLang().get("name") && null != ((Map)t.getLang().get("name")).get(locale)) {
                    vo.setActivityName((String)((Map)t.getLang().get("name")).get(locale));
                }
                vo.setConfig(t.getConfig());
                vo.setTaskId(projectCode);
                vo.setTaskName(project.getName());
                vo.setSequence(t.getSequence());
                vo.setActivityVersion(t.getVersion());
                vo.setAllowSubLevel(t.getAllowSubLevel());
                vo.setNeedEnableApprove(t.getNeedEnableApprove());
                vo.setStartApproveActivityName(t.getStartApproveActivityName());
                results.add(vo);
            });
        }
        return results;
    }

    @Override
    public Map<String, Object> postActivityStartTargetCode(ViewRequest request) throws DWException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != request.getTaskCode()) {
            HashMap<String, String> q = new HashMap<String, String>();
            q.put("startApproveActivity", request.getTaskCode());
            Task better = (Task)this.dataPickService.findBetter(BasicQuery.of(q, request.getEocInfo()), Task.class);
            if (null != better) {
                map.put("targetApproveActivity", better.getCode());
            }
        }
        return map;
    }

    @Override
    public Map<String, Object> postProjectInputData(ViewRequest request) throws DWException {
        Project project = (Project)this.dataPickService.findByCode(request.getProjectCode(), Project.class);
        if (null != project && null != project.getInputData()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("taskId", request.getProjectCode());
            result.put("inputData", project.getInputData());
            return result;
        }
        return null;
    }

    @Override
    public Object postTaskInputData(ViewRequest request) throws DWException {
        Task task = (Task)this.dataPickService.findByCode(request.getTaskCode(), Task.class);
        if (null != task && null != task.getInputData()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("activity", request.getTaskCode());
            result.put("inputData", task.getInputData());
            return result;
        }
        return null;
    }

    @Override
    public Object postTasksForWord(WordTaskReq request) throws DWException {
        ArrayList viewMaps = new ArrayList();
        return viewMaps;
    }

    @Override
    public Object postTasksForWord2(WordTaskReq request) throws DWException {
        HashMap<String, Object> viewMaps = new HashMap<String, Object>();
        if (null == request.getPageNum() || null == request.getPageSize() || request.getPageSize() > 1000) {
            viewMaps.put("msg", "pageNum pageSize is null or too big");
            return viewMaps;
        }
        ArrayList tasks = new ArrayList();
        viewMaps.put("data", tasks);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"executeType").is((Object)"manual"));
        query.with((Pageable)PageRequest.of((int)request.getPageNum(), (int)request.getPageSize()));
        List taskList = this.mongoTemplate.find(query, Task.class);
        long total = this.mongoTemplate.count(query, Task.class);
        viewMaps.put("total", total);
        viewMaps.put("pageNum", request.getPageNum());
        viewMaps.put("pageSize", taskList.size());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)taskList)) {
            return viewMaps;
        }
        if (taskList.size() > 0) {
            List pageCodes = taskList.stream().filter(task -> task.getPageCode() != null).map(task -> task.getPageCode()).collect(Collectors.toList());
            Query query2 = new Query();
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"code").in(pageCodes));
            List pages = this.mongoTemplate.find(query2, PageView.class);
            HashMap<String, PageView> pageViewMap = new HashMap<String, PageView>();
            for (PageView page : pages) {
                pageViewMap.put(page.getCode(), page);
                page.setId(null);
                page.setTenantId(null);
                page.setCode(null);
                page.setName(null);
            }
            HashSet<String> actionIds = new HashSet<String>();
            HashMap taskActions = new HashMap();
            for (Task task2 : taskList) {
                PageView pageView;
                HashMap<String, Object> viewMap = new HashMap<String, Object>();
                viewMap.put("activityId", task2.getCode());
                viewMap.put("activityName", task2.getName());
                viewMap.put("pageCode", task2.getPageCode());
                viewMap.put("pattern", task2.getPattern());
                viewMap.put("category", task2.getCategory());
                viewMap.put("application", task2.getApplication());
                viewMap.put("dimension", task2.getDimension());
                HashSet taskActionIds = new HashSet();
                viewMap.put("actionIds", taskActionIds);
                if (null != task2.getPageCode() && null != (pageView = (PageView)pageViewMap.get(task2.getPageCode())) && null != pageView.getDataSources()) {
                    pageView.getDataSources().forEach((k, v) -> {
                        try {
                            Map source = (Map)v;
                            String actionId = (String)source.get("actionId");
                            if (null != actionId) {
                                taskActionIds.add(actionId);
                                actionIds.add(actionId);
                            }
                        }
                        catch (Exception e) {
                            log.error(e.getMessage());
                        }
                    });
                }
                tasks.add(viewMap);
                taskActions.put(task2.getCode(), taskActionIds);
            }
            Map<String, ApiDataFieldMetadataDTO> actionMetas = this.genericService.actionResponseDtos(actionIds);
            viewMaps.put("actionMetas", actionMetas);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("taskActionIds", taskActions);
            Map actionTags = (Map)this.dataMapTagSystemService.postTagsByAction(param);
            if (null == actionTags) {
                throw new DWBusinessException("query tag error");
            }
            for (Map map : tasks) {
                String code = (String)map.get("activityId");
                Object tags = actionTags.get(code);
                map.put("tags", tags);
            }
        }
        return viewMaps;
    }

    @Override
    public Object postMechanism(ViewRequest request) throws DWException {
        Task taskMaster3;
        Project project;
        String tenantId = ServiceUtils.getTenantId();
        HashMap viewMap = new HashMap();
        String taskCode = request.getTaskCode();
        if (null == taskCode && null != request.getProjectCode() && null != (project = (Project)this.dataPickService.findBetter(request.getProjectCode(), Project.class)) && Boolean.TRUE.equals(project.getManualAble()) && null != (taskMaster3 = this.projectService.manualProjectPageTask(project.getCode()))) {
            taskCode = taskMaster3.getCode();
        }
        HashMap<String, Object> mechnismConfig = new HashMap<String, Object>();
        viewMap.put("mechnismConfig", mechnismConfig);
        if (null != taskCode) {
            List adaptations;
            Task task = (Task)this.dataPickService.findBetter(taskCode, Task.class);
            mechnismConfig.put("rules", this.rules(taskCode));
            if (null != task && null != task.getPageCode()) {
                Query query1 = Query.query((CriteriaDefinition)Criteria.where((String)"businessKey").is((Object)"suggestAction").and("tenantId").is((Object)tenantId).and("code").is((Object)task.getPageCode()));
                adaptations = this.mongoTemplate.find(query1, TenantObjectAdaptation.class, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
                ArrayList suggestActions = new ArrayList();
                adaptations.forEach(tenantObjectAdaptation -> suggestActions.add(tenantObjectAdaptation.getValue()));
                mechnismConfig.put("suggestAction", suggestActions);
            }
            Query query2 = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"TM_VARIABLE").and("tenantId").is((Object)tenantId).and("code").is((Object)taskCode));
            adaptations = this.dataPickService.tenantTemplate().find(query2, TenantObjectAdaptation.class, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
            ArrayList<String> codeList = new ArrayList<String>();
            for (TenantObjectAdaptation adaptation : adaptations) {
                if (!ComponentTypeEnum.MechanismLimit.name().equals(adaptation.getBusinessKey())) continue;
                ActionParam actionParam = (ActionParam)JSON.parseObject((String)JSON.toJSONString((Object)adaptation.getValue()), ActionParam.class);
                codeList.add(actionParam.getValue().toString());
            }
            Object variableListSimple = this.dataMapKgService.getVariableListSimple(codeList.stream().distinct().collect(Collectors.toList()), Boolean.FALSE);
            mechnismConfig.put("variablesParameter", variableListSimple);
        }
        return viewMap;
    }

    @Override
    public Object postOpenWindows(ViewRequest request) throws DWException {
        HashMap<String, Object> view = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        Task task = (Task)this.dataPickService.findBetter(request.getTaskCode(), Task.class);
        if (null == task || task.getPageCode() == null) {
            return list;
        }
        PageView pageView = (PageView)this.dataPickService.findBetter(task.getPageCode(), PageView.class);
        if (null == pageView) {
            return list;
        }
        view.put("code", pageView.getCode());
        Object obj = null;
        try {
            JSONObject map = JSON.parseObject((String)JSON.toJSONString((Object)pageView));
            obj = JsonPath.read((Object)map, (String)"$.pages.task-detail.dataStates[*].operations[*]", (Predicate[])new Predicate[0]);
            view.put("operations", obj);
        }
        catch (Exception e) {
            log.error("get operations error", (Throwable)e);
        }
        return view;
    }

    @Override
    public Object postOpenWindowDecisions(ViewRequest request) throws DWException {
        List decisions = this.dataPickService.find(BasicQuery.of(request.getQuery(), request.getEocInfo()), OpenWindowDecision.class);
        return decisions;
    }

    @Override
    public Object postCardConfig(ViewRequest request) throws DWException {
        BasicQuery basicQuery;
        ArrayList<Task> result = new ArrayList<Task>();
        String pageCode = request.getPageCode();
        HashMap pageCode2Task = new HashMap();
        HashMap<String, Object> viewMap = new HashMap<String, Object>();
        if ("project-card".equals(pageCode)) {
            request.getQuery().put("executeType", "user");
            basicQuery = BasicQuery.of(request.getQuery(), request.getEocInfo());
            basicQuery.setReturnFields(ListUtil.of((Object[])new String[]{"tenantId", "version", "code", "name", "lang", "pageCode"}));
            List projectList = this.dataPickService.find(basicQuery, Project.class);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)projectList)) {
                projectList.forEach(e -> {
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{e.getPageCode()})) {
                        Task task = new Task();
                        task.setPageCode(e.getPageCode());
                        task.setName(e.getName());
                        task.setLang(e.getLang());
                        task.setCode(e.getCode());
                        pageCode2Task.put(e.getCode(), task);
                    }
                });
            }
            viewMap.put("pages.project-card.dataStates.type", "all");
        } else {
            pageCode = "task-card";
            request.getQuery().put("executeType", "manual");
            basicQuery = BasicQuery.of(request.getQuery(), request.getEocInfo());
            basicQuery.setReturnFields(ListUtil.of((Object[])new String[]{"tenantId", "version", "code", "name", "lang", "pageCode"}));
            List tasks = this.dataPickService.find(basicQuery, Task.class);
            tasks.forEach(task -> {
                if (null != task.getPageCode()) {
                    pageCode2Task.put(task.getPageCode(), task);
                }
            });
            if (!"all".equals(request.getType())) {
                viewMap.put("pages.task-card.dataStates.type", "all");
            }
        }
        viewMap.put("code", pageCode2Task.keySet());
        BasicQuery basicQuery2 = BasicQuery.of(viewMap, request.getEocInfo());
        basicQuery2.setReturnFields(ListUtil.of((Object[])new String[]{"tenantId", "version", "code", "pages"}));
        List pageViews = this.dataPickService.find(basicQuery2, PageView.class);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageViews)) {
            for (PageView pageView : pageViews) {
                Map taskcard;
                List dataStates;
                Task task2 = (Task)pageCode2Task.get(pageView.getCode());
                if (null != pageView.getPages() && null != pageView.getPages().get(pageCode) && null != (dataStates = (List)(taskcard = (Map)pageView.getPages().get(pageCode)).get("dataStates"))) {
                    for (Map map : dataStates) {
                        if (!"all".equals(map.get("type"))) continue;
                        Object taskCardFields = map.get("taskCardFields");
                        task2.setFieldConfig(taskCardFields);
                        break;
                    }
                }
                result.add(task2);
            }
        }
        return result;
    }

    @Override
    public List<WSConditionDTO> postNewCardConfig(ViewRequest request) throws DWException {
        Map<String, Object> query1 = request.getQuery();
        query1.put("executeType", "manual");
        BasicQuery basicQuery = BasicQuery.of(query1, request.getEocInfo());
        basicQuery.setReturnFields(ListUtil.of((Object[])new String[]{"tenantId", "version", "code", "name", "lang", "pageCode"}));
        List tasks = this.dataPickService.find(basicQuery, Task.class);
        HashMap<String, Task> pageCode2Task = new HashMap<String, Task>();
        tasks.forEach(task -> {
            if (null != task.getPageCode()) {
                pageCode2Task.put(task.getPageCode(), (Task)task);
            }
        });
        HashMap<String, Set<Object>> query = new HashMap<String, Set<Object>>();
        query.put("code", pageCode2Task.keySet());
        query.put("pages.task-card.dataStates", (Set<Object>)Criteria.where((String)"taskCardFields.taskCardField.groups").exists(true));
        BasicQuery basicQuery2 = BasicQuery.of(query, request.getEocInfo());
        basicQuery2.setReturnFields(Arrays.asList("tenantId", "version", "pages.task-card.dataStates.taskCardFields.taskCardField", "code", "createDate"));
        List pageViews = this.dataPickService.find(basicQuery2, FatPageView.class);
        return this.pageViewtToConditionDTO(pageViews, pageCode2Task, null, "task-card", WSConfigType.groups, WSPageCode.task);
    }

    @Override
    public List<WSConditionDTO> postWorkbenchSetting(WorkbenchSettingRequest request) throws DWException {
        List<String> code = request.getCode();
        WSPageCode pageCode = request.getPageCode();
        WSConfigType configType = request.getConfigType();
        String pageCodeString = "";
        switch (pageCode) {
            case task: {
                pageCodeString = "task-card";
                break;
            }
            case project: {
                pageCodeString = "project-card";
                break;
            }
        }
        HashMap<String, List<String>> query = new HashMap<String, List<String>>();
        query.put("code", code);
        query.put("pages." + pageCodeString + ".dataStates", (List<String>)Criteria.where((String)("taskCardFields.taskCardField." + configType.name())).exists(true));
        BasicQuery basicQuery = BasicQuery.of(query, null);
        basicQuery.setReturnFields(Arrays.asList("tenantId", "version", "pages." + pageCodeString + ".dataStates.taskCardFields.taskCardField", "code", "createDate"));
        List pageViews = this.dataPickService.find(basicQuery, FatPageView.class);
        List<WSConditionDTO> result = new ArrayList<WSConditionDTO>();
        if (CollectionUtil.isNotEmpty((Collection)pageViews)) {
            HashMap<String, Task> pageCode2Task = new HashMap<String, Task>();
            HashMap<String, Project> pageCode2Project = new HashMap<String, Project>();
            if (pageCode == WSPageCode.task) {
                HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                map.put("code", code);
                map.put("pageCode", pageViews.stream().map(v -> v.getCode()).collect(Collectors.toList()));
                BasicQuery basicQuery2 = BasicQuery.of(map, null);
                basicQuery2.setReturnFields(ListUtil.of((Object[])new String[]{"tenantId", "version", "code", "name", "pageCode", "lang"}));
                List tasks = this.dataPickService.find(basicQuery2, Task.class);
                tasks.forEach(task -> {
                    if (null != task.getPageCode()) {
                        pageCode2Task.put(task.getPageCode(), (Task)task);
                    }
                });
            } else if (pageCode == WSPageCode.project) {
                HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                map.put("code", code);
                BasicQuery basicQuery3 = BasicQuery.of(map, null);
                basicQuery3.setReturnFields(Arrays.asList("tenantId", "version", "pageCode", "name", "code", "lang"));
                List projects = this.dataPickService.find(basicQuery3, Project.class);
                for (Project project : projects) {
                    pageCode2Project.put(project.getPageCode(), project);
                }
            }
            result = this.pageViewtToConditionDTO(pageViews, pageCode2Task, pageCode2Project, pageCodeString, configType, pageCode);
        }
        return result;
    }

    private List<WSConditionDTO> pageViewtToConditionDTO(List<FatPageView> pageViews, Map<String, Task> pageCode2Task, Map<String, Project> pageCode2Project, String pageCodeString, WSConfigType configType, WSPageCode pageCode) {
        ArrayList<WSConditionDTO> wsConditionList = new ArrayList<WSConditionDTO>();
        for (FatPageView pageView : pageViews) {
            ArrayList dataStates;
            HashMap map = (HashMap)pageView.getPages().get(pageCodeString);
            if (map == null || map.size() <= 0 || !CollectionUtil.isNotEmpty((Collection)(dataStates = (ArrayList)map.get("dataStates")))) continue;
            for (HashMap dataState : dataStates) {
                HashMap taskCardFields = (HashMap)dataState.get("taskCardFields");
                if (taskCardFields == null) continue;
                BusinessMessageSourceMethod businessMessageSourceMethod = null;
                Object businessMessageSourceMethodString = taskCardFields.get("businessMessageSourceMethod");
                if (businessMessageSourceMethodString != null) {
                    businessMessageSourceMethod = BusinessMessageSourceMethod.valueOf((String)businessMessageSourceMethodString);
                }
                HashMap taskCardField = (HashMap)taskCardFields.get("taskCardField");
                ArrayList arrayList = (ArrayList)taskCardField.get(configType.name());
                for (HashMap condition : arrayList) {
                    Project project;
                    Task task;
                    WSConditionDTO wsConditionDTO = new WSConditionDTO();
                    wsConditionDTO.setBusinessMessageSourceMethod(businessMessageSourceMethod);
                    wsConditionDTO.setCreateDate(pageView.getCreateDate());
                    wsConditionDTO.setAliasName((String)condition.get("name"));
                    wsConditionDTO.setAliasCode((String)condition.get("code"));
                    wsConditionDTO.setDefaultEffective(Boolean.valueOf(condition.get("defaultEffective") != null ? condition.get("defaultEffective").toString() : null));
                    wsConditionDTO.setEnable(Boolean.valueOf(condition.get("defaultEffective") != null ? condition.get("defaultEffective").toString() : null));
                    wsConditionDTO.setSourceType(SourceType.customer);
                    wsConditionDTO.setDataType(condition.get("dataType") != null ? condition.get("dataType").toString() : null);
                    Map lang = (Map)condition.get("lang");
                    wsConditionDTO.setLang((Map<String, Map<String, String>>)ImmutableMap.of((Object)"aliasName", lang.get("name")));
                    ConditionScopeDTO conditionScopeDTO = new ConditionScopeDTO();
                    if (pageCode == WSPageCode.task && (task = pageCode2Task.get(pageView.getCode())) != null) {
                        wsConditionDTO.setTaskCode(task.getCode());
                        wsConditionDTO.setTaskName(task.getName());
                        conditionScopeDTO.setId(task.getId());
                        conditionScopeDTO.setName(task.getName());
                        conditionScopeDTO.setCode(task.getCode());
                        conditionScopeDTO.setLang(task.getLang());
                        conditionScopeDTO.setCardGroupTask((ConditionScopeDTO.CardGroupTask)JSON.parseObject((String)JSON.toJSONString((Object)task), ConditionScopeDTO.CardGroupTask.class));
                    }
                    if (pageCode == WSPageCode.project && (project = pageCode2Project.get(pageView.getCode())) != null) {
                        conditionScopeDTO.setId(project.getId());
                        conditionScopeDTO.setName(project.getName());
                        conditionScopeDTO.setCode(project.getCode());
                        conditionScopeDTO.setLang((Map)ImmutableMap.of((Object)"name", project.getLang().get("name")));
                    }
                    conditionScopeDTO.setFieldCode(taskCardField.get("value") != null ? taskCardField.get("value").toString() : null);
                    wsConditionDTO.setConditionScope(Collections.singletonList(conditionScopeDTO));
                    wsConditionList.add(wsConditionDTO);
                }
            }
        }
        return wsConditionList;
    }

    @Override
    public Object postWorkbenchSettingByConfigTypes(WorkbenchSettingByConfigTypeRequest request) throws DWException {
        WSPageCode pageCode = request.getPageCode();
        String pageCodeString = "";
        switch (pageCode) {
            case task: {
                pageCodeString = "task-card";
                break;
            }
            case project: {
                pageCodeString = "project-card";
                break;
            }
        }
        String tenantId = ServiceUtils.getTenantIdSilent();
        List<String> code = request.getCode();
        HashMap<String, List<String>> query = new HashMap<String, List<String>>();
        query.put("code", code);
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("pages." + pageCodeString);
        fields.add("code");
        fields.add("version");
        fields.add("tenantId");
        BasicQuery basicQuery = BasicQuery.of(query, null);
        basicQuery.setReturnFields(fields);
        List pageViews = this.dataPickService.find(basicQuery, PageView.class);
        return pageViews;
    }

    @Override
    public List<TaskCardFieldVO> taskCardField(TaskCardFieldRequest request) throws DWException {
        List<String> code = request.getCode();
        String pageCode = request.getPageCode();
        String queryField = request.getQueryField();
        String tenantVersion = this.dataPickService.tenantVersion();
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("version", tenantVersion);
        query.put("code", code);
        String queryFieldString = "taskCardFields.taskCardField";
        if (StringUtils.isNotBlank((CharSequence)queryField)) {
            queryFieldString = queryFieldString + "." + queryField;
        }
        query.put("pages." + pageCode + ".dataStates", Criteria.where((String)queryFieldString).exists(true));
        BasicQuery basicQuery = BasicQuery.of(query, null);
        basicQuery.setReturnFields(Arrays.asList("tenantId", "version", "pages." + pageCode + ".dataStates." + queryFieldString, "code"));
        List pageViews = this.dataPickService.find(basicQuery, FatPageView.class);
        ArrayList<TaskCardFieldVO> taskCardFieldVOList = new ArrayList<TaskCardFieldVO>();
        for (FatPageView pageView : pageViews) {
            HashMap map = (HashMap)pageView.getPages().get(pageCode);
            ArrayList dataStates = (ArrayList)map.get("dataStates");
            for (HashMap dataState : dataStates) {
                HashMap taskCardFields = (HashMap)dataState.get("taskCardFields");
                if (taskCardFields == null) continue;
                HashMap taskCardField = (HashMap)taskCardFields.get("taskCardField");
                TaskCardFieldVO taskCardFieldVO = (TaskCardFieldVO)JSON.parseObject((String)JSON.toJSONString((Object)taskCardField), TaskCardFieldVO.class);
                taskCardFieldVO.setCode(pageView.getCode());
                taskCardFieldVOList.add(taskCardFieldVO);
            }
        }
        return taskCardFieldVOList;
    }

    public static String dealLang(String name, BaseObject obj, String defaultValue, String locale) {
        if (null != locale && null != obj && null != obj.getLang() && null != obj.getLang().get(name) && null != ((Map)obj.getLang().get(name)).get(locale)) {
            return (String)((Map)obj.getLang().get(name)).get(locale);
        }
        return defaultValue;
    }

    @Override
    public Object getPageUIElement(ViewRequest request) throws DWException {
        HashMap<String, String> query = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)request.getCode())) {
            query.put("code", request.getCode());
        }
        if (!StringUtils.isEmpty((CharSequence)request.getTaskCode())) {
            query.put("activityId", request.getTaskCode());
        }
        if (!StringUtils.isEmpty((CharSequence)request.getPageCode())) {
            query.put("pageCode", request.getPageCode());
        }
        List betters = this.dataPickService.find(BasicQuery.of(query, request.getEocInfo()), PageUIElement.class, "pageUIElement", true);
        try {
            String tenantId = ServiceUtils.getTenantId();
            ArrayList<Map<String, Object>> actionMap = new ArrayList<Map<String, Object>>();
            this.recordService.batchListSetActionMap(betters, tenantId, actionMap);
            this.recordService.batchSetDataActionProductInfo(actionMap, tenantId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return betters;
    }

    @Override
    public List<Task> postTaskNamesByCodes(ViewRequest request) throws DWException {
        Map<String, Object> query = request.getQuery();
        if (MapUtils.isEmpty(query)) {
            return null;
        }
        query.put("executeType", "manual");
        List<Task> taskAndProjectData = this.getTaskAndProjectData(Task.class, query);
        if (taskAndProjectData != null && org.apache.commons.collections.CollectionUtils.isNotEmpty(taskAndProjectData)) {
            return taskAndProjectData.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getProjectCode())).collect(Collectors.toList());
        }
        return null;
    }

    private <T extends TenantObject> List<T> getTaskAndProjectData(Class<T> tClass, Map<String, Object> query) throws DWBusinessException {
        Object o = query.get("code");
        if (o instanceof List) {
            List codes = (List)o;
            ArrayList taskList = Lists.newArrayListWithExpectedSize((int)codes.size());
            List lists = CommonUtils.spliceArrays(codes, 600);
            boolean isTask = Task.class.isAssignableFrom(tClass);
            List fields = isTask ? ListUtil.of((Object[])new String[]{"code", "name", "lang", "tenantId", "eocInfo", "version", "projectCode"}) : ListUtil.of((Object[])new String[]{"code", "name", "lang", "tenantId", "eocInfo", "version", "manualAble"});
            for (List splitCodes : lists) {
                HashMap<String, Object> queryParam = new HashMap<String, Object>(query);
                queryParam.put("code", splitCodes);
                BasicQuery basicQuery = BasicQuery.of(query, null);
                basicQuery.setReturnFields(fields);
                List splitData = this.dataPickService.find(basicQuery, tClass);
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)splitData)) continue;
                taskList.addAll(splitData);
            }
            return taskList;
        }
        return null;
    }

    @Override
    public List<Project> postProjectNamesByCodes(ViewRequest request) throws DWException {
        Map<String, Object> query = request.getQuery();
        if (MapUtils.isEmpty(query)) {
            return null;
        }
        query.put("executeType", "user");
        List<Project> taskAndProjectData = this.getTaskAndProjectData(Project.class, query);
        if (taskAndProjectData != null && org.apache.commons.collections.CollectionUtils.isNotEmpty(taskAndProjectData)) {
            return taskAndProjectData.stream().filter(e -> BooleanUtils.isNotTrue((Boolean)e.getManualAble())).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<Object> getSystemHooks(ViewRequest request) throws DWException {
        List betters;
        HashMap<String, List<String>> query = new HashMap<String, List<String>>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(request.getTaskCodes())) {
            query.put("activityId", request.getTaskCodes());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(request.getPageCodes())) {
            query.put("pageCode", request.getPageCodes());
        }
        if ((betters = this.dataPickService.findBetters(BasicQuery.of(query, request.getEocInfo()), PageUIElement.class)) == null || betters.isEmpty()) {
            return new ArrayList<Object>();
        }
        List<Object> systemHooks = betters.stream().filter(s -> s.getElements().containsKey("systemHooks")).flatMap(s -> ((List)s.getElements().get("systemHooks")).stream()).collect(Collectors.toList());
        return systemHooks;
    }

    @Override
    public BkResponse postBk(BkRequest request) throws DWException {
        String tenantId = ServiceUtils.getTenantId();
        String version = this.dataPickService.tenantVersion(tenantId);
        BkResponse resp = new BkResponse();
        List<BkInfo> infos = this.knowledgeGraphService.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"objectType", (Object)request.getObjectType()), Filters.eq((String)"objectValue", (Object)request.getObjectValue()), Filters.eq((String)"version", (Object)version)}), BkInfo.class, "bkInfo", KnowledgeGraphDb.SYSTEM);
        resp.setType(request.getObjectType());
        resp.setQueryCode(request.getObjectValue());
        resp.setBkInfo(infos);
        if (infos.isEmpty()) {
            Map<String, Object> m = null;
            if ("task".equalsIgnoreCase(request.getObjectType())) {
                m = this.dataMapTaskService.getInputData(request.getObjectValue());
            } else if ("activity".equalsIgnoreCase(request.getObjectType())) {
                m = this.dataMapActivityService.getInputData(request.getObjectValue());
            }
            if (null != m && null != m.get("inputData")) {
                Object obj = m.get("inputData");
                ArrayList infos2 = new ArrayList();
                HashMap<String, Object> info2 = new HashMap<String, Object>();
                ArrayList<Object> bk = new ArrayList<Object>();
                info2.put("bk", bk);
                if (obj instanceof DataEntityMetadataDTO) {
                    DataEntityMetadataDTO defaultbk = (DataEntityMetadataDTO)obj;
                    info2.put("entityName", defaultbk.getEntity_name());
                    info2.put("entity_name", defaultbk.getEntity_name());
                    bk.add(defaultbk);
                } else if (obj instanceof Map) {
                    Map defaultbk = (Map)obj;
                    info2.put("entityName", defaultbk.get("entity_name"));
                    info2.put("entity_name", defaultbk.get("entity_name"));
                    bk.add(defaultbk);
                } else {
                    try {
                        DataEntityMetadataDTO defaultbk = (DataEntityMetadataDTO)JSON.parseObject((String)JSON.toJSONString((Object)obj), DataEntityMetadataDTO.class);
                        info2.put("entityName", defaultbk.getEntity_name());
                        info2.put("entity_name", defaultbk.getEntity_name());
                        bk.add(defaultbk);
                    }
                    catch (Exception e) {
                        DataEntityMetadataDTO2 defaultbk2 = (DataEntityMetadataDTO2)JSON.parseObject((String)JSON.toJSONString((Object)obj), DataEntityMetadataDTO2.class);
                        info2.put("entityName", defaultbk2.getEntity_name());
                        info2.put("entity_name", defaultbk2.getEntity_name());
                        bk.add(defaultbk2);
                    }
                }
                infos2.add(info2);
                resp.setBkInfo(infos2);
            }
        } else {
            infos.forEach(this::transBk);
        }
        return resp;
    }

    private void transBk(BkInfo in) {
        in.setEntity_name(in.getEntityName());
        if (null != in.getBk()) {
            this.transbkField(in.getBk());
        }
    }

    private void transbkField(List<BkField> fields) {
        fields.forEach(fd -> {
            fd.setEntity_name(fd.getEntityName());
            fd.setData_type(fd.getDataType());
            fd.setData_name(fd.getDataName());
            fd.setBk_name(fd.getBkName());
            fd.setIs_array(fd.getIsArray());
            fd.setIs_businesskey(fd.getIsBusinesskey());
            if (null != fd.getField()) {
                this.transbkField(fd.getField());
            }
        });
    }

    @Override
    public BkResponse postBkMeta(BkRequest request) throws DWException {
        Bson query;
        String tenantId = ServiceUtils.getTenantId();
        String version = this.dataPickService.tenantVersion(tenantId);
        BkResponse resp = new BkResponse();
        if ("activityCheckCycle".equalsIgnoreCase(request.getObjectType())) {
            query = Filters.eq((String)"objectType", (Object)"activityCheckCycle");
        } else {
            String bkConcat = DataMapViewService.bkConcat(request.getBk());
            query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"objectType", (Object)"activityCheck"), Filters.eq((String)"bkConcat", (Object)bkConcat), Filters.eq((String)"entityName", (Object)request.getEntityName())});
            resp.setBkConcat(bkConcat);
        }
        if (request.getTaskCode() != null) {
            query = Filters.and((Bson[])new Bson[]{query, Filters.eq((String)"objectValue", (Object)request.getTaskCode())});
        }
        if (request.getActivityCode() != null) {
            query = Filters.and((Bson[])new Bson[]{query, Filters.eq((String)"objectValue", (Object)request.getActivityCode())});
        }
        query = Filters.and((Bson[])new Bson[]{query, Filters.eq((String)"version", (Object)version)});
        List<BkInfo> infos = this.knowledgeGraphService.find(query, BkInfo.class, "bkInfo", KnowledgeGraphDb.SYSTEM);
        resp.setQueryCode(request.getTaskCode());
        resp.setEntityName(request.getEntityName());
        if (!infos.isEmpty()) {
            MonitorRuleDTO dto = null;
            try {
                dto = this.dataMapKgService.queryMonitorRule(infos.get(0).getRuleId(), tenantId);
            }
            catch (DWBusinessException e) {
                log.error("queryMonitorRule error", (Throwable)e);
            }
            if (dto == null) {
                return resp;
            }
            resp.setRule(dto);
            resp.setProductName(dto.getProduct_name());
            if (infos.size() > 1) {
                ArrayList<String> ruleIds = new ArrayList<String>();
                for (int i = 1; i < infos.size(); ++i) {
                    BkInfo info = infos.get(i);
                    if (null == info.getRuleId() || ruleIds.contains(info.getRuleId())) continue;
                    ruleIds.add(info.getRuleId());
                }
                HashSet<ActionParamDTO> params = new HashSet<ActionParamDTO>();
                HashSet<ReturnColumnDTO> returnCols = new HashSet<ReturnColumnDTO>();
                for (String ruleId : ruleIds) {
                    MonitorRuleDTO rule = null;
                    try {
                        rule = this.dataMapKgService.queryMonitorRule(ruleId, tenantId);
                    }
                    catch (DWBusinessException e) {
                        log.error("queryMonitorRule error", (Throwable)e);
                    }
                    if (null == rule) continue;
                    if (null != rule.getAction_params()) {
                        params.addAll(rule.getAction_params());
                    }
                    if (null == rule.getReturn_columns()) continue;
                    returnCols.addAll(rule.getReturn_columns());
                }
                dto.setAction_params(new ArrayList<ActionParamDTO>());
                dto.setReturn_columns(new ArrayList<ReturnColumnDTO>());
                dto.getAction_params().addAll(params);
                dto.getReturn_columns().addAll(returnCols);
            }
        }
        return resp;
    }

    @Override
    public Object postTasksWithCustomize(TasksWithCustomizeRequest request) throws DWException {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("application", request.getApplication());
        query.put("executeType", request.getExecuteTypeList());
        List tasks = this.dataPickService.find(BasicQuery.of(query, null), Task.class);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)tasks)) {
            return null;
        }
        try {
            List mapList = (List)JSON.parseObject((String)JSON.toJSONString((Object)tasks), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            for (Map map : mapList) {
                Optional<Boolean> isCustomizeOpt = this.getIsCustomize(map);
                Boolean isCustomize = isCustomizeOpt.orElse(null);
                map.put("isCustomize", isCustomize);
            }
            return mapList;
        }
        catch (Exception e) {
            log.error("postTasksWithCustomize failed, request:" + JSON.toJSONString((Object)request) + ", error:{}", (Throwable)e);
            return null;
        }
    }

    @Override
    public Object postActivityInputDataEntityName(BkRequest request) throws DWException {
        List infos = this.knowledgeGraphService.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)this.dataPickService.tenantVersion()), Filters.eq((String)"objectType", (Object)request.getObjectType()), Filters.in((String)"objectValue", request.getObjectValues())}), BkInfo.class, "bkInfo", KnowledgeGraphDb.SYSTEM);
        infos = MergeUtil.excludeWithSameCode(infos, BkInfo::getObjectValue, HierarchicalEntity::getSourceLevel);
        Map<String, String> activityEntityNameMap = infos.stream().collect(Collectors.toMap(BkInfo::getObjectValue, BkInfo::getEntityName));
        ArrayList<String> notFound = new ArrayList<String>();
        for (String activityCode : request.getObjectValues()) {
            if (activityEntityNameMap.containsKey(activityCode)) continue;
            notFound.add(activityCode);
        }
        HashMap<String, ArrayList<String>> param = new HashMap<String, ArrayList<String>>();
        param.put("code", notFound);
        List tasks = this.dataPickService.find(BasicQuery.of(param, null), Task.class);
        for (Task task : tasks) {
            Object eval = JSONPath.eval((Object)task.getInputData(), (String)"$.entity_name");
            activityEntityNameMap.put(task.getCode(), eval != null ? eval.toString() : "");
        }
        return activityEntityNameMap;
    }

    private Optional<Boolean> getIsCustomize(Map<String, Object> map) throws Exception {
        Object object = map.get("code");
        if (object == null) {
            return Optional.empty();
        }
        String code = object.toString();
        Map<String, Object> activityDefinition = this.dataMapTaskService.getActivityDefinition(code, "task-detail");
        if (activityDefinition == null) {
            log.error("getIsCustomize getActivityDefinition not found Definition code: {}", (Object)code);
            return Optional.empty();
        }
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(activityDefinition));
        JSONObject pages = jsonObject.getJSONObject("pages");
        Boolean isCustomize = Optional.ofNullable(pages).map(p -> p.getBoolean("isCustomize")).orElse("CUSTOM".equals(jsonObject.getString("pattern")) ? Boolean.TRUE : null);
        return Optional.ofNullable(isCustomize);
    }

    private static String bkConcat(List<String> bks) {
        Collections.sort(bks);
        StringBuilder sb = new StringBuilder();
        bks.forEach(bk -> sb.append((String)bk).append("$&"));
        return sb.toString();
    }
}

