/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.log.operation.annotation.DWIgnoreFileLog;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.filter.DataMapFilter;
import com.digiwin.athena.datamap.filter.LoginInfo;
import com.digiwin.athena.datamap.kg.DataMapLicenseKeyManager;
import com.digiwin.athena.datamap.kg.DataMapMongoEntityBaseDAO;
import com.digiwin.athena.datamap.povo.CheckAppExpirePo;
import com.digiwin.athena.datamap.service.IAppService;
import com.digiwin.athena.datamap.service.impl.DataMapTenantService;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.datamap.utils.AthenaUtils;
import com.digiwin.athena.datamap.utils.DataMapTranslateUtils;
import com.digiwin.athena.datamap.utils.DatamapESPUtils;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.common.HierarchicalEntity;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.FunctionCtrl;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.domain.ApplicationCustomizedConfig;
import com.digiwin.athena.kg.domain.ApplicationRecommendation;
import com.digiwin.athena.kg.domain.FieldOpenWindowSetting;
import com.digiwin.athena.kg.domain.InitMonitorRuleGroup;
import com.digiwin.athena.kg.domain.OpenWindowDefinition;
import com.digiwin.athena.kg.domain.SelectVariableOptionSetting;
import com.digiwin.athena.kg.domain.VariableDefinition;
import com.digiwin.athena.kg.dto.AppRelationBatchPo;
import com.digiwin.athena.kg.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.google.common.collect.Lists;
import com.mongodb.bulk.BulkWriteResult;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;

@Lang
@Service
@MyExceptionHandler
public class DatamapAppService
implements IAppService {
    private static final Logger log = LoggerFactory.getLogger(DatamapAppService.class);
    @Autowired
    private DataMapLicenseKeyManager dataMapLicenseKeyManager;
    @Autowired
    @Qualifier(value="kgSystem")
    private MongoTemplate mongoTemplate;
    @Autowired
    private DataMapIamService dataMapIamService;
    @Autowired
    DataMapTenantService dataMapTenantService;
    @Autowired
    DataMapMongoEntityBaseDAO dataMapMongoEntityBaseDAO;
    @Autowired
    KmService kmService;
    @Autowired
    @Qualifier(value="kgDataPickService")
    private DataMapKgDataPickService dataPickService;
    @Autowired
    IKnowledgeGraphService knowledgeGraphService;
    @Autowired
    MonitorRuleRepository monitorRuleRepository;
    @Autowired
    private DatamapESPUtils datamapEspUtils;
    @Autowired
    DataMapTranslateUtils dataMapTranslateUtils;
    @Autowired
    ActionRepository actionRepository;

    @Override
    public ApplicationRelation getApplicationByTypeAndCode(String type, String code) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").is((Object)code).and("type").is((Object)type);
        return this.dataPickService.findOneByCondition(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public ApplicationRelation getApplicationByTypeAndCodeAndLang1(String type, String code, String lang) throws DWBusinessException {
        ApplicationRelation applicationRelation = this.getApplicationByTypeAndCode(type, code);
        Application application = null;
        try {
            application = this.getApplicationByCode(applicationRelation.getAppCode());
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5e94\u7528\u5f02\u5e38 for type:{},code:{}", (Object)type, (Object)code);
        }
        if (application != null && application.getLang() != null) {
            Map nameLangMap = (Map)application.getLang().get("name");
            String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
            applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
        }
        return applicationRelation;
    }

    @Override
    @DWIgnoreFileLog
    public Map<String, List<ApplicationRelation>> postApplicationsMapByTypeAndCodesAndActivityMap(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        HashMap<String, Object> keyConditions = new HashMap<String, Object>();
        keyConditions.put("type", queryDTO.getType());
        Map<String, List<ApplicationRelation>> applicationRelationsMap = this.dataMapMongoEntityBaseDAO.find(keyConditions, "code", queryDTO.getCodes(), ApplicationRelation.class, queryDTO.getActivityMap());
        return applicationRelationsMap;
    }

    @Override
    public Map<String, List<ApplicationRelation>> postApplicationsMapByTypeAndCodes(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        HashMap<String, Object> keyConditions = new HashMap<String, Object>();
        keyConditions.put("type", queryDTO.getType());
        Map<String, List<ApplicationRelation>> applicationRelationsMap = this.dataMapMongoEntityBaseDAO.find(keyConditions, "code", queryDTO.getCodes(), ApplicationRelation.class, new HashMap<String, Activity>());
        return applicationRelationsMap;
    }

    @Override
    public List<ApplicationRelation> postApplicationByTypeAndCodeList(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        return this.postApplicationByTypeAndSubTypeAndCodeList(queryDTO);
    }

    @Override
    public List<ApplicationRelation> postApplicationByTypeAndSubTypeAndCodeList(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"type").is((Object)queryDTO.getType()).and("code").in((Collection)queryDTO.getCodes());
        if (StringUtils.isNotEmpty((CharSequence)queryDTO.getSubType())) {
            criteria.and("subType").is((Object)queryDTO.getSubType());
        }
        return this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public List<ApplicationRelation> getApplicationsByTypeAndCode(String type, String code) throws DWBusinessException {
        ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().type(type).codes(Collections.singletonList(code)).build();
        return this.postApplicationByTypeAndSubTypeAndCodeList(queryDTO);
    }

    @Override
    public List<Application> postApplicationsByCodes(Collection<String> codes) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"code").in(codes);
        return this.dataPickService.find(criteria, Application.class, "application");
    }

    @Override
    public Application getApplicationByCode(String code) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        return this.getApplicationByCodeAndTenantId(code, tenantId);
    }

    @Override
    public Application getApplicationByCodeAndTenantId(String code, String tenantId) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").is((Object)code);
        return this.dataPickService.findOneByCondition(criteria, tenantId, Application.class, "application");
    }

    @Override
    public FunctionCtrl getApplicationFunctionCtrlByBizCode(String code) throws DWBusinessException {
        Application application = this.getApplicationByCode(code);
        if (null == application) {
            throw new DWBusinessException("app not found");
        }
        return application.getFunctionCtrl();
    }

    @Override
    public FunctionCtrl getApplicationFunctionCtrlByAppCode(String code) throws DWBusinessException {
        FunctionCtrl functionCtrl = new FunctionCtrl();
        functionCtrl.setProjectCardCustomizeFlag(true);
        functionCtrl.setTaskCardCustomizeFlag(true);
        functionCtrl.setTaskCardMergeCustomizeFlag(true);
        return functionCtrl;
    }

    @Override
    public List<Map> getApplicationRecommendations() throws DWBusinessException {
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        List<String> tenantAppCodes = this.dataMapTenantService.getAppCodes();
        Criteria criteria = new Criteria();
        criteria.and("appCode").in(tenantAppCodes).and("version").is((Object)tenantVersion);
        List applicationRecommendations = this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), ApplicationRecommendation.class);
        Map<String, List<ApplicationRecommendation>> groupedApplicationRecommendations = null;
        LinkedList<Map> resultList = new LinkedList<Map>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)applicationRecommendations)) {
            applicationRecommendations.forEach(item -> {
                if (!org.springframework.util.StringUtils.isEmpty(((Map)item.getLang().get("template")).get(localeStr))) {
                    item.setTemplate((String)((Map)item.getLang().get("template")).get(localeStr));
                }
                if (!org.springframework.util.StringUtils.isEmpty(((Map)item.getLang().get("appName")).get(localeStr))) {
                    item.setAppName((String)((Map)item.getLang().get("appName")).get(localeStr));
                }
            });
            groupedApplicationRecommendations = applicationRecommendations.stream().collect(Collectors.groupingBy(s -> s.getAppCode()));
            groupedApplicationRecommendations.forEach((k, v) -> {
                HashMap<String, Object> innerMap = new HashMap<String, Object>();
                innerMap.put("appCode", k);
                innerMap.put("appName", ((ApplicationRecommendation)v.get(0)).getAppName());
                innerMap.put("group", v.stream().sorted(Comparator.comparing(ApplicationRecommendation::getWeight).reversed()).collect(Collectors.toList()));
                resultList.add(innerMap);
            });
        }
        return resultList;
    }

    @DWIgnoreFileLog
    public Map<String, List<ApplicationRelation>> getApplicationRelationsMapByTypeAndCodesAndLang(String type, Collection<String> codes, String lang, Map<String, Activity> activityMap) throws DWBusinessException {
        ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().type(type).codes((List)codes).activityMap(activityMap).build();
        Map<String, List<ApplicationRelation>> applicationRelationsMap = this.postApplicationsMapByTypeAndCodesAndActivityMap(queryDTO);
        HashSet<String> applicationsCodes = new HashSet<String>();
        applicationRelationsMap.values().forEach(item -> {
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)item)) {
                item.forEach(itemI -> applicationsCodes.add(itemI.getAppCode()));
            }
        });
        List<Application> applications = this.postApplicationsByCodes(applicationsCodes);
        Map applicationMap = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> b));
        applicationRelationsMap.forEach((k, v) -> v.forEach(applicationRelation -> {
            Application application = (Application)applicationMap.get(applicationRelation.getAppCode());
            if (application != null) {
                applicationRelation.setCommonApp(Boolean.valueOf(null == application.getCommonApp() ? false : application.getCommonApp()));
            } else {
                applicationRelation.setCommonApp(Boolean.valueOf(false));
            }
            if (application != null && application.getLang() != null) {
                Map nameLangMap = (Map)application.getLang().get("name");
                String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
                applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
            }
        }));
        return applicationRelationsMap;
    }

    @Override
    public Map<String, List<ApplicationRelation>> postApplicationRelationsMapByTypeAndCodesAndLang(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        Map<String, List<ApplicationRelation>> applicationRelationsMap = this.postApplicationsMapByTypeAndCodes(queryDTO);
        HashSet<String> applicationsCodes = new HashSet<String>();
        applicationRelationsMap.values().forEach(item -> {
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)item)) {
                item.forEach(itemI -> applicationsCodes.add(itemI.getAppCode()));
            }
        });
        List<Application> applications = this.postApplicationsByCodes(applicationsCodes);
        Map applicationMap = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity()));
        applicationRelationsMap.forEach((k, v) -> v.forEach(applicationRelation -> {
            Application application = (Application)applicationMap.get(applicationRelation.getAppCode());
            if (application != null && application.getLang() != null) {
                Map nameLangMap = (Map)application.getLang().get("name");
                String language = null == nameLangMap.get(queryDTO.getLang()) ? application.getName() : (String)nameLangMap.get(queryDTO.getLang());
                applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
            }
        }));
        return applicationRelationsMap;
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationsByTypeAndCodeAndLang(String type, String code, String lang) throws DWBusinessException {
        List<ApplicationRelation> applicationRelations = this.getApplicationsByTypeAndCode(type, code);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(applicationRelations)) {
            return new LinkedList<ApplicationRelation>();
        }
        applicationRelations.forEach(applicationRelation -> {
            Application application = null;
            try {
                application = this.getApplicationByCode(applicationRelation.getAppCode());
            }
            catch (DWBusinessException e) {
                log.warn("\u83b7\u53d6\u5e94\u7528\u5f02\u5e38", (Throwable)e);
            }
            if (application != null && application.getLang() != null) {
                Map nameLangMap = (Map)application.getLang().get("name");
                String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
                applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
            }
        });
        return applicationRelations;
    }

    @Override
    public ApplicationRelation getApplicationByTypeAndCodeAndLang(String type, String code, String lang) throws DWBusinessException {
        ApplicationRelation applicationRelation = this.getApplicationByTypeAndCode(type, code);
        if (null != applicationRelation) {
            Application application = this.getApplicationByCode(applicationRelation.getAppCode());
            if (application == null || application.getLang() == null) {
                return applicationRelation;
            }
            Map nameLangMap = (Map)application.getLang().get("name");
            String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
            applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
        }
        return applicationRelation;
    }

    @Override
    public Map<String, ApplicationRelation> postApplicationRelationsMapByApplicationAndLang(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        HashMap<String, ApplicationRelation> applicationRelations = new HashMap<String, ApplicationRelation>();
        List codes = queryDTO.getCodes();
        List<Application> applications = this.postApplicationsByCodes(codes);
        for (Application item : applications) {
            if (!codes.contains(item.getCode()) || item.getLang() == null) {
                throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.appNotFound", (Object[])new Object[0]) + item.getCode());
            }
            Map nameLangMap = (Map)item.getLang().get("name");
            String language = null == nameLangMap.get(queryDTO.getLocaleStr()) ? item.getName() : (String)nameLangMap.get(queryDTO.getLocaleStr());
            ApplicationRelation applicationRelation = new ApplicationRelation();
            applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
            applicationRelation.setAppCode(item.getCode());
            applicationRelations.put(applicationRelation.getCode(), applicationRelation);
        }
        return applicationRelations;
    }

    @Override
    public ApplicationRelation getApplicationRelationByApplicationAndLang(String code, String localeStr) throws DWBusinessException {
        ApplicationRelation applicationRelation = new ApplicationRelation();
        Application application = this.getApplicationByCode(code);
        if (application == null || application.getLang() == null) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.appNotFound", (Object[])new Object[0]) + code);
        }
        Map nameLangMap = (Map)application.getLang().get("name");
        String language = null == nameLangMap.get(localeStr) ? application.getName() : (String)nameLangMap.get(localeStr);
        applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
        applicationRelation.setAppCode(code);
        return applicationRelation;
    }

    @Override
    public Object getLicenseKey(String tenantId) throws Exception {
        return this.dataMapLicenseKeyManager.getLicenseKey(tenantId);
    }

    @Override
    public Object getLicenseKeyByTenantIdAndRequestFromAndKeyAndTime(String tenantId, String requestFrom, String key, long timestamp) throws Exception {
        return this.dataMapLicenseKeyManager.getLicenseKey(tenantId, requestFrom, key, timestamp);
    }

    @Override
    public Object postSetLicenseKey() throws Exception {
        String athenaLicenceKey = this.dataMapIamService.getAthenaLicenceKey();
        String tenantId = ServiceUtils.getTenantId();
        this.dataMapLicenseKeyManager.setLicenseKey(tenantId, athenaLicenceKey);
        return "success";
    }

    @Override
    public Object postSetLicenseKeyByTenantId(String tenantId) throws Exception {
        String athenaLicenceKey = this.dataMapIamService.getAthenaLicenceKey(tenantId);
        log.info("SetLicenseKeyTenantId:{},athenaLicenceKey:{}", (Object)tenantId, (Object)athenaLicenceKey);
        this.dataMapLicenseKeyManager.setLicenseKey(tenantId, athenaLicenceKey);
        return "success";
    }

    @Override
    public Object get(String code) throws Exception {
        if (code == null || code.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.codeEmpty", (Object[])new Object[0]));
        }
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        Application app = null;
        if ("common".equals(code)) {
            Object commonApps;
            String prefix = "BCB";
            Pattern pattern = Pattern.compile("^" + (String)prefix);
            Criteria criteria = Criteria.where((String)"code").regex(pattern).and("version").is((Object)tenantVersion);
            List<Application> apps = this.dataPickService.find(criteria, Application.class, "application");
            if (!CollectionUtils.isEmpty(apps) && !CollectionUtils.isEmpty(commonApps = apps.stream().filter(application -> application.getCommonApp() != null && application.getCommonApp() != false).collect(Collectors.toList()))) {
                app = (Application)commonApps.get(0);
            }
        } else {
            app = this.getApplicationByCode(code);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)app.getParamDescription())) {
            app.setParamDescription(new ArrayList());
        }
        for (Object p : app.getParamDescription()) {
            if (p.getExecutable() != null) continue;
            p.setExecutable(Integer.valueOf(1));
        }
        this.processMonitorRule(app);
        this.processVariable(app);
        HashMap<String, Map<String, String>> openWin = new HashMap<String, Map<String, String>>();
        for (FieldDescription p : app.getParamDescription()) {
            if (p.getFieldOpenWindowMap() == null || p.getFieldOpenWindowMap().isEmpty()) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            for (FieldOpenWindowSetting setting : p.getFieldOpenWindowMap()) {
                map.put(setting.getColumn(), setting.getOpenWindowKey());
            }
            openWin.put(p.getKey(), map);
        }
        Map<String, Map<String, OpenWindowDefinition>> openWinInfo = this.postOpenWinInfo(openWin);
        for (FieldDescription p : app.getParamDescription()) {
            Map<String, OpenWindowDefinition> temp = openWinInfo.get(p.getKey());
            p.setFieldOpenWindowDefinitions(temp);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)app.getParamDescription())) {
            app.getParamDescription().sort((o1, o2) -> o1.getSequence().compareTo(o2.getSequence()));
        }
        return app;
    }

    protected void processVariable(Application app) throws DWBusinessException {
        List<String> variableList = this.getVariableCode(app.getCode());
        if (variableList != null && !variableList.isEmpty()) {
            if (app.getParamDescription() != null) {
                int seq = 1000;
                for (String code : variableList) {
                    boolean existed = false;
                    for (FieldDescription p : app.getParamDescription()) {
                        if (!p.getCategory().toLowerCase(Locale.ROOT).equals("variable") || !p.getKey().equals(code)) continue;
                        existed = true;
                        break;
                    }
                    if (existed) continue;
                    FieldDescription para = this.createVariableParam(code);
                    if (para.getSequence() == null) {
                        para.setSequence(Integer.valueOf(seq));
                        seq += 10;
                    }
                    this.setFieldDescriptionValue(para);
                    app.getParamDescription().add(para);
                }
            } else {
                ArrayList<FieldDescription> paras = new ArrayList<FieldDescription>();
                int seq = 1000;
                for (String code : variableList) {
                    FieldDescription para = this.createVariableParam(code);
                    if (para.getSequence() == null) {
                        para.setSequence(Integer.valueOf(seq));
                        seq += 10;
                    }
                    this.setFieldDescriptionValue(para);
                    paras.add(para);
                }
                app.setParamDescription(paras);
            }
        }
    }

    public FieldDescription createVariableParam(String variableCode) throws DWBusinessException {
        return this.createVariableParam(variableCode, null);
    }

    public FieldDescription createVariableParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setCategory("variable");
        para.setDataType("string");
        para.setRequired(Boolean.valueOf(true));
        para.setReadOnly(false);
        para.setIsExecute(Boolean.valueOf(true));
        para.setDisplayType("STRING");
        para.setName(variableCode);
        para.setDescription(variableCode);
        this.handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);
        return para;
    }

    public FieldDescription createDefaultParam(String variableCode) throws DWBusinessException {
        return this.createDefaultParam(variableCode, null);
    }

    public FieldDescription createDefaultParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setDataType("object");
        para.setRequired(Boolean.valueOf(true));
        para.setReadOnly(false);
        para.setIsExecute(Boolean.valueOf(true));
        para.setName(variableCode);
        para.setDescription(variableCode);
        FieldDescription fieldDescription = this.handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);
        return fieldDescription == null ? null : para;
    }

    public FieldDescription createLinkParam(String variableCode) throws DWBusinessException {
        return this.createLinkParam(variableCode, null);
    }

    public FieldDescription createLinkParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setCategory("link");
        para.setDataType("object");
        para.setRequired(Boolean.valueOf(true));
        para.setReadOnly(false);
        para.setIsExecute(Boolean.valueOf(true));
        para.setDisplayType("LINK");
        para.setName(variableCode);
        para.setDescription(variableCode);
        this.handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);
        return para;
    }

    protected void processMonitorRule(Application app) throws DWBusinessException {
        List<String> ruleList = this.getMonitorRuleCode(app.getCode());
        if (ruleList != null && !ruleList.isEmpty()) {
            if (app.getParamDescription() != null) {
                int seq = 1000;
                for (String ruleId : ruleList) {
                    FieldDescription para;
                    boolean existed = false;
                    for (FieldDescription p : app.getParamDescription()) {
                        if (!p.getCategory().toLowerCase(Locale.ROOT).equals("period") || !p.getExtendData().equals(ruleId)) continue;
                        existed = true;
                        break;
                    }
                    if (existed || null == (para = this.createMonitorRuleParam(ruleId, true))) continue;
                    if (para.getSequence() == null) {
                        para.setSequence(Integer.valueOf(seq));
                        seq += 10;
                    }
                    app.getParamDescription().add(para);
                }
            } else {
                ArrayList<FieldDescription> paras = new ArrayList<FieldDescription>();
                int seq = 1000;
                for (String ruleId : ruleList) {
                    FieldDescription para = this.createMonitorRuleParam(ruleId, true);
                    if (null == para) continue;
                    if (para.getSequence() == null) {
                        para.setSequence(Integer.valueOf(seq));
                        seq += 10;
                    }
                    paras.add(para);
                }
                app.setParamDescription(paras);
            }
        }
    }

    public FieldDescription createMonitorRuleParam(String ruleId, boolean keyPrefix) throws DWBusinessException {
        return this.createMonitorRuleParam(ruleId, keyPrefix, null);
    }

    public FieldDescription createMonitorRuleParam(String ruleId, boolean keyPrefix, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        FieldDescription para = new FieldDescription();
        List<MonitorRule> monitorRules = this.dataPickService.excludeWithSameCode(this.monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion));
        boolean ucRemoved = this.filterUc(monitorRules, tenantId);
        if (monitorRules == null || monitorRules.size() == 0) {
            if (ucRemoved) {
                return null;
            }
            throw new DWBusinessException("P.KG.500.0030", I18nUtils.getValue((String)"knowledgegraph.monitorNotFound", (Object[])new Object[]{ruleId}));
        }
        MonitorRule monitorRule = monitorRules.get(0);
        if (keyPrefix) {
            para.setKey("executeTime-" + ruleId);
        } else {
            para.setKey(ruleId);
        }
        para.setDataType("string");
        para.setCategory("period");
        para.setDisplayType("PERIODIC");
        para.setFormat("rule;yyyyMMdd HH:mm;switch");
        para.setDefaultValue((Object)"D;20210801 12:00;true");
        para.setRequired(Boolean.valueOf(true));
        para.setReadOnly(false);
        para.setIsExecute(Boolean.valueOf(true));
        para.setIsDesignerSet(monitorRule.getIsDesignerSet());
        para.setExtendData(ruleId);
        para.setName(monitorRule.getName());
        para.setDescription(monitorRule.getDescription());
        para.setLang(monitorRule.getLang());
        if (monitorRule.getExecutable() == null) {
            para.setExecutable(Integer.valueOf(1));
        } else {
            para.setExecutable(monitorRule.getExecutable());
        }
        if (StringUtils.isEmpty((CharSequence)monitorRule.getPeriodEnable())) {
            para.setPeriodEnable("M;W;D;H;F;fixInterval");
        } else {
            para.setPeriodEnable(monitorRule.getPeriodEnable());
        }
        this.setEoc(para, ruleId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"category").is((Object)monitorRule.getCategory()));
        InitMonitorRuleGroup initMonitorRuleGroup = (InitMonitorRuleGroup)this.mongoTemplate.findOne(query, InitMonitorRuleGroup.class);
        if (!Objects.isNull(initMonitorRuleGroup)) {
            para.setFormat(initMonitorRuleGroup.getFormat());
            para.setDefaultValue((Object)initMonitorRuleGroup.getDefaultValue());
            para.setExecutable(initMonitorRuleGroup.getExecutable());
        }
        this.handleParaFromVariD(ruleId, tenantVersion, para, variableDefinitionsMap);
        return para;
    }

    private boolean filterUc(List<MonitorRule> activities, String tenantId) {
        boolean removed = false;
        Iterator<MonitorRule> activityIterator = activities.iterator();
        ArrayList<String> ucCodes = new ArrayList<String>();
        while (activityIterator.hasNext()) {
            MonitorRule activity = activityIterator.next();
            if (null == activity.getInclusionTenant()) continue;
            if (!activity.getInclusionTenant().contains(tenantId)) {
                activityIterator.remove();
                removed = true;
                continue;
            }
            if (!activity.getCode().startsWith("UC_")) continue;
            ucCodes.add(activity.getCode().replace("UC_", ""));
        }
        return removed;
    }

    private FieldDescription handleParaFromVariD(String code, String tenantVersion, FieldDescription para) throws DWBusinessException {
        return this.handleParaFromVariD(code, tenantVersion, para, null);
    }

    private FieldDescription handleParaFromVariD(String code, String tenantVersion, FieldDescription para, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        VariableDefinition def = null;
        if (variableDefinitionsMap == null || !variableDefinitionsMap.containsKey(code)) {
            Query query = new Query();
            Criteria criteria = Criteria.where((String)"code").in(new Object[]{code});
            query.addCriteria((CriteriaDefinition)criteria);
            def = this.dataPickService.findOneByCondition(criteria, VariableDefinition.class, "variableDefinition");
        } else {
            def = variableDefinitionsMap.get(code);
        }
        if (def != null) {
            Application application;
            if (StringUtils.isNotEmpty((CharSequence)def.getApplication()) && Boolean.TRUE.equals((application = this.getApplicationByCode(def.getApplication())).getIndividualAll()) && "SYSTEM".equals(def.getTenantId())) {
                return null;
            }
            LoginInfo loginInfo = DataMapFilter.getLoginInfo();
            if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty((CharSequence)def.getApplication())) {
                loginInfo.setApplication(def.getApplication());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getName())) {
                para.setName(def.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getDescription())) {
                para.setDescription(def.getDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getDataType())) {
                para.setDataType(def.getDataType());
            }
            if (!ObjectUtils.isEmpty((Object)def.getDefaultValue())) {
                para.setDefaultValue(def.getDefaultValue());
            }
            if (def.getIsOperation() != null) {
                para.setIsOperation(def.getIsOperation());
            }
            if (def.getEocLevel() != null && !def.getEocLevel().isEmpty()) {
                para.setEocLevel(def.getEocLevel());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getExtendData())) {
                para.setExtendData(def.getExtendData());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getDisplayType())) {
                para.setDisplayType(def.getDisplayType());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getDisplayFormat())) {
                para.setDisplayFormat(def.getDisplayFormat());
            }
            if (!ObjectUtils.isEmpty((Object)def.getValueDisplay())) {
                para.setValueDisplay(def.getValueDisplay());
            }
            if (def.getIsSimulation() != null) {
                para.setIsSimulation(def.getIsSimulation());
            }
            if (def.getIsExecute() != null) {
                para.setIsExecute(def.getIsExecute());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getExecuteName())) {
                para.setExecuteName(def.getExecuteName());
            }
            if (def.getReadOnly() != null) {
                para.setReadOnly(def.getReadOnly().booleanValue());
            }
            if (def.getRequired() != null) {
                para.setRequired(def.getRequired());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getPeriodEnable())) {
                para.setPeriodEnable(def.getPeriodEnable());
            }
            if (def.getExecutable() != null) {
                para.setExecutable(def.getExecutable());
            }
            if (def.getSequence() != null) {
                para.setSequence(def.getSequence());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getValidateScript())) {
                para.setValidateScript(def.getValidateScript());
            }
            if (!Objects.isNull(def.getSelectVariableOptionSetting())) {
                para.setOptions(this.getOptionsFromApi(def.getSelectVariableOptionSetting()));
            } else if (!ObjectUtils.isEmpty((Object)def.getOptions())) {
                para.setOptions(def.getOptions());
            }
            if (def.getParamVisble() != null && !def.getParamVisble().isEmpty()) {
                para.setParamVisble(def.getParamVisble());
            }
            if (def.getParamVisbleScope() != null && !def.getParamVisbleScope().isEmpty()) {
                para.setParamVisbleScope(def.getParamVisbleScope());
            }
            if (def.getParamDisable() != null && !def.getParamDisable().isEmpty()) {
                para.setParamDisable(def.getParamDisable());
            }
            if (def.getParamDisableScope() != null && !def.getParamDisableScope().isEmpty()) {
                para.setParamDisableScope(def.getParamDisableScope());
            }
            if (def.getColspan() != null) {
                para.setColspan(def.getColspan().intValue());
            }
            if (!ObjectUtils.isEmpty((Object)def.getDynamicCondition())) {
                para.setDynamicCondition(def.getDynamicCondition());
            }
            if (!ObjectUtils.isEmpty((Object)def.getFieldMappings())) {
                para.setFieldMappings(def.getFieldMappings());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getMechanismCode())) {
                para.setMechanismCode(def.getMechanismCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getCategory())) {
                para.setCategory(def.getCategory());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getGroup())) {
                para.setGroup(def.getGroup());
            }
            if (def.getLang() != null && !def.getLang().isEmpty()) {
                para.setLang(def.getLang());
            }
            if (!ObjectUtils.isEmpty((Object)def.getVisibleCondition())) {
                para.setVisibleCondition(def.getVisibleCondition());
            }
            if (def.getFieldOpenWindowMap() != null && !def.getFieldOpenWindowMap().isEmpty()) {
                para.setFieldOpenWindowMap(def.getFieldOpenWindowMap());
            }
            if (!ObjectUtils.isEmpty((Object)def.getDisplayTypeDefinition())) {
                para.setDisplayTypeDefinition(def.getDisplayTypeDefinition());
            }
            if (!ObjectUtils.isEmpty((Object)def.getForceOpen())) {
                para.setForceOpen(def.getForceOpen());
            }
            if (!ObjectUtils.isEmpty((Object)def.getValue())) {
                para.setValue(def.getValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getFrom())) {
                para.setFrom(def.getFrom());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getTarget())) {
                para.setTarget(def.getTarget());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getFormat())) {
                para.setFormat(def.getFormat());
            }
            if (!ObjectUtils.isEmpty((Object)def.getMax())) {
                para.setMax(def.getMax());
            }
            if (!ObjectUtils.isEmpty((Object)def.getMin())) {
                para.setMin(def.getMin());
            }
            if (!ObjectUtils.isEmpty((Object)def.getStep())) {
                para.setStep(def.getStep());
            }
            if (!ObjectUtils.isEmpty((Object)def.getLinkKey())) {
                para.setLinkKey(def.getLinkKey());
            }
            if (!ObjectUtils.isEmpty((Object)def.getLinkOptions())) {
                para.setLinkOptions(def.getLinkOptions());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getPrecision())) {
                para.setPrecision(def.getPrecision());
            }
            if (!ObjectUtils.isEmpty((Object)def.getRestrictions())) {
                para.setRestrictions(def.getRestrictions());
            }
            if (!ObjectUtils.isEmpty((Object)def.getFilters())) {
                para.setFilters(def.getFilters());
            }
            if (!ObjectUtils.isEmpty((Object)def.getIsSingleOperation())) {
                para.setIsSingleOperation(def.getIsSingleOperation());
            }
            if (!ObjectUtils.isEmpty((Object)def.getOpenWindowTip())) {
                para.setOpenWindowTip(def.getOpenWindowTip());
            }
            para.setValueComputed(MapUtils.isNotEmpty((Map)def.getValueComputed()) ? def.getValueComputed() : null);
            para.setIsTop(Optional.ofNullable(def.getIsTop()).orElse(false));
            para.setLinkageParamEvent(def.getLinkageParamEvent());
            return para;
        }
        return null;
    }

    private Object getOptionsFromApi(SelectVariableOptionSetting setting) throws DWBusinessException {
        if ("ESP".equalsIgnoreCase(setting.getOptionApiType())) {
            try {
                Map<String, Object> result = this.datamapEspUtils.execute(AthenaUtils.getHeaderToken(), ServiceUtils.getTenantId(), setting.getOptionApi(), Optional.ofNullable(setting.getOptionApiParams()).orElse(Collections.emptyMap()));
                Map config = setting.getConfig();
                String label = MapUtils.getString((Map)config, (Object)"label");
                String value = MapUtils.getString((Map)config, (Object)"value");
                String dataKey = MapUtils.getString((Map)config, (Object)"dataKey");
                Object data = result.get(dataKey);
                if (!(data instanceof List)) {
                    return Collections.emptyList();
                }
                JSONArray optionData = (JSONArray)data;
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)optionData)) {
                    return Collections.emptyList();
                }
                List collect = optionData.stream().map(o -> {
                    JSONObject jsonObject = (JSONObject)o;
                    return new JSONObject().fluentPut("label", jsonObject.get((Object)label)).fluentPut("value", jsonObject.get((Object)value));
                }).collect(Collectors.toList());
                String translateStr = this.dataMapTranslateUtils.translateContent(collect);
                return JSONArray.parseArray((String)translateStr);
            }
            catch (Exception e) {
                log.info("\u67e5\u8be2\u4e0b\u62c9\u63a7\u4ef6\u9009\u9879\u5217\u8868\u51fa\u9519\uff1a{}", (Object)e.getMessage());
                throw new DWBusinessException(e.getMessage());
            }
        }
        return null;
    }

    private void setEoc(FieldDescription para, String ruleId) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        Criteria criteria = Criteria.where((String)"monitorRuleId").in(new Object[]{ruleId}).and("version").is((Object)tenantVersion);
        List<MonitorRuleProductConfig> configs = this.dataPickService.find(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        if (configs != null && !configs.isEmpty()) {
            boolean isOperation = false;
            HashMap<String, String> eoc = new HashMap<String, String>();
            for (MonitorRuleProductConfig c : configs) {
                if (!StringUtils.isNotEmpty((CharSequence)c.getEocLevel())) continue;
                eoc.put(c.getProductName(), c.getEocLevel());
                isOperation = true;
            }
            if (isOperation) {
                para.setEocLevel(eoc);
                para.setIsOperation(Boolean.valueOf(true));
            }
        }
    }

    @Override
    public Object postList(Set<String> applicationCodeList) throws Exception {
        Criteria criteria = Criteria.where((String)"code").in(applicationCodeList);
        List<Application> applications = this.dataPickService.find(criteria, Application.class, "application");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(applications)) {
            for (Application app : applications) {
                this.processMonitorRule(app);
                this.processVariable(app);
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)app.getParamDescription())) continue;
                app.getParamDescription().sort((o1, o2) -> o1.getSequence().compareTo(o2.getSequence()));
            }
        }
        return applications;
    }

    @Override
    public Object postByNameAndTags(ApplicationRelationQueryDTO queryDTO) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        Query query = new Query();
        Criteria criteria = null;
        if (StringUtils.isNotEmpty((CharSequence)queryDTO.getApplicationName())) {
            criteria = Criteria.where((String)"name").regex(".*?\\" + queryDTO.getApplicationName() + ".*");
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)queryDTO.getTags())) {
            criteria = criteria != null ? criteria.and("tags.key").in((Collection)queryDTO.getTags()) : Criteria.where((String)"tags.key").in((Collection)queryDTO.getTags());
        }
        if (criteria != null) {
            criteria = criteria.and("version").is((Object)tenantVersion);
            query.addCriteria((CriteriaDefinition)criteria);
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion));
        }
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"editDate")}));
        List applications = this.mongoTemplate.find(query, Application.class);
        return this.dataPickService.excludeWithSameCode(applications);
    }

    @Override
    public Application getApplicationInfo(String code) throws DWBusinessException {
        Application application = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)code), Application.class, "application");
        if (application != null) {
            Locale locale = DWResourceBundleUtils.getCurrentLocale();
            String localeStr = locale.toString();
            if (application.getLang() != null && !application.getLang().isEmpty()) {
                for (Map.Entry i : application.getLang().entrySet()) {
                    Map lang = (Map)i.getValue();
                    if (lang == null || lang.isEmpty() || !lang.containsKey(localeStr)) continue;
                    try {
                        Field field = Application.class.getDeclaredField((String)i.getKey());
                        field.setAccessible(true);
                        field.set(application, lang.get(localeStr));
                    }
                    catch (NoSuchFieldException field) {
                    }
                    catch (IllegalAccessException field) {
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                }
            }
        }
        return application;
    }

    @Override
    public List<String> getTaskCode(String appCode) throws DWBusinessException {
        ArrayList<String> codes = new ArrayList<String>();
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(appCode, "task", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        return codes;
    }

    @Override
    public List<String> getMechanismCode(String appCode) throws DWBusinessException {
        ArrayList<String> codes = new ArrayList<String>();
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(appCode, "mechanism", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        return codes;
    }

    @Override
    public List<String> getMonitorRuleCode(String appCode) throws DWBusinessException {
        return this.getMonitorRuleCode(appCode, null);
    }

    public List<String> getMonitorRuleCode(String appCode, String tenantId) throws DWBusinessException {
        tenantId = StringUtils.isEmpty((CharSequence)tenantId) ? ServiceUtils.getTenantId() : tenantId;
        ArrayList<String> codes = new ArrayList<String>();
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(appCode, "monitorRule", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        Application application = this.getApplicationByCode(appCode);
        if (application == null || application.getParamDescription() == null) {
            return codes;
        }
        for (FieldDescription fieldDescription : application.getParamDescription()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)"period", (CharSequence)fieldDescription.getCategory()) || !StringUtils.isNotEmpty((CharSequence)fieldDescription.getExtendData()) || codes.contains(fieldDescription.getExtendData())) continue;
            codes.add(fieldDescription.getExtendData());
        }
        return codes;
    }

    public List<String> getMonitorRuleCodeByAppAndVersion(String appCode, String version) throws DWBusinessException {
        ArrayList<String> codes = new ArrayList<String>();
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(appCode, "monitorRule", null, null, version);
        relations.forEach(r -> codes.add(r.getCode()));
        Application application = this.getApplicationByCode(appCode);
        if (application == null || application.getParamDescription() == null) {
            return codes;
        }
        for (FieldDescription fieldDescription : application.getParamDescription()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)"period", (CharSequence)fieldDescription.getCategory()) || !StringUtils.isNotEmpty((CharSequence)fieldDescription.getExtendData()) || codes.contains(fieldDescription.getExtendData())) continue;
            codes.add(fieldDescription.getExtendData());
        }
        return codes;
    }

    public List<String> getMonitorRuleCodeByAppAndVersion(String version) throws DWBusinessException {
        List<String> codes = new ArrayList<String>();
        List<MonitorRule> monitorRules = this.monitorRuleRepository.getCommonByVersion(version);
        if (!CollectionUtils.isEmpty(monitorRules)) {
            codes = monitorRules.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        }
        return codes;
    }

    @Override
    public List<ApplicationRelation> postApplicationRelationsByCodesAndType(@RequestBody ApplicationRelationQueryDTO applicationRelationQueryDTO) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        if (appCodes.isEmpty()) {
            return new ArrayList<ApplicationRelation>();
        }
        Criteria criteria = Criteria.where((String)"type").is((Object)applicationRelationQueryDTO.getType()).and("code").in((Collection)applicationRelationQueryDTO.getCodes()).and("version").is((Object)tenantVersion);
        return this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public List<ApplicationRelation> getAppCodeByTaskCode(String code) throws DWBusinessException {
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        if (appCodes.isEmpty()) {
            return new ArrayList<ApplicationRelation>();
        }
        Criteria criteria = Criteria.where((String)"type").is((Object)"task").and("code").is((Object)code).and("appCode").in(appCodes);
        List<ApplicationRelation> relations = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        this.proccessAppNameLanguage(relations);
        return relations;
    }

    @Override
    public List<ApplicationRelation> getAppCodeByMechanismCode(String code) throws DWBusinessException {
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        if (appCodes.isEmpty()) {
            return new ArrayList<ApplicationRelation>();
        }
        Criteria criteria = Criteria.where((String)"type").is((Object)"mechanism").and("code").is((Object)code).and("appCode").in(appCodes);
        List<ApplicationRelation> relations = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        this.proccessAppNameLanguage(relations);
        return relations;
    }

    @Override
    public List<ApplicationRelation> getAppCodeByMonitorRuleCode(String code) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        if (appCodes.isEmpty()) {
            return new ArrayList<ApplicationRelation>();
        }
        Criteria criteria1 = Criteria.where((String)"type").is((Object)"monitorRule").and("code").is((Object)code).and("appCode").in(appCodes);
        List<ApplicationRelation> relations = this.dataPickService.find(criteria1, ApplicationRelation.class, "applicationRelation");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(relations)) {
            Criteria criteria = Criteria.where((String)"paramDescription.extendData").is((Object)code);
            List<Application> applications = this.dataPickService.find(criteria, Application.class, "application");
            for (Application application : applications) {
                ApplicationRelation applicationRelation = new ApplicationRelation();
                applicationRelation.setAppCode(application.getCode());
                applicationRelation.setAppName(application.getName());
                applicationRelation.setCode(code);
                applicationRelation.setType("monitorRule");
                relations.add(applicationRelation);
            }
        }
        this.proccessAppNameLanguage(relations);
        return relations;
    }

    private void proccessAppNameLanguage(List<ApplicationRelation> relations) throws DWBusinessException {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relations)) {
            for (ApplicationRelation i : relations) {
                Application app = this.getApplicationInfo(i.getAppCode());
                if (app == null) continue;
                i.setAppName(app.getName());
                Map appLang = app.getLang();
                if (appLang == null) continue;
                if (i.getLang() != null) {
                    i.getLang().put("appName", appLang.get("name"));
                    continue;
                }
                HashMap lang = new HashMap();
                lang.put("appName", appLang.get("name"));
                i.setLang(lang);
            }
        }
    }

    @Override
    public List<ApplicationRelation> postApplicationRelationByCodesAndTenantVersion(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"code").in((Collection)queryDTO.getCodes());
        return this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public List<ApplicationRelation> postApplicationRelationByAppCodesAndCodesAndTypeAndSubType(ApplicationRelationQueryDTO queryDTO) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"code").in((Collection)queryDTO.getCodes()).and("appCode").in((Collection)queryDTO.getAppCodes());
        if (StringUtils.isNotEmpty((CharSequence)queryDTO.getType())) {
            criteria.and("type").is((Object)queryDTO.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDTO.getSubType())) {
            criteria.and("subType").is((Object)queryDTO.getSubType());
        }
        return this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public List<ApplicationRelation> postApplicationRelation(List<String> appCodes) throws DWBusinessException {
        return this.dataPickService.applicationRelations(appCodes, null, null, null, null);
    }

    @Override
    public List<String> getFlowCode(String appCode) throws DWBusinessException {
        ArrayList<String> codes = new ArrayList<String>();
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(appCode, "flow", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        return codes;
    }

    @Override
    public List<ApplicationRelation> getAppCodeByFlowCode(String code) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"type").is((Object)"flow").and("code").is((Object)code);
        return this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    @Override
    public List<String> getVariableCode(String appCode) throws DWBusinessException {
        ArrayList<String> re = new ArrayList<String>();
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        if (!appCodes.contains(appCode)) {
            return re;
        }
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(appCode, "variable", null, null, null);
        relations.forEach(r -> re.add(r.getCode()));
        return re;
    }

    @Override
    public List<String> getAllAppCode() throws DWBusinessException {
        Query query = new Query();
        query.fields().include("code");
        List app = this.mongoTemplate.find(query, Application.class);
        return app.stream().map(BaseEntity::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    @Override
    public List<String> getNotCommonAppCode() throws DWBusinessException {
        Query query = new Query();
        query.fields().include("code");
        List app = this.mongoTemplate.find(query, Application.class);
        List<String> collect = app.stream().filter(item -> null == item.getCommonApp() || false == item.getCommonApp()).map(BaseEntity::getCode).distinct().collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<ApplicationRelation> getAppCodeByTypeAndCode(String type, String code) throws Exception {
        ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().type(type).codes(Collections.singletonList(code)).build();
        List<ApplicationRelation> applicationRelationList = this.postApplicationByTypeAndSubTypeAndCodeList(queryDTO);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(applicationRelationList)) {
            return applicationRelationList;
        }
        List all = this.mongoTemplate.findAll(Application.class);
        Map collect = this.dataPickService.excludeWithSameCode(all).stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> a));
        applicationRelationList.forEach(e -> {
            Application application = (Application)collect.get(e.getAppCode());
            if (application != null && application.getLang() != null && application.getLang().containsKey("name")) {
                e.setAppName(application.getName());
                HashMap lang = e.getLang();
                if (lang == null) {
                    lang = new HashMap();
                    e.setLang(lang);
                }
                lang.put("appName", application.getLang().get("name"));
            }
        });
        return applicationRelationList;
    }

    @Override
    public List<ApplicationRelation> getParadigmByTypeAndAppCode(String type, String appCode) throws Exception {
        ArrayList applicationRelationList = this.dataPickService.applicationRelations(appCode, type, null, null, null);
        return org.apache.commons.collections.CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList() : applicationRelationList;
    }

    @Override
    public Map<String, Map<String, OpenWindowDefinition>> postOpenWinInfo(Map<String, Map<String, String>> openWin) throws DWBusinessException {
        HashMap<String, Map<String, OpenWindowDefinition>> result = new HashMap<String, Map<String, OpenWindowDefinition>>();
        for (Map.Entry<String, Map<String, String>> entry0 : openWin.entrySet()) {
            HashMap<String, OpenWindowDefinition> openWindowInfo = new HashMap<String, OpenWindowDefinition>();
            if (entry0.getValue() != null) {
                for (Map.Entry<String, String> entry1 : entry0.getValue().entrySet()) {
                    OpenWindowDefinition openWindowDefinition = this.dataPickService.findOneByCondition(Criteria.where((String)"key").is((Object)entry1.getValue()), OpenWindowDefinition.class, "openWindowDefinition");
                    openWindowInfo.put(entry1.getKey(), openWindowDefinition);
                }
            }
            result.put(entry0.getKey(), openWindowInfo);
        }
        return result;
    }

    @Override
    public String getAppCodeByApplication(String application) throws Exception {
        List<ApplicationRelation> applicationRelationList = this.dataPickService.applicationRelations(Collections.singletonList(application), null, null, null, null);
        return org.apache.commons.collections.CollectionUtils.isEmpty(applicationRelationList) ? null : applicationRelationList.get(0).getAppCode();
    }

    public Map<String, String> getAppCodeByApplication() throws DWBusinessException {
        Criteria criteria = new Criteria();
        List<ApplicationRelation> applicationRelationList = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return applicationRelationList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getApplication()) && StringUtils.isNotEmpty((CharSequence)e.getAppCode())).collect(Collectors.toMap(TenantObject::getApplication, ApplicationRelation::getAppCode, (a, b) -> a));
    }

    public void checkRelatedAppHasExpired(String type, String code) throws DWBusinessException {
        List<ApplicationRelation> applicationRelations = this.getApplicationRelationsByTypeAndCodeAndLang(type, code, AthenaUtils.getCurrentLocale());
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        List collect = applicationRelations.stream().filter(e -> !appCodes.contains(e.getAppCode())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(collect) && collect.size() == applicationRelations.size()) {
            throw new DWBusinessException("RELATED_APP_EXPIRED", ((ApplicationRelation)collect.get(0)).getAppName());
        }
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String type, String appCode) throws Exception {
        ArrayList applicationRelationList = this.dataPickService.applicationRelations(appCode, type, null, null, null);
        return org.apache.commons.collections.CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList() : applicationRelationList;
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCodeAndVersion(String type, String appCode, String version) throws Exception {
        return this.getApplicationRelationByTenantIdAndTypeAndAppCode(null, type, appCode);
    }

    @Override
    public List<ApplicationRelation> postApplicationRelationByTypeAndAppCodes(ApplicationRelationQueryDTO queryDTO) throws Exception {
        List<ApplicationRelation> applicationRelationList = this.dataPickService.applicationRelations(queryDTO.getAppCodes(), queryDTO.getType(), null, null, null);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(applicationRelationList)) {
            return new ArrayList<ApplicationRelation>();
        }
        List<Application> applicationList = this.knowledgeGraphService.applications(queryDTO.getAppCodes());
        Map applicationMap = applicationList.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> b));
        String locale = ServiceUtils.getLocale();
        for (ApplicationRelation relation : applicationRelationList) {
            String appCode = relation.getAppCode();
            Application application = (Application)applicationMap.get(appCode);
            if (application == null || application.getLang() == null) continue;
            Map nameLangMap = (Map)application.getLang().get("name");
            String language = null == nameLangMap.get(locale) ? application.getName() : (String)nameLangMap.get(locale);
            relation.setAppName(StringUtils.isEmpty((CharSequence)language) ? relation.getAppName() : language);
        }
        return applicationRelationList;
    }

    @Override
    public List<ApplicationRelation> postQueryApplicationRelationByTypeAndAppCode(ApplicationRelationQueryDTO queryDTO) throws Exception {
        return this.postApplicationRelationByTypeAndAppCodes(queryDTO);
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTenantIdAndTypeAndAppCode(String tenantId, String type, String appCode) throws DWBusinessException {
        ArrayList applicationRelationList = this.dataPickService.applicationRelations(appCode, type, null, null, null);
        return org.apache.commons.collections.CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList() : applicationRelationList;
    }

    @Override
    public Object postAppRelationUpdate(AppRelationBatchPo request) throws Exception {
        if (Boolean.TRUE.equals(request.getCleanDuplicate())) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            List<ApplicationRelation> applicationRelations = this.mongoTemplate.findAll(ApplicationRelation.class);
            applicationRelations = this.dataPickService.filterApplicationRelations(applicationRelations);
            HashSet cleaned = new HashSet();
            ArrayList newList = new ArrayList();
            applicationRelations.forEach(app -> {
                if (newList.contains(app)) {
                    cleaned.add(app.getCode());
                    this.mongoTemplate.remove(app);
                } else {
                    newList.add(app);
                }
            });
            map.put("codes", cleaned);
            map.put("count", Integer.valueOf(cleaned.size()));
            return map;
        }
        List relations = request.getList();
        if (null == relations) {
            return null;
        }
        ArrayList updateList = new ArrayList();
        relations.forEach(data -> {
            Query query = new Query((CriteriaDefinition)new Criteria("code").is((Object)data.getCode()).and("type").is((Object)data.getType()).and("appCode").is((Object)data.getAppCode()));
            Update update = new Update();
            update.set("code", (Object)data.getCode());
            update.set("type", (Object)data.getType());
            update.set("application", (Object)data.getApplication());
            update.set("appName", (Object)data.getAppName());
            update.set("appCode", (Object)data.getAppCode());
            update.set("source", (Object)data.getSource());
            update.set("version", (Object)data.getVersion());
            update.set("name", (Object)data.getName());
            update.set("tenantId", (Object)data.getTenantId());
            update.set("sourceLevel", (Object)data.getSourceLevel());
            Pair updatePair = Pair.of((Object)query, (Object)update);
            updateList.add(updatePair);
        });
        BulkWriteResult result = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, ApplicationRelation.class).upsert(updateList).execute();
        int count = result.getDeletedCount() + result.getModifiedCount();
        return count;
    }

    public List<String> getNeedUserCheckApp(String tenantId) throws DWBusinessException {
        String tenantVersion = "2.0";
        if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
            try {
                tenantVersion = this.kmService.tenantVersion(tenantId);
            }
            catch (Exception e2) {
                log.error("getNeedUserCheckApp tenantId:{},e:{}", (Object)tenantId, (Object)e2);
            }
        }
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        Set appCodesSet = appCodes.stream().collect(Collectors.toSet());
        Query query = new Query();
        query.fields().include("code").include("feature");
        Criteria criteria = Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(appCodesSet);
        query.addCriteria((CriteriaDefinition)criteria);
        List all = this.mongoTemplate.find(query, Application.class);
        all = this.dataPickService.excludeWithSameCode(all);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(all)) {
            return Collections.emptyList();
        }
        List<String> collect = all.stream().filter(e -> appCodesSet.contains(e.getCode()) && this.needNeedUserCheck((Application)e)).map(BaseEntity::getCode).distinct().collect(Collectors.toList());
        return collect;
    }

    private boolean needNeedUserCheck(Application application) {
        return application.getFeature() == null || application.getFeature().get("userIntegrityCheck") == null || Boolean.parseBoolean(String.valueOf(application.getFeature().get("userIntegrityCheck")));
    }

    public void setFieldDescriptionValue(FieldDescription para) throws DWBusinessException {
        if ("GROUP".equalsIgnoreCase(para.getDisplayType())) {
            ArrayList<FieldDescription> childFieldDescriptions = new ArrayList<FieldDescription>();
            List codeList = (List)para.getDefaultValue();
            for (String code : codeList) {
                FieldDescription childFieldDescription = this.createVariableParam(code);
                childFieldDescriptions.add(childFieldDescription);
            }
            para.setParameters(childFieldDescriptions);
        }
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByType(String type) throws Exception {
        Criteria criteria = Criteria.where((String)"type").is((Object)type);
        List<ApplicationRelation> applicationRelationList = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return org.apache.commons.collections.CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList() : this.dataPickService.filterApplicationRelations(applicationRelationList);
    }

    @Override
    public List<ApplicationCustomizedConfig> postConfigByApplicationCustomized() throws DWBusinessException {
        String version = this.kmService.tenantVersion(null);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"version").is((Object)version).and("tenantId").in(new Object[]{"SYSTEM", ServiceUtils.getTenantId()});
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, ApplicationCustomizedConfig.class);
    }

    @Override
    public List<ApplicationCustomizedConfig> postConfigByGroupApplicationCustomized() throws DWBusinessException {
        String version = this.kmService.tenantVersion(null);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"version").is((Object)version).and("tenantId").in(new Object[]{"SYSTEM", ServiceUtils.getTenantId()});
        query.addCriteria((CriteriaDefinition)criteria);
        List configList = this.mongoTemplate.find(query, ApplicationCustomizedConfig.class);
        Map nameTenantIdAppIdListMap = configList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getName()) && StringUtils.isNotBlank((CharSequence)o.getTenantId())).collect(Collectors.groupingBy(BaseEntity::getName, Collectors.groupingBy(HierarchicalEntity::getTenantId, Collectors.mapping(ApplicationCustomizedConfig::getAppId, Collectors.toList()))));
        LinkedHashMap nameMap = configList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getName()) && StringUtils.isNotBlank((CharSequence)o.getTenantId())).collect(Collectors.toMap(o -> o.getName() + o.getTenantId(), Function.identity(), (existingValue, newValue) -> existingValue, LinkedHashMap::new));
        nameMap.forEach((name, config) -> config.setRelationAppIds((List)nameTenantIdAppIdListMap.getOrDefault(config.getName(), Collections.emptyMap()).get(config.getTenantId())));
        return Lists.newArrayList(nameMap.values());
    }

    @Override
    public List<Application> postAllApplications() {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"version").is((Object)"2.0");
        query.addCriteria((CriteriaDefinition)criteria);
        query.fields().include("code");
        query.fields().include("name");
        query.fields().include("description");
        query.fields().include("lang");
        query.fields().include("version");
        List applicationList = this.mongoTemplate.find(query, Application.class);
        return org.apache.commons.collections.CollectionUtils.isEmpty((Collection)applicationList) ? Collections.emptyList() : this.dataPickService.excludeWithSameCode(applicationList);
    }

    @Override
    public Object postApplicationRelationByTypeAndCode(String tenantId, String type, String code) throws DWBusinessException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("code", code);
        data.put("appCode", "");
        HashMap<String, String> convertType = new HashMap<String, String>();
        convertType.put("project", "task");
        convertType.put("task", "activity");
        convertType.put("monitorRule", "monitorRule");
        String codeType = (String)convertType.get(type);
        try {
            if (StringUtils.isEmpty((CharSequence)codeType) && Objects.equals("action", type)) {
                Optional<Action> actionOptional;
                List actions = this.dataPickService.excludeWithSameCode(this.actionRepository.findByActionId(code));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(actions) && (actionOptional = actions.stream().filter(list -> Objects.equals(list.getVersion(), "1.0")).findFirst()).isPresent()) {
                    data.put("appCode", actionOptional.get().getNameSpace());
                }
            } else if (Objects.equals("monitorRule", type)) {
                Optional<MonitorRule> monitorRuleOptional;
                List<MonitorRule> monitorRules = this.dataPickService.excludeWithSameCodeAndFilterTenant(this.monitorRuleRepository.findByCodeAndVersion(code, "1.0"), tenantId);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(monitorRules) && (monitorRuleOptional = monitorRules.stream().filter(list -> Objects.equals(list.getVersion(), "1.0")).findFirst()).isPresent()) {
                    data.put("appCode", monitorRuleOptional.get().getNameSpace());
                }
            } else {
                List<String> codes = Collections.singletonList(code);
                HashMap<String, String> profile = new HashMap<String, String>();
                profile.put("tenantId", tenantId);
                DWServiceContext.getContext().setProfile(profile);
                profile.put("tenantId", tenantId);
                ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().type(codeType).codes(codes).lang(AthenaUtils.getCurrentLocale()).build();
                Map<String, List<ApplicationRelation>> relationsMap = this.postApplicationRelationsMapByTypeAndCodesAndLang(queryDTO);
                Optional relations = relationsMap.entrySet().stream().map(Map.Entry::getValue).filter(list -> !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)).flatMap(Collection::stream).findFirst();
                if (relations.isPresent()) {
                    data.put("appCode", ((ApplicationRelation)relations.get()).getAppCode());
                }
            }
        }
        catch (Exception e) {
            log.error("postApplicationRelationByTypeAndCode error:{}", (Throwable)e);
        }
        return data;
    }

    @Override
    public Object postApplicationRelationByDDSM(AppRelationBatchPo request) throws DWBusinessException {
        String version = this.kmService.tenantVersion(null);
        List applicationRelations = request.getList();
        String applicationRelationStr = this.dataMapTranslateUtils.translateContent(applicationRelations);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(applicationRelations = JSONArray.parseArray((String)applicationRelationStr, ApplicationRelation.class)))) {
            for (ApplicationRelation applicationRelation : applicationRelations) {
                Query query = new Query();
                Criteria criteria = Criteria.where((String)"type").is((Object)applicationRelation.getType()).and("code").is((Object)applicationRelation.getCode()).and("appCode").is((Object)applicationRelation.getAppCode()).and("version").is((Object)version);
                query.addCriteria((CriteriaDefinition)criteria);
                List applicationRelationList = this.mongoTemplate.find(query, ApplicationRelation.class);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)applicationRelationList)) {
                    this.mongoTemplate.remove(query, ApplicationRelation.class);
                }
                this.mongoTemplate.save((Object)applicationRelation);
            }
        }
        return "success";
    }

    @Override
    public List<Map<String, String>> postQueryApplicationsNameByCodeList(List<String> codes, Integer appType) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").in(codes).and("appType").is((Object)appType);
        List applications = this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), Application.class);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)applications)) {
            return result;
        }
        applications.forEach(app -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("code", app.getCode());
            data.put("name", app.getName());
            data.put("version", app.getVersion());
            result.add(data);
        });
        return result;
    }

    @Override
    public Application getAppByMechanismCode(String mechanismCode) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        if (appCodes.isEmpty()) {
            throw new DWBusinessException(String.format("authorizations Application is empty, mechanismCode: %s, tenantId: %s", mechanismCode, tenantId));
        }
        ApplicationRelation relation = this.dataPickService.findOneByCondition(Criteria.where((String)"type").is((Object)"mechanism").and("code").is((Object)mechanismCode).and("appCode").in(appCodes).and("version").is((Object)tenantVersion), ApplicationRelation.class, "applicationRelation");
        if (relation == null) {
            throw new DWBusinessException("applicationRelation is empty, mechanismCode: " + mechanismCode);
        }
        Criteria criteria = Criteria.where((String)"code").is((Object)relation.getAppCode()).and("version").is((Object)tenantVersion);
        Application application = this.dataPickService.findOneByCondition(criteria, Application.class, "application");
        if (application == null) {
            throw new DWBusinessException("application is empty, code: " + relation.getAppCode());
        }
        return application;
    }

    @Override
    public Application getAppByActivityId(String activityId) throws DWBusinessException {
        ApplicationRelation relation = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)activityId), ApplicationRelation.class, "applicationRelation");
        if (relation == null) {
            throw new DWBusinessException("applicationRelation is empty, activityId: " + activityId);
        }
        Criteria criteria = Criteria.where((String)"code").is((Object)relation.getAppCode());
        Application application = this.dataPickService.findOneByCondition(criteria, Application.class, "application");
        if (application == null) {
            throw new DWBusinessException("application is empty, code: " + relation.getAppCode());
        }
        return application;
    }

    @Override
    public Object postCheckAppExpire(CheckAppExpirePo po) throws DWBusinessException {
        List<String> appCodes;
        ApplicationRelation applicationRelation = this.knowledgeGraphService.relation(po.getCode(), po.getType());
        if (null != applicationRelation && !(appCodes = this.kmService.userAuthApps()).contains(applicationRelation.getAppCode())) {
            throw new DWBusinessException("RELATED_APP_EXPIRED", applicationRelation.getAppName());
        }
        return null;
    }

    public List<String> getActivityCode(String tenantId) throws DWBusinessException {
        List<String> appCodes = this.dataMapTenantService.getAppCodes();
        Criteria criteria = Criteria.where((String)"type").in(new Object[]{"task", "activity"}).and("appCode").in(appCodes);
        List<ApplicationRelation> relations = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return relations.stream().map(s -> s.getCode()).collect(Collectors.toList());
    }
}

