/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.actions.ActionReq;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.actions.ErpAdapter;
import com.digiwin.athena.datamap.povo.ErpClean;
import com.digiwin.athena.datamap.povo.EspField;
import com.digiwin.athena.datamap.povo.GenericRequest;
import com.digiwin.athena.datamap.povo.Tag;
import com.digiwin.athena.datamap.povo.TagEntity;
import com.digiwin.athena.datamap.service.IErpService;
import com.digiwin.athena.datamap.service.impl.DataMapActionService;
import com.digiwin.athena.datamap.service.impl.DatamapAppService;
import com.digiwin.athena.datamap.service.impl.GenericService;
import com.digiwin.athena.datamap.service.inner.DataMapHelpService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.datamap.spi.DataMapTagSystemService;
import com.digiwin.athena.datamap.spi.DdsmService;
import com.digiwin.athena.datamap.spi.MdcService;
import com.digiwin.athena.datamap.utils.CommonUtils;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.approve.ApproveDecision;
import com.digiwin.athena.domain.core.approve.ApproveDecisionVariable;
import com.digiwin.athena.domain.core.approve.ApproveInfo;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.erp.Erp2DataDTO;
import com.digiwin.athena.domain.erp.Erp2FormDTO;
import com.digiwin.athena.domain.erp.Erp2FormField;
import com.digiwin.athena.domain.erp.Erp2FormInfo;
import com.digiwin.athena.domain.erp.ErpEntity;
import com.digiwin.athena.domain.erp.ErpField;
import com.digiwin.athena.domain.erp.ErpSyncBill;
import com.digiwin.athena.domain.erp.ErpSyncRecord;
import com.digiwin.athena.domain.erp.NameValue;
import com.digiwin.athena.dto.AppRelation2;
import com.digiwin.athena.kg.dto.AppRelationBatchPo;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.common.AttachmentType;
import com.google.gson.Gson;
import io.seata.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.bson.Document;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Lang
@MyExceptionHandler
@Service
public class ErpService
implements IErpService {
    private static final Logger log = LoggerFactory.getLogger(ErpService.class);
    public static final String applicationTemplate = "DDSM";
    public static final String uibootcachePattern = "uibot:cache:*";
    public static final String separator = "-";
    @Autowired(required=false)
    @Qualifier(value="dataMapTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    PluginService pluginService;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactory1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryFordomain2")
    SessionFactory sessionFactory2;
    @Autowired
    DataMapTagSystemService dataMapTagSystemService;
    @Autowired
    DataPickService dataPickService;
    @Autowired
    DataMapHelpService dataMapHelpService;
    @Autowired
    MdcService mdcService;
    @Autowired
    private List<ErpAdapter> erpAdapters;
    @Autowired
    DdsmService ddsmService;
    @Autowired
    GenericService genericService;
    @Autowired
    DataMapActionService dataMapActionService;
    @Autowired
    KmService kmService;
    @Autowired
    DatamapAppService datamapAppService;
    private static final String ICD = "ICD";

    @Override
    public Object postSync(ErpSyncBill bill) throws DWException {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        if (log.isInfoEnabled()) {
            log.info("begin to sync erp config bill:{}", (Object)bill);
        }
        String tenantId = ServiceUtils.getTenantId();
        String uid = bill.getProjectCode();
        if (null == uid) {
            throw new DWArgumentException("projectCode", I18nUtils.getValue((String)"datamap.erp.projectEmpty", (Object[])new Object[0]));
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("recordId").is((Object)uid));
        ErpSyncRecord event = (ErpSyncRecord)this.mongoTemplate.findOne(query, ErpSyncRecord.class, this.tenantCol(ErpSyncRecord.class));
        this.initBill(bill, event);
        if (event == null) {
            event = new ErpSyncRecord();
            event.setRecordId(uid);
            event.setPluginId(uid);
            event.setTenantId(tenantId);
            event.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            event.setBill(bill);
            event.setStatus(Integer.valueOf(1));
            event.setProjectCode(uid);
            event.setApproveTaskCode(uid + "_Approve");
            event.setTaskActionId(uid + "_taskQueryDataAction");
            event.setProjectActionId(uid + "_projectQueryDataAction");
            this.createData(event);
        } else {
            this.updateData(event, bill);
            List<String> codes = this.kmService.getCodeByTypeAndAppCode("task", "EAS");
            if (CollectionUtils.isEmpty(codes) || CollectionUtils.isNotEmpty(codes) && !codes.contains(event.getProjectCode())) {
                ArrayList<AppRelation2> applicationRelationList = new ArrayList<AppRelation2>();
                this.saveDdsmApplicationRelation(applicationRelationList, event.getProjectCode(), "task");
                this.saveDdsmApplicationRelation(applicationRelationList, event.getApproveTaskCode(), "activity");
                if (CollectionUtils.isNotEmpty(applicationRelationList)) {
                    AppRelationBatchPo po = new AppRelationBatchPo();
                    List list2 = JSON.parseArray((String)JSON.toJSONString(applicationRelationList), ApplicationRelation.class);
                    po.setList(list2);
                    this.datamapAppService.postApplicationRelationByDDSM(po);
                }
            }
        }
        this.checkPrimaryDetail(event);
        event.setStatus(Integer.valueOf(1));
        event.setFormData(this.fillFormData(bill));
        this.mongoTemplate.save((Object)event, this.tenantCol(ErpSyncRecord.class));
        this.updateApprove(event);
        this.updateActions(event);
        this.updateTags(event);
        if (log.isInfoEnabled()) {
            log.info("sync success");
        }
        resp.put("projectCode", event.getProjectCode());
        resp.put("recordId", uid);
        resp.put("success", true);
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)Update.update((String)"status", (Object)2), ErpSyncRecord.class, this.tenantCol(ErpSyncRecord.class));
        return resp;
    }

    @Override
    public Object postUpdatePageView(List<String> list) throws DWException {
        int batchSize = 100;
        Query query = new Query();
        if (list != null && !list.isEmpty()) {
            Criteria criteria = Criteria.where((String)"projectCode").in(list);
            query.addCriteria((CriteriaDefinition)criteria);
        }
        int page = 0;
        boolean hasMoreData = true;
        while (hasMoreData) {
            PageRequest pageable = PageRequest.of((int)page, (int)batchSize);
            query.with((Pageable)pageable);
            List batch = this.mongoTemplate.find(query, ErpSyncRecord.class, this.tenantCol(ErpSyncRecord.class));
            hasMoreData = batch.size() == batchSize;
            this.processBatch(batch);
            ++page;
        }
        return null;
    }

    private void processBatch(List<ErpSyncRecord> batch) {
        log.warn("Processing batch with " + batch.size() + " documents");
        for (ErpSyncRecord event : batch) {
            if (null == event || StringUtils.isEmpty((Object)event.getProjectCode()) || null == event.getBill() || null == event.getBill().getEntity() || event.getBill().getEntity().getDetail().isEmpty()) continue;
            String projectCode = event.getProjectCode();
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)(projectCode + "_Approve")));
            List pageViews = this.mongoTemplate.find(query, Document.class, this.tenantCol(PageView.class));
            if (!CollectionUtils.isNotEmpty((Collection)pageViews)) continue;
            List detail = event.getBill().getEntity().getDetail();
            ArrayList<Map<String, Object>> taskGridSettings = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> projectGridSettings = new ArrayList<Map<String, Object>>();
            for (ErpEntity entity : detail) {
                HashMap<String, String> taskGridsettingObj = new HashMap<String, String>();
                HashMap<String, String> projectGridsettingObj = new HashMap<String, String>();
                taskGridsettingObj.put("gridPath", "task_query_data");
                taskGridsettingObj.put("gridSchema", entity.getEntity_key());
                taskGridsettingObj.put("height", "220");
                taskGridSettings.add(taskGridsettingObj);
                projectGridsettingObj.put("gridPath", "project_query_data");
                projectGridsettingObj.put("gridSchema", entity.getEntity_key());
                projectGridsettingObj.put("height", "220");
                projectGridSettings.add(projectGridsettingObj);
            }
            for (Document document : pageViews) {
                try {
                    Map pagesMap = MapUtils.getMap((Map)document, (Object)"pages", null);
                    if (null != pagesMap) {
                        Map taskDetailMap = MapUtils.getMap((Map)pagesMap, (Object)"task-detail", null);
                        Map projectDetailMap = MapUtils.getMap((Map)pagesMap, (Object)"project-detail", null);
                        if (MapUtils.isNotEmpty((Map)taskDetailMap)) {
                            this.buildGridsettings(taskDetailMap, taskGridSettings);
                        }
                        if (MapUtils.isNotEmpty((Map)projectDetailMap)) {
                            this.buildGridsettings(projectDetailMap, projectGridSettings);
                        }
                    }
                    this.mongoTemplate.save((Object)document, this.tenantCol(PageView.class));
                }
                catch (Exception e) {
                    String code = MapUtils.getString((Map)document, (Object)"code", null);
                    log.warn("updatePageView fail,code:{},error:{}", (Object)code, (Object)e);
                }
            }
        }
    }

    private String tenantCol(Class c) {
        return this.dataPickService.tenantCol(c);
    }

    private void buildGridsettings(Map taskDetailMap, List<Map<String, Object>> gridSettings) {
        List dataStates = taskDetailMap.getOrDefault("dataStates", null);
        if (null != dataStates) {
            dataStates.forEach(dataState -> dataState.put("gridSettings", gridSettings));
        }
    }

    @Override
    public Object postUpdate(ErpSyncRecord record) throws DWException {
        HashMap resp = new HashMap();
        String locale = ServiceUtils.getCurrentLocale();
        if (null == locale) {
            locale = "zh_CN";
        }
        this.checkPrimaryDetail(record);
        this.updateApprove(record);
        this.updateActions(record);
        this.updateTags(record);
        this.updatePageViewByRecord(record, locale);
        record.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        this.mongoTemplate.save((Object)record, this.tenantCol(ErpSyncRecord.class));
        HashMap<String, Object> ddsmParam = new HashMap<String, Object>();
        HashMap<String, String> projectParam = new HashMap<String, String>();
        projectParam.put("projectCode", record.getProjectCode());
        ddsmParam.put("project", projectParam);
        this.ddsmService.ddsmSync(ddsmParam);
        return resp;
    }

    @Override
    public List getRecords() throws DWException {
        String tenantId = ServiceUtils.getTenantId();
        List records = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"bill.program_id"})), ErpSyncRecord.class, this.tenantCol(ErpSyncRecord.class));
        return records;
    }

    @Override
    public Object getRecord(String code) throws DWException {
        String tenantId = ServiceUtils.getTenantId();
        ErpSyncRecord record = (ErpSyncRecord)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("projectCode").is((Object)code)), ErpSyncRecord.class, this.tenantCol(ErpSyncRecord.class));
        return record;
    }

    @Override
    public Object postClean(ErpClean clean) throws DWException {
        List<String> pluginIds = clean.getPluginIds();
        String tenantId = ServiceUtils.getTenantId();
        if (CollectionUtils.isEmpty(pluginIds)) {
            List records = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), ErpSyncRecord.class, this.tenantCol(ErpSyncRecord.class));
            records.forEach(r -> pluginIds.add(r.getPluginId()));
        }
        if (pluginIds.size() > 0) {
            Query queryDelete = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("pluginId").in(pluginIds));
            this.mongoTemplate.remove(queryDelete, DataDescription.class, this.tenantCol(DataDescription.class));
            this.mongoTemplate.remove(queryDelete, DataState.class, this.tenantCol(DataState.class));
            this.mongoTemplate.remove(queryDelete, Project.class, this.tenantCol(Project.class));
            this.mongoTemplate.remove(queryDelete, Task.class, this.tenantCol(Task.class));
            this.mongoTemplate.remove(queryDelete, FlowGraph.class, this.tenantCol(FlowGraph.class));
            this.mongoTemplate.remove(queryDelete, Activity.class, this.tenantCol(Activity.class));
            this.mongoTemplate.remove(queryDelete, PageView.class, this.tenantCol(PageView.class));
            this.mongoTemplate.remove(queryDelete, ErpSyncRecord.class, this.tenantCol(ErpSyncRecord.class));
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantId", tenantId);
            param.put("pluginIds", pluginIds);
            if (null != this.sessionFactory1) {
                Session session1 = this.sessionFactory1.openSession();
                session1.query("match(t:TenantEntity)-[:ACTION]->(a:Action) where t.tenantId=$tenantId and a.pluginId in $pluginIds detach delete a ", param);
            }
            if (null != this.sessionFactory2) {
                Session session2 = this.sessionFactory2.openSession();
                session2.query("match(t:TenantEntity)-[:ACTION]->(a:Action) where t.tenantId=$tenantId and a.pluginId in $pluginIds detach delete a ", param);
            }
            this.dataMapTagSystemService.cleanTags(param);
        }
        return pluginIds;
    }

    protected void initBill(ErpSyncBill bill, ErpSyncRecord event) {
        if (null != bill && null != bill.getEntity() && CollectionUtils.isNotEmpty((Collection)bill.getEntity().getFields())) {
            bill.getEntity().getFields().forEach(f -> {
                if ("Number".equalsIgnoreCase(f.getType())) {
                    f.setAsApproveVariable(Boolean.valueOf(true));
                }
                if (null != event && !StringUtils.isEmpty((Object)event.getTemplate())) {
                    f.setVisible(Boolean.valueOf(false));
                }
            });
            if (null != event && null != event.getTemplate() && CollectionUtils.isNotEmpty((Collection)bill.getEntity().getDetail())) {
                for (ErpEntity entity : bill.getEntity().getDetail()) {
                    for (ErpField field : entity.getFields()) {
                        field.setVisible(Boolean.valueOf(false));
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)entity.getDetail())) continue;
                    for (ErpEntity detail2 : entity.getDetail()) {
                        for (ErpField field : detail2.getFields()) {
                            field.setVisible(Boolean.valueOf(false));
                        }
                    }
                }
            }
            if (null != event && null != event.getTemplate()) {
                ErpField action = new ErpField();
                action.setId("action");
                action.setType("string");
                HashMap<String, String> name = new HashMap<String, String>();
                name.put("zh_cn", "\u7b7e\u6838\u7c7b\u578b");
                name.put("zh_tw", "\u7c3d\u6838\u985e\u578b");
                name.put("en_us", "action");
                action.setName(name);
                action.setVisible(Boolean.valueOf(false));
                bill.getEntity().getFields().add(action);
            }
        }
    }

    private void createData(ErpSyncRecord event) {
        this.updateDTDs(event);
    }

    private void updateData(ErpSyncRecord event, ErpSyncBill bill) {
        ErpSyncBill oldBill = event.getBill();
        if (null != oldBill.getEntity() && null != bill.getEntity()) {
            List<ErpField> summary = this.mergeEntity(oldBill.getEntity().getFields(), bill.getEntity().getFields());
            bill.getEntity().setFields(summary);
            if (null != oldBill.getEntity().getDetail() && null != bill.getEntity().getDetail()) {
                HashMap oldEntities = new HashMap();
                oldBill.getEntity().getDetail().forEach(old -> oldEntities.put(old.getEntity_key(), old));
                for (ErpEntity entity : bill.getEntity().getDetail()) {
                    ErpEntity old2 = (ErpEntity)oldEntities.get(entity.getEntity_key());
                    if (null == old2) continue;
                    List<ErpField> detailFields = this.mergeEntity(old2.getFields(), entity.getFields());
                    entity.setFields(detailFields);
                }
            }
        }
        event.setBill(bill);
    }

    private List<ErpField> mergeEntity(List<ErpField> oldFields, List<ErpField> newFields) {
        if (null == oldFields || null == newFields) {
            return newFields;
        }
        HashMap maps = new HashMap();
        newFields.forEach(f -> maps.put(f.getId(), f));
        ArrayList<ErpField> merged = new ArrayList<ErpField>();
        for (ErpField f2 : oldFields) {
            if (!maps.containsKey(f2.getId())) continue;
            ErpField newOne = (ErpField)maps.get(f2.getId());
            newOne.setAsApproveVariable(f2.getAsApproveVariable());
            newOne.setVisible(f2.getVisible());
            merged.add(newOne);
        }
        for (ErpField f2 : newFields) {
            if (merged.contains(f2)) continue;
            merged.add(f2);
        }
        return merged;
    }

    private void checkPrimaryDetail(ErpSyncRecord event) {
        ErpSyncBill bill = event.getBill();
        if (null != bill && null != bill.getEntity() && CollectionUtils.isNotEmpty((Collection)bill.getEntity().getDetail())) {
            ErpEntity primaryDetail = null;
            for (int i = 0; i < bill.getEntity().getDetail().size(); ++i) {
                ErpEntity detail = (ErpEntity)bill.getEntity().getDetail().get(i);
                if (!Boolean.TRUE.equals(detail.getPrimaryEntity())) continue;
                primaryDetail = detail;
                break;
            }
            if (null != primaryDetail) {
                bill.getEntity().getDetail().remove(primaryDetail);
                bill.getEntity().getDetail().add(0, primaryDetail);
            } else {
                ((ErpEntity)bill.getEntity().getDetail().get(0)).setPrimaryEntity(Boolean.valueOf(true));
            }
        }
    }

    public void updateDTDs(ErpSyncRecord event) {
        String locale;
        ArrayList applicationRelationList = new ArrayList();
        boolean stardard = false;
        if (null != event.getTemplate()) {
            stardard = true;
        }
        if (null == (locale = ServiceUtils.getCurrentLocale())) {
            locale = "zh_CN";
        }
        Query queryDelete = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)event.getTenantId()).and("pluginId").is((Object)event.getPluginId()));
        this.mongoTemplate.remove(queryDelete, DataDescription.class, this.tenantCol(ErpSyncRecord.class));
        this.mongoTemplate.remove(queryDelete, DataState.class, this.tenantCol(ErpSyncRecord.class));
        this.mongoTemplate.remove(queryDelete, Project.class, this.tenantCol(ErpSyncRecord.class));
        this.mongoTemplate.remove(queryDelete, Task.class, this.tenantCol(ErpSyncRecord.class));
        this.mongoTemplate.remove(queryDelete, FlowGraph.class, this.tenantCol(ErpSyncRecord.class));
        this.mongoTemplate.remove(queryDelete, Activity.class, this.tenantCol(ErpSyncRecord.class));
        this.mongoTemplate.remove(queryDelete, PageView.class, this.tenantCol(ErpSyncRecord.class));
        List<DataDescription> entities1 = ErpService.entities(event, DataDescription.class);
        entities1.forEach(p -> this.mongoTemplate.save(p, this.tenantCol(DataDescription.class)));
        List<DataState> entities2 = ErpService.entities(event, DataState.class);
        entities2.forEach(p -> this.mongoTemplate.save(p, this.tenantCol(DataState.class)));
        List<Project> entities3 = ErpService.entities(event, Project.class);
        String finalLocale = locale;
        entities3.forEach(p -> {
            if ("user".equalsIgnoreCase(p.getExecuteType())) {
                if (null != event.getBill() && null != event.getBill().getProgram_name()) {
                    p.getLang().put("name", event.getBill().getProgram_name());
                    p.setName((String)event.getBill().getProgram_name().get(finalLocale));
                }
                event.setProjectCode(p.getCode());
                event.setName(p.getName());
                event.setLang(p.getLang());
            }
            this.mongoTemplate.save(p, this.tenantCol(Project.class));
            this.saveDdsmApplicationRelation(applicationRelationList, p.getCode(), "task");
        });
        List<Task> entities4 = ErpService.entities(event, Task.class);
        entities4.forEach(p -> {
            this.mongoTemplate.save(p, this.tenantCol(Task.class));
            this.saveDdsmApplicationRelation(applicationRelationList, p.getCode(), "activity");
            if ("approve".equalsIgnoreCase(p.getType())) {
                event.setApproveTaskCode(p.getCode());
            }
        });
        List<FlowGraph> entities5 = ErpService.entities(event, FlowGraph.class);
        entities5.forEach(p -> this.mongoTemplate.save(p, this.tenantCol(FlowGraph.class)));
        List<Activity> entities6 = ErpService.entities(event, Activity.class);
        entities6.forEach(p -> this.mongoTemplate.save(p, this.tenantCol(Activity.class)));
        List<PageView> entities7 = ErpService.entities(event, PageView.class);
        Map<String, Object> settings = this.getNewSettings(event, locale);
        boolean finalStardard = stardard;
        entities7.forEach(p -> {
            JSONArray dataStates;
            JSONObject projectDatail;
            JSONObject state0;
            JSONArray dataStates2;
            JSONObject taskDatail;
            Map page = p.getPages();
            if (!page.isEmpty() && !settings.isEmpty() && null != (taskDatail = (JSONObject)page.get("task-detail")) && null != (dataStates2 = (JSONArray)taskDatail.get((Object)"dataStates"))) {
                state0 = dataStates2.getJSONObject(0);
                state0.put("settings", (Object)settings);
            }
            if (null != (taskDatail = (JSONObject)page.get("task-detail")) && null != (dataStates2 = (JSONArray)taskDatail.get((Object)"dataStates"))) {
                state0 = dataStates2.getJSONObject(0);
                if (finalStardard && null != p.getPageType() && p.getPageType() == 2) {
                    this.addTabs((PageView)p, (Map)state0, event, "task_query_data");
                }
            }
            if (null != (projectDatail = (JSONObject)page.get("project-detail")) && null != (dataStates = (JSONArray)projectDatail.get((Object)"dataStates"))) {
                JSONObject state02 = dataStates.getJSONObject(0);
                if (finalStardard && null != p.getPageType() && p.getPageType() == 2) {
                    this.addTabs((PageView)p, (Map)state02, event, "project_query_data");
                }
            }
            this.mongoTemplate.save(p, this.tenantCol(PageView.class));
        });
        if (CollectionUtils.isNotEmpty(applicationRelationList)) {
            AppRelationBatchPo po = new AppRelationBatchPo();
            List list2 = JSON.parseArray((String)JSON.toJSONString(applicationRelationList), ApplicationRelation.class);
            po.setList(list2);
            try {
                this.datamapAppService.postApplicationRelationByDDSM(po);
            }
            catch (DWBusinessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void saveDdsmApplicationRelation(List<AppRelation2> applicationRelationList, String code, String type) {
        AppRelation2 applicationRelation = new AppRelation2();
        applicationRelation.setAppName("ERP\u7b7e\u6838");
        applicationRelation.setAppCode("EAS");
        applicationRelation.setApplication("EAS");
        applicationRelation.setCode(code);
        applicationRelation.setType(type);
        applicationRelation.setVersion("2.0");
        applicationRelationList.add(applicationRelation);
    }

    protected void addTabs(PageView pageView, Map state0, ErpSyncRecord event, String prefix) {
        if (null == event.getBill().getEntity() || null == event.getBill().getEntity().getDetail()) {
            return;
        }
        String locale = ServiceUtils.getCurrentLocale();
        ArrayList operations = new ArrayList();
        ArrayList tabs = new ArrayList();
        ArrayList gridSettings = new ArrayList();
        String entity_key = event.getBill().getEntity().getEntity_key();
        for (ErpEntity detail : event.getBill().getEntity().getDetail()) {
            HashMap<String, Object> tab = new HashMap<String, Object>();
            HashMap<String, Object> operation = new HashMap<String, Object>();
            HashMap<String, Object> gridSetting = new HashMap<String, Object>();
            HashMap<String, Map> lang1 = new HashMap<String, Map>();
            String target = prefix + "." + detail.getEntity_key();
            Map entityName = detail.getEntity_name();
            String title = (String)entityName.get(locale.toLowerCase());
            lang1.put("title", entityName);
            tab.put("target", target);
            tab.put("title", title);
            tab.put("lang", lang1);
            tabs.add(tab);
            gridSetting.put("gridPath", prefix);
            gridSetting.put("gridSchema", detail.getEntity_key());
            gridSetting.put("height", 220);
            gridSettings.add(gridSetting);
            operation.put("target", target);
            operation.put("title", title);
            operation.put("lang", lang1);
            operation.put("type", "DRAWER");
            operation.put("mode", "row");
            operation.put("switchData", true);
            ArrayList tabs2 = new ArrayList();
            if (null != detail.getDetail()) {
                for (ErpEntity detail2 : detail.getDetail()) {
                    HashMap<String, Object> tab2 = new HashMap<String, Object>();
                    HashMap<String, Map> lang2 = new HashMap<String, Map>();
                    String target2 = target + "." + detail2.getEntity_key();
                    Map entityName2 = detail2.getEntity_name();
                    String title2 = (String)entityName2.get(locale.toLowerCase());
                    lang2.put("title", entityName2);
                    tab2.put("target", target2);
                    tab2.put("title", title2);
                    tab2.put("lang", lang2);
                    tabs2.add(tab2);
                }
            }
            operation.put("tabs", tabs2);
            if (!CollectionUtils.isNotEmpty(tabs2)) continue;
            operations.add(operation);
        }
        state0.put("gridSettings", gridSettings);
        state0.put("operations", operations);
        state0.put("tabs", tabs);
    }

    public Map<String, Object> getNewSettings(ErpSyncRecord event, String locale) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        if (null == event || null == event.getBill() || null == event.getBill().getEntity() || event.getBill().getEntity().getDetail().isEmpty()) {
            return settings;
        }
        List details = event.getBill().getEntity().getDetail();
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            for (ErpEntity detail : details.subList(1, details.size())) {
                HashMap map = new HashMap();
                map.put("tableTitle", detail.getEntity_name().get(locale.toLowerCase()));
                settings.put(detail.getEntity_key(), map);
            }
        }
        return settings;
    }

    public void updateApprove(ErpSyncRecord event) {
        if (null == event.getBill() || null == event.getBill().getEntity() || null == event.getBill().getEntity().getFields()) {
            return;
        }
        String locale = ServiceUtils.getCurrentLocale();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)event.getTenantId()).and("pluginId").is((Object)event.getPluginId()).and("type").is((Object)"approve"));
        List approveActivities = this.mongoTemplate.find(query, Activity.class, this.tenantCol(Activity.class));
        approveActivities.forEach(activity -> {
            ApproveInfo approve = (ApproveInfo)JSON.parseObject((String)JSON.toJSONString(activity.getConfig().get("approve")), ApproveInfo.class);
            if (null == approve) {
                approve = new ApproveInfo();
            }
            if (null == approve.getDecision()) {
                approve.setDecision(new ApproveDecision());
            }
            ArrayList<ApproveDecisionVariable> ruleVariables = new ArrayList<ApproveDecisionVariable>();
            HashSet<String> keys = new HashSet<String>();
            for (ErpField erpField : event.getBill().getEntity().getFields()) {
                if (!Boolean.TRUE.equals(erpField.getAsApproveVariable())) continue;
                ApproveDecisionVariable variable = new ApproveDecisionVariable();
                variable.setKey(erpField.getId());
                variable.setType(erpField.getType());
                if (null != erpField.getName()) {
                    try {
                        variable.setName((String)erpField.getName().get(locale));
                        if (null == variable.getName()) {
                            variable.setName((String)erpField.getName().get(locale.toLowerCase()));
                        }
                        HashMap<String, Map> lang = new HashMap<String, Map>();
                        lang.put("name", erpField.getName());
                        variable.setLang(lang);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                ruleVariables.add(variable);
                keys.add(variable.getKey());
            }
            if (ruleVariables.size() > 0) {
                if (null == approve.getDecision().getRuleVariableKey() || !keys.contains(approve.getDecision().getRuleVariableKey())) {
                    approve.getDecision().setRuleVariableKey(((ApproveDecisionVariable)ruleVariables.get(0)).getKey());
                }
                approve.getDecision().setRuleVariables(ruleVariables);
                activity.getConfig().put("approve", approve);
                this.mongoTemplate.save(activity, this.tenantCol(Activity.class));
            }
        });
    }

    public void updateActions(ErpSyncRecord event) {
        if (null == event.getBill() || null == event.getBill().getEntity()) {
            return;
        }
        Session session1 = null;
        Session session2 = null;
        if (null != this.sessionFactory1) {
            session1 = this.sessionFactory1.openSession();
        }
        if (null != this.sessionFactory2) {
            session2 = this.sessionFactory2.openSession();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantId", event.getTenantId());
        param.put("pluginId", event.getPluginId());
        if (null != session1) {
            session1.query("match(t:TenantEntity)-[:ACTION]->(a:Action) where t.tenantId=$tenantId and a.pluginId=$pluginId detach delete a ", param);
        }
        if (null != session2) {
            session2.query("match(t:TenantEntity)-[:ACTION]->(a:Action) where t.tenantId=$tenantId and a.pluginId=$pluginId detach delete a ", param);
        }
        String cyhper = ErpService.content(event, "action.cql");
        ErpEntity erpEntity = event.getBill().getEntity();
        EspField data = this.erpFields2EspFields(erpEntity);
        data.setData_name("data");
        List<EspField> attachment = ErpService.entities(event, EspField.class);
        data.getField().addAll(attachment);
        EspField primaryEspDetail = null;
        if (CollectionUtils.isNotEmpty((Collection)erpEntity.getDetail())) {
            for (int i = 0; i < erpEntity.getDetail().size(); ++i) {
                ErpEntity detail = (ErpEntity)erpEntity.getDetail().get(i);
                EspField espDetail = this.erpFields2EspFields(detail);
                if (espDetail == null) continue;
                espDetail.setIs_array(true);
                data.getField().add(espDetail);
                if (Boolean.TRUE.equals(detail.getPrimaryEntity())) {
                    primaryEspDetail = espDetail;
                }
                if (!CollectionUtils.isNotEmpty((Collection)detail.getDetail())) continue;
                for (ErpEntity childDetail : detail.getDetail()) {
                    EspField espChildDetail = this.erpFields2EspFields(childDetail);
                    if (espChildDetail == null) continue;
                    espChildDetail.setIs_array(true);
                    espDetail.getField().add(espChildDetail);
                }
            }
        }
        Gson gson = new Gson();
        String task_response_object = gson.toJson((Object)data).replaceAll("\"", "\\\\\"");
        EspField data2 = this.erpFields2EspFields(erpEntity);
        data2.setData_name("data");
        data2.setIs_array(true);
        if (null != primaryEspDetail) {
            ArrayList<EspField> sorted = new ArrayList<EspField>();
            sorted.addAll(primaryEspDetail.getField());
            sorted.addAll(data2.getField());
            data2.setField(sorted);
        }
        data2.getField().addAll(attachment);
        String project_response_object = gson.toJson((Object)data2).replaceAll("\"", "\\\\\"");
        cyhper = cyhper.replace("#task_response_object#", task_response_object).replace("#project_response_object#", project_response_object);
        String cypher2 = "match(t:TenantEntity) where t.tenantId=$tenantId match(action:Action) where action.pluginId=$pluginId create (t)-[:ACTION]->(action)";
        if (null != session1) {
            session1.query(cyhper, new HashMap());
            session1.query(cypher2, param);
        }
        if (null != session2) {
            session2.query(cyhper, new HashMap());
            session2.query(cypher2, param);
        }
        String actionIds = ErpService.content(event, "actionIds.txt");
        String[] ids = StringUtils.delimitedListToStringArray((String)actionIds, (String)"\n");
        String cypher3 = "match(t:TenantEntity) where t.tenantId=$tenantId match(action:Action) where action.actionId=$actionId merge (t)-[:ACTION]->(action)";
        for (String id : ids) {
            if (StringUtils.isEmpty((Object)id)) continue;
            param.put("actionId", id);
            this.dataMapHelpService.executeCypher(cypher3, param);
        }
    }

    public void updateTags(ErpSyncRecord event) throws DWException {
        ArrayList<TagEntity> tagEntities = new ArrayList<TagEntity>();
        List<TagEntity> staticEntities = ErpService.entities(event, TagEntity.class);
        tagEntities.addAll(staticEntities);
        if (null != event.getBill() && null != event.getBill().getEntity()) {
            ErpEntity entity = event.getBill().getEntity();
            int taskOrder = 10;
            int projectOrder = 10;
            List<TagEntity> taskheader = this.erpEntity2TagFields(taskOrder, event, entity.getFields(), event.getTaskActionId(), "data", "performer__");
            tagEntities.addAll(taskheader);
            taskOrder += taskheader.size() * 10;
            if (null != entity.getDetail()) {
                for (ErpEntity detail : entity.getDetail()) {
                    List<TagEntity> taskdetail = this.erpEntity2TagFields(taskOrder, event, detail.getFields(), event.getTaskActionId(), "data." + detail.getEntity_key(), "performer__");
                    tagEntities.addAll(taskdetail);
                    taskOrder += taskdetail.size() * 10;
                    TagEntity specEntity = new TagEntity();
                    specEntity.setResourceId(event.getTaskActionId());
                    specEntity.setResourceContent(event.getTaskActionId() + ".response.data." + detail.getEntity_key());
                    ArrayList<Tag> tags = new ArrayList<Tag>();
                    Tag tag1 = new Tag();
                    tag1.setCategory("ROLE__ACTIVITY");
                    tag1.setCode("performer__" + event.getApproveTaskCode());
                    tags.add(tag1);
                    specEntity.setTags(tags);
                    tagEntities.add(specEntity);
                    int subDetailOrder = 10;
                    if (null == detail.getDetail() || detail.getDetail().size() <= 0) continue;
                    for (ErpEntity subDetail : detail.getDetail()) {
                        List<TagEntity> subDetails = this.erpEntity2TagFields(subDetailOrder, event, subDetail.getFields(), event.getTaskActionId(), "data." + detail.getEntity_key() + "." + subDetail.getEntity_key(), "performer__");
                        tagEntities.addAll(subDetails);
                        subDetailOrder += subDetails.size() * 10;
                    }
                }
            }
            List<TagEntity> projectHeader = this.erpEntity2TagFields(projectOrder, event, entity.getFields(), event.getProjectActionId(), "data", "charge__");
            tagEntities.addAll(projectHeader);
            projectOrder += projectHeader.size() * 10;
            if (null != entity.getDetail()) {
                for (ErpEntity detail : entity.getDetail()) {
                    if (!Boolean.TRUE.equals(detail.getPrimaryEntity())) continue;
                    List<TagEntity> taskdetail = this.erpEntity2TagFields(projectOrder, event, detail.getFields(), event.getProjectActionId(), "data", "charge__");
                    tagEntities.addAll(taskdetail);
                    break;
                }
            }
        }
        tagEntities.forEach(en -> {
            if (null != en.getResourceContent()) {
                String resourceContent = "{'response': '" + en.getResourceContent() + "'}";
                en.setResourceContent(resourceContent);
            }
        });
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pluginId", event.getPluginId());
        param.put("tagEntities", tagEntities);
        this.dataMapTagSystemService.syncTags(param);
        GenericRequest request = new GenericRequest();
        request.setModule("tagsystem");
        request.setTenantId(ServiceUtils.getTenantId());
        this.genericService.postCleanCache(request);
    }

    private static <T> List<T> entities(ErpSyncRecord event, Class<T> c) {
        String replaced = ErpService.content(event, c.getSimpleName() + ".json");
        List entities = JSON.parseArray((String)replaced, c);
        return entities;
    }

    private static String content(ErpSyncRecord event, String name) {
        String template = applicationTemplate;
        if (null != event.getTemplate()) {
            template = "ddsmtemplates/" + event.getTemplate();
        }
        String files = CommonUtils.loadStream(template + "/" + name);
        String replaced = files.replaceAll("#template_prefix#", event.getRecordId()).replaceAll("#template_tenantId#", event.getTenantId());
        return replaced;
    }

    private EspField erpFields2EspFields(ErpEntity erpEntity) {
        if (null == erpEntity) {
            return null;
        }
        EspField espEntity = new EspField();
        espEntity.setData_name(erpEntity.getEntity_key());
        espEntity.setData_type("object");
        espEntity.setDescription(erpEntity.getEntity_name());
        ArrayList<EspField> espFields = new ArrayList<EspField>();
        espEntity.setField(espFields);
        if (null != erpEntity.getFields()) {
            erpEntity.getFields().forEach(erp -> {
                EspField esp = new EspField();
                esp.setData_name(erp.getId());
                esp.setData_type(this.erpType2EspType(erp.getType()));
                esp.setDescription(erp.getName());
                esp.setEnum_key(erp.getEnum_key());
                espFields.add(esp);
            });
        }
        return espEntity;
    }

    private String erpType2EspType(String erpType) {
        return erpType;
    }

    List<TagEntity> erpEntity2TagFields(int order, ErpSyncRecord event, List<ErpField> erpFields, String actionId, String doc, String tagPrefix) {
        ArrayList<TagEntity> tagEntities = new ArrayList<TagEntity>();
        if (null == erpFields) {
            return tagEntities;
        }
        int step = 10;
        for (ErpField erpField : erpFields) {
            TagEntity tagEntity = new TagEntity();
            tagEntity.setResourceId(actionId);
            tagEntity.setResourceContent(actionId + ".response." + doc + "." + erpField.getId());
            tagEntity.setTags(new ArrayList<Tag>());
            if (Boolean.TRUE.equals(erpField.getVisible())) {
                Tag tag1 = new Tag();
                tag1.setCode(tagPrefix + event.getApproveTaskCode());
                tag1.setCategory("ROLE__ACTIVITY");
                tagEntity.getTags().add(tag1);
                Tag tag2 = new Tag();
                tag2.setCode(tagPrefix + event.getApproveTaskCode() + "__ORDER_" + order);
                tag2.setCategory("ORDER");
                tagEntity.getTags().add(tag2);
                order += step;
            }
            if (null != event && null != event.getTemplate() && "Decimal".equalsIgnoreCase(erpField.getType())) {
                Tag tag3 = new Tag();
                tag3.setCode("BUSINESS_AMOUNT");
                tag3.setCategory("DISPLAY");
                tagEntity.getTags().add(tag3);
                tagEntity.setExtendedInfo(this.getExtendedInfo(erpField.getId()));
            }
            if (tagEntity.getTags().size() <= 0) continue;
            tagEntities.add(tagEntity);
        }
        return tagEntities;
    }

    @Override
    public Erp2FormInfo getErp2FormInfo() throws DWException {
        String erp = this.mdcService.getErp(ServiceUtils.getTenantId());
        if (null == erp) {
            throw new DWBusinessException("\u672a\u627e\u5230\u5f53\u524d\u79df\u6237\u7684erp\u4fe1\u606f");
        }
        ActionReq req = new ActionReq();
        req.setActionId("e10.oapi.easyflow.object.list.data.query.get");
        ActionResp actionResp = this.dataMapActionService.postProcess(req);
        if (Objects.equals(actionResp.getSuccess(), Boolean.FALSE)) {
            erp = ICD;
        }
        Erp2FormInfo info = (Erp2FormInfo)this.dataPickService.findByCode(erp, Erp2FormInfo.class);
        String locale = ServiceUtils.getCurrentLocale();
        if (null != info && !StringUtils.isEmpty((Object)locale)) {
            for (Erp2FormField field : info.getFields()) {
                field.setName((String)((Map)field.getLang().get("name")).get(locale));
                if (!"action".equalsIgnoreCase(field.getKey())) continue;
                List options = field.getOptions();
                for (NameValue option : options) {
                    option.setName((String)((Map)option.getLang().get("name")).get(locale));
                }
            }
        }
        return info;
    }

    @Override
    public Object postCreate(Erp2FormDTO dto) throws DWException {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        String tenantId = ServiceUtils.getTenantId();
        if (null == dto.getErp()) {
            throw new DWBusinessException("erp\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ErpAdapter erpAdapter = this.getErpAdapter(dto.getErp());
        String template = erpAdapter.erpTemplate(dto);
        if (null == template) {
            throw new DWBusinessException("\u6ca1\u6709\u627e\u5230\u5408\u9002\u7684\u6a21\u677f");
        }
        ErpSyncRecord record = this.searchSameRecord(tenantId, dto.getData());
        if (null != record) {
            throw new DWBusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u8bb0\u5f55");
        }
        ErpSyncBill bill = erpAdapter.getMeta(dto);
        String uid = DataMapUtils.uuid();
        ErpSyncRecord event = new ErpSyncRecord();
        event.setRecordId(uid);
        event.setPluginId(uid);
        event.setTenantId(tenantId);
        event.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        event.setFormData(dto.getData());
        event.setStatus(Integer.valueOf(2));
        event.setProjectCode(uid);
        event.setApproveTaskCode(uid + "_Approve");
        event.setTaskActionId(uid + "_taskQueryDataAction");
        event.setProjectActionId(uid + "_projectQueryDataAction");
        event.setTemplate(template);
        this.initBill(bill, event);
        event.setBill(bill);
        if (log.isInfoEnabled()) {
            log.info("begin to sync erp config ErpSyncRecord:{}", (Object)event);
        }
        this.createData(event);
        this.checkPrimaryDetail(event);
        this.updateApprove(event);
        this.updateActions(event);
        this.updateTags(event);
        if (log.isInfoEnabled()) {
            log.info("sync success");
        }
        resp.put("projectCode", event.getProjectCode());
        resp.put("recordId", uid);
        resp.put("success", true);
        this.mongoTemplate.save((Object)event, this.tenantCol(ErpSyncRecord.class));
        HashMap<String, Object> ddsmParam = new HashMap<String, Object>();
        HashMap<String, String> projectParam = new HashMap<String, String>();
        projectParam.put("projectCode", event.getProjectCode());
        ddsmParam.put("project", projectParam);
        this.ddsmService.ddsmSync(ddsmParam);
        return event;
    }

    @Override
    public Object postProjectByData(Erp2DataDTO dto) throws DWException {
        ActionResp actionResp = new ActionResp();
        String tenantId = ServiceUtils.getTenantId();
        String erp = dto.getErp();
        if (null == erp) {
            erp = this.mdcService.getErp(tenantId);
        }
        if (null == erp) {
            actionResp.setSuccess(false);
            actionResp.setMsg("erp\u4e0d\u80fd\u4e3a\u7a7a");
            return actionResp;
        }
        ErpAdapter erpAdapter = this.getErpAdapter(erp);
        List records = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("status").is((Object)2)), ErpSyncRecord.class, this.tenantCol(ErpSyncRecord.class));
        if (records.isEmpty()) {
            actionResp.setSuccess(false);
            actionResp.setMsg("\u6ca1\u6709\u5339\u914d\u5230\u79df\u6237\u8bb0\u5f55");
            return actionResp;
        }
        Erp2FormInfo erp2FormInfo = this.getErp2FormInfo();
        ErpSyncRecord record = erpAdapter.erpProject(dto, records, erp2FormInfo);
        if (null == record) {
            actionResp.setSuccess(false);
            actionResp.setMsg("\u6ca1\u6709\u5339\u914d\u5230\u8bb0\u5f55");
            return actionResp;
        }
        Project project = (Project)this.dataPickService.findByCode(record.getProjectCode(), Project.class);
        this.updatePageView(record, dto);
        actionResp.setSuccess(true);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("project", project);
        data.put("record", record);
        actionResp.setData(data);
        return actionResp;
    }

    @Override
    public Object getUpgradeErp2() throws DWException {
        List records = this.mongoTemplate.findAll(ErpSyncRecord.class, this.tenantCol(ErpSyncRecord.class));
        for (ErpSyncRecord record : records) {
            ErpSyncBill bill = record.getBill();
            if (null == bill || null != record.getTemplate()) continue;
            record.setFormData(this.fillFormData(bill));
            this.mongoTemplate.save((Object)record, this.tenantCol(ErpSyncRecord.class));
        }
        return null;
    }

    private Map<String, NameValue> fillFormData(ErpSyncBill bill) {
        HashMap<String, NameValue> formData = new HashMap<String, NameValue>();
        NameValue program_id = new NameValue();
        program_id.setValue((Object)bill.getProgram_id());
        if (null != bill.getProgram_name()) {
            program_id.setName((String)bill.getProgram_name().get("zh_CN"));
        }
        formData.put("program_id", program_id);
        NameValue doc_type_no = new NameValue();
        doc_type_no.setName(bill.getDoc_type_name());
        doc_type_no.setValue((Object)bill.getDoc_type());
        formData.put("doc_type_no", doc_type_no);
        NameValue source_doc_type = new NameValue();
        source_doc_type.setName(bill.getOrg_type_name());
        source_doc_type.setValue((Object)bill.getOrg_type());
        formData.put("source_doc_type", source_doc_type);
        NameValue op_org_no = new NameValue();
        op_org_no.setName(bill.getOrg_name());
        op_org_no.setValue((Object)bill.getOrg_code());
        formData.put("op_org_no", op_org_no);
        NameValue action = new NameValue();
        action.setName("\u5ba1\u6838");
        action.setValue((Object)"Do");
        formData.put("action", action);
        return formData;
    }

    ErpAdapter getErpAdapter(String erp) throws DWBusinessException {
        for (ErpAdapter adapter : this.erpAdapters) {
            if (!adapter.support(erp)) continue;
            return adapter;
        }
        throw new DWBusinessException("\u672a\u627e\u5230\u5bf9\u5e94\u7684erp\u9002\u914d\u5668\uff1a" + erp);
    }

    protected ErpSyncRecord searchSameRecord(String tenantId, Map<String, NameValue> formData) {
        if (formData.isEmpty()) {
            return null;
        }
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        for (Map.Entry<String, NameValue> m : formData.entrySet()) {
            criteria.and("formData." + m.getKey() + ".value").is(m.getValue().getValue());
        }
        return (ErpSyncRecord)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)criteria), ErpSyncRecord.class, this.tenantCol(ErpSyncRecord.class));
    }

    protected void updatePageView(ErpSyncRecord record, Erp2DataDTO dto) throws DWBusinessException {
        Object category;
        Map attachments = (Map)dto.getData().get("attachment");
        if (attachments.isEmpty() || StringUtils.isEmpty(attachments.get("upload_mode")) || CollectionUtils.isEmpty((Collection)((Collection)attachments.get("data")))) {
            return;
        }
        List attachmentData = (List)attachments.get("data");
        Map categoryMap = (Map)attachmentData.get(0);
        PageView pageView = (PageView)this.dataPickService.findByCode(record.getApproveTaskCode(), PageView.class);
        if (null == pageView) {
            return;
        }
        Map attachment = (Map)pageView.getAttachment();
        if (attachment.isEmpty()) {
            return;
        }
        List configs = (List)attachment.get("configs");
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return;
        }
        Map configsData = (Map)configs.get(0);
        if (configsData.isEmpty()) {
            return;
        }
        if (!categoryMap.isEmpty() && null != (category = categoryMap.get("category"))) {
            List readCategory = (List)configsData.get("readCategory");
            readCategory.add(category);
        }
        configsData.put("type", AttachmentType.getValue((Integer)((Double)attachments.get("upload_mode")).intValue()));
        this.mongoTemplate.save((Object)pageView, this.tenantCol(PageView.class));
    }

    public void updatePageViewByRecord(ErpSyncRecord record, String locale) throws DWBusinessException {
        PageView pageView;
        if (null == record || null == record.getBill() || null == record.getBill().getEntity() || null == record.getBill().getEntity().getDetail()) {
            return;
        }
        boolean stardard = false;
        if (null != record.getTemplate()) {
            stardard = true;
        }
        HashMap settings = new HashMap();
        for (ErpEntity detail : record.getBill().getEntity().getDetail()) {
            if (!Boolean.FALSE.equals(detail.getPrimaryEntity())) continue;
            HashMap map = new HashMap();
            map.put("tableTitle", detail.getEntity_name().get(locale.toLowerCase()));
            settings.put(detail.getEntity_key(), map);
            break;
        }
        if (null == (pageView = (PageView)this.dataPickService.findByCode(record.getApproveTaskCode(), PageView.class))) {
            return;
        }
        boolean finalStardard = stardard;
        Map page = pageView.getPages();
        if (!page.isEmpty()) {
            List dataStates;
            Map projectDatail;
            List dataStates2;
            Map taskDatail = (Map)page.get("task-detail");
            if (null != taskDatail && CollectionUtils.isNotEmpty((Collection)(dataStates2 = (List)taskDatail.get("dataStates")))) {
                Map dataSetings = (Map)dataStates2.get(0);
                if (!settings.isEmpty()) {
                    dataSetings.put("settings", settings);
                }
                if (finalStardard) {
                    this.addTabs(pageView, dataSetings, record, "task_query_data");
                }
            }
            if (null != (projectDatail = (Map)page.get("project-detail")) && CollectionUtils.isNotEmpty((Collection)(dataStates = (List)projectDatail.get("dataStates")))) {
                Map dataSetings = (Map)dataStates.get(0);
                if (finalStardard) {
                    this.addTabs(pageView, dataSetings, record, "project_query_data");
                }
            }
        }
        this.mongoTemplate.save((Object)pageView, this.tenantCol(PageView.class));
    }

    protected Map<String, Object> getExtendedInfo(String fieldName) {
        HashMap<String, Object> extendedInfo = new HashMap<String, Object>();
        HashMap<String, String> queryCurrencyApiReturnFields = new HashMap<String, String>();
        queryCurrencyApiReturnFields.put("query_field", fieldName);
        queryCurrencyApiReturnFields.put("decimal_places_type", "decimal_places_type");
        queryCurrencyApiReturnFields.put("decimal_places", "unit_purchase_price_decimal_places");
        HashMap<String, Object> actionParam = new HashMap<String, Object>();
        actionParam.put("unAddFlag", false);
        actionParam.put("name", "currency_data.currency_no");
        actionParam.put("type", "RAW_ARRAY_PARAS");
        actionParam.put("value", fieldName);
        ArrayList<HashMap<String, Object>> actionParams = new ArrayList<HashMap<String, Object>>();
        actionParams.add(actionParam);
        HashMap<String, Object> tmAction = new HashMap<String, Object>();
        tmAction.put("actionParams", actionParams);
        tmAction.put("actionId", "esp_currency.parameter.data.get");
        tmAction.put("type", "ESP");
        tmAction.put("dispatchBPM", false);
        tmAction.put("sequence", 0.0);
        tmAction.put("defaultAction", false);
        tmAction.put("terminateProcess", false);
        HashMap<String, HashMap<String, Object>> queryCurrencyApi = new HashMap<String, HashMap<String, Object>>();
        queryCurrencyApi.put("tmAction", tmAction);
        extendedInfo.put("currencyField", "");
        extendedInfo.put("queryCurrencyApiReturnFields", queryCurrencyApiReturnFields);
        extendedInfo.put("queryCurrencyApi", queryCurrencyApi);
        extendedInfo.put("cutZero", true);
        return extendedInfo;
    }
}

