/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.IPresetService;
import com.digiwin.athena.datamap.service.impl.GenericService;
import com.digiwin.athena.datamap.spi.DbPresetService;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.preset.dto.PresetDTO;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
@MyExceptionHandler
public class PresetService
implements IPresetService {
    @Autowired
    GenericService genericService;
    @Autowired
    private DbPresetService dbPresetService;

    @Override
    public void put(String colName, PresetDTO content) throws Exception {
        if (StringUtils.isEmpty((CharSequence)colName)) {
            throw new DWArgumentException("colName", I18nUtils.getValue((String)"preset.colNameEmpty", (Object[])new Object[0]));
        }
        HashMap<String, Object> preset = new HashMap<String, Object>();
        String key = content.getKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new DWArgumentException("content", I18nUtils.getValue((String)"preset.contentKeyEmpty", (Object[])new Object[0]));
        }
        preset.put("key", key);
        preset.put("tenantId", content.getTenantId());
        preset.put("content", content.getContent());
        preset.put("name", content.getName());
        preset.put("remark", content.getRemark());
        preset.put("createBy", content.getCreateBy());
        preset.put("createDate", content.getCreateDate());
        preset.put("modifyBy", content.getModifyBy());
        preset.put("modifyDate", content.getModifyDate());
        if (content.getDomain() != null) {
            preset.put("domain", content.getDomain().toString());
        }
        preset.put("domainId", content.getDomainId());
        preset.put("version", content.getVersion());
        try {
            MongoCollection<Document> col = this.dbPresetService.getCollection(colName, "key", "version");
            col.insertOne((Object)new Document(preset));
            this.genericService.delMatch("knowledgegraph:preset*");
        }
        catch (Exception e) {
            throw new DWBusinessException("P.PL.500.0004", e.getLocalizedMessage());
        }
    }

    @Override
    public void delete(String colName, String key, String tenantVersion) throws Exception {
        MongoCollection<Document> col = this.dbPresetService.getCollection(colName, "key", "version");
        col.deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"key", (Object)key), Filters.eq((String)"version", (Object)tenantVersion)}));
        this.genericService.delMatch("knowledgegraph:preset*");
    }

    @Override
    public Object get(String colName, String key) throws Exception {
        Document re = new HashMap();
        MongoCollection<Document> col = this.dbPresetService.getCollection(colName, "key", "version");
        Document doc = (Document)col.find(Filters.eq((String)"key", (Object)key)).projection(Projections.excludeId()).first();
        if (doc != null) {
            re = doc;
        }
        return re;
    }

    @Override
    public Object getQuery(String colName, Map<String, Object> conditions) throws Exception {
        Document doc;
        Document re = new HashMap();
        BasicDBObject sortObj = new BasicDBObject();
        sortObj.put((Object)"createDate", (Object)-1);
        MongoCollection<Document> col = this.dbPresetService.getCollection(colName, "key", "version");
        if (CollectionUtils.isEmpty(conditions)) {
            doc = (Document)col.find().projection(Projections.excludeId()).sort((Bson)sortObj).first();
        } else {
            ArrayList<Bson> con = new ArrayList<Bson>();
            for (Map.Entry<String, Object> entry : conditions.entrySet()) {
                con.add(Filters.eq((String)entry.getKey(), (Object)entry.getValue()));
            }
            doc = (Document)col.find(Filters.and((Bson[])con.toArray(new Bson[0]))).projection(Projections.excludeId()).sort((Bson)sortObj).first();
        }
        if (doc != null) {
            re = doc;
        }
        return re;
    }

    @Override
    public void deleteTanentRule(String colName, String pluginId, String tenantVersion) throws Exception {
        MongoCollection<Document> col = this.dbPresetService.getCollection(colName, "pluginId", "version");
        col.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"pluginId", (Object)pluginId), Filters.eq((String)"version", (Object)tenantVersion)}));
        this.genericService.delMatch("knowledgegraph:preset*");
    }
}

