/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.dao.DataMapActivityDAO;
import com.digiwin.athena.datamap.kg.DataMapMongoEntityBaseDAO;
import com.digiwin.athena.datamap.kg.dto.ActivityDataEntryVO;
import com.digiwin.athena.datamap.kg.dto.TBBReportReplacer;
import com.digiwin.athena.datamap.kg.dto.valueobject.ActivityDataEntryInfoVO;
import com.digiwin.athena.datamap.povo.ApplicationGroup;
import com.digiwin.athena.datamap.povo.ProjectVo;
import com.digiwin.athena.datamap.povo.rebuild.UserComponentDto;
import com.digiwin.athena.datamap.report.DataMapReportManager;
import com.digiwin.athena.datamap.service.IRecordService;
import com.digiwin.athena.datamap.service.impl.DataMapActionService;
import com.digiwin.athena.datamap.service.impl.DataMapMechanismService;
import com.digiwin.athena.datamap.service.impl.DataMapReportConditionService;
import com.digiwin.athena.datamap.service.impl.DataMapTaskService;
import com.digiwin.athena.datamap.service.impl.DataMapTenantService;
import com.digiwin.athena.datamap.service.impl.DatamapAppService;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.datamap.utils.AthenaUtils;
import com.digiwin.athena.datamap.utils.ExcelExporter;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.FunctionCtrl;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.dto.TenantSummaryFieldsDto;
import com.digiwin.athena.kg.action.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.activity.TenantCardTitleDefinition;
import com.digiwin.athena.kg.domain.TenantSummaryField;
import com.digiwin.athena.kg.domain.TenantSummaryFields;
import com.digiwin.athena.kg.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.kg.dto.queryCondition.ReportConditionSetting;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.repository.neo4j.ActivityRepository;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
@Lang
public class RecordService
implements IRecordService {
    private static final Logger log = LoggerFactory.getLogger(RecordService.class);
    public static final String SUMMARY = "summary";
    public static final String BUSINESS_INFO = "businessInfo";
    public static final String SEARCH_KEY = "searchKey";
    public static final String PROJECT_INFO = "projectInfo";
    @Autowired
    @Qualifier(value="kgSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="kgTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    DataMapReportManager dataMapReportManager;
    @Autowired
    KmService kmService;
    @Autowired
    DataMapActionService dataMapActionService;
    @Autowired
    DataMapTenantService dataMapTenantService;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    DataMapKgDataPickService dataPickService;
    @Autowired
    @Lazy
    DatamapAppService applicationService;
    @Autowired
    DataMapTaskService dataMapTaskService;
    @Autowired
    DataMapMongoEntityBaseDAO dataMapMongoEntityBaseDAO;
    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    DataMapReportConditionService dataMapReportConditionService;
    @Autowired
    DataMapIamService dataMapIamService;
    @Autowired
    DataMapMechanismService dataMapMechanismService;
    @Autowired
    private DataMapActivityDAO dataMapActivityDAO;

    @Override
    public Object postTenantTBBReportsByProductCode(TBBReportReplacer reportReplacer) throws Exception {
        String tenantVersion = this.kmService.tenantVersion(reportReplacer.getTenantId());
        this.clearTenantTBBReportsByProductCode(reportReplacer.getProductCode(), reportReplacer.getTenantId(), tenantVersion);
        reportReplacer.setVersion(tenantVersion);
        this.writeNewReportToDB(reportReplacer);
        return null;
    }

    @Override
    public Object getTBBReports(String mode, String productCode) throws Exception {
        List activityDataEntryVOS;
        switch (mode) {
            case "pc": {
                activityDataEntryVOS = (List)this.getActivitiesByPattern("STATEMENT");
                break;
            }
            case "mobile": {
                activityDataEntryVOS = (List)this.getActivitiesByPattern("MOBI-STATEMENT");
                break;
            }
            default: {
                activityDataEntryVOS = (List)this.getActivitiesByPattern("STATEMENT");
            }
        }
        if (CollectionUtils.isEmpty((Collection)activityDataEntryVOS)) {
            return Collections.EMPTY_LIST;
        }
        activityDataEntryVOS = activityDataEntryVOS.stream().filter(activity -> activity.getAppCode() != null && activity.getAppCode().equals(productCode)).collect(Collectors.toList());
        return activityDataEntryVOS;
    }

    @Override
    public Object getBaseDataApplication() throws Exception {
        List<Activity> activities = this.dataMapActivityDAO.getCommonBaseData(ServiceUtils.getTenantId());
        List activityCodes = activities.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().codes(activityCodes).tenantVersion("2.0").build();
        List<ApplicationRelation> applicationRelations = this.applicationService.postApplicationRelationByCodesAndTenantVersion(queryDTO);
        new ExcelExporter().exportToExcel(applicationRelations);
        return applicationRelations;
    }

    @Override
    public Object getStatements(String effect) throws Exception {
        List<ActivityDataEntryVO> infos = this.getActivitiesByPatternOrSubTypeSort("STATEMENT", "statement");
        this.setUserPermissionInfo(infos, effect);
        return infos;
    }

    @Override
    public Object getEntries(String effect) throws Exception {
        List<ActivityDataEntryVO> infos = this.getActivitiesByPatternOrSubTypeSort("DATA_ENTRY", "base_entry");
        this.setUserPermissionInfo(infos, effect);
        return infos;
    }

    @Override
    public Object getPatterns(String effect, String pattern) throws Exception {
        List<ActivityDataEntryVO> infos = this.getActivitiesByPatternOrSubTypeSort(pattern, null);
        this.setUserPermissionInfo(infos, effect);
        return infos;
    }

    @Override
    public List<Activity> postActivityNames(Map<String, Object> query) throws DWBusinessException {
        BasicQuery query1 = BasicQuery.of(query, null);
        query1.setReturnFields(Arrays.asList("code", "name", "lang"));
        List activities = this.dataPickService.find(query1, Activity.class, "activityConfigsBasic", true);
        return activities;
    }

    public List<ActivityDataEntryVO> getActivitiesByPatternOrSubTypeSort(String pattern, String subType) throws Exception {
        List<ActivityDataEntryVO> activitiesByPattern = this.getActivitiesByPatternOrSubType(pattern, subType);
        this.setGroupInfo(activitiesByPattern);
        return activitiesByPattern;
    }

    public List<ActivityDataEntryVO> getActivitiesByPatternOrSubType(String pattern, String subType) throws Exception {
        long start = System.currentTimeMillis();
        log.info("enter getActivitiesByPattern at :{}\uff0c pattern\uff1a{}\uff0c subType\uff1a{}", new Object[]{start, pattern, subType});
        LinkedList<ActivityDataEntryVO> activityDataEntryVOS = new LinkedList<ActivityDataEntryVO>();
        String tenantId = this.kmService.tenantId();
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        UserComponentDto dto = this.kmService.userComponents("activity", subType, localeStr);
        if (null == dto) {
            return activityDataEntryVOS;
        }
        Set<String> codesFiltered = dto.getCodesFiltered();
        List<String> commonAppCodes = dto.getCommonAppCodes();
        Map<String, ApplicationRelation> codeRelations = dto.getCodeRelations();
        String hasGroundEnd = null;
        Object hasGroundEndObj = null;
        try {
            hasGroundEndObj = this.dataMapMechanismService.getVariable("hasGroundEnd", tenantId);
            if (hasGroundEndObj != null) {
                Map hasGroundEndMap = (Map)hasGroundEndObj;
                hasGroundEnd = String.valueOf(hasGroundEndMap.get("hasGroundEnd"));
            }
        }
        catch (Exception e) {
            log.error("getActivitiesByPatternOrSubType error tenantId:{}", (Object)tenantId, (Object)e);
        }
        HashMap<String, Object> query2 = new HashMap<String, Object>();
        query2.put("code", codesFiltered);
        if (null != pattern) {
            query2.put("pattern", pattern);
        }
        List<Activity> activities = this.dataPickService.find(query2, Activity.class, "activityConfigsBasic");
        if (StringUtils.equals((CharSequence)hasGroundEnd, (CharSequence)"N")) {
            Iterator<Activity> iterator = activities.iterator();
            while (iterator.hasNext()) {
                Activity activity = iterator.next();
                if (!Boolean.TRUE.equals(activity.getDependOnGroundEnd())) continue;
                iterator.remove();
            }
        }
        this.filterUc(activities, tenantId);
        for (Activity activityItem : activities) {
            ActivityDataEntryVO dataEntryVO = new ActivityDataEntryVO();
            ApplicationRelation applicationRelation = codeRelations.get(activityItem.getCode());
            String appCode = applicationRelation.getAppCode();
            dataEntryVO.setCode(activityItem.getCode());
            dataEntryVO.setName(activityItem.getName());
            dataEntryVO.setAuthorityPrefix(activityItem.getAuthorityPrefix());
            dataEntryVO.setIfCommon(false);
            dataEntryVO.setCommonApp(false);
            if (commonAppCodes.contains(appCode)) {
                dataEntryVO.setCommonApp(true);
            }
            dataEntryVO.setResCode(activityItem.getResCode());
            dataEntryVO.setCategory(activityItem.getCategory());
            dataEntryVO.setCategoryAbi(activityItem.getCategoryAbi());
            dataEntryVO.setAppCode(appCode);
            dataEntryVO.setAppName(null == applicationRelation ? "\u7f3a\u5c11\u5e94\u7528\u5173\u7cfb\u914d\u7f6e" : applicationRelation.getAppName());
            dataEntryVO.setGroupCode(StringUtils.isEmpty((CharSequence)activityItem.getGroupCode()) ? null : activityItem.getGroupCode());
            dataEntryVO.setSort(null == activityItem.getSequence() ? null : String.valueOf(activityItem.getSequence()));
            dataEntryVO.setSubReport(activityItem.getSubReport());
            dataEntryVO.setLang(activityItem.getLang());
            dataEntryVO.setDisablePrintFlag(activityItem.getDisablePrintFlag());
            dataEntryVO.setDisableExportFlag(activityItem.getDisableExportFlag());
            activityDataEntryVOS.add(dataEntryVO);
        }
        return activityDataEntryVOS;
    }

    @Override
    public Object getActivitiesByPattern(String pattern) throws Exception {
        return this.getActivitiesByPatternOrSubType(pattern, KmService.patternToSubType.get(pattern));
    }

    private Set<String> getCommonAppIds(Map<String, List<ApplicationRelation>> applicationRelationsMap) {
        HashSet<String> commonAppIds = new HashSet<String>();
        applicationRelationsMap.forEach((k, v) -> {
            ApplicationRelation applicationRelation = (ApplicationRelation)v.get(0);
            if (applicationRelation.getCommonApp().booleanValue()) {
                commonAppIds.add(applicationRelation.getAppCode());
            }
        });
        return commonAppIds;
    }

    private Set<String> getCommonAppsIncludedItems(Map<String, List<ApplicationRelation>> applicationRelationsMap) {
        Set<String> appIdSet = this.getCommonAppIds(applicationRelationsMap);
        Set<String> commonAppsIncludedItems = Collections.emptySet();
        if (!CollectionUtils.isEmpty(appIdSet)) {
            commonAppsIncludedItems = new HashSet<String>(this.dataMapIamService.appItems(new ArrayList<String>(appIdSet)));
        }
        Set<String> finalCommonAppsIncludedItems = commonAppsIncludedItems;
        return finalCommonAppsIncludedItems;
    }

    private Map<String, Boolean> getActivityHasGroundEnd(List<Activity> activities) {
        if (CollectionUtils.isEmpty(activities)) {
            return new HashMap<String, Boolean>();
        }
        ArrayList allActivityList = new ArrayList();
        Map<String, List<Activity>> groupByVersionActivityMap = activities.stream().collect(Collectors.groupingBy(e -> e.getVersion() == null ? "" : e.getVersion()));
        Set<Map.Entry<String, List<Activity>>> entries = groupByVersionActivityMap.entrySet();
        for (Map.Entry<String, List<Activity>> entry : entries) {
            List<Activity> value = entry.getValue();
            List activityCodeList = value.stream().map(BaseEntity::getCode).collect(Collectors.toList());
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").in(activityCodeList).and("version").is((Object)entry.getKey()));
            query.fields().include("code").include("dependOnGroundEnd");
            List activityConfig = this.mongoTemplate.find(query, Activity.class, "activityConfigs");
            if (CollectionUtils.isEmpty((Collection)activityConfig)) continue;
            allActivityList.addAll(activityConfig);
        }
        Map<String, Boolean> resultMap = allActivityList.stream().collect(Collectors.toMap(BaseEntity::getCode, e -> BooleanUtils.toBoolean((Boolean)e.getDependOnGroundEnd()), (a, b) -> a));
        return resultMap;
    }

    private void handleTBBTenantReports(String pattern, String tenantId, String tenantVersion, List<Activity> activities, Map<String, String> tbbCodeApplicationMap) {
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        List tbbReportReplacers = this.mongoTemplateUser.find(queryUser, TBBReportReplacer.class, "tbbReports");
        LinkedList tbbActivities = new LinkedList();
        HashSet replaceIdSet = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)tbbReportReplacers)) {
            tbbReportReplacers.forEach(item -> item.getReports().forEach(itemj -> {
                if (pattern.equals("STATEMENT") && itemj.getMode().equals("pc") || pattern.equals("MOBI-STATEMENT") && itemj.getMode().equals("mobile")) {
                    Activity activity = new Activity();
                    activity.setCode(itemj.getId());
                    HashMap<String, Map<String, String>> langMap = new HashMap<String, Map<String, String>>();
                    langMap.put("name", itemj.getName());
                    activity.setLang(langMap);
                    tbbCodeApplicationMap.put(itemj.getId(), item.getProductCode());
                    if (!StringUtils.isEmpty((CharSequence)itemj.getReplaceId())) {
                        replaceIdSet.add(itemj.getReplaceId());
                    }
                    tbbActivities.add(activity);
                }
            }));
        }
        activities = !CollectionUtils.isEmpty(activities) ? activities.stream().filter(activity -> !replaceIdSet.contains(activity.getCode())).collect(Collectors.toList()) : new LinkedList<Activity>();
        if (!CollectionUtils.isEmpty(tbbActivities)) {
            tbbActivities.forEach(tbbActivity -> tbbActivity.setCategory("STATEMENT"));
            activities.addAll(tbbActivities);
        }
    }

    private void filterUc(List<Activity> activities, String tenantId) {
        Iterator<Activity> activityIterator = activities.iterator();
        ArrayList<String> ucCodes = new ArrayList<String>();
        while (activityIterator.hasNext()) {
            Activity activity = activityIterator.next();
            if (null == activity.getInclusionTenant()) continue;
            if (!activity.getInclusionTenant().contains(tenantId)) {
                activityIterator.remove();
                continue;
            }
            if (!activity.getCode().startsWith("UC_")) continue;
            ucCodes.add(activity.getCode().replace("UC_", ""));
        }
    }

    @Override
    public Object getActivitiesInfoByPattern() throws Exception {
        LinkedList activityDataEntryVOS = new LinkedList();
        List<String> appCodes = this.kmService.userAuthApps();
        String localeStr = ServiceUtils.getLocale();
        DWServiceContext context = DWServiceContext.getContext();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        CompletableFuture<List> service1Future = CompletableFuture.supplyAsync(() -> {
            try {
                DWServiceContext.setContext((DWServiceContext)context);
                RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                List baseList = (List)this.getActivitiesByPattern("DATA_ENTRY");
                baseList.forEach(data -> data.setType("baseDataEntry"));
                return baseList;
            }
            catch (Exception e) {
                log.error("getActivitiesInfoByPattern error:{}", (Throwable)e);
                return new ArrayList();
            }
        });
        CompletableFuture<List> service2Future = CompletableFuture.supplyAsync(() -> {
            try {
                DWServiceContext.setContext((DWServiceContext)context);
                RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                List reportList = (List)this.getActivitiesByPattern("STATEMENT");
                reportList.forEach(data -> data.setType("statement"));
                return reportList;
            }
            catch (Exception e) {
                log.error("getActivitiesInfoByPattern error:{}", (Throwable)e);
                return new ArrayList();
            }
        });
        CompletableFuture<List> service3Future = CompletableFuture.supplyAsync(() -> {
            try {
                DWServiceContext.setContext((DWServiceContext)context);
                RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                List<ProjectVo> jsonObjectList = this.dataMapTaskService.getManualList();
                return jsonObjectList;
            }
            catch (Exception e) {
                log.error("getActivitiesInfoByPattern error:{}", (Throwable)e);
                return new ArrayList();
            }
        });
        CompletableFuture<Void> allOf = CompletableFuture.allOf(service1Future, service2Future, service3Future);
        LinkedList resultList = new LinkedList();
        ((CompletableFuture)allOf.thenRun(() -> {
            try {
                RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                List baseList = (List)service1Future.join();
                List reportList = (List)service2Future.join();
                List jsonObjectList = (List)service3Future.join();
                ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().appCodes(appCodes).type("task").build();
                List<ApplicationRelation> applicationRelationList = this.applicationService.postApplicationRelationByTypeAndAppCodes(queryDTO);
                Map<String, List<ApplicationRelation>> map = applicationRelationList.stream().collect(Collectors.groupingBy(BaseEntity::getCode));
                for (ProjectVo jsonObject : jsonObjectList) {
                    List<ApplicationRelation> applicationRelations = map.get(jsonObject.getCode());
                    if (CollectionUtils.isEmpty(applicationRelations)) continue;
                    List handlerList = applicationRelations.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ApplicationRelation>(Comparator.comparing(BaseEntity::getCode))), ArrayList::new));
                    handlerList.forEach(applicationRelation -> {
                        ActivityDataEntryVO activityDataEntryVO = new ActivityDataEntryVO();
                        activityDataEntryVO.setAppCode(null == applicationRelation ? null : applicationRelation.getAppCode());
                        activityDataEntryVO.setAppName(null == applicationRelation ? "\u7f3a\u5c11\u5e94\u7528\u5173\u7cfb\u914d\u7f6e" : applicationRelation.getAppName());
                        activityDataEntryVO.setName(ServiceUtils.localeName((Object)((Object)jsonObject), (String)"name", (String)localeStr));
                        activityDataEntryVO.setCode(jsonObject.getCode());
                        activityDataEntryVO.setType("manualStartProject");
                        activityDataEntryVO.setCategory(null);
                        activityDataEntryVO.setIfCustom(null);
                        activityDataEntryVOS.add(activityDataEntryVO);
                    });
                }
                activityDataEntryVOS.addAll(baseList);
                activityDataEntryVOS.addAll(reportList);
                Map<String, List<ActivityDataEntryVO>> maps = activityDataEntryVOS.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getAppCode())).collect(Collectors.groupingBy(ActivityDataEntryVO::getAppCode));
                maps.forEach((key, value) -> {
                    LinkedList<ActivityDataEntryInfoVO.ActivityDataEntryInnerVO> activityDataEntryInnerVO = new LinkedList<ActivityDataEntryInfoVO.ActivityDataEntryInnerVO>();
                    ActivityDataEntryInfoVO activityDataEntryVO = new ActivityDataEntryInfoVO();
                    activityDataEntryVO.setAppCode(((ActivityDataEntryVO)((Object)((Object)((Object)value.get(0))))).getAppCode());
                    activityDataEntryVO.setAppName(((ActivityDataEntryVO)((Object)((Object)((Object)value.get(0))))).getAppName());
                    value.forEach(data -> {
                        ActivityDataEntryInfoVO.ActivityDataEntryInnerVO activityDataEntryInner = new ActivityDataEntryInfoVO.ActivityDataEntryInnerVO();
                        activityDataEntryInner.setName(data.getName());
                        activityDataEntryInner.setCode(data.getCode());
                        activityDataEntryInner.setType(data.getType());
                        activityDataEntryInner.setIfCustom(data.getIfCustom());
                        activityDataEntryInner.setCategory(data.getCategory());
                        activityDataEntryInnerVO.add(activityDataEntryInner);
                    });
                    activityDataEntryVO.setData(activityDataEntryInnerVO);
                    resultList.add(activityDataEntryVO);
                });
            }
            catch (Exception e) {
                log.error("getActivitiesInfoByPattern error:{}", (Throwable)e);
            }
        })).join();
        return resultList;
    }

    @Override
    public Object getActivitiesByPatternAndAppCode(String pattern, String appCode) throws Exception {
        List activitiesByPattern = (List)this.getActivitiesByPattern(pattern);
        if (!CollectionUtils.isEmpty((Collection)activitiesByPattern)) {
            Iterator iterator = activitiesByPattern.iterator();
            while (iterator.hasNext()) {
                ActivityDataEntryVO next = (ActivityDataEntryVO)((Object)iterator.next());
                if (StringUtils.equals((CharSequence)next.getAppCode(), (CharSequence)appCode)) continue;
                iterator.remove();
            }
        }
        return activitiesByPattern;
    }

    @Override
    public Object getActivitiesAndSortByPattern(String pattern) throws Exception {
        return this.getActivitiesByPatternOrSubTypeSort(pattern, KmService.patternToSubType.get(pattern));
    }

    @Override
    public Object getActivityDefinition(String activityId, String pageCode) throws Exception {
        Map<String, Object> dm;
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        Activity activity = this.dataPickService.chooseOneWithSameCode(this.dataMapActivityDAO.getActivityByCodeAndVersion(activityId, tenantVersion, tenantId));
        if (null == activity && null != (dm = this.dataMapTaskService.getActivityDefinition(activityId, pageCode))) {
            return dm;
        }
        if (null == activity) {
            return null;
        }
        String activityVersion = activity.getVersion();
        Activity activityPageConfig = this.findBetterActivity(tenantId, activityId, activityVersion);
        if (null != activityPageConfig) {
            if (null != activityPageConfig.getPages()) {
                activityPageConfig.setPages((Map)activityPageConfig.getPages().get(pageCode));
            }
            this.batchSetProductInfo(activityPageConfig.getDataSources(), tenantId);
            this.batchSetProductInfo(activityPageConfig.getPages(), tenantId);
            AthenaUtils.mergeObject(activityPageConfig, activity);
        }
        try {
            ReportConditionSetting setting = this.dataMapReportConditionService.findQueryConditionSetting(tenantId, activityId, tenantVersion);
            if (null != setting && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)setting.getSortData())) {
                this.dealReportSort(activity, setting.getSortData());
            }
        }
        catch (Exception e) {
            log.warn("activity dealReportSort error:", (Throwable)e);
        }
        this.processApplication(activityId, activity);
        try {
            ApplicationRelation applicationRelation = this.applicationService.getApplicationByTypeAndCode("activity", activity.getCode());
            FunctionCtrl functionCtrl = this.applicationService.getApplicationFunctionCtrlByAppCode(applicationRelation.getAppCode());
            boolean cardCustomizeFlag = this.isCardCustom(functionCtrl);
            if (cardCustomizeFlag) {
                this.processSysSummaryFields(activity);
                this.processTenantSummaryFields(activity, pageCode);
            }
        }
        catch (Exception e) {
            log.warn("parse activity error:" + e.getMessage());
            return activity;
        }
        return activity;
    }

    @Override
    public Object getActivityDefinitionBasic(String activityId, String pageCode) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        Activity activity = this.dataPickService.chooseOneWithSameCode(this.dataMapActivityDAO.getActivityByCodeAndVersion(activityId, tenantVersion, tenantId));
        if (null == activity) {
            return null;
        }
        String activityVersion = activity.getVersion();
        Activity activityPageConfig = this.findBetterActivity(tenantId, activityId, activityVersion);
        if (null != activityPageConfig) {
            if (null != activityPageConfig.getPages()) {
                activityPageConfig.setPages((Map)activityPageConfig.getPages().get(pageCode));
            }
            this.batchSetProductInfo(activityPageConfig.getDataSources(), tenantId);
            this.batchSetProductInfo(activityPageConfig.getPages(), tenantId);
            AthenaUtils.mergeObject(activityPageConfig, activity);
        }
        this.processApplication(activityId, activity);
        this.processSysSummaryFields(activity);
        return activity;
    }

    private void clearTenantTBBReportsByProductCode(String productCode, String tenantId, String tenantVersion) throws DWBusinessException {
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion).and("productCode").is((Object)productCode);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        this.mongoTemplateUser.remove(queryUser, "tbbReports");
    }

    private void writeNewReportToDB(TBBReportReplacer reportReplaceDO) {
        this.mongoTemplateUser.insert((Object)reportReplaceDO, "tbbReports");
    }

    public List<ActivityDataEntryVO> postActivitiesGroup(List<ActivityDataEntryVO> requestList) throws Exception {
        log.info("start postActivitiesGroup:{}", (Object)System.currentTimeMillis());
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String lang = locale.toString();
        for (ActivityDataEntryVO vo : requestList) {
            ApplicationGroup applicationGroup;
            Criteria criteria;
            if (!StringUtils.isEmpty((CharSequence)vo.getGroupCode())) {
                criteria = new Criteria();
                criteria.and("appCode").exists(false).and("groupCode").is((Object)vo.getGroupCode()).and("version").is((Object)tenantVersion);
                applicationGroup = (ApplicationGroup)((Object)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), ApplicationGroup.class));
            } else {
                criteria = new Criteria();
                criteria.and("appCode").is((Object)vo.getAppCode()).and("activityCode").is((Object)vo.getCode()).and("version").is((Object)tenantVersion);
                applicationGroup = (ApplicationGroup)((Object)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), ApplicationGroup.class));
                if (null != applicationGroup) {
                    vo.setGroupCode(applicationGroup.getGroupCode());
                }
            }
            if (null == applicationGroup || null == applicationGroup.getLang()) continue;
            vo.setGroupSort(StringUtils.isEmpty((CharSequence)applicationGroup.getGroupSort()) ? null : applicationGroup.getGroupSort());
            HashMap nameLangMap = (HashMap)applicationGroup.getLang().get("groupName");
            if (null == nameLangMap) {
                nameLangMap = applicationGroup.getLang().get("name") == null ? new HashMap() : (Map)applicationGroup.getLang().get("name");
            }
            String language = null == nameLangMap.get(lang) ? applicationGroup.getGroupName() : (String)nameLangMap.get(lang);
            vo.setGroupName(null == language ? applicationGroup.getGroupName() : language);
        }
        log.info("end postActivitiesGroup:{}", (Object)System.currentTimeMillis());
        return requestList;
    }

    private void filterComponentByCode(List<ActivityDataEntryVO> activitiesByPattern, String pattern) throws DWBusinessException {
        if (CollectionUtils.isEmpty(activitiesByPattern)) {
            return;
        }
        List appCodeList = activitiesByPattern.stream().map(ActivityDataEntryVO::getAppCode).distinct().collect(Collectors.toList());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").in(appCodeList).and("tenantId").is((Object)ServiceUtils.getTenantId()));
        List tenantAppComponentListBOS = this.mongoTemplateUser.find(query, TenantAppComponentListBO.class);
        if (!CollectionUtils.isEmpty((Collection)tenantAppComponentListBOS)) {
            Map<String, List> map = tenantAppComponentListBOS.stream().collect(Collectors.toMap(TenantAppComponentListBO::getAppCode, vo -> {
                if (CollectionUtils.isEmpty((Collection)vo.getComponents())) {
                    return new ArrayList();
                }
                return vo.getComponents().stream().filter(v -> v.getType().equals((Object)this.transformPattern(pattern)) && !v.isDisabled()).map(ComponentBaseInfoBO::getCode).distinct().collect(Collectors.toList());
            }, (a, b) -> a));
            Iterator<ActivityDataEntryVO> iterator = activitiesByPattern.iterator();
            while (iterator.hasNext()) {
                List codeList;
                ActivityDataEntryVO next = iterator.next();
                if (!map.containsKey(next.getAppCode()) || CollectionUtils.isEmpty((Collection)(codeList = map.get(next.getAppCode()))) || codeList.contains(next.getCode())) continue;
                iterator.remove();
            }
        }
    }

    private ComponentTypeEnum transformPattern(String pattern) {
        if ("DATA_ENTRY".equals(pattern)) {
            return ComponentTypeEnum.BaseDataEntry;
        }
        if ("STATEMENT".equals(pattern) || "MOBI-STATEMENT".equals(pattern)) {
            return ComponentTypeEnum.Report;
        }
        log.error("not found pattern:{}", (Object)pattern);
        return null;
    }

    public Activity findBetterActivity(String tenantId, String activityCode, String activityVersion) throws DWBusinessException {
        HashMap<String, Object> keyConditions = new HashMap<String, Object>();
        keyConditions.put("code", activityCode);
        Activity defaultActivity = this.dataMapMongoEntityBaseDAO.findOne(keyConditions, activityVersion, Activity.class, "activityConfigs");
        return defaultActivity;
    }

    private void batchSetProductInfo(Map<String, Object> data, String tenantId) throws Exception {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        ArrayList<Map<String, Object>> actionMap = new ArrayList<Map<String, Object>>();
        this.batchMapSetActionMap(data, tenantId, actionMap);
        this.batchSetDataActionProductInfo(actionMap, tenantId);
    }

    private void batchMapSetActionMap(Map<String, Object> data, String tenantId, List<Map<String, Object>> actionMap) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        actionMap.add(data);
        for (Map.Entry<String, Object> item : data.entrySet()) {
            Object value = item.getValue();
            if (value instanceof Map) {
                this.batchMapSetActionMap((Map)value, tenantId, actionMap);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.batchListSetActionMap((List)value, tenantId, actionMap);
        }
    }

    public void batchListSetActionMap(List data, String tenantId, List<Map<String, Object>> actionMap) {
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        for (Object item : data) {
            if (item instanceof Map) {
                this.batchMapSetActionMap((Map)item, tenantId, actionMap);
                continue;
            }
            if (!(item instanceof List)) continue;
            this.batchListSetActionMap((List)item, tenantId, actionMap);
        }
    }

    public void batchSetDataActionProductInfo(List<Map<String, Object>> actions, String tenantId) throws Exception {
        if (CollectionUtils.isEmpty(actions)) {
            return;
        }
        if (CollectionUtils.isEmpty(actions = actions.stream().filter(action -> ObjectUtils.isEmpty(action.get("productName")) && "ESP".equalsIgnoreCase(String.valueOf(action.get("type"))) && StringUtils.isNotEmpty((CharSequence)String.valueOf(action.get("serviceName")))).collect(Collectors.toList()))) {
            return;
        }
        List serviceNames = actions.stream().map(action -> String.valueOf(action.get("serviceName"))).distinct().collect(Collectors.toList());
        Map serviceNameMap = this.productNameResolver.getProductNameMap(tenantId, serviceNames);
        for (Map<String, Object> action2 : actions) {
            action2.put("productName", serviceNameMap.get(String.valueOf(action2.get("serviceName"))));
        }
    }

    private void dealReportSort(Activity activity, List<Map<String, Object>> sortData) {
        Map pages;
        if (activity != null && null != (pages = activity.getPages()) && !CollectionUtils.isEmpty((Collection)((List)pages.get("layout")))) {
            List layoutList = (List)pages.get("layout");
            for (Map layout : layoutList) {
                if (!"FORM_LIST".equals(layout.get("type"))) continue;
                RecordService.processGroup(layout, sortData);
            }
        }
    }

    private static void processGroup(Map<String, Object> layout, List<Map<String, Object>> sortData) {
        List group = (List)layout.get("group");
        if (group != null) {
            Optional<Map> sortItemOpt = sortData.stream().filter(item -> ((String)layout.get("id")).equals(item.get("id"))).findFirst();
            if (sortItemOpt.isPresent()) {
                Map<String, Integer> sortIndexMap = RecordService.createSortIndexMap(sortItemOpt.get());
                group.sort(Comparator.comparingInt(item -> {
                    String pathSchema = (String)item.get("path") + ";" + item.get("schema");
                    return sortIndexMap.getOrDefault(pathSchema, 99999);
                }));
            }
            group.forEach(subItem -> {
                if ("FORM_LIST".equals(subItem.get("type"))) {
                    RecordService.processGroup(subItem, sortData);
                }
            });
        }
    }

    public static Map<String, Integer> createSortIndexMap(Map<String, Object> sortItem) {
        List sortFields = (List)sortItem.get("sortField");
        if (sortFields == null) {
            return new HashMap<String, Integer>();
        }
        return sortFields.stream().collect(Collectors.toMap(field -> field, field -> sortFields.indexOf(field), (existingValue, newValue) -> existingValue));
    }

    private void processApplication(String activityId, Activity activity) throws DWBusinessException {
        if (null != activity) {
            ApplicationRelation applicationRelation = this.applicationService.getApplicationByTypeAndCodeAndLang1("activity", activityId, AthenaUtils.getCurrentLocale());
            if (null != applicationRelation) {
                activity.setApplication(applicationRelation.getAppCode());
                activity.setAppName(applicationRelation.getAppName());
            }
            activity.setActivityId(activityId);
            activity.setActivityName((Object)activity.getName());
            if (null != activity.getLang()) {
                activity.getLang().put("activityName", activity.getLang().get("name"));
            }
        }
    }

    private void processSysSummaryFields(Activity activity) {
        Map pages;
        if (null != activity && !CollectionUtils.isEmpty((Map)(pages = activity.getPages()))) {
            List dataStates = (List)pages.get("dataStates");
            if (!CollectionUtils.isEmpty((Collection)dataStates)) {
                dataStates.forEach(dataState -> {
                    if (SUMMARY.equals(dataState.get("type"))) {
                        activity.setSummary(dataState);
                        activity.setSummaryFields((List)dataState.get("fieldMappings"));
                    }
                    if (BUSINESS_INFO.equals(dataState.get("type"))) {
                        activity.setBusinessInfo(dataState);
                    }
                    if (SEARCH_KEY.equals(dataState.get("type"))) {
                        activity.setSearchKey(dataState);
                    }
                    if (PROJECT_INFO.equals(dataState.get("type"))) {
                        activity.setProjectInfo(dataState);
                    }
                });
                if (!this.checkNewSummary(activity)) {
                    List summaryFields = (List)((Map)dataStates.get(0)).get("summaryFields");
                    activity.setSummaryFields(summaryFields);
                }
            } else {
                List summaryFieldsCandidate = (List)pages.get("summaryFields");
                if (!CollectionUtils.isEmpty((Collection)summaryFieldsCandidate)) {
                    activity.setSummaryFields(summaryFieldsCandidate);
                }
            }
        }
    }

    private void processTenantSummaryFields(Activity activity, String pageCode) throws DWBusinessException {
        if (null != activity) {
            String type;
            String application = activity.getApplication();
            String code = activity.getCode();
            switch (pageCode) {
                case "project-card": {
                    type = "project";
                    break;
                }
                case "task-card": {
                    type = "task";
                    break;
                }
                default: {
                    type = null;
                }
            }
            if (this.checkNewSummary(activity)) {
                this.newProcessTenantSummaryFields(activity, pageCode);
            } else {
                activity.setCanSelectedSummaryFields((List)ObjectUtil.cloneByStream((Object)activity.getSummaryFields()));
                if (type != null && null != application) {
                    TenantSummaryFields tenantSummaryFields = this.queryTenantSummaryFields(application, type, code);
                    if (null != tenantSummaryFields) {
                        boolean ifUseTenantSummaryFields = this.judgeIfUseTenantSummaryFields(tenantSummaryFields, activity.getSummaryFields());
                        boolean ifUseTenantTitle = this.judgeIfUseTenantTitle(tenantSummaryFields);
                        if (ifUseTenantSummaryFields) {
                            if (!CollectionUtils.isEmpty((Collection)tenantSummaryFields.getSummaryFields())) {
                                List<Map<String, Object>> transformedTenantSummaryFields = this.transformTenantFieldsToSys(tenantSummaryFields, activity.getSummaryFields());
                                List<Map<String, Object>> mergedSummaryFields = this.mergeSummaryFields(activity.getSummaryFields(), transformedTenantSummaryFields);
                                Map pages = activity.getPages();
                                if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                                    List dataStates = (List)pages.get("dataStates");
                                    Map dataState = (Map)dataStates.get(0);
                                    dataState.put("summaryFields", mergedSummaryFields);
                                } else {
                                    pages.put("summaryFields", mergedSummaryFields);
                                }
                                activity.setSummaryFields(mergedSummaryFields);
                            }
                            activity.setUsedTenantSummaryFields(Boolean.valueOf(true));
                        } else {
                            activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
                        }
                        if (ifUseTenantTitle && activity.getUsedTenantSummaryFields().booleanValue()) {
                            TenantCardTitleDefinition tenantCardTitleDefinition = new TenantCardTitleDefinition();
                            tenantCardTitleDefinition.setFields(tenantSummaryFields.getTitle());
                            tenantCardTitleDefinition.setTitlePrefix(tenantSummaryFields.getTitlePrefix());
                            activity.setTenantCardTitleDefinition(tenantCardTitleDefinition);
                        }
                        activity.setTenantSummaryFields(this.transformToTenantSummaryFieldsDTO(tenantSummaryFields));
                    } else {
                        activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
                    }
                } else {
                    activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
                }
                this.filterSummaryFields(activity);
            }
        }
    }

    private TenantSummaryFieldsDto transformToTenantSummaryFieldsDTO(TenantSummaryFields tenantSummaryFields) {
        return (TenantSummaryFieldsDto)JSON.parseObject((String)JSON.toJSONString((Object)tenantSummaryFields), TenantSummaryFieldsDto.class);
    }

    private void newProcessTenantSummaryFields(Activity activity, String pageCode) throws DWBusinessException {
        if (null != activity) {
            String type;
            String application = activity.getApplication();
            String code = activity.getCode();
            switch (pageCode) {
                case "project-card": {
                    type = "project";
                    break;
                }
                case "task-card": {
                    type = "task";
                    break;
                }
                default: {
                    type = null;
                }
            }
            List newSummaryFieldes = (List)activity.getSummary().get("fieldMappings");
            activity.setCanSelectedSummaryFields((List)ObjectUtil.cloneByStream((Object)newSummaryFieldes));
            if (type != null && null != application) {
                TenantSummaryFields tenantSummaryFields = this.queryTenantSummaryFields(application, type, code);
                if (null != tenantSummaryFields) {
                    boolean ifUseTenantSummaryFields = this.judgeIfUseTenantSummaryFields(tenantSummaryFields, newSummaryFieldes);
                    boolean ifUseTenantTitle = this.judgeIfUseTenantTitle(tenantSummaryFields);
                    if (ifUseTenantSummaryFields) {
                        if (!CollectionUtils.isEmpty((Collection)tenantSummaryFields.getSummaryFields())) {
                            List<Map<String, Object>> transformedTenantSummaryFields;
                            List<Map<String, Object>> mergedSummaryFields = transformedTenantSummaryFields = this.transformTenantFieldsToSys(tenantSummaryFields, newSummaryFieldes);
                            Map pages = activity.getPages();
                            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                                for (Map dataState : (List)pages.get("dataStates")) {
                                    if (!SUMMARY.equals(dataState.get("type"))) continue;
                                    dataState.put("fieldMappings", mergedSummaryFields);
                                }
                            }
                            activity.setSummaryFields(mergedSummaryFields);
                        }
                        activity.setUsedTenantSummaryFields(Boolean.valueOf(true));
                    } else {
                        activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
                    }
                    if (ifUseTenantTitle && activity.getUsedTenantSummaryFields().booleanValue()) {
                        TenantCardTitleDefinition tenantCardTitleDefinition = new TenantCardTitleDefinition();
                        tenantCardTitleDefinition.setFields(tenantSummaryFields.getTitle());
                        tenantCardTitleDefinition.setTitlePrefix(tenantSummaryFields.getTitlePrefix());
                        activity.setTenantCardTitleDefinition(tenantCardTitleDefinition);
                    }
                    activity.setTenantSummaryFields(this.transformToTenantSummaryFieldsDTO(tenantSummaryFields));
                } else {
                    activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
                }
            } else {
                activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
            }
            this.newFilterSummaryFields(activity);
        }
    }

    private boolean checkNewSummary(Activity activity) {
        return !CollectionUtils.isEmpty((Map)activity.getSummary()) || !CollectionUtils.isEmpty((Map)activity.getBusinessInfo()) || !CollectionUtils.isEmpty((Map)activity.getSearchKey()) || !CollectionUtils.isEmpty((Map)activity.getProjectInfo());
    }

    private boolean isCardCustom(FunctionCtrl functionCtrl) {
        return functionCtrl != null && (functionCtrl.isProjectCardCustomizeFlag() || functionCtrl.isTaskCardCustomizeFlag());
    }

    private TenantSummaryFields queryTenantSummaryFields(String application, String type, String code) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("type").is((Object)type).and("code").is((Object)code).and("application").is((Object)application);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        TenantSummaryFields result = (TenantSummaryFields)this.mongoTemplateUser.findOne(queryUser, TenantSummaryFields.class);
        return result;
    }

    private void newFilterSummaryFields(Activity activity) throws DWBusinessException {
        if (!CollectionUtils.isEmpty((Collection)activity.getSummaryFields()) && !activity.getUsedTenantSummaryFields().booleanValue()) {
            activity.getSummaryFields().removeIf(map -> MapUtils.getBoolean((Map)map, (Object)"defaultEffective", (Boolean)true) == false);
            Map pages = activity.getPages();
            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                for (Map dataState : (List)pages.get("dataStates")) {
                    if (!SUMMARY.equals(dataState.get("type"))) continue;
                    dataState.put("fieldMappings", activity.getSummaryFields());
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)activity.getCanSelectedSummaryFields())) {
            activity.getCanSelectedSummaryFields().removeIf(map -> MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) == false);
        }
        if (!CollectionUtils.isEmpty((Collection)activity.getCanSelectedSummaryFields())) {
            List canSelectedSummaryFields = activity.getCanSelectedSummaryFields();
            List tenantSummaryFieldList = activity.getSummaryFields();
            String locale = Optional.ofNullable(AthenaUtils.getCurrentLocale()).orElse("zh_CN");
            String actionId = MapUtils.getString((Map)((Map)activity.getCanSelectedSummaryFields().get(0)), (Object)"actionId");
            List fields = null;
            if (StringUtils.isNotEmpty((CharSequence)actionId)) {
                try {
                    GetActionLocaleResponseDTO actionLocaleResponseDTO = (GetActionLocaleResponseDTO)this.dataMapActionService.getMetadata(actionId);
                    ApiDataFieldLocaleMetadataDTO data = actionLocaleResponseDTO.getResponse().getData();
                    fields = data.getField();
                }
                catch (Exception e) {
                    throw new DWBusinessException("\u67e5\u8be2\u5143\u6570\u636e\u5b9a\u4e49\u51fa\u9519\uff0cactionId\uff1a{}", actionId);
                }
            }
            activity.getCanSelectedSummaryFields().forEach(field -> {
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"description"))) {
                    Object title = JSONPath.eval((Object)field, (String)"$.tags[0].title");
                    Object localeTitle = JSONPath.eval((Object)field, (String)("$.tags[0].lang.title." + locale));
                    field.put("description", localeTitle != null ? localeTitle : title);
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_name"))) {
                    String value = MapUtils.getString((Map)field, (Object)"value", (String)"");
                    field.put("data_name", value.contains(".") ? value.split("\\.")[1] : "");
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_type"))) {
                    field.put("data_type", "string");
                }
            });
            for (Map tenantSummaryField : tenantSummaryFieldList) {
                boolean b = canSelectedSummaryFields.stream().noneMatch(map -> MapUtils.getString((Map)map, (Object)"value", (String)"").equals(MapUtils.getString((Map)tenantSummaryField, (Object)"value", (String)"")));
                if (!b || !MapUtils.getBoolean((Map)tenantSummaryField, (Object)SUMMARY, (Boolean)true).booleanValue()) continue;
                if (fields != null && fields.size() > 0) {
                    Optional<ApiDataFieldLocaleMetadataDTO> dataName = fields.stream().filter(f -> f.getData_name().equals(MapUtils.getString((Map)tenantSummaryField, (Object)"data_name", (String)""))).findFirst();
                    dataName.ifPresent(apiDataFieldLocaleMetadataDTO -> tenantSummaryField.put("description", apiDataFieldLocaleMetadataDTO.getDescription()));
                }
                canSelectedSummaryFields.add(tenantSummaryField);
            }
        }
    }

    private boolean judgeIfUseTenantSummaryFields(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        }
        if (CollectionUtils.isEmpty(summaryFields)) {
            return false;
        }
        return summaryFields.get(0).get("actionId").equals(tenantSummaryFields.getActionId());
    }

    private boolean judgeIfUseTenantTitle(TenantSummaryFields tenantSummaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        }
        String titlePrefix = tenantSummaryFields.getTitlePrefix();
        List title = tenantSummaryFields.getTitle();
        return !CollectionUtils.isEmpty((Collection)title) || !StringUtils.isEmpty((CharSequence)titlePrefix);
    }

    private List<Map<String, Object>> transformTenantFieldsToSys(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        List tenantSummaryFieldList = tenantSummaryFields.getSummaryFields();
        if (!CollectionUtils.isEmpty((Collection)tenantSummaryFieldList)) {
            ArrayList<Map<String, Object>> sysSummaryFields = new ArrayList<Map<String, Object>>(6);
            for (int i = 0; i < tenantSummaryFieldList.size(); ++i) {
                List values = ((TenantSummaryField)tenantSummaryFieldList.get(i)).getValue();
                for (int j = 0; j < values.size(); ++j) {
                    String fieldPath = (String)values.get(j);
                    Optional<Map> first = summaryFields.stream().filter(map -> fieldPath.equals(MapUtil.getStr((Map)map, (Object)"value"))).findFirst();
                    Map sysSummaryField = Maps.newHashMap();
                    if (first.isPresent()) {
                        sysSummaryField = first.get();
                    }
                    Map sysSummaryFieldCopy = (Map)ObjectUtil.cloneByStream((Object)sysSummaryField);
                    sysSummaryFieldCopy.put(SUMMARY, true);
                    sysSummaryFieldCopy.put("actionId", tenantSummaryFields.getActionId());
                    sysSummaryFieldCopy.put("value", fieldPath);
                    ArrayList tagList = new ArrayList(1);
                    HashMap<String, Object> tag = new HashMap<String, Object>();
                    tag.put("code", "group_" + i);
                    tag.put("title", ((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                    tag.put("customTitle", true);
                    if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)sysSummaryFieldCopy, (Object)"description"))) {
                        sysSummaryFieldCopy.put("description", ((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                        sysSummaryFieldCopy.put("data_type", "string");
                        sysSummaryFieldCopy.put("data_name", fieldPath.contains(".") ? fieldPath.split("\\.")[1] : fieldPath);
                    }
                    if (!tag.containsKey("lang")) {
                        JSONObject lang = new JSONObject();
                        JSONObject titleLang = new JSONObject();
                        titleLang.fluentPut("zh_CN", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle()).fluentPut("zh_TW", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle()).fluentPut("en_US", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                        lang.put("title", (Object)titleLang);
                        tag.put("lang", lang);
                    }
                    tagList.add(tag);
                    sysSummaryFieldCopy.put("tags", tagList);
                    sysSummaryFields.add(sysSummaryFieldCopy);
                }
            }
            return sysSummaryFields;
        }
        return summaryFields;
    }

    private List<Map<String, Object>> mergeSummaryFields(List<Map<String, Object>> summaryFields, List<Map<String, Object>> transformedTenantSummaryFields) {
        if (CollectionUtils.isEmpty(summaryFields)) {
            return transformedTenantSummaryFields;
        }
        ArrayList<Map<String, Object>> mergedSummaryFields = new ArrayList<Map<String, Object>>();
        mergedSummaryFields.addAll(transformedTenantSummaryFields);
        mergedSummaryFields.addAll(summaryFields.stream().filter(map -> MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) == false).collect(Collectors.toList()));
        return mergedSummaryFields;
    }

    private void filterSummaryFields(Activity activity) throws DWBusinessException {
        if (!CollectionUtils.isEmpty((Collection)activity.getSummaryFields()) && !activity.getUsedTenantSummaryFields().booleanValue()) {
            activity.getSummaryFields().removeIf(map -> MapUtils.getBoolean((Map)map, (Object)"defaultEffective", (Boolean)true) == false && MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) != false);
            Map pages = activity.getPages();
            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                List dataStates = (List)pages.get("dataStates");
                Map dataState = (Map)dataStates.get(0);
                dataState.put("summaryFields", activity.getSummaryFields());
            } else {
                pages.put("summaryFields", activity.getSummaryFields());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)activity.getCanSelectedSummaryFields())) {
            activity.getCanSelectedSummaryFields().removeIf(map -> MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) == false);
        }
        if (!CollectionUtils.isEmpty((Collection)activity.getCanSelectedSummaryFields())) {
            List canSelectedSummaryFields = activity.getCanSelectedSummaryFields();
            List tenantSummaryFieldList = activity.getSummaryFields();
            String locale = Optional.ofNullable(AthenaUtils.getCurrentLocale()).orElse("zh_CN");
            String actionId = MapUtils.getString((Map)((Map)activity.getCanSelectedSummaryFields().get(0)), (Object)"actionId");
            List fields = null;
            if (StringUtils.isNotEmpty((CharSequence)actionId)) {
                try {
                    GetActionLocaleResponseDTO actionLocaleResponseDTO = (GetActionLocaleResponseDTO)this.dataMapActionService.getMetadata(actionId);
                    ApiDataFieldLocaleMetadataDTO data = actionLocaleResponseDTO.getResponse().getData();
                    fields = data.getField();
                }
                catch (Exception e) {
                    throw new DWBusinessException("\u67e5\u8be2\u5143\u6570\u636e\u5b9a\u4e49\u51fa\u9519\uff0cactionId\uff1a{}", actionId);
                }
            }
            activity.getCanSelectedSummaryFields().forEach(field -> {
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"description"))) {
                    Object title = JSONPath.eval((Object)field, (String)"$.tags[0].title");
                    Object localeTitle = JSONPath.eval((Object)field, (String)("$.tags[0].lang.title." + locale));
                    field.put("description", localeTitle != null ? localeTitle : title);
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_name"))) {
                    String value = MapUtils.getString((Map)field, (Object)"value", (String)"");
                    field.put("data_name", value.contains(".") ? value.split("\\.")[1] : "");
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_type"))) {
                    field.put("data_type", "string");
                }
            });
            for (Map tenantSummaryField : tenantSummaryFieldList) {
                boolean b = canSelectedSummaryFields.stream().noneMatch(map -> MapUtils.getString((Map)map, (Object)"value", (String)"").equals(MapUtils.getString((Map)tenantSummaryField, (Object)"value", (String)"")));
                if (!b || !MapUtils.getBoolean((Map)tenantSummaryField, (Object)SUMMARY, (Boolean)true).booleanValue()) continue;
                if (null != fields && !fields.isEmpty()) {
                    Optional<ApiDataFieldLocaleMetadataDTO> dataName = fields.stream().filter(f -> f.getData_name().equals(MapUtils.getString((Map)tenantSummaryField, (Object)"data_name", (String)""))).findFirst();
                    dataName.ifPresent(apiDataFieldLocaleMetadataDTO -> tenantSummaryField.put("description", apiDataFieldLocaleMetadataDTO.getDescription()));
                }
                canSelectedSummaryFields.add(tenantSummaryField);
            }
        }
    }

    private void setGroupInfo(List<ActivityDataEntryVO> activitiesByPattern) throws DWBusinessException {
        if (CollectionUtils.isEmpty(activitiesByPattern)) {
            return;
        }
        HashSet<String> groupCodes = new HashSet<String>();
        HashSet<String> activityCodes = new HashSet<String>();
        for (ActivityDataEntryVO vo : activitiesByPattern) {
            if (null != vo.getGroupCode()) {
                groupCodes.add(vo.getGroupCode());
            }
            activityCodes.add(vo.getCode());
        }
        List<ApplicationGroup> applicationGroupsByActivityCode = this.dataPickService.find(Criteria.where((String)"activityCode").in(activityCodes), ApplicationGroup.class, "applicationGroup");
        List<Object> applicationGroupsByGroupCode = new ArrayList();
        if (!groupCodes.isEmpty()) {
            applicationGroupsByGroupCode = this.dataPickService.find(Criteria.where((String)"groupCode").in(groupCodes), ApplicationGroup.class, "applicationGroup");
        }
        HashMap<String, ApplicationGroup> activityCode2Groups = new HashMap<String, ApplicationGroup>();
        HashMap<String, ApplicationGroup> groupCode2Groups = new HashMap<String, ApplicationGroup>();
        for (ApplicationGroup applicationGroup : applicationGroupsByActivityCode) {
            activityCode2Groups.put(applicationGroup.getActivityCode(), applicationGroup);
        }
        for (ApplicationGroup applicationGroup : applicationGroupsByGroupCode) {
            groupCode2Groups.put(applicationGroup.getGroupCode(), applicationGroup);
        }
        for (ActivityDataEntryVO activityDataEntryVO : activitiesByPattern) {
            ApplicationGroup group = null;
            if (null != activityDataEntryVO.getGroupCode()) {
                group = (ApplicationGroup)((Object)groupCode2Groups.get(activityDataEntryVO.getGroupCode()));
            }
            if (null == group) {
                group = (ApplicationGroup)((Object)activityCode2Groups.get(activityDataEntryVO.getCode()));
            }
            if (null == group) continue;
            activityDataEntryVO.setGroupCode(group.getGroupCode());
            activityDataEntryVO.setGroupName(group.getGroupName());
            activityDataEntryVO.setGroupSort(group.getGroupSort());
            if (null == activityDataEntryVO.getLang()) {
                activityDataEntryVO.setLang(new HashMap());
            }
            if (null == group.getLang() || null == group.getLang().get("groupName")) continue;
            activityDataEntryVO.getLang().put("groupName", group.getLang().get("groupName"));
        }
    }

    private void setUserPermissionInfo(List<ActivityDataEntryVO> activitiesByPattern, String effect) throws DWBusinessException {
        if (CollectionUtils.isEmpty(activitiesByPattern)) {
            return;
        }
        HashSet<String> appCodes = new HashSet<String>();
        for (ActivityDataEntryVO vo : activitiesByPattern) {
            if (null == vo.getAuthorityPrefix()) continue;
            try {
                String appCode = vo.getAuthorityPrefix().split(":")[0];
                if (!StringUtils.isNotEmpty((CharSequence)appCode)) continue;
                appCodes.add(appCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Map<String, String> userPermissions = this.kmService.userPermission(appCodes, effect);
        Iterator<ActivityDataEntryVO> iterator2 = activitiesByPattern.iterator();
        while (iterator2.hasNext()) {
            ActivityDataEntryVO project = iterator2.next();
            project.setEffect("allow");
            if (StringUtils.isNotEmpty((CharSequence)project.getAuthorityPrefix()) && !userPermissions.containsKey(project.getCode())) {
                iterator2.remove();
                continue;
            }
            if (Boolean.TRUE.equals(project.getCommonApp()) && StringUtils.isEmpty((CharSequence)project.getAuthorityPrefix())) {
                iterator2.remove();
                continue;
            }
            String eff = userPermissions.get(project.getCode());
            if (StringUtils.isNotEmpty((CharSequence)eff)) {
                project.setEffect(eff);
            }
            if (null == effect || effect.equals(project.getEffect())) continue;
            iterator2.remove();
        }
    }
}

