/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.povo.SearchRequest;
import com.digiwin.athena.datamap.service.ISearchService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.spi.DatamapCacService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Lang
@Service
public class SearchServiceImpl
implements ISearchService {
    @Autowired
    DatamapCacService datamapCacService;
    @Autowired
    IKnowledgeGraphService knowledgeGraphService;
    @Autowired
    DataMapPickService dataMapPickService;

    @Override
    public List<Application> postTenantApps(SearchRequest request) throws DWException {
        String tenantId = ServiceUtils.getTenantId();
        List<String> appCodes = this.datamapCacService.getAuthorizationsApplication(tenantId);
        List<Application> apps = this.knowledgeGraphService.applications(appCodes);
        return apps;
    }

    @Override
    public List<Application> postUserApps(SearchRequest request) throws DWException {
        List<String> appCodes = this.datamapCacService.getAppAuth(null);
        List<Application> apps = this.knowledgeGraphService.applications(appCodes);
        return apps;
    }

    @Override
    public Object postAppProject(SearchRequest request) throws DWException {
        if (null == request.getQuery()) {
            return null;
        }
        String appCode = (String)request.getQuery().get("code");
        if (null == appCode) {
            return null;
        }
        List<ApplicationRelation> relations = this.knowledgeGraphService.relations(appCode, "task");
        List codes = relations.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
        BasicQuery basicQuery = new BasicQuery();
        basicQuery.setQuery(new HashMap());
        basicQuery.getQuery().put("code", codes);
        basicQuery.setEocInfo(request.getEocInfo());
        List projects = this.dataMapPickService.find(basicQuery, Project.class);
        return projects;
    }

    @Override
    public Object postAppTask(SearchRequest request) throws DWException {
        if (null == request.getQuery()) {
            return null;
        }
        String appCode = (String)request.getQuery().get("code");
        if (null == appCode) {
            return null;
        }
        List<ApplicationRelation> relations = this.knowledgeGraphService.relations(appCode, "activity");
        List codes = relations.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
        BasicQuery basicQuery = new BasicQuery();
        basicQuery.setQuery(new HashMap());
        basicQuery.getQuery().put("code", codes);
        basicQuery.setEocInfo(request.getEocInfo());
        List projects = this.dataMapPickService.find(basicQuery, Task.class);
        return projects;
    }
}

