/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.povo.DtdRelatedInfo;
import com.digiwin.athena.datamap.service.ISetService;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.PageView;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class SetService
implements ISetService {
    @Autowired
    @Qualifier(value="dataMapSystem")
    private MongoTemplate mongoTemplate;

    @Override
    public Object postSaveDtdRelatedInfo(DtdRelatedInfo dtdRelatedInfo) throws DWBusinessException {
        try {
            if (null != dtdRelatedInfo && StringUtils.isNotEmpty((CharSequence)dtdRelatedInfo.getProject().getPluginId())) {
                this.deleteDtdRelatedInfo(dtdRelatedInfo.getProject().getPluginId(), dtdRelatedInfo.getVersion());
                this.saveDtdRelatedInfo(dtdRelatedInfo);
            }
        }
        catch (Exception e) {
            throw new DWBusinessException(e.toString());
        }
        return null;
    }

    private void saveDtdRelatedInfo(DtdRelatedInfo dtdRelatedInfo) {
        dtdRelatedInfo.getProject().setApplication(dtdRelatedInfo.getAppCode());
        dtdRelatedInfo.getProject().setAthena_namespace(dtdRelatedInfo.getAppCode());
        this.mongoTemplate.save((Object)dtdRelatedInfo.getProject());
        for (Activity activity : dtdRelatedInfo.getActivityList()) {
            activity.setApplication(dtdRelatedInfo.getAppCode());
            activity.setAthena_namespace(dtdRelatedInfo.getAppCode());
            this.mongoTemplate.save((Object)activity);
        }
        for (DataState dataState : dtdRelatedInfo.getDataStateList()) {
            dataState.setApplication(dtdRelatedInfo.getAppCode());
            dataState.setAthena_namespace(dtdRelatedInfo.getAppCode());
            this.mongoTemplate.save((Object)dataState);
        }
        for (FlowGraph flowGraph : dtdRelatedInfo.getFlowGraphList()) {
            flowGraph.setApplication(dtdRelatedInfo.getAppCode());
            flowGraph.setAthena_namespace(dtdRelatedInfo.getAppCode());
            this.mongoTemplate.save((Object)flowGraph);
        }
        for (PageView pageView : dtdRelatedInfo.getPageViewList()) {
            pageView.setApplication(dtdRelatedInfo.getAppCode());
            pageView.setAthena_namespace(dtdRelatedInfo.getAppCode());
            this.mongoTemplate.save((Object)pageView);
        }
        for (Task task : dtdRelatedInfo.getTaskList()) {
            task.setApplication(dtdRelatedInfo.getAppCode());
            task.setAthena_namespace(dtdRelatedInfo.getAppCode());
            this.mongoTemplate.save((Object)task);
        }
        dtdRelatedInfo.getDataDescription().setApplication(dtdRelatedInfo.getAppCode());
        dtdRelatedInfo.getDataDescription().setAthena_namespace(dtdRelatedInfo.getAppCode());
        this.mongoTemplate.save((Object)dtdRelatedInfo.getDataDescription());
    }

    private void deleteDtdRelatedInfo(String pluginId, String version) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)"SYSTEM").and("pluginId").is((Object)pluginId);
        if (StringUtils.isNotEmpty((CharSequence)version)) {
            criteria.and("version").is((Object)version);
        }
        Query queryDelete = Query.query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(queryDelete, DataDescription.class);
        this.mongoTemplate.remove(queryDelete, DataState.class);
        this.mongoTemplate.remove(queryDelete, Project.class);
        this.mongoTemplate.remove(queryDelete, Task.class);
        this.mongoTemplate.remove(queryDelete, FlowGraph.class);
        this.mongoTemplate.remove(queryDelete, Activity.class);
        this.mongoTemplate.remove(queryDelete, PageView.class);
    }
}

