/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.service.IPluginService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.plugin.PluginBinding;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.dto.BindingResult;
import com.digiwin.athena.dto.TaskPathVo;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.plugins.PluginRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PluginService
implements IPluginService {
    private static final Logger log = LoggerFactory.getLogger(PluginService.class);
    @Autowired
    @Qualifier(value="dataMapSystem")
    protected MongoTemplate mongoTemplate;
    @Autowired(required=false)
    @Qualifier(value="mongoTemplateTenant")
    MongoTemplate mongoTemplateTenant;
    @Autowired
    DataMapPickService dataMapPickService;

    @Override
    public BindingResult postMergePlugin(PluginBindingPo binding) throws DWException {
        List<Project> projects;
        List<Activity> activities;
        List<FlowGraph> flows;
        List<Task> tasks;
        List<DataState> dataStates;
        BindingResult br = new BindingResult();
        if (null == binding.getPluginIds() || null == binding.getTenantId()) {
            br.setSuccess(false);
            br.setMsg("tenantId or pluginIds is null");
            return br;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)binding.getTenantId()).and("pluginId").in((Collection)binding.getPluginIds()));
        List bindings = this.mongoTemplateTenant.find(query, PluginBinding.class);
        List bindedIds = bindings.stream().map(pb -> pb.getPluginId()).collect(Collectors.toList());
        if (!Boolean.TRUE.equals(binding.getForce())) {
            binding.getPluginIds().removeAll(bindedIds);
        }
        if (0 == binding.getPluginIds().size()) {
            br.setSuccess(false);
            br.setMsg("\u6ca1\u6709\u53ef\u7528\u7684pluginIds\uff0c\u4e3a\u7a7a\u6216\u8005\u5df2\u7ed1\u5b9a");
            return br;
        }
        System.out.println("\u5f00\u59cb\u5e94\u7528\u63d2\u4ef6:" + binding.getPluginIds() + " \u5230\u79df\u6237:" + binding.getTenantId());
        this.postRemovePlugin(binding);
        List pluginId = binding.getPluginIds();
        String tenantId = binding.getTenantId();
        List<DataDescription> dataDescs = this.findPluginConfig(pluginId, DataDescription.class, null);
        if (!dataDescs.isEmpty()) {
            dataDescs.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
            });
            this.mongoTemplateTenant.insert(dataDescs, this.dataMapPickService.tenantCol(DataDescription.class));
        }
        if (!(dataStates = this.findPluginConfig(pluginId, DataState.class, null)).isEmpty()) {
            dataStates.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
                br.setChangeMap(true);
            });
            this.mongoTemplateTenant.insert(dataStates, this.dataMapPickService.tenantCol(DataState.class));
        }
        if (!(tasks = this.findPluginConfig(pluginId, Task.class, null)).isEmpty()) {
            tasks.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
                br.setChangeMap(true);
            });
            this.mongoTemplateTenant.insert(tasks, this.dataMapPickService.tenantCol(Task.class));
        }
        if (!(flows = this.findPluginConfig(pluginId, FlowGraph.class, null)).isEmpty()) {
            flows.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
            });
            this.mongoTemplateTenant.insert(flows, this.dataMapPickService.tenantCol(FlowGraph.class));
        }
        if (!(activities = this.findPluginConfig(pluginId, Activity.class, null)).isEmpty()) {
            activities.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
            });
            this.mongoTemplateTenant.insert(activities, this.dataMapPickService.tenantCol(Activity.class));
        }
        if (!(projects = this.findPluginConfig(pluginId, Project.class, null)).isEmpty()) {
            projects.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
            });
            this.mongoTemplateTenant.insert(projects, this.dataMapPickService.tenantCol(Project.class));
        }
        List<Class> classes = PluginService.getTenantMechanismClasses();
        for (Class c : classes) {
            List<TenantObject> objects = this.findPluginConfig(pluginId, c, null);
            if (objects.isEmpty()) continue;
            objects.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
            });
            this.mongoTemplateTenant.insert(objects, this.dataMapPickService.tenantCol(c));
        }
        binding.getPluginIds().forEach(pid -> {
            if (!bindedIds.contains(pid)) {
                PluginBinding pluginBinding = new PluginBinding();
                pluginBinding.setPluginId(pid);
                pluginBinding.setTenantId(binding.getTenantId());
                this.mongoTemplateTenant.save((Object)pluginBinding);
            }
        });
        br.setSuccess(true);
        return br;
    }

    @Override
    public List<TaskPathVo> postRemovePlugin(PluginBindingPo binding) throws DWException {
        if (CollectionUtils.isEmpty((Collection)binding.getPluginIds())) {
            return null;
        }
        Query queryDelete = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)binding.getTenantId()).and("pluginId").in((Collection)binding.getPluginIds()));
        this.mongoTemplateTenant.remove(queryDelete, DataDescription.class, this.dataMapPickService.tenantCol(DataDescription.class));
        this.mongoTemplateTenant.remove(queryDelete, DataState.class, this.dataMapPickService.tenantCol(DataState.class));
        this.mongoTemplateTenant.remove(queryDelete, Task.class, this.dataMapPickService.tenantCol(Task.class));
        this.mongoTemplateTenant.remove(queryDelete, FlowGraph.class, this.dataMapPickService.tenantCol(FlowGraph.class));
        this.mongoTemplateTenant.remove(queryDelete, Activity.class, this.dataMapPickService.tenantCol(Activity.class));
        this.mongoTemplateTenant.remove(queryDelete, Project.class, this.dataMapPickService.tenantCol(Project.class));
        this.mongoTemplateTenant.remove(queryDelete, PageView.class, this.dataMapPickService.tenantCol(PageView.class));
        this.mongoTemplateTenant.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        this.mongoTemplateTenant.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Project.class));
        this.mongoTemplateTenant.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Task.class));
        this.mongoTemplateTenant.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Activity.class));
        List<Class> classes = PluginService.getTenantMechanismClasses();
        for (Class c : classes) {
            this.mongoTemplateTenant.remove(queryDelete, c, this.dataMapPickService.tenantCol(c));
        }
        try {
            this.postRemovePluginSystem(binding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<TaskPathVo> postRemovePluginSystem(PluginBindingPo binding) throws DWException {
        if (CollectionUtils.isEmpty((Collection)binding.getPluginIds())) {
            return null;
        }
        Query queryDelete = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)binding.getTenantId()).and("pluginId").in((Collection)binding.getPluginIds()));
        this.mongoTemplate.remove(queryDelete, DataDescription.class, this.dataMapPickService.tenantCol(DataDescription.class));
        this.mongoTemplate.remove(queryDelete, DataState.class, this.dataMapPickService.tenantCol(DataState.class));
        this.mongoTemplate.remove(queryDelete, Task.class, this.dataMapPickService.tenantCol(Task.class));
        this.mongoTemplate.remove(queryDelete, FlowGraph.class, this.dataMapPickService.tenantCol(FlowGraph.class));
        this.mongoTemplate.remove(queryDelete, Activity.class, this.dataMapPickService.tenantCol(Activity.class));
        this.mongoTemplate.remove(queryDelete, Project.class, this.dataMapPickService.tenantCol(Project.class));
        this.mongoTemplate.remove(queryDelete, PageView.class, this.dataMapPickService.tenantCol(PageView.class));
        this.mongoTemplate.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        this.mongoTemplate.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Project.class));
        this.mongoTemplate.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Task.class));
        this.mongoTemplate.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Activity.class));
        List<Class> classes = PluginService.getTenantMechanismClasses();
        for (Class c : classes) {
            this.mongoTemplate.remove(queryDelete, c, this.dataMapPickService.tenantCol(c));
        }
        return null;
    }

    public <T extends TenantObject> List<T> findPluginConfig(List<String> pluginId, Class<T> c, String col) throws DWBusinessException {
        List r = null;
        r = col != null ? this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)"MECHANISM").and("pluginId").in(pluginId)), c, col) : this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)"MECHANISM").and("pluginId").in(pluginId)), c);
        return r;
    }

    public void removeTenantPlugin(PluginBindingPo binding, String table) {
        Query queryDelete = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)binding.getTenantId()).and("pluginId").in((Collection)binding.getPluginIds()));
        this.mongoTemplateTenant.remove(queryDelete, table);
    }

    public static List<Class> getTenantMechanismClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(MechanismDecision.class);
        classes.add(MechanismDecisionTarget.class);
        classes.add(PageView.class);
        classes.add(PluginRecord.class);
        return classes;
    }
}

