/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.povo.middleware.UserPermission;
import com.digiwin.athena.datamap.supports.TenantApplication;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.kg.authority.AuthorizedUserResult;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DataMapIamService {
    private static final Logger log = LoggerFactory.getLogger(DataMapIamService.class);
    private final String TENANT_APPLICATION = "/api/iam/v2/user/tenant/application";
    private final String APP_ITEMS = "/api/iam/v2/app/action/ids";
    private final String SEND_MESSAGE = "/api/aim/v2/batch/user/message";
    private final String TENANT_ALL_APPLICATION = "/api/iam/v2/tenant/application";
    private final String LOGIN = "/api/iam/v2/identity/login/internal";
    private final String APP_INFO = "/api/iam/v2/app";
    private final String USER = "/api/iam/v2/user/simple";
    private final String POLICY_ACTION = "/api/iam/v2/policy/action";
    private final String USER_PERMISSION2 = "/api/iam/v2/permission/user";
    private final String USER_PERMISSION2_ALL = "/api/iam/v2/permission/users/apps/all";
    private final String USER_ROLE = "/api/iam/v2/user/role";
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${iamUrl}")
    private String iamUrl;
    @Value(value="${iamApToken}")
    private String iamApToken;
    @Value(value="${integrationInternalPasswordHash:6826CC688C4AF1BD0A8DDA2DBDF8897B}")
    private String integrationInternalPasswordHash;

    public String getAthenaLicenceKey() {
        return this.getLicenceKey("Athena");
    }

    public String getAthenaLicenceKey(String tenantId) throws Exception {
        return this.getLicenceKey("Athena", tenantId);
    }

    private String getLicenceKey(String application) {
        List<TenantApplication> tenantApplications = this.listApplications();
        Optional<TenantApplication> any = tenantApplications.stream().filter(e -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)application)).findAny();
        if (any.isPresent()) {
            return any.get().getSecretKey();
        }
        return null;
    }

    private String getLicenceKey(String application, String tenantId) throws Exception {
        List<TenantApplication> tenantApplications;
        Optional<TenantApplication> any;
        Object login = this.login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
        String token = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            token = loginJsonObject.getString("token");
        }
        if ((any = (tenantApplications = this.listApplications(token)).stream().filter(e -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)application)).findAny()).isPresent()) {
            return any.get().getSecretKey();
        }
        log.info("getLicenceKey not found application:{} of tenantId:{}", (Object)application, (Object)tenantId);
        return null;
    }

    private List<TenantApplication> listApplications(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/user/tenant/application", HttpMethod.GET, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        List tenantApplications = JSONObject.parseArray((String)JSON.toJSONString((Object)body), TenantApplication.class);
        return tenantApplications;
    }

    private List<TenantApplication> listApplications() {
        String token = DWServiceContext.getContext().getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/user/tenant/application", HttpMethod.GET, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        List tenantApplications = JSONObject.parseArray((String)JSON.toJSONString((Object)body), TenantApplication.class);
        return tenantApplications;
    }

    public List<String> appItems(List<String> appIds) {
        String token = DWServiceContext.getContext().getToken();
        HttpHeaders headers = new HttpHeaders();
        DataMapUtils.requiredHeaders(headers);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, List<String>> requestMap = new HashMap<String, List<String>>();
        requestMap.put("appIds", appIds);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/app/action/ids", HttpMethod.POST, requestEntity, Map.class, new Object[0]);
        Map body = (Map)resEntity.getBody();
        log.info("appItems response:{}", (Object)body);
        return (List)body.get("data");
    }

    public String getTestIntegrationToken(String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("tenantId", tenantId);
        requestBody.put("userId", "integration");
        requestBody.put("passwordHash", this.integrationInternalPasswordHash);
        requestBody.put("identityType", "token");
        String url = this.iamUrl + "/api/iam/v2/identity/login/internal";
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        JSONObject body = JSON.parseObject((String)JSON.toJSONString((Object)resEntity.getBody()));
        return body.getString("token");
    }

    public Object login(String tenantId) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("userId", "integration");
        requestMap.put("passwordHash", this.integrationInternalPasswordHash);
        requestMap.put("identityType", "token");
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/identity/login/internal", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        return body;
    }

    public String getTenantToken(String tenantId, Object loginResponse) throws Exception {
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)loginResponse));
        String token = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            token = loginJsonObject.getString("token");
        }
        return token;
    }

    public String getTenantToken(String tenantId) throws Exception {
        Object login = this.login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
        String token = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            token = loginJsonObject.getString("token");
        }
        return token;
    }

    public String getTenantType(String tenantId, Object loginResponse) throws Exception {
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)loginResponse));
        String enterpriseTenantType = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            enterpriseTenantType = loginJsonObject.getString("enterpriseTenantType");
        }
        return enterpriseTenantType;
    }

    public Integer getTenantType(String token) throws IOException {
        String apiMetadataUrl = this.iamUrl + "/api/iam/v2/tenant/current";
        try {
            URL restURL = new URL(apiMetadataUrl);
            HttpURLConnection conn = (HttpURLConnection)restURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("digi-middleware-auth-user", token);
            conn.setRequestProperty("digi-middleware-auth-app", this.iamApToken);
            conn.setDoOutput(true);
            JSONObject response = (JSONObject)JSON.parseObject((InputStream)conn.getInputStream(), JSONObject.class, (Feature[])new Feature[0]);
            Integer type = response.getJSONObject("tenant").getInteger("enterpriseType");
            return type;
        }
        catch (Exception e) {
            log.error("http get tenant type error:{}", (Object)e.getMessage());
            throw e;
        }
    }

    public Object startEnterpriseOperation(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap requestMap = new HashMap();
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/app/initialize", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        log.info("startEnterpriseOperation response:{}", body);
        return body;
    }

    public String getIntegrationToken(String tenantId, String appToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", appToken);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("tenantId", tenantId);
        requestBody.put("userId", "integration");
        requestBody.put("passwordHash", this.integrationInternalPasswordHash);
        requestBody.put("identityType", "token");
        String url = this.iamUrl + "/api/iam/v2/identity/login/internal";
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        try {
            ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            JSONObject body = JSON.parseObject((String)JSON.toJSONString((Object)resEntity.getBody()));
            return body.getString("token");
        }
        catch (Exception e) {
            log.info("getUserToken by integration have exception\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    public List<AuthorizedUserResult> getAuthorizedUser(String token, String appCode) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", this.iamApToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/query/" + appCode + "/authorized/user", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        List authorizedUserResultList = JSONObject.parseArray((String)JSON.toJSONString((Object)body), AuthorizedUserResult.class);
        return authorizedUserResultList;
    }

    public Object getUserPermission(String appCode, String userId, String token) {
        if (appCode == null || StringUtils.isEmpty((CharSequence)userId) || StringUtils.isEmpty((CharSequence)token)) {
            throw new RuntimeException(I18nUtils.getValue((String)"knowledgegraph.tokenOrUserMiss", (Object[])new Object[0]));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("userId", userId);
        requestMap.put("sysId", appCode);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/permission/user", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        return body;
    }

    public List<UserPermission> getUserPermission(Set<String> appCodes, String userId, String token, String effect) {
        if (CollectionUtils.isEmpty(appCodes) || StringUtils.isEmpty((CharSequence)userId) || StringUtils.isEmpty((CharSequence)token)) {
            throw new RuntimeException(I18nUtils.getValue((String)"knowledgegraph.tokenOrUserMiss", (Object[])new Object[0]));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        String securityToken = ServiceUtils.getSecurityToken();
        if (null != securityToken) {
            headers.add("security-token", this.iamApToken);
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("userIds", Collections.singletonList(userId));
        requestMap.put("sysIds", appCodes);
        if (StringUtils.isNotEmpty((CharSequence)effect)) {
            requestMap.put("effect", effect);
        }
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ParameterizedTypeReference<List<UserPermission>> typeRef = new ParameterizedTypeReference<List<UserPermission>>(){};
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/permission/users/apps/all", HttpMethod.POST, requestEntity, (ParameterizedTypeReference)typeRef, new Object[0]);
        List body = (List)resEntity.getBody();
        return body;
    }
}

