/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.povo.DapResponse;
import com.digiwin.athena.datamap.povo.GetActionLocaleResponseDTO;
import com.digiwin.athena.datamap.povo.monitorrule.MonitorRuleDTO;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.assign.AdvancedUserDefinitionWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DataMapKgService {
    private static final Logger log = LoggerFactory.getLogger(DataMapKgService.class);
    @Value(value="${thememapUrl}")
    private String tmHost;
    @Autowired
    private DataPickService dataPickService;

    public Object getParadigm(String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mechanismCode", code);
        DapResponse resp = DataMapUtils.request(this.tmHost + "/restful/service/knowledgegraph/paradigm/ParadigmConditionByMechanismCode", "get", params);
        return resp.getResponse();
    }

    public Object getVariableListSimple(List<String> code, Boolean needGetDefault) {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("variableIds", code);
        req.put("needGetDefault", needGetDefault);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("map", req);
        DapResponse resp = DataMapUtils.request(this.tmHost + "/restful/service/knowledgegraph/mechanism/variableListSimple", "post", params);
        return resp.getResponse();
    }

    public List<ActivityWidget> generatePreActivities(AdvancedUserDefinitionWidget advancedUserDefinitionWidget, String capacityCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("advancedUserDefinitionWidget", advancedUserDefinitionWidget);
        params.put("capacityCode", capacityCode);
        DapResponse resp = DataMapUtils.request(this.tmHost + "/restful/service/knowledgegraph/mechanism/generatePreActivities", "post", params);
        ArrayList<ActivityWidget> result = new ArrayList<ActivityWidget>();
        if (resp.getResponse() instanceof JSONArray) {
            ((JSONArray)resp.getResponse()).forEach(item -> result.add((ActivityWidget)this.dataPickService.convert(item, ActivityWidget.class)));
        }
        return result;
    }

    public Object getVariable(String variableName, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("variableName", variableName);
        params.put("tenantId", tenantId);
        DapResponse response = DataMapUtils.request(this.tmHost + "/restful/service/knowledgegraph/mechanism/variable", "get", params);
        return response.getResponse();
    }

    public GetActionLocaleResponseDTO getActionMetaData(String actionId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("actionId", actionId);
        DapResponse response = DataMapUtils.request(this.tmHost + "/restful/service/knowledgegraph/action/metadata", "get", params);
        return (GetActionLocaleResponseDTO)JSONObject.parseObject((String)JSONObject.toJSONString(response.getResponse()), GetActionLocaleResponseDTO.class);
    }

    public MonitorRuleDTO queryMonitorRule(String ruleId, String tenantId) throws DWBusinessException {
        HashMap<String, Object> config = new HashMap<String, Object>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ruleId", ruleId);
        params.put("tenantId", tenantId);
        config.put("config", params);
        DapResponse resp = DataMapUtils.request(this.tmHost + "/restful/service/knowledgegraph/monitorRule/query", "post", config);
        if (resp.getStatus() != 200) {
            log.error("queryMonitorRule error, ruleId: {}, tenantId: {}, errorMsg: {}", new Object[]{ruleId, tenantId, resp.getErrorMessage()});
            throw new DWBusinessException(resp.getErrorMessage());
        }
        return (MonitorRuleDTO)this.dataPickService.convert(resp.getResponse(), MonitorRuleDTO.class);
    }
}

