/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DatamapCacService {
    private static final Logger log = LoggerFactory.getLogger(DatamapCacService.class);
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${cacUrl}")
    private String cacUrl;
    @Value(value="${iamApToken}")
    private String iamApToken;
    private final String AUTHORIZATIONS_TENANTS = "/api/cac/v4/authorizations/tenants/";
    private static final String CAC_TENANT_USER = "/api/cac/v4/authorizations/current/user/apps";

    public Object authorizationsTenants(String tenantId) {
        String requestUrl = this.cacUrl + "/api/cac/v4/authorizations/tenants/" + tenantId;
        HttpHeaders headers = new HttpHeaders();
        DataMapUtils.requiredHeaders(headers);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity exchange = this.restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, Object.class, new Object[0]);
        Object forObject = exchange.getBody();
        return forObject;
    }

    public List<String> getAuthorizationsApplication(String tenantId) {
        ArrayList<String> appLists = new ArrayList<String>();
        Object obj = this.authorizationsTenants(tenantId);
        if (obj == null) {
            return appLists;
        }
        JSONArray jsonArray = JSON.parseArray((String)JSONObject.toJSONString((Object)obj));
        for (int i = 0; i < jsonArray.size(); ++i) {
            DateTimeFormatter dtf2;
            String code = jsonArray.getJSONObject(i).getString("code");
            String expiredTime = jsonArray.getJSONObject(i).getString("expiredTime");
            LocalDateTime expiredLocalDateTime = LocalDateTime.parse(expiredTime, dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            if (expiredLocalDateTime.isBefore(LocalDateTime.now())) continue;
            appLists.add(code);
        }
        return new ArrayList<String>(appLists);
    }

    public List<String> getAppAuth(String userId) throws DWBusinessException {
        ResponseEntity response;
        HttpHeaders headers = new HttpHeaders();
        DataMapUtils.requiredHeaders(headers);
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-app", this.iamApToken);
        String url = this.cacUrl + CAC_TENANT_USER;
        if (StringUtils.isNotEmpty((String)userId)) {
            url = url + "?userId=" + userId;
        }
        if ((response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0])).getStatusCode() == HttpStatus.OK) {
            Map body = (Map)response.getBody();
            List dataList = (List)body.get("data");
            if (dataList != null) {
                return dataList.stream().filter(e -> this.isEffective((Map<String, Object>)e)).map(data -> data.get("id").toString()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.getAuthError", (Object[])new Object[0]));
    }

    private boolean isEffective(Map<String, Object> map) {
        Object expiredTimeObj = map.get("expiredTime");
        if (expiredTimeObj != null) {
            String expiredTime = String.valueOf(expiredTimeObj);
            DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime expiredLocalDateTime = LocalDateTime.parse(expiredTime, dtf2);
            return LocalDateTime.now().isBefore(expiredLocalDateTime);
        }
        return false;
    }
}

