/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.spi;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DatamapGMCService {
    private static final Logger log = LoggerFactory.getLogger(DatamapGMCService.class);
    @Value(value="${gmcUrl}")
    private String gmcUrl;
    @Autowired
    private RestTemplate restTemplate;

    public Object getCloudGood(String appId) {
        String requestUrl = this.gmcUrl + "/api/cloudgoods/" + appId;
        Object forObject = this.restTemplate.getForObject(requestUrl, Object.class, new Object[0]);
        return forObject;
    }

    public Object updateCloudGoodModules(Object requestObj) throws DWBusinessException {
        String requestUrl = this.gmcUrl + "/api/cloudgoods/modules";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-auth-user", this.getGmcToken());
        HttpEntity httpEntity = new HttpEntity(requestObj, (MultiValueMap)headers);
        ResponseEntity stringResponseEntity = this.restTemplate.postForEntity(requestUrl, (Object)httpEntity, Object.class, new Object[0]);
        return stringResponseEntity.getBody();
    }

    private String getGmcToken() throws DWBusinessException {
        String token;
        Map requestHeader = DWServiceContext.getContext().getRequestHeader();
        String string = token = requestHeader == null ? "" : (String)requestHeader.get("gmctoken");
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new DWBusinessException("\u8c03\u7528gmc\u7cfb\u7edf\u7684token\u7f3a\u5931");
        }
        return token;
    }
}

