/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.spi;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.domain.common.ITenantObject;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.TenantAppRelation;
import com.digiwin.athena.domain.neo4j.TenantEntity;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DbKnowledgeGraphService
implements IKnowledgeGraphService {
    @Autowired
    @Qualifier(value="kgSystem")
    private MongoTemplate mongoTemplateSys;
    @Autowired
    @Qualifier(value="kgTenant")
    private MongoTemplate mongoTemplateTenant;
    @Autowired
    @Qualifier(value="mappingMongoConverterSystem")
    MongoConverter converter;
    @Autowired
    @Qualifier(value="dataMapSystem")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Lazy
    DataMapPickService dataPickService;
    @Autowired
    DataMapKgDataPickService dataMapKgDataPickService;
    public static List<Class<?>> tenantClasses = Collections.singletonList(TenantAppComponentListBO.class);
    public static List<Class<?>> sysClasses = Arrays.asList(Application.class, ApplicationRelation.class, TenantEntity.class, TenantAppRelation.class);

    @Override
    public <T> T findOne(Bson filter, Class<T> entityClass, String collectionName, KnowledgeGraphDb db) {
        return this.findOne(filter, null, entityClass, collectionName, db);
    }

    @Override
    public <T> T findOne(Bson filter, Bson projection, Class<T> entityClass, String collectionName, KnowledgeGraphDb db) {
        FindIterable findIterable = this.mongoTemplate.getMongoDbFactory().getMongoDatabase(db.getValue()).getCollection(collectionName).find(filter);
        if (projection != null) {
            findIterable.projection(projection);
        }
        findIterable.limit(1);
        Document document = (Document)findIterable.first();
        if (document == null) {
            return null;
        }
        return (T)this.converter.read(entityClass, (Object)document);
    }

    @Override
    public <T extends ITenantObject> T findOneWithTenant(Bson filter, Class<T> entityClass, String collectionName, KnowledgeGraphDb db) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataPickService.tenantVersion();
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(tenantId);
        if (!"SYSTEM".equals(tenantId)) {
            tenantIds.add("SYSTEM");
            tenantIds.add(null);
        }
        Bson combinedFilter = Filters.and((Bson[])new Bson[]{filter, Filters.in((String)"tenantId", tenantIds), Filters.eq((String)"version", (Object)tenantVersion)});
        FindIterable findIterable = this.mongoTemplate.getMongoDbFactory().getMongoDatabase(db.getValue()).getCollection(collectionName).find(combinedFilter, Document.class);
        int i = 0;
        ITenantObject first = null;
        for (Document document : findIterable) {
            ITenantObject t = (ITenantObject)this.converter.read(entityClass, (Object)document);
            if (i++ == 0) {
                first = t;
            }
            if ("SYSTEM".equals(t.getTenantId()) || t.getTenantId() == null) continue;
            return (T)t;
        }
        return (T)first;
    }

    @Override
    public <T> List<T> find(Bson filter, Class<T> entityClass, String collectionName, KnowledgeGraphDb db) {
        return this.find(filter, null, entityClass, collectionName, db);
    }

    @Override
    public <T> List<T> find(Bson filter, Bson projection, Class<T> entityClass, String collectionName, KnowledgeGraphDb db) {
        FindIterable findIterable = this.mongoTemplate.getMongoDbFactory().getMongoDatabase(db.getValue()).getCollection(collectionName).find(filter, Document.class);
        if (projection != null) {
            findIterable.projection(projection);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Document t : findIterable) {
            list.add(this.converter.read(entityClass, (Object)t));
        }
        return list;
    }

    @Override
    public UpdateResult upsert(Bson filter, Bson update, String collectionName, KnowledgeGraphDb db) {
        return this.mongoTemplate.getMongoDbFactory().getMongoDatabase(db.getValue()).getCollection(collectionName).updateOne(filter, update);
    }

    @Override
    public DeleteResult remove(Bson filter, String collectionName, KnowledgeGraphDb db) {
        return this.mongoTemplate.getMongoDbFactory().getMongoDatabase(db.getValue()).getCollection(collectionName).deleteMany(filter);
    }

    public List<Application> tenantAppRelations(List<String> appCodes) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataPickService.tenantVersion();
        List relations = this.mongoTemplateSys.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").in(new Object[]{tenantId, "SYSTEM", null}).and("code").in(appCodes).and("version").is((Object)tenantVersion)), Application.class);
        relations = MergeUtil.excludeSameCode((List)relations, Application.class, null);
        return relations;
    }

    public Application tenantApp(String appCode) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataPickService.tenantVersion();
        List applications = this.mongoTemplateSys.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").in(new Object[]{tenantId, "SYSTEM", null}).and("code").is((Object)appCode).and("version").is((Object)tenantVersion)), Application.class);
        return CollectionUtils.isNotEmpty((Collection)(applications = MergeUtil.excludeSameCode((List)applications, Application.class, null))) ? (Application)applications.get(0) : null;
    }

    @Override
    public List<ApplicationRelation> applicationRelations(List<String> appCodes, String type, String subType) throws DWBusinessException {
        ArrayList<ApplicationRelation> result = new ArrayList();
        List<Application> tenantAppRelations = this.tenantAppRelations(appCodes);
        HashMap taMaps = new HashMap();
        tenantAppRelations.forEach(t -> taMaps.put(t.getCode(), t));
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataPickService.tenantVersion();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").in(appCodes).and("version").is((Object)tenantVersion).and("type").is((Object)type));
        if (null != subType) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"subType").is((Object)subType));
        }
        List relations = this.mongoTemplateSys.find(query, ApplicationRelation.class);
        for (ApplicationRelation relation : relations) {
            Application tenantAppRelation1 = (Application)taMaps.get(relation.getAppCode());
            if (null == tenantAppRelation1) {
                result.add(relation);
                continue;
            }
            int queryLevel = 0;
            if ("base_entry".equals(subType) || "statement".equals(subType)) {
                queryLevel = 2;
            } else if (Boolean.TRUE.equals(tenantAppRelation1.getIndividualAll())) {
                queryLevel = 1;
            }
            switch (queryLevel) {
                case 0: {
                    if (!"SYSTEM".equals(relation.getTenantId()) && !StringUtils.isEmpty((Object)relation.getTenantId()) && (!tenantId.equals(relation.getTenantId()) || relation.getSourceLevel() != null)) break;
                    result.add(relation);
                    break;
                }
                case 1: {
                    if (!tenantId.equals(relation.getTenantId())) break;
                    result.add(relation);
                    break;
                }
                case 2: {
                    result.add(relation);
                }
            }
        }
        result = MergeUtil.excludeSameCode(result, ApplicationRelation.class, null);
        return result;
    }

    @Override
    public List<ApplicationRelation> relations(String app, String type) throws DWBusinessException {
        List<ApplicationRelation> relations = this.applicationRelations(Arrays.asList(app), type, null);
        return relations;
    }

    @Override
    public List<ApplicationRelation> relations(List<String> apps, String type) throws DWBusinessException {
        if (CollectionUtils.isEmpty(apps)) {
            return null;
        }
        List<ApplicationRelation> relations = this.applicationRelations(apps, type, null);
        return relations;
    }

    @Override
    public ApplicationRelation relation(String code, String type) throws DWBusinessException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("code", code);
        if (null != type) {
            query.put("type", type);
        }
        return (ApplicationRelation)this.dataMapKgDataPickService.findOne(BasicQuery.of(query, null), ApplicationRelation.class);
    }

    @Override
    public List<Application> applications(List<String> appCodes) throws DWBusinessException {
        return this.dataMapKgDataPickService.findByCodes(appCodes, Application.class);
    }

    @Override
    public Application application(String app) throws DWBusinessException {
        return (Application)this.dataMapKgDataPickService.findByCode(app, Application.class);
    }

    @Override
    @Deprecated
    public <T> List<T> find(BasicQuery basicQuery, Class<T> c, KnowledgeGraphDb db, String col) {
        Query query = this.dataPickService.buildQuery(basicQuery, c);
        MongoTemplate template = this.mongoTemplateSys;
        if (KnowledgeGraphDb.TENANT.equals((Object)db)) {
            template = this.mongoTemplateTenant;
        }
        return template.find(query, c, col);
    }

    @Override
    @Deprecated
    public <T> T findOne(BasicQuery basicQuery, Class<T> c, KnowledgeGraphDb db, String col) {
        T t = null;
        List<T> ts = this.find(basicQuery, c, db, col);
        if (CollectionUtils.isNotEmpty(ts)) {
            t = ts.get(0);
        }
        return t;
    }
}

