/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.spi;

import com.digiwin.athena.datamap.spi.IDbPresetService;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.stereotype.Service;

@Service
public class DbPresetService
implements IDbPresetService {
    @Autowired
    MongoConverter converter;
    @Autowired
    @Qualifier(value="dataMapSystem")
    private MongoTemplate mongoTemplate;
    private final String presetDbName = "preset";

    @Override
    public <T> T findOne(Bson filter, Class<T> entityClass, String collectionName) {
        return this.findOne(filter, null, entityClass, collectionName);
    }

    @Override
    public <T> T findOne(Bson filter, Bson projection, Class<T> entityClass, String collectionName) {
        FindIterable findIterable = this.mongoTemplate.getMongoDbFactory().getMongoDatabase("preset").getCollection(collectionName).find(filter);
        if (projection != null) {
            findIterable.projection(projection);
        }
        findIterable.limit(1);
        Document document = (Document)findIterable.first();
        if (document == null) {
            return null;
        }
        return (T)this.converter.read(entityClass, (Object)document);
    }

    @Override
    public <T> List<T> find(Bson filter, Class<T> entityClass, String collectionName) {
        return this.find(filter, null, entityClass, collectionName);
    }

    @Override
    public <T> List<T> find(Bson filter, Bson projection, Class<T> entityClass, String collectionName) {
        FindIterable findIterable = this.mongoTemplate.getMongoDbFactory().getMongoDatabase("preset").getCollection(collectionName).find(filter, Document.class);
        if (projection != null) {
            findIterable.projection(projection);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Document t : findIterable) {
            list.add(this.converter.read(entityClass, (Object)t));
        }
        return list;
    }

    @Override
    public MongoCollection<Document> getCollection(String name, String ... indexes) {
        MongoCollection col = this.mongoTemplate.getMongoDbFactory().getMongoDatabase("preset").getCollection(name);
        boolean keyExisted = false;
        for (Document index : col.listIndexes()) {
            if (!name.equals(index.get((Object)"name"))) continue;
            keyExisted = true;
            break;
        }
        if (!keyExisted) {
            IndexOptions indexOptions = new IndexOptions().name(name).unique(false).background(true);
            col.createIndex(Indexes.ascending((String[])indexes), indexOptions);
        }
        return col;
    }

    @Override
    public UpdateResult upsert(Bson filter, Bson update, String collectionName) {
        return this.mongoTemplate.getMongoDbFactory().getMongoDatabase("preset").getCollection(collectionName).updateOne(filter, update);
    }

    @Override
    public DeleteResult remove(Bson filter, String collectionName) {
        return this.mongoTemplate.getMongoDbFactory().getMongoDatabase("preset").getCollection(collectionName).deleteMany(filter);
    }
}

