/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.supports.EspBody;
import com.digiwin.athena.datamap.supports.EspRequest;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class EspService {
    private static final Logger log = LoggerFactory.getLogger(EspService.class);

    public EspBody invokeSync(EspRequest request) {
        EspBody body = new EspBody();
        HttpServletRequest httpRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Map profile = DWServiceContext.getContext().getProfile();
        String tenantId = profile.getOrDefault("tenantId", null);
        String routerKey = httpRequest.getHeader("routerKey");
        String token = httpRequest.getHeader("token");
        String locale = httpRequest.getHeader("locale");
        if (null == token) {
            token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        }
        if (null == locale) {
            locale = "zh_CN";
        }
        if (null == request.getToken()) {
            request.setToken(token);
        }
        if (null == request.getTenantId()) {
            request.setTenantId(tenantId);
        }
        if (null == request.getLocale()) {
            request.setLocale(locale);
        }
        if (null == request.getRouterKey()) {
            request.setRouterKey(routerKey);
        }
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd(request.getHostProd());
        requestModel.setHostVer("1.0");
        requestModel.setHostId(request.getHostId());
        requestModel.setHostAcct("athena");
        requestModel.setLanguage(request.getLocale());
        requestModel.setTenantId(request.getTenantId());
        requestModel.setServiceProd(request.getProductName());
        requestModel.setServiceName(request.getServiceName());
        requestModel.setEocMap(request.getEocMap());
        requestModel.setBodyJsonString(request.jsonBody());
        HashMap<String, String> datakeyMap = new HashMap<String, String>();
        datakeyMap.put("appCode", "DDSM");
        requestModel.setDatakeyMap(datakeyMap);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (null != request.getToken()) {
            headerMap.put("token", request.getToken());
        }
        if (null != request.getRouterKey()) {
            headerMap.put("routerKey", request.getRouterKey());
        }
        if (null != request.getHeaders()) {
            headerMap.putAll(request.getHeaders());
        }
        requestModel.setHeaderMap(headerMap);
        try {
            ResponseModel responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
            if (StringUtils.isNotEmpty((CharSequence)responseModel.getBodyJsonString())) {
                body = (EspBody)JSON.parseObject((String)responseModel.getBodyJsonString(), EspBody.class);
                System.out.println(body);
                if ("0".equals(body.getStd_data().getExecution().getCode())) {
                    body.setSuccess(true);
                } else {
                    body.setMsg(body.getStd_data().getExecution().getDescription());
                }
            } else {
                log.info("EspService.invokeSync invoke bodyJsonString is empty !");
            }
            log.info("ResponseModel from esp:" + JSON.toJSONString((Object)responseModel));
            body = (EspBody)JSON.parseObject((String)responseModel.getBodyJsonString(), EspBody.class);
            if ("0".equals(body.getStd_data().getExecution().getCode())) {
                body.setSuccess(true);
            } else {
                body.setMsg(body.getStd_data().getExecution().getDescription());
            }
        }
        catch (Exception e) {
            log.error("invoke esp failed", (Throwable)e);
        }
        return body;
    }
}

