/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.povo.DapResponse;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class DataMapUtils {
    private static final Logger log = LoggerFactory.getLogger(DataMapUtils.class);
    public static HttpClient httpclient = null;
    public static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).setMaxRedirects(50).build();
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    HttpRoutePlanner initHttpRoutePlanner;
    static HttpRoutePlanner httpRoutePlanner;

    @PostConstruct
    public void init() {
        httpRoutePlanner = this.initHttpRoutePlanner;
    }

    public static DapResponse request(String url, String httpMethod, Map<String, Object> params) {
        DapResponse result = new DapResponse();
        String json = DataMapUtils.requestString(url, httpMethod, params);
        if (null != json) {
            result = (DapResponse)JSON.parseObject((String)json, DapResponse.class);
        }
        return result;
    }

    public static String requestString(String url, String httpMethod, Map<String, Object> params) {
        return DataMapUtils.requestString(url, httpMethod, params, null);
    }

    public static String requestString(String url, String httpMethod, Map<String, Object> params, Map<String, String> headers) {
        String result = null;
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        try {
            URL u = new URL(url);
            String kghost = u.getHost();
            headers.put("Host", kghost);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String routerKey = request.getHeader("routerKey");
        String token = request.getHeader("token");
        String locale = request.getHeader("locale");
        String securityToken = request.getHeader("security-token");
        if (null == token) {
            token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
            routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
            locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        }
        if (null == token) {
            token = DWServiceContext.getContext().getToken();
        }
        if (null == securityToken) {
            securityToken = (String)DWServiceContext.getContext().getRequestHeader().get("security-token");
        }
        if (null != routerKey) {
            headers.put("routerKey", routerKey);
        }
        if (null != token) {
            headers.put("token", token);
            headers.put("digi-middleware-auth-user", token);
        }
        if (null != locale) {
            headers.put("locale", locale);
        }
        if (null != securityToken) {
            headers.put("security-token", securityToken);
        }
        if ("post".equalsIgnoreCase(httpMethod)) {
            log.info("Utils requestString beginning... \u5165\u53c2\uff1a{}\uff0c{}\uff0c{}", new Object[]{url, headers, params});
            result = DataMapUtils.postJson(url, headers, params);
            log.info("Utils requestString ending... \u7ed3\u679c\uff1a{}", (Object)result);
        } else {
            result = DataMapUtils.get(url, headers, params);
        }
        return result;
    }

    public static HttpClient getHttpClient() {
        if (null == httpclient) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                sslContext.init(null, new TrustManager[]{tm}, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            httpclient = HttpClients.custom().setMaxConnPerRoute(384).setMaxConnTotal(1024).setSSLContext(sslContext).setRoutePlanner(httpRoutePlanner).build();
        }
        return httpclient;
    }

    private static Header[] toHeader(Map<String, String> headers) {
        if (null != headers) {
            ArrayList hs = new ArrayList();
            headers.forEach((k, v) -> hs.add(new BasicHeader(k, v)));
            return hs.toArray(new Header[0]);
        }
        return null;
    }

    public static String get(String url, Map<String, String> headers, Map<String, Object> params) {
        String result = null;
        HttpResponse response = DataMapUtils.get0(url, DataMapUtils.toHeader(headers), params);
        HttpEntity entity = response.getEntity();
        try {
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return result;
    }

    public static <T> T get(String url, Map<String, String> headers, Map<String, Object> params, Class<T> c) {
        Object result = JSON.parseObject((String)DataMapUtils.get(url, headers, params), c);
        return (T)result;
    }

    public static HttpResponse get0(String url, Header[] headers, Map<String, Object> params) {
        if (null != params && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            params.forEach((k, v) -> {
                try {
                    String sv = v.toString();
                    sb.append((String)k).append("=").append(URLEncoder.encode(sv, "UTF-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
            url = url + sb.substring(0, sb.length() - 1).toString();
        }
        HttpGet get = new HttpGet(url);
        get.setHeaders(headers);
        get.setConfig(requestConfig);
        HttpResponse response = null;
        if (log.isInfoEnabled()) {
            log.info("get url=" + url + ",headers=" + JSON.toJSONString((Object)headers) + ",params=" + params);
        }
        try {
            response = DataMapUtils.getHttpClient().execute((HttpUriRequest)get);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public static String postJson(String url, Map<String, String> headers, Map<String, Object> params) {
        String result = null;
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        httppost.setHeaders(DataMapUtils.toHeader(headers));
        String jsonbody = JSON.toJSONString(params);
        StringEntity myEntity = new StringEntity(jsonbody, ContentType.APPLICATION_JSON);
        httppost.setEntity((HttpEntity)myEntity);
        HttpResponse response = null;
        if (log.isInfoEnabled()) {
            log.info("post to:" + url + ",and request body=" + jsonbody + " and header=" + headers);
        }
        try {
            response = DataMapUtils.getHttpClient().execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        if (log.isInfoEnabled()) {
            log.info("response from :" + url + ",response body=" + result);
        }
        return result;
    }

    public static String join(List<?> list, String sep) {
        if (null == sep) {
            sep = ",";
        }
        if (null != list && list.size() > 0) {
            StringBuilder sb = new StringBuilder();
            int len = list.size();
            int last = len - 1;
            for (int i = 0; i < len; ++i) {
                sb.append(list.get(i));
                if (i >= last) continue;
                sb.append(sep);
            }
            return sb.toString();
        }
        return null;
    }

    public static void requiredHeaders(HttpHeaders headers) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = ServiceUtils.getToken();
            String locale = request.getHeader("locale");
            String securityToken = request.getHeader("security-token");
            if (null == routerKey) {
                routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
                locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
            }
            if (null == securityToken) {
                securityToken = (String)DWServiceContext.getContext().getRequestHeader().get("security-token");
            }
            if (!StringUtils.isEmpty((Object)routerKey)) {
                headers.set("routerKey", routerKey);
            }
            if (!StringUtils.isEmpty((Object)token)) {
                headers.set("token", token);
                headers.set("digi-middleware-auth-user", token);
            }
            if (!StringUtils.isEmpty((Object)locale)) {
                headers.set("locale", locale);
            }
            if (!StringUtils.isEmpty((Object)securityToken)) {
                headers.set("security-token", securityToken);
            }
        }
        catch (Exception e) {
            log.error("requiredHeaders error", (Throwable)e);
        }
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static <T> T mergeObject(T source, T target, Class<T> clazz, String needField, Boolean forceReplace) {
        Field[] declaredFields = clazz.getDeclaredFields();
        Arrays.stream(declaredFields).filter(v -> v.getName().matches(needField)).forEach(v -> {
            try {
                v.setAccessible(true);
                Object strSource = v.get(source);
                Object strTarget = v.get(target);
                if (!ObjectUtil.isEmpty((Object)strTarget)) {
                    if (forceReplace.booleanValue()) {
                        strSource = strTarget;
                    } else if (!ObjectUtil.isEmpty((Object)strSource)) {
                        if (!String.valueOf(strSource).contains(String.valueOf(target))) {
                            strSource = strSource + "\n" + strTarget;
                        }
                    } else {
                        strSource = strTarget;
                    }
                }
                v.set(source, strSource);
            }
            catch (IllegalAccessException e) {
                log.error("\u5408\u5e76\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
                log.error("\u5165\u53c2\uff1asource\u3010{}\u3011\uff0ctarget\u3010{}\u3011\uff0cclazz\u3010{}\u3011\uff0cneedField\u3010{}\u3011", new Object[]{source, target, clazz, needField});
            }
        });
        return source;
    }

    public static String getTableLayoutId(PageView pageView) {
        JSONObject pages = JSONObject.parseObject((String)JSON.toJSONString((Object)pageView.getPages()));
        JSONArray dataStates = pages.getJSONObject("task-detail").getJSONArray("dataStates");
        JSONArray layouts = dataStates != null && !dataStates.isEmpty() ? dataStates.getJSONObject(0).getJSONArray("layout") : pages.getJSONObject("task-detail").getJSONArray("layout");
        if (layouts != null && !layouts.isEmpty()) {
            String layoutId = layouts.stream().filter(v -> {
                JSONObject layout = JSONObject.parseObject((String)JSON.toJSONString((Object)v));
                return "ATHENA_TABLE".equals(layout.getString("type"));
            }).findFirst().map(v -> {
                JSONObject layout = JSONObject.parseObject((String)JSON.toJSONString((Object)v));
                return layout.getString("id");
            }).get();
            return layoutId;
        }
        return "default";
    }

    public static String getSelectorLayoutId(PageView pageView, String fieldName) {
        JSONObject pages = JSONObject.parseObject((String)JSON.toJSONString((Object)pageView.getPages()));
        JSONArray dataStates = pages.getJSONObject("task-detail").getJSONArray("dataStates");
        JSONArray layouts = dataStates != null && !dataStates.isEmpty() ? dataStates.getJSONObject(0).getJSONArray("layout") : pages.getJSONObject("task-detail").getJSONArray("layout");
        if (layouts != null && !layouts.isEmpty()) {
            String layoutId = layouts.stream().filter(v -> {
                JSONObject layout = JSONObject.parseObject((String)JSON.toJSONString((Object)v));
                return "ATHENA_TABLE".equals(layout.getString("type"));
            }).findFirst().map(v -> {
                JSONObject layout = JSONObject.parseObject((String)JSON.toJSONString((Object)v));
                JSONArray columnDefs = layout.getJSONArray("columnDefs");
                String columnDefId = columnDefs.stream().filter(t -> {
                    JSONObject columnDef = JSONObject.parseObject((String)JSON.toJSONString((Object)t));
                    JSONObject column = JSONObject.parseObject((String)JSON.toJSONString((Object)columnDef.getJSONArray("columns").get(0)));
                    return fieldName.equals(column.getString("schema"));
                }).findFirst().map(u -> {
                    JSONObject columnDef = JSONObject.parseObject((String)JSON.toJSONString((Object)u));
                    JSONObject column = JSONObject.parseObject((String)JSON.toJSONString((Object)columnDef.getJSONArray("columns").get(0)));
                    return column.getString("id");
                }).get();
                return columnDefId;
            }).get();
            return layoutId;
        }
        return "default";
    }

    public static String getTableDataKey(PageView pageView) {
        JSONObject pages = JSONObject.parseObject((String)JSON.toJSONString((Object)pageView.getPages()));
        JSONArray dataStates = pages.getJSONObject("task-detail").getJSONArray("dataStates");
        JSONArray layouts = dataStates != null && !dataStates.isEmpty() ? dataStates.getJSONObject(0).getJSONArray("layout") : pages.getJSONObject("task-detail").getJSONArray("layout");
        if (layouts != null && !layouts.isEmpty()) {
            String tableDataKey = layouts.stream().filter(v -> {
                JSONObject layout = JSONObject.parseObject((String)JSON.toJSONString((Object)v));
                return "ATHENA_TABLE".equals(layout.getString("type")) && !CollectionUtils.isEmpty((Collection)layout.getJSONArray("columnDefs"));
            }).findFirst().map(v -> {
                JSONObject layout = JSONObject.parseObject((String)JSON.toJSONString((Object)v));
                return layout.getString("schema");
            }).get();
            return tableDataKey;
        }
        return "default";
    }
}

