package com.digiwin.athena.controller;

import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.action.ActionTypeInfoResDto;
import com.digiwin.athena.service.ActionMetaDataService;
import com.digiwin.athena.vo.action.ActionInfoResp;
import com.digiwin.athena.vo.action.ActionVersionReq;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/action")
@Tag(name="行动",description = "4a87c534-19d3-41c1-a809-41db426b5ee0")
public class ActionMetaDataController {

    @Autowired
    private ActionMetaDataService actionMetaDataService;

    @GetMapping("/autoMatchAction")
    @Operation(summary = "自动匹配action")
    public ResultDto<List<ActionTypeInfoResDto>> autoMatchAction(@Schema(description = "产品") String product,
                                                                 String actionId){
        List<ActionTypeInfoResDto> res = actionMetaDataService.autoMatchAction(product,actionId);

        return ResultDto.createSuccess(res);
    }


    /**
     * 根据服务名称获取最新版本
     *
     * @param actionVersionReq 服务名称
     * @return 版本
     */
    @PostMapping("/getActionVersion")
    @Operation(summary = "根据服务名称获取版本")
    public ResultDto<Map<String, ActionInfoResp>> getActionVersion(
            @Schema(description = "服务名称") @RequestBody @Validated ActionVersionReq actionVersionReq) {
        Map<String, ActionInfoResp> versionMap = actionMetaDataService.getActionInfoByServiceName(actionVersionReq);
        return ResultDto.createSuccess(versionMap);
    }
}
