package com.digiwin.athena.dto.action;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.domain.base.RelationTable;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

@Data
@Accessors(chain = true)
public class ApiDataFieldMetadataDTO {

    public static final String DATA_TYPE_TABLE = "object";

    private String id;

    private String name;
    private String data_name;
    //object,string
    private String data_type;
    private String dbFieldType;
    private String required;
    @JSONField(name = "is_datakey")
    @JsonProperty("is_datakey")
    private String is_datakey;
    @JSONField(name = "is_array")
    @JsonProperty("is_array")
    private Boolean is_array;
    @JSONField(name = "is_businesskey")
    @JsonProperty("is_businesskey")
    private Boolean is_businesskey;
    // 是否必填
    @JSONField(name = "is_necessary")
    @JsonProperty("is_necessary")
    private Boolean is_necessary;
    // 是否需要关联
    @JSONField(name = "need_relate")
    @JsonProperty("need_relate")
    private Boolean need_relate;
    @JSONField(name = "column_type")
    @JsonProperty("column_type")
    private String column_type;
    private MultiLanguageDTO description;
    private MultiLanguageDTO remark;
    // 列举值
    private String listEnum;
    // 列举值多语言
    private MultiLanguageDTO listEnumMultilingual;
    private FieldDataPrecision data_precision;
    private List<ApiDataFieldMetadataDTO> field;
    private String fullPath;
    //20220515 by maxl
    //增加枚举key，对应到词条枚举值dictionary的key
    private String enum_key;
    private String dictionaryKey;
    private Long dictionaryId;

    private List<RelationTable> relationTable;

    private List<String> labels;

    private List<JSONObject> tagList;
    // 模型驱动-标识是否为引用字段
    private Boolean isQuoteField;
    // 模型驱动-标识字段长度
    private String size;
    // 模型驱动-标识字段精度
    private String scale;
    // 模型驱动-标识默认值
    private String defaultValue;
    // 模型驱动-是否唯一
    private Boolean unique;
    // 模型驱动-是否系统配置项
    private Boolean isSystem;
    // 模型驱动-集合字段是否是单身
    private Boolean isChild;
    // 模型驱动-当前字段是否为集合字段
    private Boolean isCollection;
    // 模型驱动-当前字段是否为单头的业务主键
    private Boolean isParentBk;

    private String percent;//敏捷应用- percent 带百分号 thousand 显示千分位 none 无样式

    private Integer decimal;//敏捷应用- 精度 保留几位小数

    private Map<String,MultiLanguageDTO> lang; //敏捷应用-多语言

    private String formula;//敏捷应用-计算公式

    private String nodeId;//敏捷应用-节点id

    private String source;//敏捷应用-节点id

    private String interval;//敏捷应用-节点id

    private String new_data_name;//敏捷应用-更名字段

    private String new_name;//敏捷应用-更名说明

    private String old_data_name;//临时字段 后端逻辑使用

    private String quoteParam;//引用输入参数

    private Boolean rename;//是否更名

    private Boolean accept;//是否接收字段

    private ApiDataFieldMetadataAgileDTO mappingValue;

    private String nodeName;

    private String nodeType;

    private Boolean can_del;//是否可删除

    private String metaFieldType;

    //判断是否是标准参数
    private Boolean is_standard;

    private Boolean isFixedValue;

    private Object fixedValue;

    private Boolean can_sort;

    private Boolean can_filter;
    //数据提取类型 by度量measure by维度dimension
    private String extractionType;
    //聚合函数 SUM AVG COUNT MAX MIN
    private String extractionFunction;
}
