package com.digiwin.athena.vo.action;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Author liugla
 * @Description 获取action版本信息请求类
 * @Date 2025/11/11 10:25
 * @Version 1.0
 **/
@Data
@Schema(description = "获取action版本信息")
@Accessors(chain = true)
public class ActionVersionReq {
	/**
	 * 服务名称
	 */
	@Schema(description = "服务名称")
	@NotEmpty(message = "服务名称不能为空")
	private List<String> serviceNames;
	
	public ActionVersionReq setServiceNames(List<String> serviceNames) {
		if (serviceNames == null || serviceNames.isEmpty()) {
			throw new IllegalArgumentException("服务名称不能为空集合");
		}
		for (String serviceName : serviceNames) {
			if (serviceName == null || serviceName.trim().isEmpty()) {
				throw new IllegalArgumentException("集合中不能包含空字符串");
			}
		}
		this.serviceNames = serviceNames;
		return this;
	}
}
