/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.controller;

import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.action.ActionTypeInfoResDto;
import com.digiwin.athena.service.ActionMetaDataService;
import com.digiwin.athena.vo.action.ActionInfoResp;
import com.digiwin.athena.vo.action.ActionVersionReq;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/action"})
@Tag(name="\u884c\u52a8", description="4a87c534-19d3-41c1-a809-41db426b5ee0")
public class ActionMetaDataController {
    @Autowired
    private ActionMetaDataService actionMetaDataService;

    @GetMapping(value={"/autoMatchAction"})
    @Operation(summary="\u81ea\u52a8\u5339\u914daction")
    public ResultDto<List<ActionTypeInfoResDto>> autoMatchAction(@Schema(description="\u4ea7\u54c1") String product, String actionId) {
        List<ActionTypeInfoResDto> res = this.actionMetaDataService.autoMatchAction(product, actionId);
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/getActionVersion"})
    @Operation(summary="\u6839\u636e\u670d\u52a1\u540d\u79f0\u83b7\u53d6\u7248\u672c")
    public ResultDto<Map<String, ActionInfoResp>> getActionVersion(@Schema(description="\u670d\u52a1\u540d\u79f0") @RequestBody @Validated ActionVersionReq actionVersionReq) {
        Map<String, ActionInfoResp> versionMap = this.actionMetaDataService.getActionInfoByServiceName(actionVersionReq);
        return ResultDto.createSuccess(versionMap);
    }
}

