/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao;

import com.digiwin.athena.mongodb.domain.action.ActionMetaData;
import com.digiwin.athena.mongodb.repository.MongoMultiRepositoryDecorator;
import com.digiwin.athena.utils.QueryUtils;
import com.digiwin.athena.utils.UpdateUtils;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class ActionMetadataMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActionMetadataMongoDao.class);
    @Resource
    private MongoMultiRepositoryDecorator mongoMultiRepositoryDecorator;

    public Long count(Query query) {
        return this.mongoMultiRepositoryDecorator.count(query, ActionMetaData.class);
    }

    public List<ActionMetaData> find(Query query) {
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class);
    }

    public ActionMetaData findByActionId(String actionId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionId));
        return (ActionMetaData)((Object)this.mongoMultiRepositoryDecorator.findOne(query, ActionMetaData.class));
    }

    public List<ActionMetaData> findList(Collection<String> list) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"actionId").in(list));
        return this.find(query);
    }

    public void insert(ActionMetaData actionMetaData) {
        this.mongoMultiRepositoryDecorator.insert((Object)actionMetaData);
    }

    public void delete(String actionId) {
        this.mongoMultiRepositoryDecorator.delete(QueryUtils.findByActionId((String)actionId), ActionMetaData.class);
    }

    public void updateById(ActionMetaData actionMetaData) {
        this.mongoMultiRepositoryDecorator.updateFirst(QueryUtils.findById((String)actionMetaData.getObjectId()), UpdateUtils.getUpdate((Object)((Object)actionMetaData)), ActionMetaData.class);
    }

    public void delete(Query query) {
        this.mongoMultiRepositoryDecorator.delete(query, ActionMetaData.class);
    }

    public List<ActionMetaData> findByAdpApplication(String adpApplication) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"adpApplication").is((Object)adpApplication));
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class);
    }

    public ActionMetaData selectByActionId(String actionId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionId));
        return (ActionMetaData)((Object)this.mongoMultiRepositoryDecorator.findOne(query, ActionMetaData.class));
    }

    public ActionMetaData selectByActionIdOrServiceName(String value) {
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"actionId").is((Object)value), Criteria.where((String)"serviceName").is((Object)value)});
        return (ActionMetaData)((Object)this.mongoMultiRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), ActionMetaData.class));
    }

    public List<String> selectActionIdByApplicationAndPageable(String application, Pageable pageable) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        query.with(pageable);
        Field fields = query.fields();
        fields.include("actionId");
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class).stream().map(ActionMetaData::getActionId).collect(Collectors.toList());
    }

    public ActionMetaData selectByActionIdAndApplication(String actionId, String application) {
        Criteria criteria = Criteria.where((String)"actionId").is((Object)actionId).and("application").is((Object)application);
        return (ActionMetaData)((Object)this.mongoMultiRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), ActionMetaData.class));
    }

    private static Criteria getActionIdOrActionNameCriteria(String condition) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            condition = ".*" + (String)condition + ".*";
            criteria.orOperator(new Criteria[]{Criteria.where((String)"actionId").regex((String)condition, "si"), Criteria.where((String)"actionName").regex((String)condition, "si")});
        }
        return criteria;
    }

    public List<ActionMetaData> selectBasicInfoByPageable(String condition, List<String> appCodes, Boolean needEsp, String label, Pageable pageable) {
        Criteria criteria = ActionMetadataMongoDao.getActionIdOrActionNameCriteria(condition);
        criteria.andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"application").in(appCodes), Criteria.where((String)"adpApplication").in(appCodes)})});
        if (!needEsp.booleanValue()) {
            criteria.and("application").ne((Object)"espCommon");
        }
        if (!StringUtils.isEmpty((CharSequence)label)) {
            criteria.and("label").is((Object)label);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        query.with(pageable);
        query.fields().exclude(new String[]{"response_object", "request_parameters"});
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class);
    }

    public Long countBasicInfoByPageable(String condition, List<String> appCodes, Boolean needEsp, String label) {
        Criteria criteria = ActionMetadataMongoDao.getActionIdOrActionNameCriteria(condition);
        criteria.andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"application").in(appCodes), Criteria.where((String)"adpApplication").in(appCodes)})});
        if (!needEsp.booleanValue()) {
            criteria.and("application").ne((Object)"espCommon");
        }
        if (!StringUtils.isEmpty((CharSequence)label)) {
            criteria.and("label").is((Object)label);
        }
        return this.mongoMultiRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), ActionMetaData.class);
    }

    public <T> Long countBasicInfoByPageable(String condition, List<String> excludeActionIdList, List<String> appCodes, Boolean needEsp, String label) {
        Criteria criteria = ActionMetadataMongoDao.getActionIdOrActionNameCriteria(condition);
        criteria.andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"application").in(appCodes), Criteria.where((String)"adpApplication").in(appCodes)})});
        if (!excludeActionIdList.isEmpty()) {
            criteria.and("actionId").not().in(excludeActionIdList);
        }
        if (!needEsp.booleanValue()) {
            criteria.and("application").ne((Object)"espCommon");
        }
        if (!StringUtils.isEmpty((CharSequence)label)) {
            criteria.and("label").is((Object)label);
        }
        return this.mongoMultiRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), ActionMetaData.class);
    }

    public <T> List<ActionMetaData> selectBasicInfoByPageable(String condition, List<String> excludeActionIdList, List<String> appCodes, Boolean needEsp, String label, Pageable pageable) {
        Criteria criteria = ActionMetadataMongoDao.getActionIdOrActionNameCriteria(condition);
        criteria.andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"application").in(appCodes), Criteria.where((String)"adpApplication").in(appCodes)})});
        if (!excludeActionIdList.isEmpty()) {
            criteria.and("actionId").not().in(excludeActionIdList);
        }
        if (!needEsp.booleanValue()) {
            criteria.and("application").ne((Object)"espCommon");
        }
        if (!StringUtils.isEmpty((CharSequence)label)) {
            criteria.and("label").is((Object)label);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        query.with(pageable);
        query.fields().exclude(new String[]{"response_object", "request_parameters"});
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class);
    }

    public List<ActionMetaData> selectBasicInfoByApplication(String condition, String appCode) {
        Criteria criteria = ActionMetadataMongoDao.getActionIdOrActionNameCriteria(condition);
        criteria.and("application").is((Object)appCode);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        query.fields().exclude(new String[]{"response_object", "request_parameters"});
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class);
    }

    private Criteria matchDataName(String condition) {
        condition = ".*" + (String)condition + ".*";
        Criteria criteria = new Criteria();
        Criteria cri = Criteria.where((String)"data_name").regex((String)condition, "six");
        criteria.orOperator(new Criteria[]{Criteria.where((String)"response_object.field").elemMatch(cri), Criteria.where((String)"actionId").regex((String)condition, "six"), Criteria.where((String)"response_object.data_name").regex((String)condition, "six")});
        return criteria;
    }

    public List<ActionMetaData> selectActionByDataNamePageable(String condition, List<String> excludeActionIds, Pageable pageable) {
        Criteria criteria = this.matchDataName(condition);
        if (!excludeActionIds.isEmpty()) {
            criteria.and("actionId").nin(excludeActionIds);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        query.with(pageable);
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class);
    }

    public Long countActionByDataName(String condition, List<String> excludeActionIds) {
        Criteria criteria = this.matchDataName(condition);
        if (!excludeActionIds.isEmpty()) {
            criteria.and("actionId").nin(excludeActionIds);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoMultiRepositoryDecorator.count(query, ActionMetaData.class);
    }

    public List<ActionMetaData> selectBasicInfoByActionIds(List<String> actionIds) {
        Criteria criteria = Criteria.where((String)"actionId").in(actionIds);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().exclude(new String[]{"response_object", "request_parameters"});
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class);
    }

    public void delete(ActionMetaData actionMetaData) {
        this.mongoMultiRepositoryDecorator.delete((Object)actionMetaData);
    }

    public List<String> selectAllActionIdByApplication(String appCode) {
        Criteria criteria = Criteria.where((String)"application").is((Object)appCode);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("actionId");
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class).stream().map(ActionMetaData::getActionId).collect(Collectors.toList());
    }

    public List<ActionMetaData> selectActionByDataNameAndApplication(String condition, String individualCaseAppCode) {
        Criteria criteria = this.matchDataName(condition);
        criteria.and("application").is((Object)individualCaseAppCode);
        return this.mongoMultiRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), ActionMetaData.class);
    }

    public void save(ActionMetaData resActionMetaData) {
        this.mongoMultiRepositoryDecorator.save((Object)resActionMetaData);
    }

    public void remove(ActionMetaData actionMetaData) {
        this.mongoMultiRepositoryDecorator.delete((Object)actionMetaData);
    }

    public ActionMetaData findByActionIdAndAdpApplication(String actionId) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)"actionId").is((Object)actionId).and("label").ne((Object)"EspAction");
        Criteria criteria2 = Criteria.where((String)"actionId").is((Object)actionId).and("adpApplication").exists(true);
        criteria.orOperator(new Criteria[]{criteria1, criteria2});
        Query query = new Query((CriteriaDefinition)criteria);
        return (ActionMetaData)((Object)this.mongoMultiRepositoryDecorator.findOne(query, ActionMetaData.class));
    }

    public List<ActionMetaData> selectActionIdByActionsExcludeEsp(Collection<String> actionIds) {
        Criteria criteria = Criteria.where((String)"actionId").in(actionIds).and("label").ne((Object)"EspAction");
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("actionId").include("application");
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class);
    }

    public Set<String> selectActionIdByActionIds(List<String> actionIds) {
        Criteria criteria = Criteria.where((String)"actionId").in(actionIds);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("actionId");
        return this.mongoMultiRepositoryDecorator.find(query, ActionMetaData.class).stream().map(ActionMetaData::getActionId).collect(Collectors.toSet());
    }
}

