/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.dao.mongodao.ActionMetadataMongoDao;
import com.digiwin.athena.dao.mongodao.SysActionMetaDataMongoDao;
import com.digiwin.athena.dto.action.ActionTypeInfoResDto;
import com.digiwin.athena.mongodb.domain.action.ActionMetaData;
import com.digiwin.athena.mongodb.domain.action.SysActionMetaData;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.service.ActionMetaDataService;
import com.digiwin.athena.sys.PresetDataServiceV2;
import com.digiwin.athena.vo.action.ActionInfoResp;
import com.digiwin.athena.vo.action.ActionVersionReq;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class ActionMetaDataServiceImpl
implements ActionMetaDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActionMetaDataServiceImpl.class);
    @Autowired
    private PresetDataServiceV2 presetDataServiceV2;
    @Autowired
    private ActionMetadataMongoDao actionMetadataMongoDao;
    @Autowired
    private SysActionMetaDataMongoDao sysActionMetaDataMongoDao;

    @Override
    public List<ActionTypeInfoResDto> autoMatchAction(String product, String actionId) {
        PresetData presetData = null;
        try {
            presetData = this.presetDataServiceV2.getPresetDataObject("API_TEMPLATE_" + product);
        }
        catch (Exception e) {
            return new ArrayList<ActionTypeInfoResDto>();
        }
        List actionTypeInfoResDtos = (List)JSONObject.parseObject((String)presetData.getValue(), (TypeReference)new TypeReference<List<ActionTypeInfoResDto>>(){}, (Feature[])new Feature[0]);
        String actionPrefix = null;
        for (ActionTypeInfoResDto actionTypeInfoResDto : actionTypeInfoResDtos) {
            if (!actionId.endsWith(actionTypeInfoResDto.getApiName())) continue;
            actionPrefix = actionId.substring(0, actionId.length() - actionTypeInfoResDto.getApiName().length());
            break;
        }
        if (StringUtils.isEmpty(actionPrefix)) {
            return new ArrayList<ActionTypeInfoResDto>();
        }
        for (ActionTypeInfoResDto actionTypeInfoResDto : actionTypeInfoResDtos) {
            actionTypeInfoResDto.setApiName(actionPrefix + actionTypeInfoResDto.getApiName());
        }
        List<String> actionIds = actionTypeInfoResDtos.stream().map(ActionTypeInfoResDto::getApiName).collect(Collectors.toList());
        Set<String> actionIdSet = this.sysActionMetaDataMongoDao.selectActionIdByActionIds(actionIds);
        actionIdSet.addAll(this.actionMetadataMongoDao.selectActionIdByActionIds(actionIds));
        Iterator iterator = actionTypeInfoResDtos.iterator();
        while (iterator.hasNext()) {
            ActionTypeInfoResDto next = (ActionTypeInfoResDto)iterator.next();
            if (actionIdSet.contains(next.getApiName())) continue;
            iterator.remove();
        }
        return actionTypeInfoResDtos;
    }

    @Override
    public Map<String, ActionInfoResp> getActionInfoByServiceName(ActionVersionReq req) {
        Criteria criteria = new Criteria().and("serviceName").in(req.getServiceNames());
        Query query = new Query((CriteriaDefinition)criteria);
        List<SysActionMetaData> sysActionMetaData = this.sysActionMetaDataMongoDao.find(query);
        return sysActionMetaData.stream().collect(Collectors.groupingBy(ActionMetaData::getServiceName, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().max((o1, o2) -> {
            BigDecimal o1Version = null;
            BigDecimal o2Version = null;
            try {
                o1Version = new BigDecimal(o1.getServiceVersion());
                o2Version = new BigDecimal(o2.getServiceVersion());
            }
            catch (Exception e) {
                throw new RuntimeException("\u3010" + o1.getServiceName() + "\u3011\u7248\u672c\u683c\u5f0f\u975e\u6cd5\uff0c\u8bf7\u68c0\u67e5\u7248\u672c\u53f7\u683c\u5f0f\uff01");
            }
            return o1Version.compareTo(o2Version);
        }).map(v -> new ActionInfoResp().setActionId(v.getActionId()).setActionName(v.getActionName()).setApplication(v.getApplication()).setLabel(v.getLabel()).setProvider(v.getProvider()).setServiceName(v.getServiceName()).setServiceVersion(v.getServiceVersion())).orElse(null)))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

