package com.digiwin.athena.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.dao.mongodao.ActionMetadataMongoDao;
import com.digiwin.athena.dao.mongodao.SysActionMetaDataMongoDao;
import com.digiwin.athena.dto.action.ActionTypeInfoResDto;
import com.digiwin.athena.mongodb.domain.action.SysActionMetaData;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.service.ActionMetaDataService;
import com.digiwin.athena.sys.PresetDataServiceV2;
import com.digiwin.athena.vo.action.ActionInfoResp;
import com.digiwin.athena.vo.action.ActionVersionReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@Slf4j
public class ActionMetaDataServiceImpl implements ActionMetaDataService {


    @Autowired
    private PresetDataServiceV2 presetDataServiceV2;

    @Autowired
    private ActionMetadataMongoDao actionMetadataMongoDao;
    @Autowired
    private SysActionMetaDataMongoDao sysActionMetaDataMongoDao;

    @Override
    public List<ActionTypeInfoResDto> autoMatchAction(String product, String actionId) {
        PresetData presetData = null;
        try {
            presetData = presetDataServiceV2.getPresetDataObject("API_TEMPLATE_" + product);
        } catch (Exception e) {
            return new ArrayList<>();
        }

        List<ActionTypeInfoResDto> actionTypeInfoResDtos = JSONObject.parseObject(presetData.getValue(), new TypeReference<List<ActionTypeInfoResDto>>() {
        });
        String actionPrefix=null;
        for (ActionTypeInfoResDto actionTypeInfoResDto : actionTypeInfoResDtos) {
            if (actionId.endsWith(actionTypeInfoResDto.getApiName())){
                actionPrefix = actionId.substring(0,actionId.length()-actionTypeInfoResDto.getApiName().length());
                break;
            }
        }
        if (StringUtils.isEmpty(actionPrefix)){
            return new ArrayList<>();
        }
        for (ActionTypeInfoResDto actionTypeInfoResDto : actionTypeInfoResDtos) {
            actionTypeInfoResDto.setApiName(actionPrefix+actionTypeInfoResDto.getApiName());
        }

        List<String> actionIds = actionTypeInfoResDtos.stream().map(ActionTypeInfoResDto::getApiName).collect(Collectors.toList());

        Set<String> actionIdSet = sysActionMetaDataMongoDao.selectActionIdByActionIds(actionIds);
        actionIdSet.addAll(actionMetadataMongoDao.selectActionIdByActionIds(actionIds));

        Iterator<ActionTypeInfoResDto> iterator = actionTypeInfoResDtos.iterator();
        while(iterator.hasNext()){
            ActionTypeInfoResDto next = iterator.next();
            if (!actionIdSet.contains(next.getApiName())){
                iterator.remove();
            }
        }
        return actionTypeInfoResDtos;
    }

    public Map<String, ActionInfoResp> getActionInfoByServiceName(ActionVersionReq req) {
        Criteria criteria = new Criteria().and("serviceName").in(req.getServiceNames());
        Query query = new Query(criteria);
        List<SysActionMetaData> sysActionMetaData = sysActionMetaDataMongoDao.find(query);
        return sysActionMetaData.stream().collect(Collectors.groupingBy(SysActionMetaData::getServiceName,
                        Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().max((o1, o2) -> {
                            BigDecimal o1Version = null;
                            BigDecimal o2Version = null;
                            try {
                                o1Version = new BigDecimal(o1.getServiceVersion());
                                o2Version = new BigDecimal(o2.getServiceVersion());
                            } catch (Exception e) {
                                throw new RuntimeException("【" + o1.getServiceName() + "】版本格式非法，请检查版本号格式！");
                            }
                            return o1Version.compareTo(o2Version);
                        }).map(v->{
                            return new ActionInfoResp()
                                    .setActionId(v.getActionId())
                                    .setActionName(v.getActionName())
                                    .setApplication(v.getApplication())
                                    .setLabel(v.getLabel())
                                    .setProvider(v.getProvider())
                                    .setServiceName(v.getServiceName())
                                    .setServiceVersion(v.getServiceVersion());
                        }).orElse(null)))).entrySet().stream()
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}
