package com.digiwin.athena.mongodb.domain.action;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.dto.action.ApiDataFieldMetadataAgileDTO;
import com.digiwin.athena.dto.action.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.MongoBaseDto;
import com.digiwin.athena.domain.base.RelationTable;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * @Param
 * @return
 * @Author wangxiao
 * @Date 2021/8/27 16:51
 * @Description //修改原来actionDto结构
 **/
@Data
@Document(collection = "actionMetadata")
public class ActionMetaData extends MongoBaseDto {

    @Id
    private String objectId;
    private List<String> labels;
    private String label;
    private String id;
    private String name;
    private String productName;
    private String actionName;
    private String actionName_tw;
    private String title;
    private String actionId;
    private String serviceName;
    private String serviceVersion;
    private String lastUpdateTime;
    /*    private String actionName;
        private String actionName_tw;*/
    private String remark_cn;
    private String remark_tw;
    private String desc;
    private String url;
    // IAM类型action会用到
    private String relativeUrl;
    private String method;
    private ApiDataFieldMetadataDTO response_object;
    private ApiDataFieldMetadataDTO response_error_info_object;
    private List<ApiDataFieldMetadataDTO> request_parameters;
    private String expression;
    private String target;
    private String type;
    private String innerType;
    private String invokeType;
    private String application;
    private String tenant;

    //StartDataEventAction
    private String dataEventId;
    @JSONField(name = "isServiceComposition")
    @JsonProperty("isServiceComposition")
    private Boolean isServiceComposition;
    private String subject;
    private Boolean split;
    //eocAction
    private String allocateType;
    //GetMechanismVariableAction
    private String variableName;
    private String code;//机制变量名
    private String variableValue;
    //StartProcessAction
    private String processId;
    private String taskId;
    private Integer emergency = 50;
    //StartServiceComposerAction
    private String serviceComposerId;
    private Boolean asyncComplete;
    private String version;
    //TransformAction
    private String ruleId;
    // 是否是从运行态数据库中迁移到设计态数据库
    private Boolean isMigrate;
    // 项目code，为了编译时生成monitorRuleAdapter
    private String projectCode;
    // 租户，为了接收运行态的租户信息
    private String tenantId;
    // 只有AthenaAction有用，去标记uri的前缀，如km  bpm
    private String module;
    // getMechanismVariableAction类型的action需要eocLevel，默认没有值，当这个action对应的机制变量需要设置为运营单元级别的时候，这边需要指定运营单元的层级，目前的值应该就是company 和 site
    private String eocLevel;
    // 编译时需要
    private List<RelationTable> relationTable;
    // 来自模型驱动的action记录下pageDesign的code，方便后续查询action时组装长度/精度/引用/默认值等属性
    private String pageDesignCode;

    //业务对象code
    private String businessCode;
    //数据来源，adTemplate 来自服务编排
    private String source;

    private Map<String, MultiLanguageDTO> lang;

    // 敏捷应用 获取数据节点字段
    private String querySchema;
    //敏捷应用 推送数据节点字段
    private String nameSpace;
    //敏捷应用 推送数据节点字段
    private String sceneNodeType;
    //敏捷应用 数据运算节点字段
    private String microTrans;

    //数据流code
    private String dataFlowCode;

    private String adpApplication;

    private Set<String> enumKeys;

    private Boolean generatedEnumKeys;

    private String templateId;

    /**
     * 是否为通过apiConfig生成的元数据
     * 兼容历史数据
     * true 为 通过apiConfig生成的元数据
     */
    private Boolean formApiConfig;
    //存放api元数据 作用同bmd节点的querySchema
    private String apiMeta;

    //存放业务类型数据
    private String bizParamMeta;

    private List<FixedSettingDTO>  fixSetting;
    //当前正在设计的指标code
    private String parentMetricCode;
    //当前正在被引用的指标的code
    private String quoteMetricCode;
    //当前正在被引用的指标的pulling节点id
    private String quoteMetricPullingId;
    // 节点类型说明
    private String actionTypeDescription;
    // 产品线
    private String productLine;
    //actionMode=dynamic时，执行引擎会执行动态计算
    private String actionMode;
    //actionMode=dynamic时，运行态需要API和SQL节点的输出字段的维度度量取数配置
    private ApiDataFieldMetadataAgileDTO aggregation;
    private String provider;

}
