/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.dao.mongodao.ActionMetadataMongoDao;
import com.digiwin.athena.dao.mongodao.SysActionMetaDataMongoDao;
import com.digiwin.athena.dto.action.ActionTypeInfoResDto;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.service.ActionMetaDataService;
import com.digiwin.athena.sys.PresetDataServiceV2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActionMetaDataServiceImpl
implements ActionMetaDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActionMetaDataServiceImpl.class);
    @Autowired
    private PresetDataServiceV2 presetDataServiceV2;
    @Autowired
    private ActionMetadataMongoDao actionMetadataMongoDao;
    @Autowired
    private SysActionMetaDataMongoDao sysActionMetaDataMongoDao;

    @Override
    public List<ActionTypeInfoResDto> autoMatchAction(String product, String actionId) {
        PresetData presetData = null;
        try {
            presetData = this.presetDataServiceV2.getPresetDataObject("API_TEMPLATE_" + product);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u6ca1\u6709%s\u8be5\u4ea7\u54c1\u7ebf\u7684\u914d\u7f6e", product));
        }
        List actionTypeInfoResDtos = (List)JSONObject.parseObject((String)presetData.getValue(), (TypeReference)new TypeReference<List<ActionTypeInfoResDto>>(){}, (Feature[])new Feature[0]);
        String actionPrefix = null;
        for (ActionTypeInfoResDto actionTypeInfoResDto : actionTypeInfoResDtos) {
            if (!actionId.endsWith(actionTypeInfoResDto.getApiName())) continue;
            actionPrefix = actionId.substring(0, actionId.length() - actionTypeInfoResDto.getApiName().length());
        }
        if (StringUtils.isEmpty(actionPrefix)) {
            return new ArrayList<ActionTypeInfoResDto>();
        }
        for (ActionTypeInfoResDto actionTypeInfoResDto : actionTypeInfoResDtos) {
            actionTypeInfoResDto.setApiName(actionPrefix + actionTypeInfoResDto.getApiName());
        }
        List<String> actionIds = actionTypeInfoResDtos.stream().map(ActionTypeInfoResDto::getApiName).collect(Collectors.toList());
        Set<String> actionIdSet = this.sysActionMetaDataMongoDao.selectActionIdByActionIds(actionIds);
        actionIdSet.addAll(this.actionMetadataMongoDao.selectActionIdByActionIds(actionIds));
        Iterator iterator = actionTypeInfoResDtos.iterator();
        while (iterator.hasNext()) {
            ActionTypeInfoResDto next = (ActionTypeInfoResDto)iterator.next();
            if (actionIdSet.contains(next.getApiName())) continue;
            iterator.remove();
        }
        return actionTypeInfoResDtos;
    }
}

