/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao;

import com.digiwin.athena.mongodb.domain.action.ActionMetaData;
import com.digiwin.athena.mongodb.domain.action.SysActionMetaData;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

@Repository
public class SysActionMetaDataMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysActionMetaDataMongoDao.class);
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    @Autowired
    public void setMongoSystemRepositoryDecorator(MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator) {
        this.mongoSystemRepositoryDecorator = mongoSystemRepositoryDecorator;
    }

    public List<SysActionMetaData> selectPlatformApiByActionIdOrNamePageable(String condition, Pageable pageable) {
        Criteria criteria = SysActionMetaDataMongoDao.getActionIdOrActionNameCriteria(condition);
        criteria.and("adpApplication").is(null);
        criteria.and("application").is((Object)"espCommon");
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        query.with(pageable);
        return this.mongoSystemRepositoryDecorator.find(query, SysActionMetaData.class);
    }

    public List<SysActionMetaData> selectByActionIdOrNamePageable(String condition, Pageable pageable) {
        Criteria criteria = SysActionMetaDataMongoDao.getActionIdOrActionNameCriteria(condition);
        criteria.and("application").is((Object)"espCommon");
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        query.with(pageable);
        return this.mongoSystemRepositoryDecorator.find(query, SysActionMetaData.class);
    }

    public Long countPlatformApiByActionIdOrName(String condition) {
        Criteria criteria = SysActionMetaDataMongoDao.getActionIdOrActionNameCriteria(condition);
        criteria.and("adpApplication").is(null);
        criteria.and("application").is((Object)"espCommon");
        return this.mongoSystemRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), SysActionMetaData.class);
    }

    public Long countByActionIdOrName(String condition) {
        Criteria criteria = SysActionMetaDataMongoDao.getActionIdOrActionNameCriteria(condition);
        criteria.and("application").is((Object)"espCommon");
        return this.mongoSystemRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), SysActionMetaData.class);
    }

    private static Criteria getActionIdOrActionNameCriteria(String condition) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            condition = ".*" + (String)condition + ".*";
            criteria.orOperator(new Criteria[]{Criteria.where((String)"actionId").regex((String)condition, "si"), Criteria.where((String)"actionName").regex((String)condition, "si")});
        }
        return criteria;
    }

    public Long countByActionIdOrNamePageable(String condition) {
        Criteria criteria = SysActionMetaDataMongoDao.getActionIdOrActionNameCriteria(condition);
        return this.mongoSystemRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), SysActionMetaData.class);
    }

    public SysActionMetaData selectByActionId(String actionId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionId));
        return (SysActionMetaData)((Object)this.mongoSystemRepositoryDecorator.findOne(query, SysActionMetaData.class));
    }

    public List<SysActionMetaData> selectByActionIds(List<String> actionIds) {
        Criteria criteria = Criteria.where((String)"actionId").in(actionIds);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoSystemRepositoryDecorator.find(query, SysActionMetaData.class);
    }

    public void removeByActionId(String actionId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionId));
        this.mongoSystemRepositoryDecorator.remove(query, SysActionMetaData.class);
    }

    public void save(ActionMetaData actionMetaData) {
        this.mongoSystemRepositoryDecorator.save((Object)actionMetaData);
    }

    public List<SysActionMetaData> selectBasicInfoLimit(String condition, int limit) {
        Criteria criteria = SysActionMetaDataMongoDao.getActionIdOrActionNameCriteria(condition);
        criteria.and("label").is((Object)"EspAction");
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(limit);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        query.fields().exclude(new String[]{"response_object", "request_parameters"});
        return this.mongoSystemRepositoryDecorator.find(query, SysActionMetaData.class);
    }

    private Criteria matchDataName(String condition) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            condition = ".*" + (String)condition + ".*";
            Criteria cri = Criteria.where((String)"data_name").regex((String)condition, "six");
            criteria.orOperator(new Criteria[]{Criteria.where((String)"response_object.field").elemMatch(cri), Criteria.where((String)"actionId").regex((String)condition, "six"), Criteria.where((String)"response_object.data_name").regex((String)condition, "six")});
        }
        return criteria;
    }

    public List<SysActionMetaData> selectEspActionByDataNamePageable(String condition, Pageable pageable) {
        Criteria criteria = this.matchDataName(condition);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        query.with(pageable);
        return this.mongoSystemRepositoryDecorator.find(query, SysActionMetaData.class);
    }

    public Long countEspActionByDataName(String condition) {
        Criteria criteria = this.matchDataName(condition);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoSystemRepositoryDecorator.count(query, SysActionMetaData.class);
    }

    public void updateByActionId(Update update, String actionId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionId));
        this.mongoSystemRepositoryDecorator.upsert(query, update, "sys_actionMetadata");
    }

    public SysActionMetaData selectPlatformApiByActionId(String actionId) {
        Criteria criteria = Criteria.where((String)"actionId").is((Object)actionId).and("adpApplication").is(null);
        return (SysActionMetaData)((Object)this.mongoSystemRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), SysActionMetaData.class));
    }

    public List<SysActionMetaData> selectBasicInfoPlatformApiByActionIds(List<String> actionIds) {
        Criteria criteria = Criteria.where((String)"actionId").in(actionIds);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().exclude(new String[]{"response_object", "request_parameters"});
        return this.mongoSystemRepositoryDecorator.find(query, SysActionMetaData.class);
    }

    public void deleteByAdpApplication(String code) {
        Criteria criteria = new Criteria().and("adpApplication").is((Object)code);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoSystemRepositoryDecorator.remove(query, SysActionMetaData.class);
    }

    public Set<String> selectActionIdByActionIds(List<String> actionIds) {
        Criteria criteria = Criteria.where((String)"actionId").in(actionIds);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("actionId");
        return this.mongoSystemRepositoryDecorator.find(query, SysActionMetaData.class).stream().map(ActionMetaData::getActionId).collect(Collectors.toSet());
    }
}

