package com.digiwin.athena.controller;

import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.action.ActionTypeInfoResDto;
import com.digiwin.athena.service.ActionMetaDataService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/action")
@Tag(name="行动",description = "4a87c534-19d3-41c1-a809-41db426b5ee0")
public class ActionMetaDataController {

    @Autowired
    private ActionMetaDataService actionMetaDataService;

    @GetMapping("/autoMatchAction")
    @Operation(summary = "自动匹配action")
    public ResultDto<List<ActionTypeInfoResDto>> autoMatchAction(@Schema(description = "产品") String product,
                                                                 String actionId){
        List<ActionTypeInfoResDto> res = actionMetaDataService.autoMatchAction(product,actionId);

        return ResultDto.createSuccess(res);
    }
}
