package com.digiwin.athena.dao.mongodao;

import com.digiwin.athena.constant.modelDriven.ModelDrivenConstant;
import com.digiwin.athena.mongodb.domain.action.ActionMetaData;
import com.digiwin.athena.mongodb.domain.action.SysActionMetaData;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
@Repository
public class SysActionMetaDataMongoDao {

    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    @Autowired
    public void setMongoSystemRepositoryDecorator(MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator) {
        this.mongoSystemRepositoryDecorator = mongoSystemRepositoryDecorator;
    }

    /**
     * 查询api管理平台同步过来的action
     * @param condition
     * @param pageable
     * @return
     */
    public List<SysActionMetaData> selectPlatformApiByActionIdOrNamePageable(String condition, Pageable pageable) {
        Criteria criteria = getActionIdOrActionNameCriteria(condition);
        criteria.and("adpApplication").is(null);
        criteria.and("application").is("espCommon");
        Query query = new Query(criteria);
        query.with(Sort.by(Sort.Direction.ASC,"_id"));
        query.with(pageable);
        return mongoSystemRepositoryDecorator.find(query,SysActionMetaData.class);
    }

    public List<SysActionMetaData> selectByActionIdOrNamePageable(String condition, Pageable pageable) {
        Criteria criteria = getActionIdOrActionNameCriteria(condition);
        criteria.and("application").is("espCommon");
        Query query = new Query(criteria);
        query.with(Sort.by(Sort.Direction.ASC,"_id"));
        query.with(pageable);
        return mongoSystemRepositoryDecorator.find(query,SysActionMetaData.class);
    }

    public Long countPlatformApiByActionIdOrName(String condition) {
        Criteria criteria = getActionIdOrActionNameCriteria(condition);
        criteria.and("adpApplication").is(null);
        criteria.and("application").is("espCommon");
        return mongoSystemRepositoryDecorator.count(new Query(criteria),SysActionMetaData.class);
    }

    public Long countByActionIdOrName(String condition) {
        Criteria criteria = getActionIdOrActionNameCriteria(condition);
        criteria.and("application").is("espCommon");
        return mongoSystemRepositoryDecorator.count(new Query(criteria),SysActionMetaData.class);
    }

    private static Criteria getActionIdOrActionNameCriteria(String condition) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty(condition)) {
            condition = ".*" + condition + ".*";
            criteria.orOperator(
                    Criteria.where("actionId").regex(condition, "si")
                    , Criteria.where("actionName").regex(condition, "si"));
        }
        return criteria;
    }

    public Long countByActionIdOrNamePageable(String condition) {
        Criteria criteria = getActionIdOrActionNameCriteria(condition);
        return mongoSystemRepositoryDecorator.count(new Query(criteria),SysActionMetaData.class);
    }

    public SysActionMetaData selectByActionId(String actionId) {
        Query query = new Query(Criteria.where("actionId").is(actionId));
        return mongoSystemRepositoryDecorator.findOne(query, SysActionMetaData.class);
    }

    public List<SysActionMetaData> selectByActionIds(List<String> actionIds) {
        Criteria criteria = Criteria.where("actionId").in(actionIds);
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.find(query,SysActionMetaData.class);
    }

    public void removeByActionId(String actionId) {
        Query query = new Query(Criteria.where("actionId").is(actionId));
        mongoSystemRepositoryDecorator.remove(query, SysActionMetaData.class);
    }

    public void save(ActionMetaData actionMetaData) {
        mongoSystemRepositoryDecorator.save(actionMetaData);
    }

    public List<SysActionMetaData> selectBasicInfoLimit(String condition, int limit) {
        Criteria criteria = getActionIdOrActionNameCriteria(condition);
        criteria.and("label").is("EspAction");
        Query query = new Query(criteria);
        query.limit(limit);
        query.with(Sort.by(Sort.Direction.ASC,"_id"));
        query.fields().exclude("response_object","request_parameters");
        return mongoSystemRepositoryDecorator.find(query, SysActionMetaData.class);
    }

    private Criteria matchDataName(String condition){
        Criteria criteria = new Criteria();

        if (StringUtils.isNotEmpty(condition)) {
            condition = ".*" + condition + ".*";
            Criteria cri = Criteria.where("data_name").regex(condition, "six");
            criteria.orOperator(
                    Criteria.where("response_object.field").elemMatch(cri)
                    , Criteria.where(ModelDrivenConstant.MODEL_ACTIONID).regex(condition, "six")
                    , Criteria.where("response_object.data_name").regex(condition, "six"));
        }
        return criteria;
    }
    public List<SysActionMetaData> selectEspActionByDataNamePageable(String condition, Pageable pageable) {
        Criteria criteria = matchDataName(condition);
        Query query = new Query(criteria);
        query.with(Sort.by(Sort.Direction.ASC,"_id"));
        query.with(pageable);

        return mongoSystemRepositoryDecorator.find(query,SysActionMetaData.class);
    }

    public Long countEspActionByDataName(String condition) {
        Criteria criteria = matchDataName(condition);
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.count(query,SysActionMetaData.class);
    }

    public void updateByActionId(Update update, String actionId) {
        Query query = new Query(Criteria.where("actionId").is(actionId));
        mongoSystemRepositoryDecorator.upsert(query,update,"sys_actionMetadata");
    }

    public SysActionMetaData selectPlatformApiByActionId(String actionId) {
        Criteria criteria = Criteria.where("actionId").is(actionId).and("adpApplication").is(null);
        return mongoSystemRepositoryDecorator.findOne(new Query(criteria),SysActionMetaData.class);
    }


    public List<SysActionMetaData> selectBasicInfoPlatformApiByActionIds(List<String> actionIds) {
        Criteria criteria = Criteria.where("actionId").in(actionIds);
        Query query = new Query(criteria);
        query.fields().exclude("response_object","request_parameters");
        return mongoSystemRepositoryDecorator.find(query, SysActionMetaData.class);
    }

    public void deleteByAdpApplication(String code) {
        Criteria criteria = new Criteria().and("adpApplication").is(code);
        Query query = new Query(criteria);
        mongoSystemRepositoryDecorator.remove(query,SysActionMetaData.class);
    }

    public Set<String> selectActionIdByActionIds(List<String> actionIds) {
        Criteria criteria = Criteria.where("actionId").in(actionIds);
        Query query = new Query(criteria);
        query.fields().include("actionId");
        return mongoSystemRepositoryDecorator.find(query,SysActionMetaData.class).stream().map(SysActionMetaData::getActionId).collect(Collectors.toSet());
    }
}
