package com.digiwin.athena.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.dao.mongodao.ActionMetadataMongoDao;
import com.digiwin.athena.dao.mongodao.SysActionMetaDataMongoDao;
import com.digiwin.athena.dto.action.ActionTypeInfoResDto;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.service.ActionMetaDataService;
import com.digiwin.athena.sys.PresetDataServiceV2;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@Slf4j
public class ActionMetaDataServiceImpl implements ActionMetaDataService {


    @Autowired
    private PresetDataServiceV2 presetDataServiceV2;

    @Autowired
    private ActionMetadataMongoDao actionMetadataMongoDao;
    @Autowired
    private SysActionMetaDataMongoDao sysActionMetaDataMongoDao;

    @Override
    public List<ActionTypeInfoResDto> autoMatchAction(String product, String actionId) {
        PresetData presetData = null;
        try {
            presetData = presetDataServiceV2.getPresetDataObject("API_TEMPLATE_" + product);
        } catch (Exception e) {
            return new ArrayList<>();
        }

        List<ActionTypeInfoResDto> actionTypeInfoResDtos = JSONObject.parseObject(presetData.getValue(), new TypeReference<List<ActionTypeInfoResDto>>() {
        });
        String actionPrefix=null;
        for (ActionTypeInfoResDto actionTypeInfoResDto : actionTypeInfoResDtos) {
            if (actionId.endsWith(actionTypeInfoResDto.getApiName())){
                actionPrefix = actionId.substring(0,actionId.length()-actionTypeInfoResDto.getApiName().length());
                break;
            }
        }
        if (StringUtils.isEmpty(actionPrefix)){
            return new ArrayList<>();
        }
        for (ActionTypeInfoResDto actionTypeInfoResDto : actionTypeInfoResDtos) {
            actionTypeInfoResDto.setApiName(actionPrefix+actionTypeInfoResDto.getApiName());
        }

        List<String> actionIds = actionTypeInfoResDtos.stream().map(ActionTypeInfoResDto::getApiName).collect(Collectors.toList());

        Set<String> actionIdSet = sysActionMetaDataMongoDao.selectActionIdByActionIds(actionIds);
        actionIdSet.addAll(actionMetadataMongoDao.selectActionIdByActionIds(actionIds));

        Iterator<ActionTypeInfoResDto> iterator = actionTypeInfoResDtos.iterator();
        while(iterator.hasNext()){
            ActionTypeInfoResDto next = iterator.next();
            if (!actionIdSet.contains(next.getApiName())){
                iterator.remove();
            }
        }
        return actionTypeInfoResDtos;
    }

}
