/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.mongodb.domain.application;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.auth.metadata.domain.AuthorityPolicy;
import com.digiwin.athena.auth.metadata.domain.ResourceRole;
import com.digiwin.athena.domain.pagedesign.TenantInfo;
import com.digiwin.athena.dto.application.FieldDescriptionDto;
import com.digiwin.athena.dto.application.ParamApi;
import com.digiwin.athena.mongodb.domain.BaseObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="application")
public class Application
extends BaseObject {
    public static final String APP_STATUS_CREATING = "creating";
    public static final String APP_STATUS_CREATION_FAILED = "creationFailed";
    public static final String APP_STATUS_UPDATING = "updating";
    public static final String APP_STATUS_UPDATE_FAILED = "updateFailed";
    public static final String APP_STATUS_SUCCESS = "success";
    @Id
    private String objectId;
    private String code;
    private String name;
    private String description;
    private String briefDescription;
    private List<ParamApi> paramApi;
    private List<FieldDescriptionDto> manifest;
    private String category;
    private Boolean isMigrate;
    private String tenantId;
    private String version;
    private String appToken;
    private List<JSONObject> compiledDataList;
    private Boolean published;
    private Integer appType;
    private Integer appSubType;
    private String iconName;
    private String iconBgcolor;
    private String iconUrl;
    private String iconType;
    @Transient
    private String appSid;
    private Boolean commonApp;
    private String source;
    private List<String> searchKeywords;
    private JSONObject feature;
    private Integer appChannel;
    private List<String> clientType;
    private List<AuthorityPolicy> authorityPolicyList;
    private List<ResourceRole> roles;
    private String groupCode;
    private String groupName;
    private String payType;
    private String billingGoodsId;
    private String appSystem;
    private String latestCompileVersion;
    private String latestCompileDescription;
    private String publishEnvVersion;
    private String publishEnvVersionDescription;
    private String knowledgeType;
    private String deleteStatus;
    private int deleteOrder;
    private String prologue;
    private Boolean enableCompile;
    private String deploymentType;
    private List<Integer> appTypes;
    private String gitProjectId;
    private String gitUrl;
    private Integer abandon;
    private Boolean onSale;
    private Boolean visible;
    private Boolean auth;
    private JSONObject designer;
    @Schema(description="\u662f\u5426\u4e2a\u6848\u5e94\u7528")
    private Boolean individual;
    @Schema(description="\u6e90\u6807\u51c6\u5e94\u7528code")
    private String sourceApplicationCode;
    @Schema(description="\u662f\u5426\u9879\u76ee\u4efb\u52a1\u5b9a\u5236")
    private Boolean individualAll;
    @Schema(description="\u5e94\u7528\u72b6\u6001|creating-\u521b\u5efa\u4e2d\uff0ccreationFailed-\u521b\u5efa\u5931\u8d25\uff0cupdating-\u66f4\u65b0\u4e2d\uff0cupdateFailed-\u66f4\u65b0\u5931\u8d25\uff0csuccess-\u6210\u529f")
    private String appStatus = "success";
    private TenantInfo belongTenantInfo;
    private List<TenantInfo> useTenantInfos = new ArrayList<TenantInfo>();
    private String publishStatus;
    private Date publishTime;
    private Map tag;
    @Transient
    private Boolean externalApp;
    private String introduction;
    private String prompt;
    private Map<String, Boolean> assetInitFlag = new HashMap<String, Boolean>();

    public void addRoles(List<ResourceRole> roles) {
        if (this.roles == null) {
            this.roles = new ArrayList<ResourceRole>();
        }
        this.roles.addAll(roles);
    }

    private void addTenantRole(List<ResourceRole> roles, int index, int i) {
        ResourceRole tenantRole = roles.get(i);
        ResourceRole resourceRole = this.roles.stream().filter(item -> item.getUserId().equals(tenantRole.getUserId())).findAny().orElse(null);
        if (resourceRole != null) {
            resourceRole.setIsTenantSuper(Boolean.valueOf(true));
        } else {
            int j = index + i;
            if (j >= this.roles.size()) {
                this.roles.add(tenantRole);
            } else {
                this.roles.add(j, tenantRole);
            }
        }
    }

    public void addCompileData(JSONObject compileData) {
        if (CollUtil.isEmpty(this.compiledDataList)) {
            this.compiledDataList = new ArrayList<JSONObject>();
        }
        this.compiledDataList.add(compileData);
    }

    public void addAuthPolicy(AuthorityPolicy authorityPolicy) {
        if (this.authorityPolicyList == null) {
            this.authorityPolicyList = new ArrayList<AuthorityPolicy>();
        }
        this.authorityPolicyList.add(authorityPolicy);
    }

    public boolean hasPublishAuth() {
        return CollUtil.isNotEmpty(this.authorityPolicyList);
    }

    public boolean isIndividual() {
        if (this.getIndividual() != null) {
            return this.getIndividual();
        }
        return false;
    }

    public boolean appIsComeFromBc() {
        Map tag = this.getTag();
        if (tag == null) {
            return false;
        }
        Object sourceComponent = tag.get("sourceComponent");
        return "BC".equals(sourceComponent);
    }

    @Generated
    public static ApplicationBuilder builder() {
        return new ApplicationBuilder();
    }

    @Generated
    public String getObjectId() {
        return this.objectId;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getBriefDescription() {
        return this.briefDescription;
    }

    @Generated
    public List<ParamApi> getParamApi() {
        return this.paramApi;
    }

    @Generated
    public List<FieldDescriptionDto> getManifest() {
        return this.manifest;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public Boolean getIsMigrate() {
        return this.isMigrate;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getAppToken() {
        return this.appToken;
    }

    @Generated
    public List<JSONObject> getCompiledDataList() {
        return this.compiledDataList;
    }

    @Generated
    public Boolean getPublished() {
        return this.published;
    }

    @Generated
    public Integer getAppType() {
        return this.appType;
    }

    @Generated
    public Integer getAppSubType() {
        return this.appSubType;
    }

    @Generated
    public String getIconName() {
        return this.iconName;
    }

    @Generated
    public String getIconBgcolor() {
        return this.iconBgcolor;
    }

    @Generated
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Generated
    public String getIconType() {
        return this.iconType;
    }

    @Generated
    public String getAppSid() {
        return this.appSid;
    }

    @Generated
    public Boolean getCommonApp() {
        return this.commonApp;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public List<String> getSearchKeywords() {
        return this.searchKeywords;
    }

    @Generated
    public JSONObject getFeature() {
        return this.feature;
    }

    @Generated
    public Integer getAppChannel() {
        return this.appChannel;
    }

    @Generated
    public List<String> getClientType() {
        return this.clientType;
    }

    @Generated
    public List<AuthorityPolicy> getAuthorityPolicyList() {
        return this.authorityPolicyList;
    }

    @Generated
    public List<ResourceRole> getRoles() {
        return this.roles;
    }

    @Generated
    public String getGroupCode() {
        return this.groupCode;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @Generated
    public String getPayType() {
        return this.payType;
    }

    @Generated
    public String getBillingGoodsId() {
        return this.billingGoodsId;
    }

    @Generated
    public String getAppSystem() {
        return this.appSystem;
    }

    @Generated
    public String getLatestCompileVersion() {
        return this.latestCompileVersion;
    }

    @Generated
    public String getLatestCompileDescription() {
        return this.latestCompileDescription;
    }

    @Generated
    public String getPublishEnvVersion() {
        return this.publishEnvVersion;
    }

    @Generated
    public String getPublishEnvVersionDescription() {
        return this.publishEnvVersionDescription;
    }

    @Generated
    public String getKnowledgeType() {
        return this.knowledgeType;
    }

    @Generated
    public String getDeleteStatus() {
        return this.deleteStatus;
    }

    @Generated
    public int getDeleteOrder() {
        return this.deleteOrder;
    }

    @Generated
    public String getPrologue() {
        return this.prologue;
    }

    @Generated
    public Boolean getEnableCompile() {
        return this.enableCompile;
    }

    @Generated
    public String getDeploymentType() {
        return this.deploymentType;
    }

    @Generated
    public List<Integer> getAppTypes() {
        return this.appTypes;
    }

    @Generated
    public String getGitProjectId() {
        return this.gitProjectId;
    }

    @Generated
    public String getGitUrl() {
        return this.gitUrl;
    }

    @Generated
    public Integer getAbandon() {
        return this.abandon;
    }

    @Generated
    public Boolean getOnSale() {
        return this.onSale;
    }

    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Generated
    public Boolean getAuth() {
        return this.auth;
    }

    @Generated
    public JSONObject getDesigner() {
        return this.designer;
    }

    @Generated
    public Boolean getIndividual() {
        return this.individual;
    }

    @Generated
    public String getSourceApplicationCode() {
        return this.sourceApplicationCode;
    }

    @Generated
    public Boolean getIndividualAll() {
        return this.individualAll;
    }

    @Generated
    public String getAppStatus() {
        return this.appStatus;
    }

    @Generated
    public TenantInfo getBelongTenantInfo() {
        return this.belongTenantInfo;
    }

    @Generated
    public List<TenantInfo> getUseTenantInfos() {
        return this.useTenantInfos;
    }

    @Generated
    public String getPublishStatus() {
        return this.publishStatus;
    }

    @Generated
    public Date getPublishTime() {
        return this.publishTime;
    }

    @Generated
    public Map getTag() {
        return this.tag;
    }

    @Generated
    public Boolean getExternalApp() {
        return this.externalApp;
    }

    @Generated
    public String getIntroduction() {
        return this.introduction;
    }

    @Generated
    public String getPrompt() {
        return this.prompt;
    }

    @Generated
    public Map<String, Boolean> getAssetInitFlag() {
        return this.assetInitFlag;
    }

    @Generated
    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }

    @Generated
    public void setParamApi(List<ParamApi> paramApi) {
        this.paramApi = paramApi;
    }

    @Generated
    public void setManifest(List<FieldDescriptionDto> manifest) {
        this.manifest = manifest;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setIsMigrate(Boolean isMigrate) {
        this.isMigrate = isMigrate;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    @Generated
    public void setCompiledDataList(List<JSONObject> compiledDataList) {
        this.compiledDataList = compiledDataList;
    }

    @Generated
    public void setPublished(Boolean published) {
        this.published = published;
    }

    @Generated
    public void setAppType(Integer appType) {
        this.appType = appType;
    }

    @Generated
    public void setAppSubType(Integer appSubType) {
        this.appSubType = appSubType;
    }

    @Generated
    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    @Generated
    public void setIconBgcolor(String iconBgcolor) {
        this.iconBgcolor = iconBgcolor;
    }

    @Generated
    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @Generated
    public void setIconType(String iconType) {
        this.iconType = iconType;
    }

    @Generated
    public void setAppSid(String appSid) {
        this.appSid = appSid;
    }

    @Generated
    public void setCommonApp(Boolean commonApp) {
        this.commonApp = commonApp;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setSearchKeywords(List<String> searchKeywords) {
        this.searchKeywords = searchKeywords;
    }

    @Generated
    public void setFeature(JSONObject feature) {
        this.feature = feature;
    }

    @Generated
    public void setAppChannel(Integer appChannel) {
        this.appChannel = appChannel;
    }

    @Generated
    public void setClientType(List<String> clientType) {
        this.clientType = clientType;
    }

    @Generated
    public void setAuthorityPolicyList(List<AuthorityPolicy> authorityPolicyList) {
        this.authorityPolicyList = authorityPolicyList;
    }

    @Generated
    public void setRoles(List<ResourceRole> roles) {
        this.roles = roles;
    }

    @Generated
    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    @Generated
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Generated
    public void setPayType(String payType) {
        this.payType = payType;
    }

    @Generated
    public void setBillingGoodsId(String billingGoodsId) {
        this.billingGoodsId = billingGoodsId;
    }

    @Generated
    public void setAppSystem(String appSystem) {
        this.appSystem = appSystem;
    }

    @Generated
    public void setLatestCompileVersion(String latestCompileVersion) {
        this.latestCompileVersion = latestCompileVersion;
    }

    @Generated
    public void setLatestCompileDescription(String latestCompileDescription) {
        this.latestCompileDescription = latestCompileDescription;
    }

    @Generated
    public void setPublishEnvVersion(String publishEnvVersion) {
        this.publishEnvVersion = publishEnvVersion;
    }

    @Generated
    public void setPublishEnvVersionDescription(String publishEnvVersionDescription) {
        this.publishEnvVersionDescription = publishEnvVersionDescription;
    }

    @Generated
    public void setKnowledgeType(String knowledgeType) {
        this.knowledgeType = knowledgeType;
    }

    @Generated
    public void setDeleteStatus(String deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    @Generated
    public void setDeleteOrder(int deleteOrder) {
        this.deleteOrder = deleteOrder;
    }

    @Generated
    public void setPrologue(String prologue) {
        this.prologue = prologue;
    }

    @Generated
    public void setEnableCompile(Boolean enableCompile) {
        this.enableCompile = enableCompile;
    }

    @Generated
    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    @Generated
    public void setAppTypes(List<Integer> appTypes) {
        this.appTypes = appTypes;
    }

    @Generated
    public void setGitProjectId(String gitProjectId) {
        this.gitProjectId = gitProjectId;
    }

    @Generated
    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
    }

    @Generated
    public void setAbandon(Integer abandon) {
        this.abandon = abandon;
    }

    @Generated
    public void setOnSale(Boolean onSale) {
        this.onSale = onSale;
    }

    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Generated
    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    @Generated
    public void setDesigner(JSONObject designer) {
        this.designer = designer;
    }

    @Generated
    public void setIndividual(Boolean individual) {
        this.individual = individual;
    }

    @Generated
    public void setSourceApplicationCode(String sourceApplicationCode) {
        this.sourceApplicationCode = sourceApplicationCode;
    }

    @Generated
    public void setIndividualAll(Boolean individualAll) {
        this.individualAll = individualAll;
    }

    @Generated
    public void setAppStatus(String appStatus) {
        this.appStatus = appStatus;
    }

    @Generated
    public void setBelongTenantInfo(TenantInfo belongTenantInfo) {
        this.belongTenantInfo = belongTenantInfo;
    }

    @Generated
    public void setUseTenantInfos(List<TenantInfo> useTenantInfos) {
        this.useTenantInfos = useTenantInfos;
    }

    @Generated
    public void setPublishStatus(String publishStatus) {
        this.publishStatus = publishStatus;
    }

    @Generated
    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    @Generated
    public void setTag(Map tag) {
        this.tag = tag;
    }

    @Generated
    public void setExternalApp(Boolean externalApp) {
        this.externalApp = externalApp;
    }

    @Generated
    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    @Generated
    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @Generated
    public void setAssetInitFlag(Map<String, Boolean> assetInitFlag) {
        this.assetInitFlag = assetInitFlag;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application other = (Application)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getDeleteOrder() != other.getDeleteOrder()) {
            return false;
        }
        Boolean this$isMigrate = this.getIsMigrate();
        Boolean other$isMigrate = other.getIsMigrate();
        if (this$isMigrate == null ? other$isMigrate != null : !((Object)this$isMigrate).equals(other$isMigrate)) {
            return false;
        }
        Boolean this$published = this.getPublished();
        Boolean other$published = other.getPublished();
        if (this$published == null ? other$published != null : !((Object)this$published).equals(other$published)) {
            return false;
        }
        Integer this$appType = this.getAppType();
        Integer other$appType = other.getAppType();
        if (this$appType == null ? other$appType != null : !((Object)this$appType).equals(other$appType)) {
            return false;
        }
        Integer this$appSubType = this.getAppSubType();
        Integer other$appSubType = other.getAppSubType();
        if (this$appSubType == null ? other$appSubType != null : !((Object)this$appSubType).equals(other$appSubType)) {
            return false;
        }
        Boolean this$commonApp = this.getCommonApp();
        Boolean other$commonApp = other.getCommonApp();
        if (this$commonApp == null ? other$commonApp != null : !((Object)this$commonApp).equals(other$commonApp)) {
            return false;
        }
        Integer this$appChannel = this.getAppChannel();
        Integer other$appChannel = other.getAppChannel();
        if (this$appChannel == null ? other$appChannel != null : !((Object)this$appChannel).equals(other$appChannel)) {
            return false;
        }
        Boolean this$enableCompile = this.getEnableCompile();
        Boolean other$enableCompile = other.getEnableCompile();
        if (this$enableCompile == null ? other$enableCompile != null : !((Object)this$enableCompile).equals(other$enableCompile)) {
            return false;
        }
        Integer this$abandon = this.getAbandon();
        Integer other$abandon = other.getAbandon();
        if (this$abandon == null ? other$abandon != null : !((Object)this$abandon).equals(other$abandon)) {
            return false;
        }
        Boolean this$onSale = this.getOnSale();
        Boolean other$onSale = other.getOnSale();
        if (this$onSale == null ? other$onSale != null : !((Object)this$onSale).equals(other$onSale)) {
            return false;
        }
        Boolean this$visible = this.getVisible();
        Boolean other$visible = other.getVisible();
        if (this$visible == null ? other$visible != null : !((Object)this$visible).equals(other$visible)) {
            return false;
        }
        Boolean this$auth = this.getAuth();
        Boolean other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
            return false;
        }
        Boolean this$individual = this.getIndividual();
        Boolean other$individual = other.getIndividual();
        if (this$individual == null ? other$individual != null : !((Object)this$individual).equals(other$individual)) {
            return false;
        }
        Boolean this$individualAll = this.getIndividualAll();
        Boolean other$individualAll = other.getIndividualAll();
        if (this$individualAll == null ? other$individualAll != null : !((Object)this$individualAll).equals(other$individualAll)) {
            return false;
        }
        Boolean this$externalApp = this.getExternalApp();
        Boolean other$externalApp = other.getExternalApp();
        if (this$externalApp == null ? other$externalApp != null : !((Object)this$externalApp).equals(other$externalApp)) {
            return false;
        }
        String this$objectId = this.getObjectId();
        String other$objectId = other.getObjectId();
        if (this$objectId == null ? other$objectId != null : !this$objectId.equals(other$objectId)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$briefDescription = this.getBriefDescription();
        String other$briefDescription = other.getBriefDescription();
        if (this$briefDescription == null ? other$briefDescription != null : !this$briefDescription.equals(other$briefDescription)) {
            return false;
        }
        List<ParamApi> this$paramApi = this.getParamApi();
        List<ParamApi> other$paramApi = other.getParamApi();
        if (this$paramApi == null ? other$paramApi != null : !((Object)this$paramApi).equals(other$paramApi)) {
            return false;
        }
        List<FieldDescriptionDto> this$manifest = this.getManifest();
        List<FieldDescriptionDto> other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$appToken = this.getAppToken();
        String other$appToken = other.getAppToken();
        if (this$appToken == null ? other$appToken != null : !this$appToken.equals(other$appToken)) {
            return false;
        }
        List<JSONObject> this$compiledDataList = this.getCompiledDataList();
        List<JSONObject> other$compiledDataList = other.getCompiledDataList();
        if (this$compiledDataList == null ? other$compiledDataList != null : !((Object)this$compiledDataList).equals(other$compiledDataList)) {
            return false;
        }
        String this$iconName = this.getIconName();
        String other$iconName = other.getIconName();
        if (this$iconName == null ? other$iconName != null : !this$iconName.equals(other$iconName)) {
            return false;
        }
        String this$iconBgcolor = this.getIconBgcolor();
        String other$iconBgcolor = other.getIconBgcolor();
        if (this$iconBgcolor == null ? other$iconBgcolor != null : !this$iconBgcolor.equals(other$iconBgcolor)) {
            return false;
        }
        String this$iconUrl = this.getIconUrl();
        String other$iconUrl = other.getIconUrl();
        if (this$iconUrl == null ? other$iconUrl != null : !this$iconUrl.equals(other$iconUrl)) {
            return false;
        }
        String this$iconType = this.getIconType();
        String other$iconType = other.getIconType();
        if (this$iconType == null ? other$iconType != null : !this$iconType.equals(other$iconType)) {
            return false;
        }
        String this$appSid = this.getAppSid();
        String other$appSid = other.getAppSid();
        if (this$appSid == null ? other$appSid != null : !this$appSid.equals(other$appSid)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<String> this$searchKeywords = this.getSearchKeywords();
        List<String> other$searchKeywords = other.getSearchKeywords();
        if (this$searchKeywords == null ? other$searchKeywords != null : !((Object)this$searchKeywords).equals(other$searchKeywords)) {
            return false;
        }
        JSONObject this$feature = this.getFeature();
        JSONObject other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !this$feature.equals(other$feature)) {
            return false;
        }
        List<String> this$clientType = this.getClientType();
        List<String> other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !((Object)this$clientType).equals(other$clientType)) {
            return false;
        }
        List<AuthorityPolicy> this$authorityPolicyList = this.getAuthorityPolicyList();
        List<AuthorityPolicy> other$authorityPolicyList = other.getAuthorityPolicyList();
        if (this$authorityPolicyList == null ? other$authorityPolicyList != null : !((Object)this$authorityPolicyList).equals(other$authorityPolicyList)) {
            return false;
        }
        List<ResourceRole> this$roles = this.getRoles();
        List<ResourceRole> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$groupCode = this.getGroupCode();
        String other$groupCode = other.getGroupCode();
        if (this$groupCode == null ? other$groupCode != null : !this$groupCode.equals(other$groupCode)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        String this$payType = this.getPayType();
        String other$payType = other.getPayType();
        if (this$payType == null ? other$payType != null : !this$payType.equals(other$payType)) {
            return false;
        }
        String this$billingGoodsId = this.getBillingGoodsId();
        String other$billingGoodsId = other.getBillingGoodsId();
        if (this$billingGoodsId == null ? other$billingGoodsId != null : !this$billingGoodsId.equals(other$billingGoodsId)) {
            return false;
        }
        String this$appSystem = this.getAppSystem();
        String other$appSystem = other.getAppSystem();
        if (this$appSystem == null ? other$appSystem != null : !this$appSystem.equals(other$appSystem)) {
            return false;
        }
        String this$latestCompileVersion = this.getLatestCompileVersion();
        String other$latestCompileVersion = other.getLatestCompileVersion();
        if (this$latestCompileVersion == null ? other$latestCompileVersion != null : !this$latestCompileVersion.equals(other$latestCompileVersion)) {
            return false;
        }
        String this$latestCompileDescription = this.getLatestCompileDescription();
        String other$latestCompileDescription = other.getLatestCompileDescription();
        if (this$latestCompileDescription == null ? other$latestCompileDescription != null : !this$latestCompileDescription.equals(other$latestCompileDescription)) {
            return false;
        }
        String this$publishEnvVersion = this.getPublishEnvVersion();
        String other$publishEnvVersion = other.getPublishEnvVersion();
        if (this$publishEnvVersion == null ? other$publishEnvVersion != null : !this$publishEnvVersion.equals(other$publishEnvVersion)) {
            return false;
        }
        String this$publishEnvVersionDescription = this.getPublishEnvVersionDescription();
        String other$publishEnvVersionDescription = other.getPublishEnvVersionDescription();
        if (this$publishEnvVersionDescription == null ? other$publishEnvVersionDescription != null : !this$publishEnvVersionDescription.equals(other$publishEnvVersionDescription)) {
            return false;
        }
        String this$knowledgeType = this.getKnowledgeType();
        String other$knowledgeType = other.getKnowledgeType();
        if (this$knowledgeType == null ? other$knowledgeType != null : !this$knowledgeType.equals(other$knowledgeType)) {
            return false;
        }
        String this$deleteStatus = this.getDeleteStatus();
        String other$deleteStatus = other.getDeleteStatus();
        if (this$deleteStatus == null ? other$deleteStatus != null : !this$deleteStatus.equals(other$deleteStatus)) {
            return false;
        }
        String this$prologue = this.getPrologue();
        String other$prologue = other.getPrologue();
        if (this$prologue == null ? other$prologue != null : !this$prologue.equals(other$prologue)) {
            return false;
        }
        String this$deploymentType = this.getDeploymentType();
        String other$deploymentType = other.getDeploymentType();
        if (this$deploymentType == null ? other$deploymentType != null : !this$deploymentType.equals(other$deploymentType)) {
            return false;
        }
        List<Integer> this$appTypes = this.getAppTypes();
        List<Integer> other$appTypes = other.getAppTypes();
        if (this$appTypes == null ? other$appTypes != null : !((Object)this$appTypes).equals(other$appTypes)) {
            return false;
        }
        String this$gitProjectId = this.getGitProjectId();
        String other$gitProjectId = other.getGitProjectId();
        if (this$gitProjectId == null ? other$gitProjectId != null : !this$gitProjectId.equals(other$gitProjectId)) {
            return false;
        }
        String this$gitUrl = this.getGitUrl();
        String other$gitUrl = other.getGitUrl();
        if (this$gitUrl == null ? other$gitUrl != null : !this$gitUrl.equals(other$gitUrl)) {
            return false;
        }
        JSONObject this$designer = this.getDesigner();
        JSONObject other$designer = other.getDesigner();
        if (this$designer == null ? other$designer != null : !this$designer.equals(other$designer)) {
            return false;
        }
        String this$sourceApplicationCode = this.getSourceApplicationCode();
        String other$sourceApplicationCode = other.getSourceApplicationCode();
        if (this$sourceApplicationCode == null ? other$sourceApplicationCode != null : !this$sourceApplicationCode.equals(other$sourceApplicationCode)) {
            return false;
        }
        String this$appStatus = this.getAppStatus();
        String other$appStatus = other.getAppStatus();
        if (this$appStatus == null ? other$appStatus != null : !this$appStatus.equals(other$appStatus)) {
            return false;
        }
        TenantInfo this$belongTenantInfo = this.getBelongTenantInfo();
        TenantInfo other$belongTenantInfo = other.getBelongTenantInfo();
        if (this$belongTenantInfo == null ? other$belongTenantInfo != null : !this$belongTenantInfo.equals(other$belongTenantInfo)) {
            return false;
        }
        List<TenantInfo> this$useTenantInfos = this.getUseTenantInfos();
        List<TenantInfo> other$useTenantInfos = other.getUseTenantInfos();
        if (this$useTenantInfos == null ? other$useTenantInfos != null : !((Object)this$useTenantInfos).equals(other$useTenantInfos)) {
            return false;
        }
        String this$publishStatus = this.getPublishStatus();
        String other$publishStatus = other.getPublishStatus();
        if (this$publishStatus == null ? other$publishStatus != null : !this$publishStatus.equals(other$publishStatus)) {
            return false;
        }
        Date this$publishTime = this.getPublishTime();
        Date other$publishTime = other.getPublishTime();
        if (this$publishTime == null ? other$publishTime != null : !((Object)this$publishTime).equals(other$publishTime)) {
            return false;
        }
        Map this$tag = this.getTag();
        Map other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag)) {
            return false;
        }
        String this$introduction = this.getIntroduction();
        String other$introduction = other.getIntroduction();
        if (this$introduction == null ? other$introduction != null : !this$introduction.equals(other$introduction)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        Map<String, Boolean> this$assetInitFlag = this.getAssetInitFlag();
        Map<String, Boolean> other$assetInitFlag = other.getAssetInitFlag();
        return !(this$assetInitFlag == null ? other$assetInitFlag != null : !((Object)this$assetInitFlag).equals(other$assetInitFlag));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Application;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDeleteOrder();
        Boolean $isMigrate = this.getIsMigrate();
        result = result * 59 + ($isMigrate == null ? 43 : ((Object)$isMigrate).hashCode());
        Boolean $published = this.getPublished();
        result = result * 59 + ($published == null ? 43 : ((Object)$published).hashCode());
        Integer $appType = this.getAppType();
        result = result * 59 + ($appType == null ? 43 : ((Object)$appType).hashCode());
        Integer $appSubType = this.getAppSubType();
        result = result * 59 + ($appSubType == null ? 43 : ((Object)$appSubType).hashCode());
        Boolean $commonApp = this.getCommonApp();
        result = result * 59 + ($commonApp == null ? 43 : ((Object)$commonApp).hashCode());
        Integer $appChannel = this.getAppChannel();
        result = result * 59 + ($appChannel == null ? 43 : ((Object)$appChannel).hashCode());
        Boolean $enableCompile = this.getEnableCompile();
        result = result * 59 + ($enableCompile == null ? 43 : ((Object)$enableCompile).hashCode());
        Integer $abandon = this.getAbandon();
        result = result * 59 + ($abandon == null ? 43 : ((Object)$abandon).hashCode());
        Boolean $onSale = this.getOnSale();
        result = result * 59 + ($onSale == null ? 43 : ((Object)$onSale).hashCode());
        Boolean $visible = this.getVisible();
        result = result * 59 + ($visible == null ? 43 : ((Object)$visible).hashCode());
        Boolean $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
        Boolean $individual = this.getIndividual();
        result = result * 59 + ($individual == null ? 43 : ((Object)$individual).hashCode());
        Boolean $individualAll = this.getIndividualAll();
        result = result * 59 + ($individualAll == null ? 43 : ((Object)$individualAll).hashCode());
        Boolean $externalApp = this.getExternalApp();
        result = result * 59 + ($externalApp == null ? 43 : ((Object)$externalApp).hashCode());
        String $objectId = this.getObjectId();
        result = result * 59 + ($objectId == null ? 43 : $objectId.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $briefDescription = this.getBriefDescription();
        result = result * 59 + ($briefDescription == null ? 43 : $briefDescription.hashCode());
        List<ParamApi> $paramApi = this.getParamApi();
        result = result * 59 + ($paramApi == null ? 43 : ((Object)$paramApi).hashCode());
        List<FieldDescriptionDto> $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $appToken = this.getAppToken();
        result = result * 59 + ($appToken == null ? 43 : $appToken.hashCode());
        List<JSONObject> $compiledDataList = this.getCompiledDataList();
        result = result * 59 + ($compiledDataList == null ? 43 : ((Object)$compiledDataList).hashCode());
        String $iconName = this.getIconName();
        result = result * 59 + ($iconName == null ? 43 : $iconName.hashCode());
        String $iconBgcolor = this.getIconBgcolor();
        result = result * 59 + ($iconBgcolor == null ? 43 : $iconBgcolor.hashCode());
        String $iconUrl = this.getIconUrl();
        result = result * 59 + ($iconUrl == null ? 43 : $iconUrl.hashCode());
        String $iconType = this.getIconType();
        result = result * 59 + ($iconType == null ? 43 : $iconType.hashCode());
        String $appSid = this.getAppSid();
        result = result * 59 + ($appSid == null ? 43 : $appSid.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<String> $searchKeywords = this.getSearchKeywords();
        result = result * 59 + ($searchKeywords == null ? 43 : ((Object)$searchKeywords).hashCode());
        JSONObject $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : $feature.hashCode());
        List<String> $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : ((Object)$clientType).hashCode());
        List<AuthorityPolicy> $authorityPolicyList = this.getAuthorityPolicyList();
        result = result * 59 + ($authorityPolicyList == null ? 43 : ((Object)$authorityPolicyList).hashCode());
        List<ResourceRole> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $groupCode = this.getGroupCode();
        result = result * 59 + ($groupCode == null ? 43 : $groupCode.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        String $payType = this.getPayType();
        result = result * 59 + ($payType == null ? 43 : $payType.hashCode());
        String $billingGoodsId = this.getBillingGoodsId();
        result = result * 59 + ($billingGoodsId == null ? 43 : $billingGoodsId.hashCode());
        String $appSystem = this.getAppSystem();
        result = result * 59 + ($appSystem == null ? 43 : $appSystem.hashCode());
        String $latestCompileVersion = this.getLatestCompileVersion();
        result = result * 59 + ($latestCompileVersion == null ? 43 : $latestCompileVersion.hashCode());
        String $latestCompileDescription = this.getLatestCompileDescription();
        result = result * 59 + ($latestCompileDescription == null ? 43 : $latestCompileDescription.hashCode());
        String $publishEnvVersion = this.getPublishEnvVersion();
        result = result * 59 + ($publishEnvVersion == null ? 43 : $publishEnvVersion.hashCode());
        String $publishEnvVersionDescription = this.getPublishEnvVersionDescription();
        result = result * 59 + ($publishEnvVersionDescription == null ? 43 : $publishEnvVersionDescription.hashCode());
        String $knowledgeType = this.getKnowledgeType();
        result = result * 59 + ($knowledgeType == null ? 43 : $knowledgeType.hashCode());
        String $deleteStatus = this.getDeleteStatus();
        result = result * 59 + ($deleteStatus == null ? 43 : $deleteStatus.hashCode());
        String $prologue = this.getPrologue();
        result = result * 59 + ($prologue == null ? 43 : $prologue.hashCode());
        String $deploymentType = this.getDeploymentType();
        result = result * 59 + ($deploymentType == null ? 43 : $deploymentType.hashCode());
        List<Integer> $appTypes = this.getAppTypes();
        result = result * 59 + ($appTypes == null ? 43 : ((Object)$appTypes).hashCode());
        String $gitProjectId = this.getGitProjectId();
        result = result * 59 + ($gitProjectId == null ? 43 : $gitProjectId.hashCode());
        String $gitUrl = this.getGitUrl();
        result = result * 59 + ($gitUrl == null ? 43 : $gitUrl.hashCode());
        JSONObject $designer = this.getDesigner();
        result = result * 59 + ($designer == null ? 43 : $designer.hashCode());
        String $sourceApplicationCode = this.getSourceApplicationCode();
        result = result * 59 + ($sourceApplicationCode == null ? 43 : $sourceApplicationCode.hashCode());
        String $appStatus = this.getAppStatus();
        result = result * 59 + ($appStatus == null ? 43 : $appStatus.hashCode());
        TenantInfo $belongTenantInfo = this.getBelongTenantInfo();
        result = result * 59 + ($belongTenantInfo == null ? 43 : $belongTenantInfo.hashCode());
        List<TenantInfo> $useTenantInfos = this.getUseTenantInfos();
        result = result * 59 + ($useTenantInfos == null ? 43 : ((Object)$useTenantInfos).hashCode());
        String $publishStatus = this.getPublishStatus();
        result = result * 59 + ($publishStatus == null ? 43 : $publishStatus.hashCode());
        Date $publishTime = this.getPublishTime();
        result = result * 59 + ($publishTime == null ? 43 : ((Object)$publishTime).hashCode());
        Map $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        String $introduction = this.getIntroduction();
        result = result * 59 + ($introduction == null ? 43 : $introduction.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        Map<String, Boolean> $assetInitFlag = this.getAssetInitFlag();
        result = result * 59 + ($assetInitFlag == null ? 43 : ((Object)$assetInitFlag).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Application(objectId=" + this.getObjectId() + ", code=" + this.getCode() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", briefDescription=" + this.getBriefDescription() + ", paramApi=" + String.valueOf(this.getParamApi()) + ", manifest=" + String.valueOf(this.getManifest()) + ", category=" + this.getCategory() + ", isMigrate=" + this.getIsMigrate() + ", tenantId=" + this.getTenantId() + ", version=" + this.getVersion() + ", appToken=" + this.getAppToken() + ", compiledDataList=" + String.valueOf(this.getCompiledDataList()) + ", published=" + this.getPublished() + ", appType=" + this.getAppType() + ", appSubType=" + this.getAppSubType() + ", iconName=" + this.getIconName() + ", iconBgcolor=" + this.getIconBgcolor() + ", iconUrl=" + this.getIconUrl() + ", iconType=" + this.getIconType() + ", appSid=" + this.getAppSid() + ", commonApp=" + this.getCommonApp() + ", source=" + this.getSource() + ", searchKeywords=" + String.valueOf(this.getSearchKeywords()) + ", feature=" + String.valueOf(this.getFeature()) + ", appChannel=" + this.getAppChannel() + ", clientType=" + String.valueOf(this.getClientType()) + ", authorityPolicyList=" + String.valueOf(this.getAuthorityPolicyList()) + ", roles=" + String.valueOf(this.getRoles()) + ", groupCode=" + this.getGroupCode() + ", groupName=" + this.getGroupName() + ", payType=" + this.getPayType() + ", billingGoodsId=" + this.getBillingGoodsId() + ", appSystem=" + this.getAppSystem() + ", latestCompileVersion=" + this.getLatestCompileVersion() + ", latestCompileDescription=" + this.getLatestCompileDescription() + ", publishEnvVersion=" + this.getPublishEnvVersion() + ", publishEnvVersionDescription=" + this.getPublishEnvVersionDescription() + ", knowledgeType=" + this.getKnowledgeType() + ", deleteStatus=" + this.getDeleteStatus() + ", deleteOrder=" + this.getDeleteOrder() + ", prologue=" + this.getPrologue() + ", enableCompile=" + this.getEnableCompile() + ", deploymentType=" + this.getDeploymentType() + ", appTypes=" + String.valueOf(this.getAppTypes()) + ", gitProjectId=" + this.getGitProjectId() + ", gitUrl=" + this.getGitUrl() + ", abandon=" + this.getAbandon() + ", onSale=" + this.getOnSale() + ", visible=" + this.getVisible() + ", auth=" + this.getAuth() + ", designer=" + String.valueOf(this.getDesigner()) + ", individual=" + this.getIndividual() + ", sourceApplicationCode=" + this.getSourceApplicationCode() + ", individualAll=" + this.getIndividualAll() + ", appStatus=" + this.getAppStatus() + ", belongTenantInfo=" + String.valueOf(this.getBelongTenantInfo()) + ", useTenantInfos=" + String.valueOf(this.getUseTenantInfos()) + ", publishStatus=" + this.getPublishStatus() + ", publishTime=" + String.valueOf(this.getPublishTime()) + ", tag=" + String.valueOf(this.getTag()) + ", externalApp=" + this.getExternalApp() + ", introduction=" + this.getIntroduction() + ", prompt=" + this.getPrompt() + ", assetInitFlag=" + String.valueOf(this.getAssetInitFlag()) + ")";
    }

    @Generated
    public Application(String objectId, String code, String name, String description, String briefDescription, List<ParamApi> paramApi, List<FieldDescriptionDto> manifest, String category, Boolean isMigrate, String tenantId, String version, String appToken, List<JSONObject> compiledDataList, Boolean published, Integer appType, Integer appSubType, String iconName, String iconBgcolor, String iconUrl, String iconType, String appSid, Boolean commonApp, String source, List<String> searchKeywords, JSONObject feature, Integer appChannel, List<String> clientType, List<AuthorityPolicy> authorityPolicyList, List<ResourceRole> roles, String groupCode, String groupName, String payType, String billingGoodsId, String appSystem, String latestCompileVersion, String latestCompileDescription, String publishEnvVersion, String publishEnvVersionDescription, String knowledgeType, String deleteStatus, int deleteOrder, String prologue, Boolean enableCompile, String deploymentType, List<Integer> appTypes, String gitProjectId, String gitUrl, Integer abandon, Boolean onSale, Boolean visible, Boolean auth, JSONObject designer, Boolean individual, String sourceApplicationCode, Boolean individualAll, String appStatus, TenantInfo belongTenantInfo, List<TenantInfo> useTenantInfos, String publishStatus, Date publishTime, Map tag, Boolean externalApp, String introduction, String prompt, Map<String, Boolean> assetInitFlag) {
        this.objectId = objectId;
        this.code = code;
        this.name = name;
        this.description = description;
        this.briefDescription = briefDescription;
        this.paramApi = paramApi;
        this.manifest = manifest;
        this.category = category;
        this.isMigrate = isMigrate;
        this.tenantId = tenantId;
        this.version = version;
        this.appToken = appToken;
        this.compiledDataList = compiledDataList;
        this.published = published;
        this.appType = appType;
        this.appSubType = appSubType;
        this.iconName = iconName;
        this.iconBgcolor = iconBgcolor;
        this.iconUrl = iconUrl;
        this.iconType = iconType;
        this.appSid = appSid;
        this.commonApp = commonApp;
        this.source = source;
        this.searchKeywords = searchKeywords;
        this.feature = feature;
        this.appChannel = appChannel;
        this.clientType = clientType;
        this.authorityPolicyList = authorityPolicyList;
        this.roles = roles;
        this.groupCode = groupCode;
        this.groupName = groupName;
        this.payType = payType;
        this.billingGoodsId = billingGoodsId;
        this.appSystem = appSystem;
        this.latestCompileVersion = latestCompileVersion;
        this.latestCompileDescription = latestCompileDescription;
        this.publishEnvVersion = publishEnvVersion;
        this.publishEnvVersionDescription = publishEnvVersionDescription;
        this.knowledgeType = knowledgeType;
        this.deleteStatus = deleteStatus;
        this.deleteOrder = deleteOrder;
        this.prologue = prologue;
        this.enableCompile = enableCompile;
        this.deploymentType = deploymentType;
        this.appTypes = appTypes;
        this.gitProjectId = gitProjectId;
        this.gitUrl = gitUrl;
        this.abandon = abandon;
        this.onSale = onSale;
        this.visible = visible;
        this.auth = auth;
        this.designer = designer;
        this.individual = individual;
        this.sourceApplicationCode = sourceApplicationCode;
        this.individualAll = individualAll;
        this.appStatus = appStatus;
        this.belongTenantInfo = belongTenantInfo;
        this.useTenantInfos = useTenantInfos;
        this.publishStatus = publishStatus;
        this.publishTime = publishTime;
        this.tag = tag;
        this.externalApp = externalApp;
        this.introduction = introduction;
        this.prompt = prompt;
        this.assetInitFlag = assetInitFlag;
    }

    @Generated
    public Application() {
    }

    @Generated
    public static class ApplicationBuilder {
        @Generated
        private String objectId;
        @Generated
        private String code;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String briefDescription;
        @Generated
        private List<ParamApi> paramApi;
        @Generated
        private List<FieldDescriptionDto> manifest;
        @Generated
        private String category;
        @Generated
        private Boolean isMigrate;
        @Generated
        private String tenantId;
        @Generated
        private String version;
        @Generated
        private String appToken;
        @Generated
        private List<JSONObject> compiledDataList;
        @Generated
        private Boolean published;
        @Generated
        private Integer appType;
        @Generated
        private Integer appSubType;
        @Generated
        private String iconName;
        @Generated
        private String iconBgcolor;
        @Generated
        private String iconUrl;
        @Generated
        private String iconType;
        @Generated
        private String appSid;
        @Generated
        private Boolean commonApp;
        @Generated
        private String source;
        @Generated
        private List<String> searchKeywords;
        @Generated
        private JSONObject feature;
        @Generated
        private Integer appChannel;
        @Generated
        private List<String> clientType;
        @Generated
        private List<AuthorityPolicy> authorityPolicyList;
        @Generated
        private List<ResourceRole> roles;
        @Generated
        private String groupCode;
        @Generated
        private String groupName;
        @Generated
        private String payType;
        @Generated
        private String billingGoodsId;
        @Generated
        private String appSystem;
        @Generated
        private String latestCompileVersion;
        @Generated
        private String latestCompileDescription;
        @Generated
        private String publishEnvVersion;
        @Generated
        private String publishEnvVersionDescription;
        @Generated
        private String knowledgeType;
        @Generated
        private String deleteStatus;
        @Generated
        private int deleteOrder;
        @Generated
        private String prologue;
        @Generated
        private Boolean enableCompile;
        @Generated
        private String deploymentType;
        @Generated
        private List<Integer> appTypes;
        @Generated
        private String gitProjectId;
        @Generated
        private String gitUrl;
        @Generated
        private Integer abandon;
        @Generated
        private Boolean onSale;
        @Generated
        private Boolean visible;
        @Generated
        private Boolean auth;
        @Generated
        private JSONObject designer;
        @Generated
        private Boolean individual;
        @Generated
        private String sourceApplicationCode;
        @Generated
        private Boolean individualAll;
        @Generated
        private String appStatus;
        @Generated
        private TenantInfo belongTenantInfo;
        @Generated
        private List<TenantInfo> useTenantInfos;
        @Generated
        private String publishStatus;
        @Generated
        private Date publishTime;
        @Generated
        private Map tag;
        @Generated
        private Boolean externalApp;
        @Generated
        private String introduction;
        @Generated
        private String prompt;
        @Generated
        private Map<String, Boolean> assetInitFlag;

        @Generated
        ApplicationBuilder() {
        }

        @Generated
        public ApplicationBuilder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        @Generated
        public ApplicationBuilder code(String code) {
            this.code = code;
            return this;
        }

        @Generated
        public ApplicationBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ApplicationBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ApplicationBuilder briefDescription(String briefDescription) {
            this.briefDescription = briefDescription;
            return this;
        }

        @Generated
        public ApplicationBuilder paramApi(List<ParamApi> paramApi) {
            this.paramApi = paramApi;
            return this;
        }

        @Generated
        public ApplicationBuilder manifest(List<FieldDescriptionDto> manifest) {
            this.manifest = manifest;
            return this;
        }

        @Generated
        public ApplicationBuilder category(String category) {
            this.category = category;
            return this;
        }

        @Generated
        public ApplicationBuilder isMigrate(Boolean isMigrate) {
            this.isMigrate = isMigrate;
            return this;
        }

        @Generated
        public ApplicationBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public ApplicationBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public ApplicationBuilder appToken(String appToken) {
            this.appToken = appToken;
            return this;
        }

        @Generated
        public ApplicationBuilder compiledDataList(List<JSONObject> compiledDataList) {
            this.compiledDataList = compiledDataList;
            return this;
        }

        @Generated
        public ApplicationBuilder published(Boolean published) {
            this.published = published;
            return this;
        }

        @Generated
        public ApplicationBuilder appType(Integer appType) {
            this.appType = appType;
            return this;
        }

        @Generated
        public ApplicationBuilder appSubType(Integer appSubType) {
            this.appSubType = appSubType;
            return this;
        }

        @Generated
        public ApplicationBuilder iconName(String iconName) {
            this.iconName = iconName;
            return this;
        }

        @Generated
        public ApplicationBuilder iconBgcolor(String iconBgcolor) {
            this.iconBgcolor = iconBgcolor;
            return this;
        }

        @Generated
        public ApplicationBuilder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        @Generated
        public ApplicationBuilder iconType(String iconType) {
            this.iconType = iconType;
            return this;
        }

        @Generated
        public ApplicationBuilder appSid(String appSid) {
            this.appSid = appSid;
            return this;
        }

        @Generated
        public ApplicationBuilder commonApp(Boolean commonApp) {
            this.commonApp = commonApp;
            return this;
        }

        @Generated
        public ApplicationBuilder source(String source) {
            this.source = source;
            return this;
        }

        @Generated
        public ApplicationBuilder searchKeywords(List<String> searchKeywords) {
            this.searchKeywords = searchKeywords;
            return this;
        }

        @Generated
        public ApplicationBuilder feature(JSONObject feature) {
            this.feature = feature;
            return this;
        }

        @Generated
        public ApplicationBuilder appChannel(Integer appChannel) {
            this.appChannel = appChannel;
            return this;
        }

        @Generated
        public ApplicationBuilder clientType(List<String> clientType) {
            this.clientType = clientType;
            return this;
        }

        @Generated
        public ApplicationBuilder authorityPolicyList(List<AuthorityPolicy> authorityPolicyList) {
            this.authorityPolicyList = authorityPolicyList;
            return this;
        }

        @Generated
        public ApplicationBuilder roles(List<ResourceRole> roles) {
            this.roles = roles;
            return this;
        }

        @Generated
        public ApplicationBuilder groupCode(String groupCode) {
            this.groupCode = groupCode;
            return this;
        }

        @Generated
        public ApplicationBuilder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        @Generated
        public ApplicationBuilder payType(String payType) {
            this.payType = payType;
            return this;
        }

        @Generated
        public ApplicationBuilder billingGoodsId(String billingGoodsId) {
            this.billingGoodsId = billingGoodsId;
            return this;
        }

        @Generated
        public ApplicationBuilder appSystem(String appSystem) {
            this.appSystem = appSystem;
            return this;
        }

        @Generated
        public ApplicationBuilder latestCompileVersion(String latestCompileVersion) {
            this.latestCompileVersion = latestCompileVersion;
            return this;
        }

        @Generated
        public ApplicationBuilder latestCompileDescription(String latestCompileDescription) {
            this.latestCompileDescription = latestCompileDescription;
            return this;
        }

        @Generated
        public ApplicationBuilder publishEnvVersion(String publishEnvVersion) {
            this.publishEnvVersion = publishEnvVersion;
            return this;
        }

        @Generated
        public ApplicationBuilder publishEnvVersionDescription(String publishEnvVersionDescription) {
            this.publishEnvVersionDescription = publishEnvVersionDescription;
            return this;
        }

        @Generated
        public ApplicationBuilder knowledgeType(String knowledgeType) {
            this.knowledgeType = knowledgeType;
            return this;
        }

        @Generated
        public ApplicationBuilder deleteStatus(String deleteStatus) {
            this.deleteStatus = deleteStatus;
            return this;
        }

        @Generated
        public ApplicationBuilder deleteOrder(int deleteOrder) {
            this.deleteOrder = deleteOrder;
            return this;
        }

        @Generated
        public ApplicationBuilder prologue(String prologue) {
            this.prologue = prologue;
            return this;
        }

        @Generated
        public ApplicationBuilder enableCompile(Boolean enableCompile) {
            this.enableCompile = enableCompile;
            return this;
        }

        @Generated
        public ApplicationBuilder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Generated
        public ApplicationBuilder appTypes(List<Integer> appTypes) {
            this.appTypes = appTypes;
            return this;
        }

        @Generated
        public ApplicationBuilder gitProjectId(String gitProjectId) {
            this.gitProjectId = gitProjectId;
            return this;
        }

        @Generated
        public ApplicationBuilder gitUrl(String gitUrl) {
            this.gitUrl = gitUrl;
            return this;
        }

        @Generated
        public ApplicationBuilder abandon(Integer abandon) {
            this.abandon = abandon;
            return this;
        }

        @Generated
        public ApplicationBuilder onSale(Boolean onSale) {
            this.onSale = onSale;
            return this;
        }

        @Generated
        public ApplicationBuilder visible(Boolean visible) {
            this.visible = visible;
            return this;
        }

        @Generated
        public ApplicationBuilder auth(Boolean auth) {
            this.auth = auth;
            return this;
        }

        @Generated
        public ApplicationBuilder designer(JSONObject designer) {
            this.designer = designer;
            return this;
        }

        @Generated
        public ApplicationBuilder individual(Boolean individual) {
            this.individual = individual;
            return this;
        }

        @Generated
        public ApplicationBuilder sourceApplicationCode(String sourceApplicationCode) {
            this.sourceApplicationCode = sourceApplicationCode;
            return this;
        }

        @Generated
        public ApplicationBuilder individualAll(Boolean individualAll) {
            this.individualAll = individualAll;
            return this;
        }

        @Generated
        public ApplicationBuilder appStatus(String appStatus) {
            this.appStatus = appStatus;
            return this;
        }

        @Generated
        public ApplicationBuilder belongTenantInfo(TenantInfo belongTenantInfo) {
            this.belongTenantInfo = belongTenantInfo;
            return this;
        }

        @Generated
        public ApplicationBuilder useTenantInfos(List<TenantInfo> useTenantInfos) {
            this.useTenantInfos = useTenantInfos;
            return this;
        }

        @Generated
        public ApplicationBuilder publishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        @Generated
        public ApplicationBuilder publishTime(Date publishTime) {
            this.publishTime = publishTime;
            return this;
        }

        @Generated
        public ApplicationBuilder tag(Map tag) {
            this.tag = tag;
            return this;
        }

        @Generated
        public ApplicationBuilder externalApp(Boolean externalApp) {
            this.externalApp = externalApp;
            return this;
        }

        @Generated
        public ApplicationBuilder introduction(String introduction) {
            this.introduction = introduction;
            return this;
        }

        @Generated
        public ApplicationBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @Generated
        public ApplicationBuilder assetInitFlag(Map<String, Boolean> assetInitFlag) {
            this.assetInitFlag = assetInitFlag;
            return this;
        }

        @Generated
        public Application build() {
            return new Application(this.objectId, this.code, this.name, this.description, this.briefDescription, this.paramApi, this.manifest, this.category, this.isMigrate, this.tenantId, this.version, this.appToken, this.compiledDataList, this.published, this.appType, this.appSubType, this.iconName, this.iconBgcolor, this.iconUrl, this.iconType, this.appSid, this.commonApp, this.source, this.searchKeywords, this.feature, this.appChannel, this.clientType, this.authorityPolicyList, this.roles, this.groupCode, this.groupName, this.payType, this.billingGoodsId, this.appSystem, this.latestCompileVersion, this.latestCompileDescription, this.publishEnvVersion, this.publishEnvVersionDescription, this.knowledgeType, this.deleteStatus, this.deleteOrder, this.prologue, this.enableCompile, this.deploymentType, this.appTypes, this.gitProjectId, this.gitUrl, this.abandon, this.onSale, this.visible, this.auth, this.designer, this.individual, this.sourceApplicationCode, this.individualAll, this.appStatus, this.belongTenantInfo, this.useTenantInfos, this.publishStatus, this.publishTime, this.tag, this.externalApp, this.introduction, this.prompt, this.assetInitFlag);
        }

        @Generated
        public String toString() {
            return "Application.ApplicationBuilder(objectId=" + this.objectId + ", code=" + this.code + ", name=" + this.name + ", description=" + this.description + ", briefDescription=" + this.briefDescription + ", paramApi=" + String.valueOf(this.paramApi) + ", manifest=" + String.valueOf(this.manifest) + ", category=" + this.category + ", isMigrate=" + this.isMigrate + ", tenantId=" + this.tenantId + ", version=" + this.version + ", appToken=" + this.appToken + ", compiledDataList=" + String.valueOf(this.compiledDataList) + ", published=" + this.published + ", appType=" + this.appType + ", appSubType=" + this.appSubType + ", iconName=" + this.iconName + ", iconBgcolor=" + this.iconBgcolor + ", iconUrl=" + this.iconUrl + ", iconType=" + this.iconType + ", appSid=" + this.appSid + ", commonApp=" + this.commonApp + ", source=" + this.source + ", searchKeywords=" + String.valueOf(this.searchKeywords) + ", feature=" + String.valueOf(this.feature) + ", appChannel=" + this.appChannel + ", clientType=" + String.valueOf(this.clientType) + ", authorityPolicyList=" + String.valueOf(this.authorityPolicyList) + ", roles=" + String.valueOf(this.roles) + ", groupCode=" + this.groupCode + ", groupName=" + this.groupName + ", payType=" + this.payType + ", billingGoodsId=" + this.billingGoodsId + ", appSystem=" + this.appSystem + ", latestCompileVersion=" + this.latestCompileVersion + ", latestCompileDescription=" + this.latestCompileDescription + ", publishEnvVersion=" + this.publishEnvVersion + ", publishEnvVersionDescription=" + this.publishEnvVersionDescription + ", knowledgeType=" + this.knowledgeType + ", deleteStatus=" + this.deleteStatus + ", deleteOrder=" + this.deleteOrder + ", prologue=" + this.prologue + ", enableCompile=" + this.enableCompile + ", deploymentType=" + this.deploymentType + ", appTypes=" + String.valueOf(this.appTypes) + ", gitProjectId=" + this.gitProjectId + ", gitUrl=" + this.gitUrl + ", abandon=" + this.abandon + ", onSale=" + this.onSale + ", visible=" + this.visible + ", auth=" + this.auth + ", designer=" + String.valueOf(this.designer) + ", individual=" + this.individual + ", sourceApplicationCode=" + this.sourceApplicationCode + ", individualAll=" + this.individualAll + ", appStatus=" + this.appStatus + ", belongTenantInfo=" + String.valueOf(this.belongTenantInfo) + ", useTenantInfos=" + String.valueOf(this.useTenantInfos) + ", publishStatus=" + this.publishStatus + ", publishTime=" + String.valueOf(this.publishTime) + ", tag=" + String.valueOf(this.tag) + ", externalApp=" + this.externalApp + ", introduction=" + this.introduction + ", prompt=" + this.prompt + ", assetInitFlag=" + String.valueOf(this.assetInitFlag) + ")";
        }
    }
}

