package com.digiwin.athena.dao.mongodao;

import com.digiwin.athena.mongodb.domain.application.DeleteApplicationDetail;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class DeleteApplicationDetailMongoDao {

    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    @Autowired
    public void setMongoSystemRepositoryDecorator(MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator) {
        this.mongoSystemRepositoryDecorator = mongoSystemRepositoryDecorator;
    }

    public void insert(DeleteApplicationDetail deleteApplicationDetail) {
        mongoSystemRepositoryDecorator.insert(deleteApplicationDetail);
    }

    public List<DeleteApplicationDetail> selectByApplicationCodeAndDeleteNo(String applicationCode, String deleteNo) {
        Criteria criteria =
                Criteria.where("applicationCode").is(applicationCode).and("deleteNo").is(deleteNo);
        Query query = new Query(criteria);

        return mongoSystemRepositoryDecorator.find(query, DeleteApplicationDetail.class);
    }
}
