package com.digiwin.athena.mongodb.domain.application;


import com.digiwin.athena.mongodb.domain.BaseObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

@Data
@Accessors(chain = true)
@Document("deleteApplicationDetail")
public class DeleteApplicationDetail extends BaseObject {

    @Id
    private String objectId;
    /**
     *  应用code
     */
    private String applicationCode;

    private String deleteNo;

    private String content;

    private String result;

    @JsonFormat(locale = "zh", timezone = "Asia/Shanghai", pattern = "yyyy-MM-dd HH:mm:ss.SSS")
    private Date time;

    private String errorMessage;

    private Object errorStack;

    private String cause;

    private String failMessage;

    private Long executeTimeMills;
}
