/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.applicationHandler.handler;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.base.ValidateException;
import com.digiwin.athena.dao.mongodao.DeleteApplicationDetailMongoDao;
import com.digiwin.athena.enums.DeleteApplicationProcessEnum;
import com.digiwin.athena.mongodb.domain.application.Application;
import com.digiwin.athena.mongodb.domain.application.DeleteApplicationDetail;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import com.digiwin.athena.service.RedisService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractDeletionHandler {
    @Autowired
    protected RedisService redisService;
    @Autowired
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;
    private DeleteApplicationDetailMongoDao deleteApplicationDetailMongoDao;

    @Autowired
    public void setDeleteApplicationDetailMongoDao(DeleteApplicationDetailMongoDao deleteApplicationDetailMongoDao) {
        this.deleteApplicationDetailMongoDao = deleteApplicationDetailMongoDao;
    }

    DeleteApplicationProcessEnum getDeleteType() {
        return null;
    }

    protected abstract void doDeleteExecute(Application var1);

    protected abstract void doValidateExecute(Application var1);

    protected abstract void doBackup(Application var1);

    public final void deleteExecute(Application application, String deleteNo) {
        long startTime = System.currentTimeMillis();
        try {
            this.saveDeleteLogDetailPre(application, deleteNo);
            this.doDeleteExecute(application);
            this.saveValidateDetailPost(application, deleteNo, startTime);
            this.processExecute(application, deleteNo);
        }
        catch (Exception e) {
            this.failExecute(application, deleteNo, e, 3, startTime);
            throw new BusinessException((Throwable)e);
        }
    }

    public final void backup(Application application, String deleteNo) {
        long startTime = System.currentTimeMillis();
        try {
            this.saveDeleteLogDetailPre(application, deleteNo);
            this.doBackup(application);
            this.saveValidateDetailPost(application, deleteNo, startTime);
            this.processExecute(application, deleteNo);
        }
        catch (Exception e) {
            this.failExecute(application, deleteNo, e, 2, startTime);
            throw new BusinessException((Throwable)e);
        }
    }

    public void processExecute(Application application, String deleteNo) {
        String key = "ATHENA_DEPLOYER_DELETE_PROCESS:" + application.getCode() + ":" + deleteNo;
        this.redisService.set(key, (Object)this.calculateProgress().doubleValue(), 3600L);
    }

    public final void validate(Application application, String deleteNo) {
        long startTime = System.currentTimeMillis();
        try {
            this.saveDeleteLogDetailPre(application, deleteNo);
            this.doValidateExecute(application);
            this.saveValidateDetailPost(application, deleteNo, startTime);
            this.processExecute(application, deleteNo);
        }
        catch (Exception e) {
            this.failExecute(application, deleteNo, e, 1, startTime);
            throw new ValidateException(e.getMessage());
        }
    }

    protected void saveDeleteLogDetailPre(Application application, String deleteNo) {
        DeleteApplicationDetail deleteApplicationDetail = new DeleteApplicationDetail();
        deleteApplicationDetail.setApplicationCode(application.getCode()).setDeleteNo(deleteNo).setTime(new Date()).setResult("start").setContent("\u5f00\u59cb" + this.getDeleteType().getContent());
        this.deleteApplicationDetailMongoDao.insert(deleteApplicationDetail);
    }

    public void saveValidateDetailPost(Application application, String deleteNo, long startTime) {
        DeleteApplicationDetail deleteApplicationDetail = new DeleteApplicationDetail();
        deleteApplicationDetail.setApplicationCode(application.getCode()).setContent(this.getDeleteType().getContent() + "\u7ed3\u675f").setDeleteNo(deleteNo).setExecuteTimeMills(this.calculateExecutionTime(startTime)).setResult("success").setTime(new Date());
        this.deleteApplicationDetailMongoDao.insert(deleteApplicationDetail);
    }

    protected long calculateExecutionTime(long startTime) {
        long endTime = System.currentTimeMillis();
        return endTime - startTime;
    }

    protected BigDecimal calculateProgress() {
        return new BigDecimal(this.getDeleteType().ordinal() + 1).divide(new BigDecimal(DeleteApplicationProcessEnum.values().length), 2, RoundingMode.FLOOR);
    }

    public void failExecute(Application application, String deleteNo, Exception e, int type, long startTime) {
        String key = "ATHENA_DEPLOYER_DELETE_PROCESS:" + application.getCode() + ":" + deleteNo;
        DeleteApplicationDetail deleteApplicationDetail = new DeleteApplicationDetail().setApplicationCode(application.getCode()).setDeleteNo(deleteNo).setExecuteTimeMills(this.calculateExecutionTime(startTime)).setErrorStack(JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage()).setResult("fail");
        this.mongoSystemRepositoryDecorator.insert((Object)deleteApplicationDetail);
        this.redisService.set(key, (Object)-1, 3600L);
        if (type == 3) {
            application.setDeleteStatus("deleteFailed");
            application.setDeleteOrder(4);
            this.mongoSystemRepositoryDecorator.save((Object)application);
        }
    }
}

