package com.digiwin.athena.mongodb.domain.application;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.auth.metadata.domain.AuthorityPolicy;
import com.digiwin.athena.auth.metadata.domain.ResourceRole;
import com.digiwin.athena.domain.pagedesign.TenantInfo;
import com.digiwin.athena.dto.application.FieldDescriptionDto;
import com.digiwin.athena.dto.application.ParamApi;
import com.digiwin.athena.mongodb.domain.BaseObject;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.*;

/**
 * Application
 *
 * @author wangjy
 * @date 2021/8/10
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Document(collection = "application")
public class Application extends BaseObject {
    //creating-创建中，creationFailed-创建失败，updating-更新中，updateFailed-更新失败，success-成功
    public static final String APP_STATUS_CREATING = "creating";
    public static final String APP_STATUS_CREATION_FAILED = "creationFailed";
    public static final String APP_STATUS_UPDATING = "updating";
    public static final String APP_STATUS_UPDATE_FAILED = "updateFailed";
    public static final String APP_STATUS_SUCCESS = "success";

    @Id
    private String objectId;

    private String code;

    private String name;

    /**
     * 应用的描述说明
     */
    private String description;

    /**
     * 应用的简单描述
     */
    private String briefDescription;

    //参数来源api
    private List<ParamApi> paramApi;
    //应用的清单
    private List<FieldDescriptionDto> manifest;

    private String category;
    // 是否是从运行态数据库中迁移到设计态数据库
    private Boolean isMigrate;
    private String tenantId;

    private String version;
    //@Transient
    private String appToken;

    private List<JSONObject> compiledDataList;

    private Boolean published;

    //应用分类#1数据驱动#2分析数据#4随心控应用#5模型驱动应用#6敏捷数据#7助理
    /**
     * 应用分类#1数据驱动#2分析数据#4随心控应用#5模型驱动应用#6敏捷数据#7助理#8大AI创建模型
     */
    private Integer appType;

    // 应用子分类 #1事务类 #2知识类 #3数据类
    private Integer appSubType;

    private String iconName;

    private String iconBgcolor;
    /**
     * 应用图片地址
     */
    private String iconUrl;

    /**
     * 应用图片格式
     */
    private String iconType;

    @Transient
    private String appSid;

    private Boolean commonApp;

    private String source;//敏捷应用
    /**
     * 搜索关键词
     */
    private List<String> searchKeywords;

    private JSONObject feature;

    /**
     * 0:小程序; 1:智驱工作台
     */
    private Integer appChannel;

    /**
     * ["APP", "WEB"]
     */
    private List<String> clientType;


    private List<AuthorityPolicy> authorityPolicyList;

    private List<ResourceRole> roles;

    private String groupCode;

    private String groupName;
    /**
     * 计费方式  none 无  payPerView按次
     */
    private String payType;
    /**
     * 计费商品id
     */
    private String billingGoodsId;
    /**
     * 区分敏数应用指标体系和数据集体系
     * metrics-指标体系
     * dataset-数据集体系
     */
    private String appSystem;

    private String latestCompileVersion;

    private String latestCompileDescription;

    //沙箱环境发布的版本号
    private String publishEnvVersion;
    //沙箱环境发布的版本描述
    private String publishEnvVersionDescription;
    // public-公有知识类 private-私有知识库
    private String knowledgeType;

    /**
     *  删除状态  deleting 删除中  deleteFailed 删除失败
     */
    private String deleteStatus;

    /**
     *  用于排序  3 删除中  4 删除失败
     */
    private int deleteOrder;

    /**
     * 开场白信息（娜娜应用专用）
     */
    private String prologue;

    private Boolean enableCompile;

    /**
     * 部署专案类型（纯高代码应用专用）S
     * 部署类型： all-前端和后端开发, frontend-前, backend-后
     */
    private String deploymentType;

    /**
     *  应用类型集合
     */
    private List<Integer> appTypes;

    //mysql表里的存留字段
    private String gitProjectId;

    private String gitUrl;

    private Integer abandon;

    //前端是判斷應用的 onSale 這個字段來顯示「刪除」的功能，onSale = true 則「刪除」會被拿掉
    private Boolean onSale;

    private Boolean visible;


    /**
     * 判定当前用户是否有权限访问该应用
     * true:有权限，false:无权限
     */
    private Boolean auth;

    /**
     * 当前应用设计器
     */
    private JSONObject designer;

    @Schema(description = "是否个案应用")
    private Boolean individual;
    @Schema(description = "源标准应用code")
    private String sourceApplicationCode;
    @Schema(description = "是否项目任务定制")
    private Boolean individualAll;
    @Schema(description = "应用状态|creating-创建中，creationFailed-创建失败，updating-更新中，updateFailed-更新失败，success-成功")
    private String appStatus = APP_STATUS_SUCCESS;

    private TenantInfo belongTenantInfo;

    private List<TenantInfo> useTenantInfos = new ArrayList<>();

    /**
     * 应用发布状态->具有一定滞后性->通过定时任务同步
     * success/fail
     */
    private String publishStatus;

    /**
     * 应用首次发布成功时间>具有一定滞后性->通过定时任务同步
     *
     */
    private Date publishTime;

    /**
     * 业务中台打通DTD需求
     * - 业务中台发布过来的应用需要新增tag标识【"sourceComponent":"BC"】
     */
    private Map tag;

    /**
     * 业务中台打通DTD需求,只有2.0应用，有些属性更新应用时不需要更新
     */
    @Transient
    private Boolean externalApp;



    /**
     * 开场白 敏捷问数应用
     * @param introduction
     */
    private String introduction;

    /**
     * 提示语 敏捷问数应用
     * @param prompt
     */
    private String prompt;
    /**
     * 资产初始化标识|DTD-false
     */
    private Map<String,Boolean> assetInitFlag=new HashMap<>();

    public void addRoles(List<ResourceRole> roles) {
        if (this.roles == null) {
            this.roles = new ArrayList<>();
        }
        this.roles.addAll(roles);
    }

    private void addTenantRole(List<ResourceRole> roles, int index, int i) {
        ResourceRole tenantRole = roles.get(i);
        ResourceRole resourceRole = this.roles.stream().filter(item -> item.getUserId().equals(tenantRole.getUserId())).findAny().orElse(null);
        if (resourceRole != null) {
            resourceRole.setIsTenantSuper(true);
        } else {
            int j = index + i;
            if (j >= this.roles.size()) {
                this.roles.add(tenantRole);
            } else {
                this.roles.add(j, tenantRole);
            }

        }
    }

    public void addCompileData(JSONObject compileData) {
        if (CollUtil.isEmpty(compiledDataList)) {
            compiledDataList = new ArrayList<>();
        }
        compiledDataList.add(compileData);
    }

    public void addAuthPolicy(AuthorityPolicy authorityPolicy) {
        if (this.authorityPolicyList == null) {
            this.authorityPolicyList = new ArrayList<>();
        }
        this.authorityPolicyList.add(authorityPolicy);
    }

    public boolean hasPublishAuth() {
        if (CollUtil.isNotEmpty(authorityPolicyList)) {
            return true;
        }
        return false;
    }

    public boolean isIndividual(){
        if (this.getIndividual() !=null){
            return this.getIndividual();
        }
        return false;
    }

    public boolean appIsComeFromBc() {

        Map tag = this.getTag();
        if (tag == null) {
            return false;
        }

        Object sourceComponent = tag.get("sourceComponent");
        return "BC".equals(sourceComponent);
    }


    /**
     * @see com.digiwin.athena.bo.assembly.SolutionPlan#isAssemblyApp(Integer)
     * @return 前端序列化使用
     */
    @SuppressWarnings("unused")
    public boolean getIsAssemblyApp() {
        return getAppType() >= 10000;
    }
}
