/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao;

import com.digiwin.athena.mongodb.domain.application.Application;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import com.digiwin.athena.utils.QueryUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class ApplicationMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationMongoDao.class);
    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public Application getApplication(String code) {
        return (Application)((Object)this.mongoPrimaryRepositoryDecorator.findOne(QueryUtils.findByCode((String)code), Application.class));
    }

    public Application getApplication(Query query) {
        return (Application)((Object)this.mongoPrimaryRepositoryDecorator.findOne(query, Application.class));
    }

    public List<Application> getApplications(Query query) {
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> selectByCodes(Collection<String> applicationCode) {
        Criteria criteria = Criteria.where((String)"code").in(applicationCode);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> selectByCodesExcludeTargetAppCodes(Collection<String> applicationCode, Collection<String> excludeCodes) {
        Criteria criteria = Criteria.where((String)"code").in(applicationCode).nin(excludeCodes);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> selectByPage(Query query, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
            query.with((Pageable)pageable);
        }
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public Long queryCountByQuery(Query query) {
        return this.mongoPrimaryRepositoryDecorator.count(query, Application.class);
    }

    public void saveNotSetEdit(Application application) {
        this.mongoPrimaryRepositoryDecorator.saveNotSetEdit((Object)application);
    }

    public Set<String> selectApplicationCodeByCommonApp(Boolean isCommonApp) {
        Criteria criteria = Criteria.where((String)"commonApp").is((Object)isCommonApp);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("code");
        List applications = this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
        return applications.stream().map(Application::getCode).collect(Collectors.toSet());
    }

    public Application selectByCode(String code) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"code").is((Object)code);
        query.addCriteria((CriteriaDefinition)criteria);
        return (Application)((Object)this.mongoPrimaryRepositoryDecorator.findOne(query, Application.class));
    }

    public List<Application> selectByCategory(String category) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"category").is((Object)category);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> selectByAppType(List<Integer> appTypes) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"appType").in(appTypes);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> selectCheckUc(String applicationCode) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"sourceApplicationCode").is((Object)applicationCode).and("individual").is((Object)true);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public void insert(Application application) {
        this.mongoPrimaryRepositoryDecorator.insert((Object)application);
    }

    public Long selectOnlyOneByIndividualAndSourceApplicationCodeAndTenantId(String standardAppCode, String tenantId) {
        Criteria criteria1 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"belongTenantInfo.tenantId").is((Object)tenantId), Criteria.where((String)"useTenantInfos.tenantId").is((Object)tenantId)});
        Criteria criteria = Criteria.where((String)"sourceApplicationCode").is((Object)standardAppCode).and("individual").is((Object)true).andOperator(new Criteria[]{criteria1});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        return this.mongoPrimaryRepositoryDecorator.count(query, Application.class);
    }

    public List<Application> selectBySourceApplicationCodeAndIndividual(String sourceApplicationCode) {
        Criteria criteria = Criteria.where((String)"sourceApplicationCode").is((Object)sourceApplicationCode).and("individual").is((Object)true);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public void save(Application application) {
        this.mongoPrimaryRepositoryDecorator.save((Object)application);
    }

    public Long countStandardByTypeAndNameAndTenantIdAndCodes(String name, List<Integer> types, String tenantId, List<String> codes) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("individual").ne((Object)true).and("code").in(codes);
        if (!StringUtils.isEmpty((CharSequence)name)) {
            criteria.and("name").regex(".*" + name + ".*", "i");
        }
        if (!CollectionUtils.isEmpty(types)) {
            criteria.and("appType").in(types);
        }
        return this.mongoPrimaryRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public List<Application> selectStandardByTypeAndNameAndTenantIdAndCodePageable(String name, List<Integer> types, String tenantId, List<String> codes, Pageable pageable) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("individual").ne((Object)true).and("code").in(codes);
        if (!StringUtils.isEmpty((CharSequence)name)) {
            criteria.and("name").regex(".*" + name + ".*", "i");
        }
        if (!CollectionUtils.isEmpty(types)) {
            criteria.and("appType").in(types);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        query.with(pageable);
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> selectIndividualAppByTenantId(String tenantId) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("individual").is((Object)true);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public List<Application> selectStandardAppByTenantId(String tenantId) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("individual").ne((Object)true);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public List<Application> selectIndividualByTenantIdAndAppTypeAndDeleteStatus(String tenantId, List<Integer> excludeAppType, List<String> excludeDeleteStatus) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"tenantId").in(new Object[]{tenantId}).and("abandon").is((Object)0).and("individual").is((Object)true).and("deleteStatus").nin(excludeAppType).and("appType").nin(excludeDeleteStatus));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> selectStandardByTenantIdAndAppTypeAndDeleteStatus(String tenantId, List<Integer> excludeAppType, List<String> excludeDeleteStatus) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"tenantId").in(new Object[]{tenantId}).and("abandon").is((Object)0).and("individual").ne((Object)true).and("deleteStatus").nin(excludeAppType).and("appType").nin(excludeDeleteStatus));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<String> selectStandardAppCodeByTenantIdAndCommonApp(String tenantId, Boolean commonApp) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("commonApp").is((Object)commonApp).and("individual").ne((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("code");
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class).stream().map(Application::getCode).collect(Collectors.toList());
    }

    public List<Application> selectCommonAppByTenantId(String tenantId) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("commonApp").is((Object)true);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public List<Application> selectDistinctByType(Integer type, List<String> codes) {
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"appType").is((Object)type).and("code").in(codes));
        GroupOperation group = Aggregation.group((String[])new String[]{"code"}).first("name").as("name").first("code").as("code").first("description").as("description").first("appType").as("appType").first("iconName").as("iconName").first("iconBgcolor").as("iconBgcolor").first("lang").as("lang");
        ProjectionOperation project = Aggregation.project((String[])new String[0]).andExclude(new String[]{"_id"}).andInclude(new String[]{"name", "code", "description", "appType", "iconName", "iconBgcolor", "lang"});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group, project});
        AggregationResults aggregate = this.mongoPrimaryRepositoryDecorator.aggregate(aggregation, "application", Application.class);
        return aggregate.getMappedResults();
    }

    public Boolean existBySourceApplicationCode(String code) {
        Criteria criteria = Criteria.where((String)"sourceApplicationCode").is((Object)code);
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        return this.mongoPrimaryRepositoryDecorator.count(query, Application.class) > 0L;
    }

    public List<String> selectAppCodeByTenantId(String tenantId) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("individual").ne((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("code");
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class).stream().map(Application::getCode).collect(Collectors.toList());
    }

    public List<Application> selectByCodesAndIndividual(List<String> appCodes, Boolean individual) {
        Criteria criteria = Criteria.where((String)"code").in(appCodes).and("individual").is((Object)individual);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("code");
        fields.include("appStatus");
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> findSelfCreatedApp(String userId, String currentTenantId, Integer appType, String condition) {
        Criteria criteria = Criteria.where((String)"createBy").is((Object)userId).and("abandon").is((Object)0).and("tenantId").is((Object)currentTenantId).and("individual").ne((Object)true);
        if (null != appType) {
            criteria.and("appType").is((Object)appType);
        }
        ApplicationMongoDao.addSearchCondition(condition, criteria);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> findSelfCreatedIndividualApp(String userId, String currentTenantId, Integer appType, String condition) {
        Criteria criteria = Criteria.where((String)"createBy").is((Object)userId).and("abandon").is((Object)0).and("tenantId").is((Object)currentTenantId).and("individual").is((Object)true);
        if (null != appType) {
            criteria.and("appType").is((Object)appType);
        }
        ApplicationMongoDao.addSearchCondition(condition, criteria);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    private static void addSearchCondition(String condition, Criteria criteria) {
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Pattern pattern = Pattern.compile(".*" + Pattern.quote(condition) + ".*", 2);
            Criteria c1 = Criteria.where((String)"code").regex(pattern);
            Criteria c2 = Criteria.where((String)"name").regex(pattern);
            Criteria c3 = Criteria.where((String)"description").regex(pattern);
            criteria.orOperator(new Criteria[]{c1, c2, c3});
        }
    }

    public List<Application> selectByCodeAndDeleteStatus(List<String> codes, List<String> deleteStatus) {
        Criteria criteria = Criteria.where((String)"deleteStatus").nin(deleteStatus).and("appType").ne((Object)8).and("individual").ne((Object)true);
        if (!CollectionUtils.isEmpty(codes)) {
            criteria.and("code").in(codes);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> selectIndividualByCodeAndDeleteStatus(List<String> codes, List<String> deleteStatus) {
        Criteria criteria = Criteria.where((String)"deleteStatus").nin(deleteStatus).and("appType").ne((Object)8).and("individual").is((Object)true);
        if (!CollectionUtils.isEmpty(codes)) {
            criteria.and("code").in(codes);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Integer> selectAppType(List<String> codes, List<Integer> solutionTypes) {
        Criteria criteria = Criteria.where((String)"code").in(codes).and("appType").in(solutionTypes);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("appType");
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class).stream().map(Application::getAppType).distinct().collect(Collectors.toList());
    }

    public List<Integer> selectAppTypeByTenant(String tenantId) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("appType");
        return this.mongoPrimaryRepositoryDecorator.getTargetMongoTemplate().findDistinct(query, "appType", Application.class, Integer.class);
    }

    public List<String> selectByQuery(Query query) {
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class).stream().map(Application::getCode).distinct().collect(Collectors.toList());
    }

    public Application selectByCodeAndTenantId(String applicationCode, String tenantId) {
        return (Application)((Object)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)Criteria.where((String)"code").is((Object)applicationCode).and("tenantId").is((Object)tenantId)), Application.class));
    }

    public List<Application> selectAllBusinessApplication() {
        Criteria criteria = Criteria.where((String)"tag").exists(true).ne(null);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> selectBasicInfoByCodesAndTenantId(Collection<String> codes, String tenantId) {
        Criteria criteria = Criteria.where((String)"code").in(codes).and("tenantId").is((Object)tenantId);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include(new String[]{"name", "tenantId", "lang"});
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public Long selectCountByCodesAndTenantId(Collection<String> appCodes, String tenantId) {
        Criteria criteria = Criteria.where((String)"code").in(appCodes).and("tenantId").is((Object)tenantId);
        return this.mongoPrimaryRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public List<Application> selectByCodesAndTenantId(Collection<String> appCodes, String tenantId) {
        Criteria criteria = Criteria.where((String)"code").in(appCodes).and("tenantId").is((Object)tenantId);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public List<Application> findIndividualAppsBySourceAppCode(String sourceApplicationCode) {
        Criteria criteria = Criteria.where((String)"sourceApplicationCode").is((Object)sourceApplicationCode).and("individual").is((Object)Boolean.TRUE);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public List<Application> findIndAppsBySrcAppCodeAndSrcBranch(String sourceApplicationCode, String individualComeFromBranch) {
        Criteria criteria = Criteria.where((String)"sourceApplicationCode").is((Object)sourceApplicationCode).and("individual").is((Object)Boolean.TRUE).and("individualComeFromBranch").is((Object)individualComeFromBranch);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public List<Application> selectBySourceAppCodeAndSourceBranchAndIndividual(String sourceAppCode, String sourceBranch) {
        Criteria criteria = Criteria.where((String)"sourceApplicationCode").is((Object)sourceAppCode).and("individualComeFromBranch").is((Object)sourceBranch).and("individual").is((Object)true);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public Collection<Application> selectCodeByCodesAndAppType(List<String> codes, Integer appType) {
        Criteria criteria = Criteria.where((String)"code").in(codes).and("appType").is((Object)appType);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include(new String[]{"code", "name", "lang"});
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }

    public List<Application> findBasicInfoByCodes(List<String> codes) {
        Criteria criteria = Criteria.where((String)"code").in(codes);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("code").include("name").include("lang");
        return this.mongoPrimaryRepositoryDecorator.find(query, Application.class);
    }
}

