package com.digiwin.athena.dao.mongodao.assembly;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerPageQo;
import com.digiwin.athena.mongodb.domain.assembly.AssemblyApplicationConfigEntity;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import java.util.List;
import java.util.regex.Pattern;

/**
 * 设计时态设计器DAO接口
 */
public interface DDesignerMongoDao {
    static void addSearchNameOrType(Query query, String searchContent) {
        if (StrUtil.isNotBlank(searchContent)) {
            Pattern pattern = Pattern.compile(".*" + Pattern.quote(searchContent) + ".*", Pattern.CASE_INSENSITIVE);
            query.addCriteria(new Criteria().orOperator(
                    Criteria.where(AssemblyApplicationConfigEntity.Fields.name).regex(pattern),
                    Criteria.where(AssemblyApplicationConfigEntity.Fields.type).regex(pattern)
            ));
        }
    }
    /**
     * 根据ID查询设计器
     *
     * @param objectId 对象ID
     * @return 设计器信息
     */
    Designer selectById(String objectId);

    /**
     * 根据编码查询设计器
     *
     * @param code 设计器编码
     * @return 设计器信息
     */
    Designer selectByCode(String code);


    /**
     * 根据名称查询设计器
     *
     * @param name - 设计器名称
     * @return 设计器信息
     */
    Designer selectByName(String name);

    /**
     * 新增设计器
     *
     * @param designer 设计器信息
     * @return 设计器信息
     */
    void save(Designer designer);

    /**
     * 根据ID删除设计器
     *
     * @param objectId 对象ID
     * @return 是否成功
     */
    boolean deleteById(String objectId);

    /**
     * 检查是否已存在
     *
     * @param code      编码
     * @param name      name
     * @param excludeId 排除的ID（用于更新时检查）
     * @return 是否存在
     */
    boolean existsByKey(String code, String name, String excludeId);

    Pagination<DesignerListDTO> selectPage(PageReqCondition<DesignerPageQo> param);

    List<Designer> selectByRelatedAsset(String assetTypeId);
}
