package com.digiwin.athena.service.assembly;

import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerPageQo;
import com.digiwin.athena.dto.assembly.designer.DesignerSaveDTO;
import jakarta.validation.constraints.NotBlank;

/**
 * 设计器管理服务接口
 */
public interface DDesignerService {
    Pagination<DesignerListDTO> findList(PageReqCondition<DesignerPageQo> param);

    Designer save(DesignerSaveDTO designer);

    void save(Designer designer);

    void deleteById(String objectId);

    DesignerDetailDTO findDetailById(@NotBlank String id);

    Designer findById(String objectId);

    /**
     * 验证设计器编码唯一性
     *
     * @param code            设计器编码
     * @param name            name
     * @param excludeObjectId 排除的设计器ID（可选，用于更新时验证）
     * @return 是否唯一
     */
    boolean validateUnique(String code, String name, String excludeObjectId);


}